package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ObjectId", 
    "AppElementType"})
@JsonInclude(Include.NON_NULL)
public class AppElementInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ObjectId")
    protected String objectId;

    @JsonProperty("AppElementType")
    protected String appElementType;

    protected AppElementInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppElementInfo";
    }

    @Property(name="ObjectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(objectId);
    }

    public AppElementInfo withObjectId(String objectId) {
        AppElementInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppElementInfo");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="AppElementType")
    @JsonIgnore
    public Optional<String> getAppElementType() {
        return Optional.ofNullable(appElementType);
    }

    public AppElementInfo withAppElementType(String appElementType) {
        Checks.checkIsAscii(appElementType);
        AppElementInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.AppElementInfo");
        _x.appElementType = appElementType;
        return _x;
    }

    public AppElementInfo withUnmappedField(String name, String value) {
        AppElementInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String objectId;
        private String appElementType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = changedFields.add("ObjectId");
            return this;
        }

        public Builder appElementType(String appElementType) {
            this.appElementType = appElementType;
            this.changedFields = changedFields.add("AppElementType");
            return this;
        }

        public AppElementInfo build() {
            AppElementInfo _x = new AppElementInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppElementInfo";
            _x.objectId = objectId;
            _x.appElementType = appElementType;
            return _x;
        }
    }

    private AppElementInfo _copy() {
        AppElementInfo _x = new AppElementInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objectId = objectId;
        _x.appElementType = appElementType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppElementInfo[");
        b.append("ObjectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("AppElementType=");
        b.append(this.appElementType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
