/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Post;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostcommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostlikeCollectionRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.PostcommentRequest;
import microsoft.dynamics.crm.entity.request.PostlikeRequest;

public class PostCollectionRequest
extends CollectionPageEntityRequest<Post, PostRequest> {
    protected ContextPath contextPath;

    public PostCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Post.class, cp -> new PostRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest post_AsyncOperations() {
        return new AsyncoperationCollectionRequest(this.contextPath.addSegment("post_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest post_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(this.contextPath.addSegment("post_AsyncOperations").addKeys(new NameValue[]{new NameValue(asyncoperationid.toString())}), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest post_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(this.contextPath.addSegment("post_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest post_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(this.contextPath.addSegment("post_BulkDeleteFailures").addKeys(new NameValue[]{new NameValue(bulkdeletefailureid.toString())}), Optional.empty());
    }

    public PostcommentCollectionRequest post_Comments() {
        return new PostcommentCollectionRequest(this.contextPath.addSegment("Post_Comments"), Optional.empty());
    }

    public PostcommentRequest post_Comments(String postcommentid) {
        return new PostcommentRequest(this.contextPath.addSegment("Post_Comments").addKeys(new NameValue[]{new NameValue(postcommentid.toString())}), Optional.empty());
    }

    public PostlikeCollectionRequest post_Likes() {
        return new PostlikeCollectionRequest(this.contextPath.addSegment("Post_Likes"), Optional.empty());
    }

    public PostlikeRequest post_Likes(String postlikeid) {
        return new PostlikeRequest(this.contextPath.addSegment("Post_Likes").addKeys(new NameValue[]{new NameValue(postlikeid.toString())}), Optional.empty());
    }

    @Function(name="RetrievePersonalWall")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Post> retrievePersonalWall(Integer pageNumber, Integer pageSize, Integer commentsPerPost, OffsetDateTime startDate, OffsetDateTime endDate, Integer type, Integer source, Boolean sortDirection, String keyword) {
        Preconditions.checkNotNull((Object)pageNumber, (String)"pageNumber cannot be null");
        Preconditions.checkNotNull((Object)pageSize, (String)"pageSize cannot be null");
        Preconditions.checkNotNull((Object)commentsPerPost, (String)"commentsPerPost cannot be null");
        Preconditions.checkNotNull((Object)startDate, (String)"startDate cannot be null");
        Preconditions.checkNotNull((Object)endDate, (String)"endDate cannot be null");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null");
        Preconditions.checkNotNull((Object)source, (String)"source cannot be null");
        Preconditions.checkNotNull((Object)sortDirection, (String)"sortDirection cannot be null");
        Preconditions.checkNotNull((Object)keyword, (String)"keyword cannot be null");
        Map _parameters = ParameterMap.put((String)"PageNumber", (String)"Edm.Int32", (Object)pageNumber).put("PageSize", "Edm.Int32", (Object)pageSize).put("CommentsPerPost", "Edm.Int32", (Object)commentsPerPost).put("StartDate", "Edm.DateTimeOffset", (Object)startDate).put("EndDate", "Edm.DateTimeOffset", (Object)endDate).put("Type", "Edm.Int32", (Object)type).put("Source", "Edm.Int32", (Object)source).put("SortDirection", "Edm.Boolean", (Object)sortDirection).put("Keyword", "Edm.String", (Object)Checks.checkIsAscii((String)keyword)).build();
        return CollectionPageNonEntityRequest.forFunction((ContextPath)this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePersonalWall"), Post.class, (Map)_parameters);
    }

    @Function(name="RetrieveRecordWall")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Post> retrieveRecordWall(Crmbaseentity entity, Integer pageNumber, Integer pageSize, Integer commentsPerPost, OffsetDateTime startDate, OffsetDateTime endDate, Integer type, Integer source, Boolean sortDirection, String keyword) {
        Preconditions.checkNotNull((Object)entity, (String)"entity cannot be null");
        Preconditions.checkNotNull((Object)pageNumber, (String)"pageNumber cannot be null");
        Preconditions.checkNotNull((Object)pageSize, (String)"pageSize cannot be null");
        Preconditions.checkNotNull((Object)commentsPerPost, (String)"commentsPerPost cannot be null");
        Preconditions.checkNotNull((Object)startDate, (String)"startDate cannot be null");
        Preconditions.checkNotNull((Object)endDate, (String)"endDate cannot be null");
        Preconditions.checkNotNull((Object)type, (String)"type cannot be null");
        Preconditions.checkNotNull((Object)source, (String)"source cannot be null");
        Preconditions.checkNotNull((Object)sortDirection, (String)"sortDirection cannot be null");
        Preconditions.checkNotNull((Object)keyword, (String)"keyword cannot be null");
        Map _parameters = ParameterMap.put((String)"Entity", (String)"Microsoft.Dynamics.CRM.crmbaseentity", (Object)entity).put("PageNumber", "Edm.Int32", (Object)pageNumber).put("PageSize", "Edm.Int32", (Object)pageSize).put("CommentsPerPost", "Edm.Int32", (Object)commentsPerPost).put("StartDate", "Edm.DateTimeOffset", (Object)startDate).put("EndDate", "Edm.DateTimeOffset", (Object)endDate).put("Type", "Edm.Int32", (Object)type).put("Source", "Edm.Int32", (Object)source).put("SortDirection", "Edm.Boolean", (Object)sortDirection).put("Keyword", "Edm.String", (Object)Checks.checkIsAscii((String)keyword)).build();
        return CollectionPageNonEntityRequest.forFunction((ContextPath)this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveRecordWall"), Post.class, (Map)_parameters);
    }
}

