/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "EntityLogicalName", "AttributeLogicalName", "DataType", "Format", "Alias"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ViewColumn
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityLogicalName")
    protected String entityLogicalName;
    @JsonProperty(value="AttributeLogicalName")
    protected String attributeLogicalName;
    @JsonProperty(value="DataType")
    protected String dataType;
    @JsonProperty(value="Format")
    protected String format;
    @JsonProperty(value="Alias")
    protected String alias;

    protected ViewColumn() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ViewColumn";
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(this.entityLogicalName);
    }

    public ViewColumn withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii((String)entityLogicalName);
        ViewColumn _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ViewColumn");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="AttributeLogicalName")
    @JsonIgnore
    public Optional<String> getAttributeLogicalName() {
        return Optional.ofNullable(this.attributeLogicalName);
    }

    public ViewColumn withAttributeLogicalName(String attributeLogicalName) {
        Checks.checkIsAscii((String)attributeLogicalName);
        ViewColumn _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ViewColumn");
        _x.attributeLogicalName = attributeLogicalName;
        return _x;
    }

    @Property(name="DataType")
    @JsonIgnore
    public Optional<String> getDataType() {
        return Optional.ofNullable(this.dataType);
    }

    public ViewColumn withDataType(String dataType) {
        Checks.checkIsAscii((String)dataType);
        ViewColumn _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ViewColumn");
        _x.dataType = dataType;
        return _x;
    }

    @Property(name="Format")
    @JsonIgnore
    public Optional<String> getFormat() {
        return Optional.ofNullable(this.format);
    }

    public ViewColumn withFormat(String format) {
        Checks.checkIsAscii((String)format);
        ViewColumn _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ViewColumn");
        _x.format = format;
        return _x;
    }

    @Property(name="Alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    public ViewColumn withAlias(String alias) {
        Checks.checkIsAscii((String)alias);
        ViewColumn _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ViewColumn");
        _x.alias = alias;
        return _x;
    }

    public ViewColumn withUnmappedField(String name, String value) {
        ViewColumn _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ViewColumn _copy() {
        ViewColumn _x = new ViewColumn();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entityLogicalName = this.entityLogicalName;
        _x.attributeLogicalName = this.attributeLogicalName;
        _x.dataType = this.dataType;
        _x.format = this.format;
        _x.alias = this.alias;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ViewColumn[");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("AttributeLogicalName=");
        b.append(this.attributeLogicalName);
        b.append(", ");
        b.append("DataType=");
        b.append(this.dataType);
        b.append(", ");
        b.append("Format=");
        b.append(this.format);
        b.append(", ");
        b.append("Alias=");
        b.append(this.alias);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityLogicalName;
        private String attributeLogicalName;
        private String dataType;
        private String format;
        private String alias;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = this.changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder attributeLogicalName(String attributeLogicalName) {
            this.attributeLogicalName = attributeLogicalName;
            this.changedFields = this.changedFields.add("AttributeLogicalName");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.changedFields = this.changedFields.add("DataType");
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            this.changedFields = this.changedFields.add("Format");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = this.changedFields.add("Alias");
            return this;
        }

        public ViewColumn build() {
            ViewColumn _x = new ViewColumn();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ViewColumn";
            _x.entityLogicalName = this.entityLogicalName;
            _x.attributeLogicalName = this.attributeLogicalName;
            _x.dataType = this.dataType;
            _x.format = this.format;
            _x.alias = this.alias;
            return _x;
        }
    }
}

