package microsoft.dynamics.crm.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

import java.lang.Override;
import java.lang.String;

public enum SearchDirection implements Enum {

    @JsonProperty("Forward")
    FORWARD("Forward", "0"),

    @JsonProperty("Backward")
    BACKWARD("Backward", "1");

    private final String name;
    private final String value;

    private SearchDirection(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
