package microsoft.dynamics.crm.entity.set;

import com.github.davidmoten.odata.client.ContextPath;

import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.FeedbackCollectionRequest;

public final class Feedback extends FeedbackCollectionRequest {

    public Feedback(ContextPath contextPath) {
        super(contextPath, Optional.empty());
    }

    public Systemusers closedby() {
        return new Systemusers(contextPath.addSegment("closedby"));
    }

    public Contacts contactId() {
        return new Contacts(contextPath.addSegment("ContactId"));
    }

    public Systemusers createdby() {
        return new Systemusers(contextPath.addSegment("createdby"));
    }

    public Contacts createdByContact() {
        return new Contacts(contextPath.addSegment("CreatedByContact"));
    }

    public Systemusers createdonbehalfby() {
        return new Systemusers(contextPath.addSegment("createdonbehalfby"));
    }

    public Contacts createdOnBehalfByContact() {
        return new Contacts(contextPath.addSegment("CreatedOnBehalfByContact"));
    }

    public Duplicaterecords feedback_DuplicateBaseRecord() {
        return new Duplicaterecords(contextPath.addSegment("feedback_DuplicateBaseRecord"));
    }

    public Duplicaterecords feedback_DuplicateMatchingRecord() {
        return new Duplicaterecords(contextPath.addSegment("feedback_DuplicateMatchingRecord"));
    }

    public Feedback feedback_feedback() {
        return new Feedback(contextPath.addSegment("feedback_feedback"));
    }

    public Principalobjectattributeaccessset feedback_principalobjectattributeaccess() {
        return new Principalobjectattributeaccessset(contextPath.addSegment("feedback_principalobjectattributeaccess"));
    }

    public Syncerrors feedback_SyncErrors() {
        return new Syncerrors(contextPath.addSegment("Feedback_SyncErrors"));
    }

    public Feedback feedbackId() {
        return new Feedback(contextPath.addSegment("FeedbackId"));
    }

    public Knowledgearticles knowledgeArticleId() {
        return new Knowledgearticles(contextPath.addSegment("KnowledgeArticleId"));
    }

    public Systemusers modifiedby() {
        return new Systemusers(contextPath.addSegment("modifiedby"));
    }

    public Systemusers modifiedOnBehalfBy() {
        return new Systemusers(contextPath.addSegment("ModifiedOnBehalfBy"));
    }

    public Owners ownerid() {
        return new Owners(contextPath.addSegment("ownerid"));
    }

    public Businessunits owningbusinessunit() {
        return new Businessunits(contextPath.addSegment("owningbusinessunit"));
    }

    public Transactioncurrencies transactioncurrencyid() {
        return new Transactioncurrencies(contextPath.addSegment("transactioncurrencyid"));
    }
}
