package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Serviceendpoint;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;

@JsonIgnoreType
public class ServiceendpointRequest extends EntityRequest<Serviceendpoint> {

    public ServiceendpointRequest(ContextPath contextPath, Optional<Object> value) {
        super(Serviceendpoint.class, contextPath, value);
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public OrganizationRequest organizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest serviceendpoint_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("serviceendpoint_sdkmessageprocessingstep"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest serviceendpoint_sdkmessageprocessingstep(String sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("serviceendpoint_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid.toString())), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    @Action(name = "TriggerServiceEndpointCheck")
    @JsonIgnore
    public ActionRequestNoReturn triggerServiceEndpointCheck() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.TriggerServiceEndpointCheck"), _parameters);
    }

}
