package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Roletemplate;
import microsoft.dynamics.crm.entity.collection.request.PrivilegeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;

@JsonIgnoreType
public class RoletemplateRequest extends EntityRequest<Roletemplate> {

    public RoletemplateRequest(ContextPath contextPath, Optional<Object> value) {
        super(Roletemplate.class, contextPath, value);
    }

    public PrivilegeCollectionRequest roletemplateprivileges_association() {
        return new PrivilegeCollectionRequest(
                        contextPath.addSegment("roletemplateprivileges_association"), Optional.empty());
    }

    public PrivilegeRequest roletemplateprivileges_association(String privilegeid) {
        return new PrivilegeRequest(contextPath.addSegment("roletemplateprivileges_association").addKeys(new NameValue(privilegeid.toString())), Optional.empty());
    }

    public RoleCollectionRequest role_template_roles() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("role_template_roles"), Optional.empty());
    }

    public RoleRequest role_template_roles(String roleid) {
        return new RoleRequest(contextPath.addSegment("role_template_roles").addKeys(new NameValue(roleid.toString())), Optional.empty());
    }

}
