package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.RetrieveAuditDetailsResponse;
import microsoft.dynamics.crm.entity.Audit;

@JsonIgnoreType
public class AuditRequest extends EntityRequest<Audit> {

    public AuditRequest(ContextPath contextPath, Optional<Object> value) {
        super(Audit.class, contextPath, value);
    }

    public SystemuserRequest callinguserid() {
        return new SystemuserRequest(contextPath.addSegment("callinguserid"), Optional.empty());
    }

    public SystemuserRequest userid() {
        return new SystemuserRequest(contextPath.addSegment("userid"), Optional.empty());
    }

    @Function(name = "RetrieveAuditDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditDetailsResponse> retrieveAuditDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAuditDetailsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAuditDetails"), RetrieveAuditDetailsResponse.class, _parameters);
    }

}
