package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Userqueryvisualization;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.UserqueryvisualizationRequest;

public class UserqueryvisualizationCollectionRequest extends CollectionPageEntityRequest<Userqueryvisualization, UserqueryvisualizationRequest>{

    protected ContextPath contextPath;

    public UserqueryvisualizationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Userqueryvisualization.class, cp -> new UserqueryvisualizationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest userQueryVisualization_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("UserQueryVisualization_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest userQueryVisualization_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("UserQueryVisualization_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
