package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Transformationmapping;
import microsoft.dynamics.crm.entity.request.TransformationmappingRequest;
import microsoft.dynamics.crm.entity.request.TransformationparametermappingRequest;

public class TransformationmappingCollectionRequest extends CollectionPageEntityRequest<Transformationmapping, TransformationmappingRequest>{

    protected ContextPath contextPath;

    public TransformationmappingCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Transformationmapping.class, cp -> new TransformationmappingRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TransformationparametermappingCollectionRequest transformationParameterMapping_TransformationMapping() {
        return new TransformationparametermappingCollectionRequest(contextPath.addSegment("TransformationParameterMapping_TransformationMapping"), Optional.empty());
    }

    public TransformationparametermappingRequest transformationParameterMapping_TransformationMapping(String transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("TransformationParameterMapping_TransformationMapping").addKeys(new NameValue(transformationparametermappingid.toString())), Optional.empty());
    }

}
