package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Theme;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ThemeRequest;

public class ThemeCollectionRequest extends CollectionPageEntityRequest<Theme, ThemeRequest>{

    protected ContextPath contextPath;

    public ThemeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Theme.class, cp -> new ThemeRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest theme_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("theme_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest theme_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("theme_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest theme_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("theme_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest theme_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("theme_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest theme_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("theme_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest theme_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("theme_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
