package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Teamtemplate;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TeamtemplateRequest;

public class TeamtemplateCollectionRequest extends CollectionPageEntityRequest<Teamtemplate, TeamtemplateRequest>{

    protected ContextPath contextPath;

    public TeamtemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Teamtemplate.class, cp -> new TeamtemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public TeamCollectionRequest teamtemplate_Teams() {
        return new TeamCollectionRequest(contextPath.addSegment("teamtemplate_Teams"), Optional.empty());
    }

    public TeamRequest teamtemplate_Teams(String ownerid) {
        return new TeamRequest(contextPath.addSegment("teamtemplate_Teams").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest teamTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("TeamTemplate_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest teamTemplate_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("TeamTemplate_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
