package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Systemform;
import microsoft.dynamics.crm.entity.Systemuser;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ProcesstriggerRequest;
import microsoft.dynamics.crm.entity.request.SystemformRequest;

public class SystemformCollectionRequest extends CollectionPageEntityRequest<Systemform, SystemformRequest>{

    protected ContextPath contextPath;

    public SystemformCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Systemform.class, cp -> new SystemformRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest systemForm_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SystemForm_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest systemForm_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SystemForm_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesstriggerCollectionRequest processtrigger_systemform() {
        return new ProcesstriggerCollectionRequest(contextPath.addSegment("processtrigger_systemform"), Optional.empty());
    }

    public ProcesstriggerRequest processtrigger_systemform(String processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("processtrigger_systemform").addKeys(new NameValue(processtriggerid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest systemForm_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("SystemForm_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest systemForm_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("SystemForm_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public SystemformCollectionRequest form_ancestor_form() {
        return new SystemformCollectionRequest(contextPath.addSegment("form_ancestor_form"), Optional.empty());
    }

    public SystemformRequest form_ancestor_form(String formid) {
        return new SystemformRequest(contextPath.addSegment("form_ancestor_form").addKeys(new NameValue(formid.toString())), Optional.empty());
    }

    @Function(name = "RetrieveFilteredForms")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Systemform> retrieveFilteredForms(String entityLogicalName, Integer formType, Systemuser user) {
        Preconditions.checkNotNull(entityLogicalName, "entityLogicalName cannot be null");
        Preconditions.checkNotNull(formType, "formType cannot be null");
        Preconditions.checkNotNull(user, "user cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("EntityLogicalName", "Edm.String", Checks.checkIsAscii(entityLogicalName))
            .put("FormType", "Edm.Int32", formType)
            .put("User", "Microsoft.Dynamics.CRM.systemuser", user)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveFilteredForms"), Systemform.class, _parameters);
    }

    @Function(name = "RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Systemform> retrieveUnpublishedMultiple() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Systemform.class, _parameters);
    }

}
