package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Socialprofile;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SocialprofileCollectionRequest extends CollectionPageEntityRequest<Socialprofile, SocialprofileRequest>{

    protected ContextPath contextPath;

    public SocialprofileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Socialprofile.class, cp -> new SocialprofileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public DuplicaterecordCollectionRequest socialProfile_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SocialProfile_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest socialProfile_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialProfile_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest socialProfile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SocialProfile_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest socialProfile_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SocialProfile_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest socialprofile_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("socialprofile_connections1"), Optional.empty());
    }

    public ConnectionRequest socialprofile_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialprofile_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest socialprofile_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("socialprofile_connections2"), Optional.empty());
    }

    public ConnectionRequest socialprofile_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("socialprofile_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest socialProfile_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SocialProfile_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest socialProfile_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SocialProfile_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest socialprofile_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("socialprofile_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest socialprofile_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("socialprofile_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest socialprofile_SocialActivities() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("Socialprofile_SocialActivities"), Optional.empty());
    }

    public SocialactivityRequest socialprofile_SocialActivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("Socialprofile_SocialActivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest socialProfile_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("SocialProfile_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest socialProfile_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SocialProfile_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest socialProfile_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SocialProfile_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest socialProfile_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SocialProfile_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    @Action(name = "GenerateSocialProfile")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Socialprofile> generateSocialProfile(Socialprofile entity) {
        Preconditions.checkNotNull(entity, "entity cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Entity", "Microsoft.Dynamics.CRM.socialprofile", entity)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Socialprofile>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.GenerateSocialProfile"), Socialprofile.class, _parameters);
    }

}
