package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Slakpiinstance;
import microsoft.dynamics.crm.entity.request.SlakpiinstanceRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SlakpiinstanceCollectionRequest extends CollectionPageEntityRequest<Slakpiinstance, SlakpiinstanceRequest>{

    protected ContextPath contextPath;

    public SlakpiinstanceCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Slakpiinstance.class, cp -> new SlakpiinstanceRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest sLAKPIInstance_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SLAKPIInstance_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest sLAKPIInstance_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SLAKPIInstance_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
