package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Sharepointsite;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class SharepointsiteCollectionRequest extends CollectionPageEntityRequest<Sharepointsite, SharepointsiteRequest>{

    protected ContextPath contextPath;

    public SharepointsiteCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Sharepointsite.class, cp -> new SharepointsiteRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ProcesssessionCollectionRequest sharePointSite_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("SharePointSite_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest sharePointSite_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SharePointSite_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointSite_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SharePointSite_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointSite_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointSite_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SharepointsiteCollectionRequest sharepointsite_parentsite_sharepointsite() {
        return new SharepointsiteCollectionRequest(contextPath.addSegment("sharepointsite_parentsite_sharepointsite"), Optional.empty());
    }

    public SharepointsiteRequest sharepointsite_parentsite_sharepointsite(String sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("sharepointsite_parentsite_sharepointsite").addKeys(new NameValue(sharepointsiteid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest sharepointsite_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("sharepointsite_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest sharepointsite_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("sharepointsite_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest sharePointSite_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("SharePointSite_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest sharePointSite_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SharePointSite_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest sharepointdocumentlocation_parent_sharepointsite() {
        return new SharepointdocumentlocationCollectionRequest(contextPath.addSegment("sharepointdocumentlocation_parent_sharepointsite"), Optional.empty());
    }

    public SharepointdocumentlocationRequest sharepointdocumentlocation_parent_sharepointsite(String sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("sharepointdocumentlocation_parent_sharepointsite").addKeys(new NameValue(sharepointdocumentlocationid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest sharePointSite_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("SharePointSite_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest sharePointSite_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SharePointSite_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest sharePointSite_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("SharePointSite_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest sharePointSite_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SharePointSite_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
