package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Serviceplan;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ServiceplanCollectionRequest extends CollectionPageEntityRequest<Serviceplan, ServiceplanRequest>{

    protected ContextPath contextPath;

    public ServiceplanCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Serviceplan.class, cp -> new ServiceplanRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest serviceplan_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("serviceplan_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest serviceplan_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("serviceplan_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest serviceplan_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("serviceplan_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest serviceplan_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("serviceplan_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest serviceplan_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("serviceplan_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest serviceplan_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("serviceplan_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest serviceplan_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("serviceplan_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest serviceplan_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("serviceplan_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest serviceplan_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("serviceplan_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest serviceplan_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("serviceplan_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest serviceplan_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("serviceplan_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest serviceplan_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("serviceplan_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest serviceplan_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("serviceplan_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest serviceplan_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("serviceplan_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest serviceplan_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("serviceplan_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest serviceplan_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("serviceplan_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public AppmoduleCollectionRequest serviceplan_appmodule_association() {
        return new AppmoduleCollectionRequest(contextPath.addSegment("serviceplan_appmodule_association"), Optional.empty());
    }

    public AppmoduleRequest serviceplan_appmodule_association(String appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("serviceplan_appmodule_association").addKeys(new NameValue(appmoduleid.toString())), Optional.empty());
    }

}
