package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.CreateExceptionResponse;
import microsoft.dynamics.crm.entity.Appointment;
import microsoft.dynamics.crm.entity.Recurringappointmentmaster;
import microsoft.dynamics.crm.entity.request.ActioncardRequest;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.PostfollowRequest;
import microsoft.dynamics.crm.entity.request.PostregardingRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.QueueitemRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class RecurringappointmentmasterCollectionRequest extends CollectionPageEntityRequest<Recurringappointmentmaster, RecurringappointmentmasterRequest>{

    protected ContextPath contextPath;

    public RecurringappointmentmasterCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Recurringappointmentmaster.class, cp -> new RecurringappointmentmasterRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PostregardingCollectionRequest recurringappointmentmaster_PostRegardings() {
        return new PostregardingCollectionRequest(contextPath.addSegment("recurringappointmentmaster_PostRegardings"), Optional.empty());
    }

    public PostregardingRequest recurringappointmentmaster_PostRegardings(String postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("recurringappointmentmaster_PostRegardings").addKeys(new NameValue(postregardingid.toString())), Optional.empty());
    }

    public PostfollowCollectionRequest recurringappointmentmaster_PostFollows() {
        return new PostfollowCollectionRequest(contextPath.addSegment("recurringappointmentmaster_PostFollows"), Optional.empty());
    }

    public PostfollowRequest recurringappointmentmaster_PostFollows(String postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("recurringappointmentmaster_PostFollows").addKeys(new NameValue(postfollowid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest recurringAppointmentMaster_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest recurringAppointmentMaster_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("RecurringAppointmentMaster_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest recurringAppointmentMaster_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest recurringAppointmentMaster_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("RecurringAppointmentMaster_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest recurringAppointmentMaster_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest recurringAppointmentMaster_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest recurringappointmentmaster_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("recurringappointmentmaster_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest recurringappointmentmaster_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("recurringappointmentmaster_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public ActivitypartyCollectionRequest recurringappointmentmaster_activity_parties() {
        return new ActivitypartyCollectionRequest(contextPath.addSegment("recurringappointmentmaster_activity_parties"), Optional.empty());
    }

    public ActivitypartyRequest recurringappointmentmaster_activity_parties(String activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("recurringappointmentmaster_activity_parties").addKeys(new NameValue(activitypartyid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest recurringAppointmentMaster_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest recurringAppointmentMaster_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("RecurringAppointmentMaster_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AppointmentCollectionRequest recurringappointmentmaster_appointment() {
        return new AppointmentCollectionRequest(contextPath.addSegment("recurringappointmentmaster_appointment"), Optional.empty());
    }

    public AppointmentRequest recurringappointmentmaster_appointment(String activityid) {
        return new AppointmentRequest(contextPath.addSegment("recurringappointmentmaster_appointment").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public QueueitemCollectionRequest recurringAppointmentMaster_QueueItem() {
        return new QueueitemCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_QueueItem"), Optional.empty());
    }

    public QueueitemRequest recurringAppointmentMaster_QueueItem(String queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("RecurringAppointmentMaster_QueueItem").addKeys(new NameValue(queueitemid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest recurringappointmentmaster_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("recurringappointmentmaster_connections1"), Optional.empty());
    }

    public ConnectionRequest recurringappointmentmaster_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("recurringappointmentmaster_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest recurringappointmentmaster_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("recurringappointmentmaster_connections2"), Optional.empty());
    }

    public ConnectionRequest recurringappointmentmaster_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("recurringappointmentmaster_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest recurringAppointmentMaster_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest recurringAppointmentMaster_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("RecurringAppointmentMaster_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public ActioncardCollectionRequest recurringappointmentmaster_actioncard() {
        return new ActioncardCollectionRequest(contextPath.addSegment("recurringappointmentmaster_actioncard"), Optional.empty());
    }

    public ActioncardRequest recurringappointmentmaster_actioncard(String actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("recurringappointmentmaster_actioncard").addKeys(new NameValue(actioncardid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest recurringAppointmentMaster_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest recurringAppointmentMaster_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("RecurringAppointmentMaster_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest recurringAppointmentMaster_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("RecurringAppointmentMaster_Annotation"), Optional.empty());
    }

    public AnnotationRequest recurringAppointmentMaster_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("RecurringAppointmentMaster_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    @Action(name = "CreateException")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<CreateExceptionResponse> createException(Appointment target, OffsetDateTime originalStartDate, Boolean isDeleted) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Preconditions.checkNotNull(originalStartDate, "originalStartDate cannot be null");
        Preconditions.checkNotNull(isDeleted, "isDeleted cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.appointment", target)
            .put("OriginalStartDate", "Edm.DateTimeOffset", originalStartDate)
            .put("IsDeleted", "Edm.Boolean", isDeleted)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<CreateExceptionResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.CreateException"), CreateExceptionResponse.class, _parameters);
    }

}
