package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Postlike;
import microsoft.dynamics.crm.entity.request.PostlikeRequest;

public class PostlikeCollectionRequest extends CollectionPageEntityRequest<Postlike, PostlikeRequest>{

    protected ContextPath contextPath;

    public PostlikeCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Postlike.class, cp -> new PostlikeRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

}
