package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Newprocess;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;

public class NewprocessCollectionRequest extends CollectionPageEntityRequest<Newprocess, NewprocessRequest>{

    protected ContextPath contextPath;

    public NewprocessCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Newprocess.class, cp -> new NewprocessRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ProcesssessionCollectionRequest newProcess_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("NewProcess_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest newProcess_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("NewProcess_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest workflowlogs_newprocess() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("workflowlogs_newprocess"), Optional.empty());
    }

    public WorkflowlogRequest workflowlogs_newprocess(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("workflowlogs_newprocess").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest newProcess_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("NewProcess_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest newProcess_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("NewProcess_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
