package microsoft.dynamics.crm.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Mobileofflineprofile;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

public class MobileofflineprofileCollectionRequest extends CollectionPageEntityRequest<Mobileofflineprofile, MobileofflineprofileRequest>{

    protected ContextPath contextPath;

    public MobileofflineprofileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Mobileofflineprofile.class, cp -> new MobileofflineprofileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public OrganizationCollectionRequest defaultMobileOfflineProfile_Organization() {
        return new OrganizationCollectionRequest(contextPath.addSegment("DefaultMobileOfflineProfile_Organization"), Optional.empty());
    }

    public OrganizationRequest defaultMobileOfflineProfile_Organization(String organizationid) {
        return new OrganizationRequest(contextPath.addSegment("DefaultMobileOfflineProfile_Organization").addKeys(new NameValue(organizationid.toString())), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest mobileOfflineProfile_MobileOfflineProfileItem() {
        return new MobileofflineprofileitemCollectionRequest(contextPath.addSegment("MobileOfflineProfile_MobileOfflineProfileItem"), Optional.empty());
    }

    public MobileofflineprofileitemRequest mobileOfflineProfile_MobileOfflineProfileItem(String mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("MobileOfflineProfile_MobileOfflineProfileItem").addKeys(new NameValue(mobileofflineprofileitemid.toString())), Optional.empty());
    }

    public SystemuserCollectionRequest mobileOfflineProfile_SystemUser() {
        return new SystemuserCollectionRequest(contextPath.addSegment("MobileOfflineProfile_SystemUser"), Optional.empty());
    }

    public SystemuserRequest mobileOfflineProfile_SystemUser(String ownerid) {
        return new SystemuserRequest(contextPath.addSegment("MobileOfflineProfile_SystemUser").addKeys(new NameValue(ownerid.toString())), Optional.empty());
    }

    @Function(name = "RetrieveUnpublishedMultiple")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Mobileofflineprofile> retrieveUnpublishedMultiple() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublishedMultiple"), Mobileofflineprofile.class, _parameters);
    }

}
