package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Mailmergetemplate;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.MailmergetemplateRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class MailmergetemplateCollectionRequest extends CollectionPageEntityRequest<Mailmergetemplate, MailmergetemplateRequest>{

    protected ContextPath contextPath;

    public MailmergetemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Mailmergetemplate.class, cp -> new MailmergetemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public PrincipalobjectattributeaccessCollectionRequest mailmergetemplate_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("mailmergetemplate_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest mailmergetemplate_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("mailmergetemplate_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest mailMergeTemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("MailMergeTemplate_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest mailMergeTemplate_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("MailMergeTemplate_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest mailMergeTemplate_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("MailMergeTemplate_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest mailMergeTemplate_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("MailMergeTemplate_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest mailMergeTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("MailMergeTemplate_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest mailMergeTemplate_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("MailMergeTemplate_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
