package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Knowledgearticleviews;
import microsoft.dynamics.crm.entity.request.KnowledgearticleviewsRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class KnowledgearticleviewsCollectionRequest extends CollectionPageEntityRequest<Knowledgearticleviews, KnowledgearticleviewsRequest>{

    protected ContextPath contextPath;

    public KnowledgearticleviewsCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Knowledgearticleviews.class, cp -> new KnowledgearticleviewsRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest knowledgeArticleViews_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("KnowledgeArticleViews_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest knowledgeArticleViews_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KnowledgeArticleViews_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest knowledgearticleviews_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("knowledgearticleviews_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest knowledgearticleviews_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("knowledgearticleviews_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

}
