package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Kbarticletemplate;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KbarticletemplateRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class KbarticletemplateCollectionRequest extends CollectionPageEntityRequest<Kbarticletemplate, KbarticletemplateRequest>{

    protected ContextPath contextPath;

    public KbarticletemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Kbarticletemplate.class, cp -> new KbarticletemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ProcesssessionCollectionRequest kbArticleTemplate_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("KbArticleTemplate_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest kbArticleTemplate_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("KbArticleTemplate_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest kbArticleTemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("KbArticleTemplate_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest kbArticleTemplate_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("KbArticleTemplate_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public KbarticleCollectionRequest kb_article_template_kb_articles() {
        return new KbarticleCollectionRequest(contextPath.addSegment("kb_article_template_kb_articles"), Optional.empty());
    }

    public KbarticleRequest kb_article_template_kb_articles(String kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("kb_article_template_kb_articles").addKeys(new NameValue(kbarticleid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest kbArticleTemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("KbArticleTemplate_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest kbArticleTemplate_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("KbArticleTemplate_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest kbArticleTemplate_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("KbArticleTemplate_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest kbArticleTemplate_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("KbArticleTemplate_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
