package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Importfile;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;

public class ImportfileCollectionRequest extends CollectionPageEntityRequest<Importfile, ImportfileRequest>{

    protected ContextPath contextPath;

    public ImportfileCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Importfile.class, cp -> new ImportfileRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest importFile_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ImportFile_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest importFile_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ImportFile_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest importFile_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ImportFile_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest importFile_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ImportFile_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public ImportdataCollectionRequest importFile_ImportData() {
        return new ImportdataCollectionRequest(contextPath.addSegment("ImportFile_ImportData"), Optional.empty());
    }

    public ImportdataRequest importFile_ImportData(String importdataid) {
        return new ImportdataRequest(contextPath.addSegment("ImportFile_ImportData").addKeys(new NameValue(importdataid.toString())), Optional.empty());
    }

    public ImportlogCollectionRequest importLog_ImportFile() {
        return new ImportlogCollectionRequest(contextPath.addSegment("ImportLog_ImportFile"), Optional.empty());
    }

    public ImportlogRequest importLog_ImportFile(String importlogid) {
        return new ImportlogRequest(contextPath.addSegment("ImportLog_ImportFile").addKeys(new NameValue(importlogid.toString())), Optional.empty());
    }

}
