package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Importdata;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ImportdataRequest;
import microsoft.dynamics.crm.entity.request.ImportlogRequest;

public class ImportdataCollectionRequest extends CollectionPageEntityRequest<Importdata, ImportdataRequest>{

    protected ContextPath contextPath;

    public ImportdataCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Importdata.class, cp -> new ImportdataRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationCollectionRequest importData_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("ImportData_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest importData_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("ImportData_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public ImportlogCollectionRequest importLog_ImportData() {
        return new ImportlogCollectionRequest(contextPath.addSegment("ImportLog_ImportData"), Optional.empty());
    }

    public ImportlogRequest importLog_ImportData(String importlogid) {
        return new ImportlogRequest(contextPath.addSegment("ImportLog_ImportData").addKeys(new NameValue(importlogid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest importData_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("ImportData_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest importData_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("ImportData_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

}
