package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Import;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.ImportRequest;
import microsoft.dynamics.crm.entity.request.ImportfileRequest;

public class ImportCollectionRequest extends CollectionPageEntityRequest<Import, ImportRequest>{

    protected ContextPath contextPath;

    public ImportCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Import.class, cp -> new ImportRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public ImportfileCollectionRequest import_ImportFile() {
        return new ImportfileCollectionRequest(contextPath.addSegment("Import_ImportFile"), Optional.empty());
    }

    public ImportfileRequest import_ImportFile(String importfileid) {
        return new ImportfileRequest(contextPath.addSegment("Import_ImportFile").addKeys(new NameValue(importfileid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest import_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Import_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest import_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Import_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest import_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Import_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest import_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Import_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

}
