package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Goal;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ConnectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class GoalCollectionRequest extends CollectionPageEntityRequest<Goal, GoalRequest>{

    protected ContextPath contextPath;

    public GoalCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Goal.class, cp -> new GoalRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public GoalCollectionRequest goal_parent_goal() {
        return new GoalCollectionRequest(contextPath.addSegment("goal_parent_goal"), Optional.empty());
    }

    public GoalRequest goal_parent_goal(String goalid) {
        return new GoalRequest(contextPath.addSegment("goal_parent_goal").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goal_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Goal_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest goal_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Goal_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public GoalCollectionRequest goal_RollupError_Goal() {
        return new GoalCollectionRequest(contextPath.addSegment("Goal_RollupError_Goal"), Optional.empty());
    }

    public GoalRequest goal_RollupError_Goal(String goalid) {
        return new GoalRequest(contextPath.addSegment("Goal_RollupError_Goal").addKeys(new NameValue(goalid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest goal_connections2() {
        return new ConnectionCollectionRequest(contextPath.addSegment("goal_connections2"), Optional.empty());
    }

    public ConnectionRequest goal_connections2(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("goal_connections2").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public SyncerrorCollectionRequest goal_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Goal_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest goal_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Goal_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AnnotationCollectionRequest goal_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Goal_Annotation"), Optional.empty());
    }

    public AnnotationRequest goal_Annotation(String annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Goal_Annotation").addKeys(new NameValue(annotationid.toString())), Optional.empty());
    }

    public ConnectionCollectionRequest goal_connections1() {
        return new ConnectionCollectionRequest(contextPath.addSegment("goal_connections1"), Optional.empty());
    }

    public ConnectionRequest goal_connections1(String connectionid) {
        return new ConnectionRequest(contextPath.addSegment("goal_connections1").addKeys(new NameValue(connectionid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest goal_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Goal_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest goal_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Goal_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest goal_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("Goal_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest goal_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Goal_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest goal_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Goal_ProcessSessions"), Optional.empty());
    }

    public ProcesssessionRequest goal_ProcessSessions(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Goal_ProcessSessions").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest goal_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("goal_principalobjectattributeaccess"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest goal_principalobjectattributeaccess(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("goal_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

}
