package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Exportsolutionupload;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ExportsolutionuploadCollectionRequest extends CollectionPageEntityRequest<Exportsolutionupload, ExportsolutionuploadRequest>{

    protected ContextPath contextPath;

    public ExportsolutionuploadCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Exportsolutionupload.class, cp -> new ExportsolutionuploadRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest exportsolutionupload_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("exportsolutionupload_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest exportsolutionupload_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("exportsolutionupload_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest exportsolutionupload_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("exportsolutionupload_DuplicateMatchingRecord"), Optional.empty());
    }

    public DuplicaterecordRequest exportsolutionupload_DuplicateMatchingRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("exportsolutionupload_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest exportsolutionupload_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("exportsolutionupload_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest exportsolutionupload_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("exportsolutionupload_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest exportsolutionupload_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("exportsolutionupload_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest exportsolutionupload_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("exportsolutionupload_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest exportsolutionupload_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("exportsolutionupload_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest exportsolutionupload_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("exportsolutionupload_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public ProcesssessionCollectionRequest exportsolutionupload_ProcessSession() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("exportsolutionupload_ProcessSession"), Optional.empty());
    }

    public ProcesssessionRequest exportsolutionupload_ProcessSession(String processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("exportsolutionupload_ProcessSession").addKeys(new NameValue(processsessionid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest exportsolutionupload_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("exportsolutionupload_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest exportsolutionupload_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("exportsolutionupload_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest exportsolutionupload_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("exportsolutionupload_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest exportsolutionupload_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("exportsolutionupload_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

    public FileattachmentCollectionRequest exportsolutionupload_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("exportsolutionupload_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest exportsolutionupload_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("exportsolutionupload_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

}
