package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Entityanalyticsconfig;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.EntityanalyticsconfigRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.PrincipalobjectattributeaccessRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class EntityanalyticsconfigCollectionRequest extends CollectionPageEntityRequest<Entityanalyticsconfig, EntityanalyticsconfigRequest>{

    protected ContextPath contextPath;

    public EntityanalyticsconfigCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Entityanalyticsconfig.class, cp -> new EntityanalyticsconfigRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest entityanalyticsconfig_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("entityanalyticsconfig_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest entityanalyticsconfig_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("entityanalyticsconfig_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

    public AsyncoperationCollectionRequest entityanalyticsconfig_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("entityanalyticsconfig_AsyncOperations"), Optional.empty());
    }

    public AsyncoperationRequest entityanalyticsconfig_AsyncOperations(String asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("entityanalyticsconfig_AsyncOperations").addKeys(new NameValue(asyncoperationid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest entityanalyticsconfig_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("entityanalyticsconfig_MailboxTrackingFolders"), Optional.empty());
    }

    public MailboxtrackingfolderRequest entityanalyticsconfig_MailboxTrackingFolders(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("entityanalyticsconfig_MailboxTrackingFolders").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest entityanalyticsconfig_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("entityanalyticsconfig_BulkDeleteFailures"), Optional.empty());
    }

    public BulkdeletefailureRequest entityanalyticsconfig_BulkDeleteFailures(String bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("entityanalyticsconfig_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid.toString())), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest entityanalyticsconfig_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(contextPath.addSegment("entityanalyticsconfig_PrincipalObjectAttributeAccesses"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest entityanalyticsconfig_PrincipalObjectAttributeAccesses(String principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("entityanalyticsconfig_PrincipalObjectAttributeAccesses").addKeys(new NameValue(principalobjectattributeaccessid.toString())), Optional.empty());
    }

}
