package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Asyncoperation;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeleteoperationRequest;
import microsoft.dynamics.crm.entity.request.DuplicaterecordRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FileattachmentRequest;
import microsoft.dynamics.crm.entity.request.MailboxtrackingfolderRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.WorkflowlogRequest;

public class AsyncoperationCollectionRequest extends CollectionPageEntityRequest<Asyncoperation, AsyncoperationRequest>{

    protected ContextPath contextPath;

    public AsyncoperationCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Asyncoperation.class, cp -> new AsyncoperationRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public EmailCollectionRequest asyncOperation_Emails() {
        return new EmailCollectionRequest(contextPath.addSegment("AsyncOperation_Emails"), Optional.empty());
    }

    public EmailRequest asyncOperation_Emails(String activityid) {
        return new EmailRequest(contextPath.addSegment("AsyncOperation_Emails").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public BulkdeleteoperationCollectionRequest asyncOperation_BulkDeleteOperation() {
        return new BulkdeleteoperationCollectionRequest(contextPath.addSegment("AsyncOperation_BulkDeleteOperation"), Optional.empty());
    }

    public BulkdeleteoperationRequest asyncOperation_BulkDeleteOperation(String bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("AsyncOperation_BulkDeleteOperation").addKeys(new NameValue(bulkdeleteoperationid.toString())), Optional.empty());
    }

    public SocialactivityCollectionRequest asyncOperation_SocialActivities() {
        return new SocialactivityCollectionRequest(contextPath.addSegment("AsyncOperation_SocialActivities"), Optional.empty());
    }

    public SocialactivityRequest asyncOperation_SocialActivities(String activityid) {
        return new SocialactivityRequest(contextPath.addSegment("AsyncOperation_SocialActivities").addKeys(new NameValue(activityid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_asyncoperation_childworkflow() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("lk_workflowlog_asyncoperation_childworkflow"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_asyncoperation_childworkflow(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_asyncoperation_childworkflow").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public DuplicaterecordCollectionRequest asyncOperation_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(contextPath.addSegment("AsyncOperation_DuplicateBaseRecord"), Optional.empty());
    }

    public DuplicaterecordRequest asyncOperation_DuplicateBaseRecord(String duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("AsyncOperation_DuplicateBaseRecord").addKeys(new NameValue(duplicateid.toString())), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest asyncOperation_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(contextPath.addSegment("AsyncOperation_MailboxTrackingFolder"), Optional.empty());
    }

    public MailboxtrackingfolderRequest asyncOperation_MailboxTrackingFolder(String mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("AsyncOperation_MailboxTrackingFolder").addKeys(new NameValue(mailboxtrackingfolderid.toString())), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_asyncoperations() {
        return new WorkflowlogCollectionRequest(contextPath.addSegment("lk_workflowlog_asyncoperations"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_asyncoperations(String workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_asyncoperations").addKeys(new NameValue(workflowlogid.toString())), Optional.empty());
    }

    public FileattachmentCollectionRequest asyncoperation_FileAttachments() {
        return new FileattachmentCollectionRequest(contextPath.addSegment("asyncoperation_FileAttachments"), Optional.empty());
    }

    public FileattachmentRequest asyncoperation_FileAttachments(String fileattachmentid) {
        return new FileattachmentRequest(contextPath.addSegment("asyncoperation_FileAttachments").addKeys(new NameValue(fileattachmentid.toString())), Optional.empty());
    }

}
