package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.internal.RequestHelper;

import java.lang.Object;
import java.lang.String;
import java.util.Optional;

import microsoft.dynamics.crm.entity.Activityparty;
import microsoft.dynamics.crm.entity.request.ActivitypartyRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;

public class ActivitypartyCollectionRequest extends CollectionPageEntityRequest<Activityparty, ActivitypartyRequest>{

    protected ContextPath contextPath;

    public ActivitypartyCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Activityparty.class, cp -> new ActivitypartyRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorCollectionRequest activityParty_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("ActivityParty_SyncErrors"), Optional.empty());
    }

    public SyncerrorRequest activityParty_SyncErrors(String syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("ActivityParty_SyncErrors").addKeys(new NameValue(syncerrorid.toString())), Optional.empty());
    }

}
