package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.complex.RetrieveAbsoluteAndSiteCollectionUrlResponse;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "_ownerid_value", 
    "timezoneruleversionnumber", 
    "createdon", 
    "statuscode", 
    "_owningbusinessunit_value", 
    "userid", 
    "relativeurl", 
    "_owninguser_value", 
    "absoluteurl", 
    "importsequencenumber", 
    "_createdby_value", 
    "locationtype", 
    "_modifiedonbehalfby_value", 
    "name", 
    "_regardingobjectid_value", 
    "_parentsiteorlocation_value", 
    "versionnumber", 
    "_transactioncurrencyid_value", 
    "statecode", 
    "_owningteam_value", 
    "exchangerate", 
    "sitecollectionid", 
    "overriddencreatedon", 
    "modifiedon", 
    "_modifiedby_value", 
    "sharepointdocumentlocationid", 
    "servicetype", 
    "_createdonbehalfby_value", 
    "utcconversiontimezonecode"})
@JsonInclude(Include.NON_NULL)
public class Sharepointdocumentlocation extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.sharepointdocumentlocation";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("userid")
    protected String userid;

    @JsonProperty("relativeurl")
    protected String relativeurl;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("absoluteurl")
    protected String absoluteurl;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("locationtype")
    protected Integer locationtype;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_regardingobjectid_value")
    protected String _regardingobjectid_value;

    @JsonProperty("_parentsiteorlocation_value")
    protected String _parentsiteorlocation_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("sitecollectionid")
    protected String sitecollectionid;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("sharepointdocumentlocationid")
    protected String sharepointdocumentlocationid;

    @JsonProperty("servicetype")
    protected Integer servicetype;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    protected Sharepointdocumentlocation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSharepointdocumentlocation() {
        return new Builder();
    }

    public static final class Builder {
        private String description;
        private String _ownerid_value;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime createdon;
        private Integer statuscode;
        private String _owningbusinessunit_value;
        private String userid;
        private String relativeurl;
        private String _owninguser_value;
        private String absoluteurl;
        private Integer importsequencenumber;
        private String _createdby_value;
        private Integer locationtype;
        private String _modifiedonbehalfby_value;
        private String name;
        private String _regardingobjectid_value;
        private String _parentsiteorlocation_value;
        private Long versionnumber;
        private String _transactioncurrencyid_value;
        private Integer statecode;
        private String _owningteam_value;
        private BigDecimal exchangerate;
        private String sitecollectionid;
        private OffsetDateTime overriddencreatedon;
        private OffsetDateTime modifiedon;
        private String _modifiedby_value;
        private String sharepointdocumentlocationid;
        private Integer servicetype;
        private String _createdonbehalfby_value;
        private Integer utcconversiontimezonecode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder userid(String userid) {
            this.userid = userid;
            this.changedFields = changedFields.add("userid");
            return this;
        }

        public Builder relativeurl(String relativeurl) {
            this.relativeurl = relativeurl;
            this.changedFields = changedFields.add("relativeurl");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder absoluteurl(String absoluteurl) {
            this.absoluteurl = absoluteurl;
            this.changedFields = changedFields.add("absoluteurl");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder locationtype(Integer locationtype) {
            this.locationtype = locationtype;
            this.changedFields = changedFields.add("locationtype");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder _parentsiteorlocation_value(String _parentsiteorlocation_value) {
            this._parentsiteorlocation_value = _parentsiteorlocation_value;
            this.changedFields = changedFields.add("_parentsiteorlocation_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder sitecollectionid(String sitecollectionid) {
            this.sitecollectionid = sitecollectionid;
            this.changedFields = changedFields.add("sitecollectionid");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder sharepointdocumentlocationid(String sharepointdocumentlocationid) {
            this.sharepointdocumentlocationid = sharepointdocumentlocationid;
            this.changedFields = changedFields.add("sharepointdocumentlocationid");
            return this;
        }

        public Builder servicetype(Integer servicetype) {
            this.servicetype = servicetype;
            this.changedFields = changedFields.add("servicetype");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Sharepointdocumentlocation build() {
            Sharepointdocumentlocation _x = new Sharepointdocumentlocation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.sharepointdocumentlocation";
            _x.description = description;
            _x._ownerid_value = _ownerid_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.createdon = createdon;
            _x.statuscode = statuscode;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.userid = userid;
            _x.relativeurl = relativeurl;
            _x._owninguser_value = _owninguser_value;
            _x.absoluteurl = absoluteurl;
            _x.importsequencenumber = importsequencenumber;
            _x._createdby_value = _createdby_value;
            _x.locationtype = locationtype;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.name = name;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x._parentsiteorlocation_value = _parentsiteorlocation_value;
            _x.versionnumber = versionnumber;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.statecode = statecode;
            _x._owningteam_value = _owningteam_value;
            _x.exchangerate = exchangerate;
            _x.sitecollectionid = sitecollectionid;
            _x.overriddencreatedon = overriddencreatedon;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            _x.sharepointdocumentlocationid = sharepointdocumentlocationid;
            _x.servicetype = servicetype;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && sharepointdocumentlocationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(sharepointdocumentlocationid.toString()));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Sharepointdocumentlocation withDescription(String description) {
        Checks.checkIsAscii(description);
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.description = description;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Sharepointdocumentlocation with_ownerid_value(String _ownerid_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Sharepointdocumentlocation withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Sharepointdocumentlocation withCreatedon(OffsetDateTime createdon) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Sharepointdocumentlocation withStatuscode(Integer statuscode) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Sharepointdocumentlocation with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="userid")
    @JsonIgnore
    public Optional<String> getUserid() {
        return Optional.ofNullable(userid);
    }

    public Sharepointdocumentlocation withUserid(String userid) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("userid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.userid = userid;
        return _x;
    }

    @Property(name="relativeurl")
    @JsonIgnore
    public Optional<String> getRelativeurl() {
        return Optional.ofNullable(relativeurl);
    }

    public Sharepointdocumentlocation withRelativeurl(String relativeurl) {
        Checks.checkIsAscii(relativeurl);
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("relativeurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.relativeurl = relativeurl;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Sharepointdocumentlocation with_owninguser_value(String _owninguser_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="absoluteurl")
    @JsonIgnore
    public Optional<String> getAbsoluteurl() {
        return Optional.ofNullable(absoluteurl);
    }

    public Sharepointdocumentlocation withAbsoluteurl(String absoluteurl) {
        Checks.checkIsAscii(absoluteurl);
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("absoluteurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.absoluteurl = absoluteurl;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Sharepointdocumentlocation withImportsequencenumber(Integer importsequencenumber) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Sharepointdocumentlocation with_createdby_value(String _createdby_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="locationtype")
    @JsonIgnore
    public Optional<Integer> getLocationtype() {
        return Optional.ofNullable(locationtype);
    }

    public Sharepointdocumentlocation withLocationtype(Integer locationtype) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("locationtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.locationtype = locationtype;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Sharepointdocumentlocation with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Sharepointdocumentlocation withName(String name) {
        Checks.checkIsAscii(name);
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.name = name;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Sharepointdocumentlocation with_regardingobjectid_value(String _regardingobjectid_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="_parentsiteorlocation_value")
    @JsonIgnore
    public Optional<String> get_parentsiteorlocation_value() {
        return Optional.ofNullable(_parentsiteorlocation_value);
    }

    public Sharepointdocumentlocation with_parentsiteorlocation_value(String _parentsiteorlocation_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_parentsiteorlocation_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._parentsiteorlocation_value = _parentsiteorlocation_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Sharepointdocumentlocation withVersionnumber(Long versionnumber) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Sharepointdocumentlocation with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Sharepointdocumentlocation withStatecode(Integer statecode) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Sharepointdocumentlocation with_owningteam_value(String _owningteam_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Sharepointdocumentlocation withExchangerate(BigDecimal exchangerate) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="sitecollectionid")
    @JsonIgnore
    public Optional<String> getSitecollectionid() {
        return Optional.ofNullable(sitecollectionid);
    }

    public Sharepointdocumentlocation withSitecollectionid(String sitecollectionid) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("sitecollectionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.sitecollectionid = sitecollectionid;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Sharepointdocumentlocation withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Sharepointdocumentlocation withModifiedon(OffsetDateTime modifiedon) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Sharepointdocumentlocation with_modifiedby_value(String _modifiedby_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="sharepointdocumentlocationid")
    @JsonIgnore
    public Optional<String> getSharepointdocumentlocationid() {
        return Optional.ofNullable(sharepointdocumentlocationid);
    }

    public Sharepointdocumentlocation withSharepointdocumentlocationid(String sharepointdocumentlocationid) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("sharepointdocumentlocationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.sharepointdocumentlocationid = sharepointdocumentlocationid;
        return _x;
    }

    @Property(name="servicetype")
    @JsonIgnore
    public Optional<Integer> getServicetype() {
        return Optional.ofNullable(servicetype);
    }

    public Sharepointdocumentlocation withServicetype(Integer servicetype) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("servicetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.servicetype = servicetype;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Sharepointdocumentlocation with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Sharepointdocumentlocation withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sharepointdocumentlocation");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    public Sharepointdocumentlocation withUnmappedField(String name, String value) {
        Sharepointdocumentlocation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="regardingobjectid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getRegardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_knowledgearticle"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="regardingobjectid_account")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account"));
    }

    @NavigationProperty(name="sharepointdocumentlocation_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getSharepointdocumentlocation_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("sharepointdocumentlocation_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "sharepointdocumentlocation_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="parentsiteorlocation_sharepointdocumentlocation")
    @JsonIgnore
    public SharepointdocumentlocationRequest getParentsiteorlocation_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("parentsiteorlocation_sharepointdocumentlocation"), RequestHelper.getValue(unmappedFields, "parentsiteorlocation_sharepointdocumentlocation"));
    }

    @NavigationProperty(name="sharepointdocumentlocation_parent_sharepointdocumentlocation")
    @JsonIgnore
    public SharepointdocumentlocationCollectionRequest getSharepointdocumentlocation_parent_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("sharepointdocumentlocation_parent_sharepointdocumentlocation"), RequestHelper.getValue(unmappedFields, "sharepointdocumentlocation_parent_sharepointdocumentlocation"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="SharePointDocumentLocation_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSharePointDocumentLocation_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "SharePointDocumentLocation_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="parentsiteorlocation_sharepointsite")
    @JsonIgnore
    public SharepointsiteRequest getParentsiteorlocation_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("parentsiteorlocation_sharepointsite"), RequestHelper.getValue(unmappedFields, "parentsiteorlocation_sharepointsite"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="regardingobjectid_kbarticle")
    @JsonIgnore
    public KbarticleRequest getRegardingobjectid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("regardingobjectid_kbarticle"), RequestHelper.getValue(unmappedFields, "regardingobjectid_kbarticle"));
    }

    @NavigationProperty(name="SharePointDocumentLocation_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getSharePointDocumentLocation_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "SharePointDocumentLocation_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="SharePointDocumentLocation_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getSharePointDocumentLocation_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_ProcessSessions"), RequestHelper.getValue(unmappedFields, "SharePointDocumentLocation_ProcessSessions"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="SharePointDocumentLocation_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getSharePointDocumentLocation_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_SyncErrors"), RequestHelper.getValue(unmappedFields, "SharePointDocumentLocation_SyncErrors"));
    }

    @NavigationProperty(name="SharePointDocumentLocation_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getSharePointDocumentLocation_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SharePointDocumentLocation_AsyncOperations"), RequestHelper.getValue(unmappedFields, "SharePointDocumentLocation_AsyncOperations"));
    }

    @NavigationProperty(name="regardingobjectid_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateRequest getRegardingobjectid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("regardingobjectid_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "regardingobjectid_msdyn_knowledgearticletemplate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sharepointdocumentlocation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sharepointdocumentlocation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Sharepointdocumentlocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Sharepointdocumentlocation _copy() {
        Sharepointdocumentlocation _x = new Sharepointdocumentlocation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.description = description;
        _x._ownerid_value = _ownerid_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.createdon = createdon;
        _x.statuscode = statuscode;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.userid = userid;
        _x.relativeurl = relativeurl;
        _x._owninguser_value = _owninguser_value;
        _x.absoluteurl = absoluteurl;
        _x.importsequencenumber = importsequencenumber;
        _x._createdby_value = _createdby_value;
        _x.locationtype = locationtype;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.name = name;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x._parentsiteorlocation_value = _parentsiteorlocation_value;
        _x.versionnumber = versionnumber;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.statecode = statecode;
        _x._owningteam_value = _owningteam_value;
        _x.exchangerate = exchangerate;
        _x.sitecollectionid = sitecollectionid;
        _x.overriddencreatedon = overriddencreatedon;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        _x.sharepointdocumentlocationid = sharepointdocumentlocationid;
        _x.servicetype = servicetype;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Function(name = "RetrieveAbsoluteAndSiteCollectionUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse> retrieveAbsoluteAndSiteCollectionUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveAbsoluteAndSiteCollectionUrlResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrl"), RetrieveAbsoluteAndSiteCollectionUrlResponse.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Sharepointdocumentlocation[");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("userid=");
        b.append(this.userid);
        b.append(", ");
        b.append("relativeurl=");
        b.append(this.relativeurl);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("absoluteurl=");
        b.append(this.absoluteurl);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("locationtype=");
        b.append(this.locationtype);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("_parentsiteorlocation_value=");
        b.append(this._parentsiteorlocation_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("sitecollectionid=");
        b.append(this.sitecollectionid);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("sharepointdocumentlocationid=");
        b.append(this.sharepointdocumentlocationid);
        b.append(", ");
        b.append("servicetype=");
        b.append(this.servicetype);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
