package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SdkmessageRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "ismanaged", 
    "secondaryobjecttypecode", 
    "overwritetime", 
    "sdkmessagefilterid", 
    "_modifiedonbehalfby_value", 
    "customizationlevel", 
    "_sdkmessageid_value", 
    "isvisible", 
    "workflowsdkstepenabled", 
    "primaryobjecttypecode", 
    "introducedversion", 
    "sdkmessagefilteridunique", 
    "versionnumber", 
    "_createdonbehalfby_value", 
    "createdon", 
    "_organizationid_value", 
    "componentstate", 
    "_modifiedby_value", 
    "restrictionlevel", 
    "_createdby_value", 
    "solutionid", 
    "iscustomprocessingstepallowed", 
    "availability", 
    "modifiedon"})
@JsonInclude(Include.NON_NULL)
public class Sdkmessagefilter extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.sdkmessagefilter";
    }

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("secondaryobjecttypecode")
    protected String secondaryobjecttypecode;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("sdkmessagefilterid")
    protected String sdkmessagefilterid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("customizationlevel")
    protected Integer customizationlevel;

    @JsonProperty("_sdkmessageid_value")
    protected String _sdkmessageid_value;

    @JsonProperty("isvisible")
    protected Boolean isvisible;

    @JsonProperty("workflowsdkstepenabled")
    protected Boolean workflowsdkstepenabled;

    @JsonProperty("primaryobjecttypecode")
    protected String primaryobjecttypecode;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("sdkmessagefilteridunique")
    protected String sdkmessagefilteridunique;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("restrictionlevel")
    protected Integer restrictionlevel;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("iscustomprocessingstepallowed")
    protected Boolean iscustomprocessingstepallowed;

    @JsonProperty("availability")
    protected Integer availability;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    protected Sdkmessagefilter() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderSdkmessagefilter() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean ismanaged;
        private String secondaryobjecttypecode;
        private OffsetDateTime overwritetime;
        private String sdkmessagefilterid;
        private String _modifiedonbehalfby_value;
        private Integer customizationlevel;
        private String _sdkmessageid_value;
        private Boolean isvisible;
        private Boolean workflowsdkstepenabled;
        private String primaryobjecttypecode;
        private String introducedversion;
        private String sdkmessagefilteridunique;
        private Long versionnumber;
        private String _createdonbehalfby_value;
        private OffsetDateTime createdon;
        private String _organizationid_value;
        private Integer componentstate;
        private String _modifiedby_value;
        private Integer restrictionlevel;
        private String _createdby_value;
        private String solutionid;
        private Boolean iscustomprocessingstepallowed;
        private Integer availability;
        private OffsetDateTime modifiedon;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder secondaryobjecttypecode(String secondaryobjecttypecode) {
            this.secondaryobjecttypecode = secondaryobjecttypecode;
            this.changedFields = changedFields.add("secondaryobjecttypecode");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder sdkmessagefilterid(String sdkmessagefilterid) {
            this.sdkmessagefilterid = sdkmessagefilterid;
            this.changedFields = changedFields.add("sdkmessagefilterid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder customizationlevel(Integer customizationlevel) {
            this.customizationlevel = customizationlevel;
            this.changedFields = changedFields.add("customizationlevel");
            return this;
        }

        public Builder _sdkmessageid_value(String _sdkmessageid_value) {
            this._sdkmessageid_value = _sdkmessageid_value;
            this.changedFields = changedFields.add("_sdkmessageid_value");
            return this;
        }

        public Builder isvisible(Boolean isvisible) {
            this.isvisible = isvisible;
            this.changedFields = changedFields.add("isvisible");
            return this;
        }

        public Builder workflowsdkstepenabled(Boolean workflowsdkstepenabled) {
            this.workflowsdkstepenabled = workflowsdkstepenabled;
            this.changedFields = changedFields.add("workflowsdkstepenabled");
            return this;
        }

        public Builder primaryobjecttypecode(String primaryobjecttypecode) {
            this.primaryobjecttypecode = primaryobjecttypecode;
            this.changedFields = changedFields.add("primaryobjecttypecode");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder sdkmessagefilteridunique(String sdkmessagefilteridunique) {
            this.sdkmessagefilteridunique = sdkmessagefilteridunique;
            this.changedFields = changedFields.add("sdkmessagefilteridunique");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder restrictionlevel(Integer restrictionlevel) {
            this.restrictionlevel = restrictionlevel;
            this.changedFields = changedFields.add("restrictionlevel");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder iscustomprocessingstepallowed(Boolean iscustomprocessingstepallowed) {
            this.iscustomprocessingstepallowed = iscustomprocessingstepallowed;
            this.changedFields = changedFields.add("iscustomprocessingstepallowed");
            return this;
        }

        public Builder availability(Integer availability) {
            this.availability = availability;
            this.changedFields = changedFields.add("availability");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Sdkmessagefilter build() {
            Sdkmessagefilter _x = new Sdkmessagefilter();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.sdkmessagefilter";
            _x.ismanaged = ismanaged;
            _x.secondaryobjecttypecode = secondaryobjecttypecode;
            _x.overwritetime = overwritetime;
            _x.sdkmessagefilterid = sdkmessagefilterid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.customizationlevel = customizationlevel;
            _x._sdkmessageid_value = _sdkmessageid_value;
            _x.isvisible = isvisible;
            _x.workflowsdkstepenabled = workflowsdkstepenabled;
            _x.primaryobjecttypecode = primaryobjecttypecode;
            _x.introducedversion = introducedversion;
            _x.sdkmessagefilteridunique = sdkmessagefilteridunique;
            _x.versionnumber = versionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.createdon = createdon;
            _x._organizationid_value = _organizationid_value;
            _x.componentstate = componentstate;
            _x._modifiedby_value = _modifiedby_value;
            _x.restrictionlevel = restrictionlevel;
            _x._createdby_value = _createdby_value;
            _x.solutionid = solutionid;
            _x.iscustomprocessingstepallowed = iscustomprocessingstepallowed;
            _x.availability = availability;
            _x.modifiedon = modifiedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && sdkmessagefilterid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(sdkmessagefilterid.toString()));
        }
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Sdkmessagefilter withIsmanaged(Boolean ismanaged) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="secondaryobjecttypecode")
    @JsonIgnore
    public Optional<String> getSecondaryobjecttypecode() {
        return Optional.ofNullable(secondaryobjecttypecode);
    }

    public Sdkmessagefilter withSecondaryobjecttypecode(String secondaryobjecttypecode) {
        Checks.checkIsAscii(secondaryobjecttypecode);
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("secondaryobjecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.secondaryobjecttypecode = secondaryobjecttypecode;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Sdkmessagefilter withOverwritetime(OffsetDateTime overwritetime) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="sdkmessagefilterid")
    @JsonIgnore
    public Optional<String> getSdkmessagefilterid() {
        return Optional.ofNullable(sdkmessagefilterid);
    }

    public Sdkmessagefilter withSdkmessagefilterid(String sdkmessagefilterid) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("sdkmessagefilterid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.sdkmessagefilterid = sdkmessagefilterid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Sdkmessagefilter with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="customizationlevel")
    @JsonIgnore
    public Optional<Integer> getCustomizationlevel() {
        return Optional.ofNullable(customizationlevel);
    }

    public Sdkmessagefilter withCustomizationlevel(Integer customizationlevel) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("customizationlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.customizationlevel = customizationlevel;
        return _x;
    }

    @Property(name="_sdkmessageid_value")
    @JsonIgnore
    public Optional<String> get_sdkmessageid_value() {
        return Optional.ofNullable(_sdkmessageid_value);
    }

    public Sdkmessagefilter with_sdkmessageid_value(String _sdkmessageid_value) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("_sdkmessageid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x._sdkmessageid_value = _sdkmessageid_value;
        return _x;
    }

    @Property(name="isvisible")
    @JsonIgnore
    public Optional<Boolean> getIsvisible() {
        return Optional.ofNullable(isvisible);
    }

    public Sdkmessagefilter withIsvisible(Boolean isvisible) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("isvisible");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.isvisible = isvisible;
        return _x;
    }

    @Property(name="workflowsdkstepenabled")
    @JsonIgnore
    public Optional<Boolean> getWorkflowsdkstepenabled() {
        return Optional.ofNullable(workflowsdkstepenabled);
    }

    public Sdkmessagefilter withWorkflowsdkstepenabled(Boolean workflowsdkstepenabled) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("workflowsdkstepenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.workflowsdkstepenabled = workflowsdkstepenabled;
        return _x;
    }

    @Property(name="primaryobjecttypecode")
    @JsonIgnore
    public Optional<String> getPrimaryobjecttypecode() {
        return Optional.ofNullable(primaryobjecttypecode);
    }

    public Sdkmessagefilter withPrimaryobjecttypecode(String primaryobjecttypecode) {
        Checks.checkIsAscii(primaryobjecttypecode);
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("primaryobjecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.primaryobjecttypecode = primaryobjecttypecode;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Sdkmessagefilter withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="sdkmessagefilteridunique")
    @JsonIgnore
    public Optional<String> getSdkmessagefilteridunique() {
        return Optional.ofNullable(sdkmessagefilteridunique);
    }

    public Sdkmessagefilter withSdkmessagefilteridunique(String sdkmessagefilteridunique) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("sdkmessagefilteridunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.sdkmessagefilteridunique = sdkmessagefilteridunique;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Sdkmessagefilter withVersionnumber(Long versionnumber) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Sdkmessagefilter with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Sdkmessagefilter withCreatedon(OffsetDateTime createdon) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Sdkmessagefilter with_organizationid_value(String _organizationid_value) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Sdkmessagefilter withComponentstate(Integer componentstate) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Sdkmessagefilter with_modifiedby_value(String _modifiedby_value) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="restrictionlevel")
    @JsonIgnore
    public Optional<Integer> getRestrictionlevel() {
        return Optional.ofNullable(restrictionlevel);
    }

    public Sdkmessagefilter withRestrictionlevel(Integer restrictionlevel) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("restrictionlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.restrictionlevel = restrictionlevel;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Sdkmessagefilter with_createdby_value(String _createdby_value) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Sdkmessagefilter withSolutionid(String solutionid) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="iscustomprocessingstepallowed")
    @JsonIgnore
    public Optional<Boolean> getIscustomprocessingstepallowed() {
        return Optional.ofNullable(iscustomprocessingstepallowed);
    }

    public Sdkmessagefilter withIscustomprocessingstepallowed(Boolean iscustomprocessingstepallowed) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("iscustomprocessingstepallowed");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.iscustomprocessingstepallowed = iscustomprocessingstepallowed;
        return _x;
    }

    @Property(name="availability")
    @JsonIgnore
    public Optional<Integer> getAvailability() {
        return Optional.ofNullable(availability);
    }

    public Sdkmessagefilter withAvailability(Integer availability) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("availability");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.availability = availability;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Sdkmessagefilter withModifiedon(OffsetDateTime modifiedon) {
        Sdkmessagefilter _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.sdkmessagefilter");
        _x.modifiedon = modifiedon;
        return _x;
    }

    public Sdkmessagefilter withUnmappedField(String name, String value) {
        Sdkmessagefilter _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="sdkmessagefilterid_sdkmessageprocessingstep")
    @JsonIgnore
    public SdkmessageprocessingstepCollectionRequest getSdkmessagefilterid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("sdkmessagefilterid_sdkmessageprocessingstep"), RequestHelper.getValue(unmappedFields, "sdkmessagefilterid_sdkmessageprocessingstep"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="sdkmessageid")
    @JsonIgnore
    public SdkmessageRequest getSdkmessageid() {
        return new SdkmessageRequest(contextPath.addSegment("sdkmessageid"), RequestHelper.getValue(unmappedFields, "sdkmessageid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessagefilter patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Sdkmessagefilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Sdkmessagefilter put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Sdkmessagefilter _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Sdkmessagefilter _copy() {
        Sdkmessagefilter _x = new Sdkmessagefilter();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.ismanaged = ismanaged;
        _x.secondaryobjecttypecode = secondaryobjecttypecode;
        _x.overwritetime = overwritetime;
        _x.sdkmessagefilterid = sdkmessagefilterid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.customizationlevel = customizationlevel;
        _x._sdkmessageid_value = _sdkmessageid_value;
        _x.isvisible = isvisible;
        _x.workflowsdkstepenabled = workflowsdkstepenabled;
        _x.primaryobjecttypecode = primaryobjecttypecode;
        _x.introducedversion = introducedversion;
        _x.sdkmessagefilteridunique = sdkmessagefilteridunique;
        _x.versionnumber = versionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.createdon = createdon;
        _x._organizationid_value = _organizationid_value;
        _x.componentstate = componentstate;
        _x._modifiedby_value = _modifiedby_value;
        _x.restrictionlevel = restrictionlevel;
        _x._createdby_value = _createdby_value;
        _x.solutionid = solutionid;
        _x.iscustomprocessingstepallowed = iscustomprocessingstepallowed;
        _x.availability = availability;
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Sdkmessagefilter[");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("secondaryobjecttypecode=");
        b.append(this.secondaryobjecttypecode);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("sdkmessagefilterid=");
        b.append(this.sdkmessagefilterid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("customizationlevel=");
        b.append(this.customizationlevel);
        b.append(", ");
        b.append("_sdkmessageid_value=");
        b.append(this._sdkmessageid_value);
        b.append(", ");
        b.append("isvisible=");
        b.append(this.isvisible);
        b.append(", ");
        b.append("workflowsdkstepenabled=");
        b.append(this.workflowsdkstepenabled);
        b.append(", ");
        b.append("primaryobjecttypecode=");
        b.append(this.primaryobjecttypecode);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("sdkmessagefilteridunique=");
        b.append(this.sdkmessagefilteridunique);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("restrictionlevel=");
        b.append(this.restrictionlevel);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("iscustomprocessingstepallowed=");
        b.append(this.iscustomprocessingstepallowed);
        b.append(", ");
        b.append("availability=");
        b.append(this.availability);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
