package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "exceptionmessage", 
    "solutionname", 
    "createdon", 
    "retrycount", 
    "entityname", 
    "processedon", 
    "completedon", 
    "status", 
    "ribbonmetadatarowid", 
    "solutionid", 
    "isdbupdate"})
@JsonInclude(Include.NON_NULL)
public class Ribbonmetadatatoprocess extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess";
    }

    @JsonProperty("exceptionmessage")
    protected String exceptionmessage;

    @JsonProperty("solutionname")
    protected String solutionname;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("retrycount")
    protected Integer retrycount;

    @JsonProperty("entityname")
    protected String entityname;

    @JsonProperty("processedon")
    protected OffsetDateTime processedon;

    @JsonProperty("completedon")
    protected OffsetDateTime completedon;

    @JsonProperty("status")
    protected Integer status;

    @JsonProperty("ribbonmetadatarowid")
    protected String ribbonmetadatarowid;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("isdbupdate")
    protected Integer isdbupdate;

    protected Ribbonmetadatatoprocess() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderRibbonmetadatatoprocess() {
        return new Builder();
    }

    public static final class Builder {
        private String exceptionmessage;
        private String solutionname;
        private OffsetDateTime createdon;
        private Integer retrycount;
        private String entityname;
        private OffsetDateTime processedon;
        private OffsetDateTime completedon;
        private Integer status;
        private String ribbonmetadatarowid;
        private String solutionid;
        private Integer isdbupdate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder exceptionmessage(String exceptionmessage) {
            this.exceptionmessage = exceptionmessage;
            this.changedFields = changedFields.add("exceptionmessage");
            return this;
        }

        public Builder solutionname(String solutionname) {
            this.solutionname = solutionname;
            this.changedFields = changedFields.add("solutionname");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder retrycount(Integer retrycount) {
            this.retrycount = retrycount;
            this.changedFields = changedFields.add("retrycount");
            return this;
        }

        public Builder entityname(String entityname) {
            this.entityname = entityname;
            this.changedFields = changedFields.add("entityname");
            return this;
        }

        public Builder processedon(OffsetDateTime processedon) {
            this.processedon = processedon;
            this.changedFields = changedFields.add("processedon");
            return this;
        }

        public Builder completedon(OffsetDateTime completedon) {
            this.completedon = completedon;
            this.changedFields = changedFields.add("completedon");
            return this;
        }

        public Builder status(Integer status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder ribbonmetadatarowid(String ribbonmetadatarowid) {
            this.ribbonmetadatarowid = ribbonmetadatarowid;
            this.changedFields = changedFields.add("ribbonmetadatarowid");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder isdbupdate(Integer isdbupdate) {
            this.isdbupdate = isdbupdate;
            this.changedFields = changedFields.add("isdbupdate");
            return this;
        }

        public Ribbonmetadatatoprocess build() {
            Ribbonmetadatatoprocess _x = new Ribbonmetadatatoprocess();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess";
            _x.exceptionmessage = exceptionmessage;
            _x.solutionname = solutionname;
            _x.createdon = createdon;
            _x.retrycount = retrycount;
            _x.entityname = entityname;
            _x.processedon = processedon;
            _x.completedon = completedon;
            _x.status = status;
            _x.ribbonmetadatarowid = ribbonmetadatarowid;
            _x.solutionid = solutionid;
            _x.isdbupdate = isdbupdate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ribbonmetadatarowid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ribbonmetadatarowid.toString()));
        }
    }

    @Property(name="exceptionmessage")
    @JsonIgnore
    public Optional<String> getExceptionmessage() {
        return Optional.ofNullable(exceptionmessage);
    }

    public Ribbonmetadatatoprocess withExceptionmessage(String exceptionmessage) {
        Checks.checkIsAscii(exceptionmessage);
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("exceptionmessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.exceptionmessage = exceptionmessage;
        return _x;
    }

    @Property(name="solutionname")
    @JsonIgnore
    public Optional<String> getSolutionname() {
        return Optional.ofNullable(solutionname);
    }

    public Ribbonmetadatatoprocess withSolutionname(String solutionname) {
        Checks.checkIsAscii(solutionname);
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("solutionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.solutionname = solutionname;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Ribbonmetadatatoprocess withCreatedon(OffsetDateTime createdon) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="retrycount")
    @JsonIgnore
    public Optional<Integer> getRetrycount() {
        return Optional.ofNullable(retrycount);
    }

    public Ribbonmetadatatoprocess withRetrycount(Integer retrycount) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("retrycount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.retrycount = retrycount;
        return _x;
    }

    @Property(name="entityname")
    @JsonIgnore
    public Optional<String> getEntityname() {
        return Optional.ofNullable(entityname);
    }

    public Ribbonmetadatatoprocess withEntityname(String entityname) {
        Checks.checkIsAscii(entityname);
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("entityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.entityname = entityname;
        return _x;
    }

    @Property(name="processedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getProcessedon() {
        return Optional.ofNullable(processedon);
    }

    public Ribbonmetadatatoprocess withProcessedon(OffsetDateTime processedon) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("processedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.processedon = processedon;
        return _x;
    }

    @Property(name="completedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedon() {
        return Optional.ofNullable(completedon);
    }

    public Ribbonmetadatatoprocess withCompletedon(OffsetDateTime completedon) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("completedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.completedon = completedon;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<Integer> getStatus() {
        return Optional.ofNullable(status);
    }

    public Ribbonmetadatatoprocess withStatus(Integer status) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.status = status;
        return _x;
    }

    @Property(name="ribbonmetadatarowid")
    @JsonIgnore
    public Optional<String> getRibbonmetadatarowid() {
        return Optional.ofNullable(ribbonmetadatarowid);
    }

    public Ribbonmetadatatoprocess withRibbonmetadatarowid(String ribbonmetadatarowid) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("ribbonmetadatarowid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.ribbonmetadatarowid = ribbonmetadatarowid;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Ribbonmetadatatoprocess withSolutionid(String solutionid) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="isdbupdate")
    @JsonIgnore
    public Optional<Integer> getIsdbupdate() {
        return Optional.ofNullable(isdbupdate);
    }

    public Ribbonmetadatatoprocess withIsdbupdate(Integer isdbupdate) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = changedFields.add("isdbupdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ribbonmetadatatoprocess");
        _x.isdbupdate = isdbupdate;
        return _x;
    }

    public Ribbonmetadatatoprocess withUnmappedField(String name, String value) {
        Ribbonmetadatatoprocess _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ribbonmetadatatoprocess patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ribbonmetadatatoprocess put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Ribbonmetadatatoprocess _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Ribbonmetadatatoprocess _copy() {
        Ribbonmetadatatoprocess _x = new Ribbonmetadatatoprocess();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.exceptionmessage = exceptionmessage;
        _x.solutionname = solutionname;
        _x.createdon = createdon;
        _x.retrycount = retrycount;
        _x.entityname = entityname;
        _x.processedon = processedon;
        _x.completedon = completedon;
        _x.status = status;
        _x.ribbonmetadatarowid = ribbonmetadatarowid;
        _x.solutionid = solutionid;
        _x.isdbupdate = isdbupdate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Ribbonmetadatatoprocess[");
        b.append("exceptionmessage=");
        b.append(this.exceptionmessage);
        b.append(", ");
        b.append("solutionname=");
        b.append(this.solutionname);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("retrycount=");
        b.append(this.retrycount);
        b.append(", ");
        b.append("entityname=");
        b.append(this.entityname);
        b.append(", ");
        b.append("processedon=");
        b.append(this.processedon);
        b.append(", ");
        b.append("completedon=");
        b.append(this.completedon);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("ribbonmetadatarowid=");
        b.append(this.ribbonmetadatarowid);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("isdbupdate=");
        b.append(this.isdbupdate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
