package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "solutionid", 
    "ownermappingid", 
    "targetuservalueforsourcecrmuserlink", 
    "modifiedon", 
    "statuscode", 
    "_targetsystemuserid_value", 
    "introducedversion", 
    "_modifiedonbehalfby_value", 
    "processcode", 
    "ownermappingidunique", 
    "ismanaged", 
    "targetsystemuserdomainname", 
    "_importmapid_value", 
    "createdon", 
    "_createdby_value", 
    "_modifiedby_value", 
    "sourceuservalueforsourcecrmuserlink", 
    "overwritetime", 
    "sourcesystemusername", 
    "_createdonbehalfby_value", 
    "statecode", 
    "componentstate"})
@JsonInclude(Include.NON_NULL)
public class Ownermapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ownermapping";
    }

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("ownermappingid")
    protected String ownermappingid;

    @JsonProperty("targetuservalueforsourcecrmuserlink")
    protected String targetuservalueforsourcecrmuserlink;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_targetsystemuserid_value")
    protected String _targetsystemuserid_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("processcode")
    protected Integer processcode;

    @JsonProperty("ownermappingidunique")
    protected String ownermappingidunique;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("targetsystemuserdomainname")
    protected String targetsystemuserdomainname;

    @JsonProperty("_importmapid_value")
    protected String _importmapid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("sourceuservalueforsourcecrmuserlink")
    protected String sourceuservalueforsourcecrmuserlink;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("sourcesystemusername")
    protected String sourcesystemusername;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    protected Ownermapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOwnermapping() {
        return new Builder();
    }

    public static final class Builder {
        private String solutionid;
        private String ownermappingid;
        private String targetuservalueforsourcecrmuserlink;
        private OffsetDateTime modifiedon;
        private Integer statuscode;
        private String _targetsystemuserid_value;
        private String introducedversion;
        private String _modifiedonbehalfby_value;
        private Integer processcode;
        private String ownermappingidunique;
        private Boolean ismanaged;
        private String targetsystemuserdomainname;
        private String _importmapid_value;
        private OffsetDateTime createdon;
        private String _createdby_value;
        private String _modifiedby_value;
        private String sourceuservalueforsourcecrmuserlink;
        private OffsetDateTime overwritetime;
        private String sourcesystemusername;
        private String _createdonbehalfby_value;
        private Integer statecode;
        private Integer componentstate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder ownermappingid(String ownermappingid) {
            this.ownermappingid = ownermappingid;
            this.changedFields = changedFields.add("ownermappingid");
            return this;
        }

        public Builder targetuservalueforsourcecrmuserlink(String targetuservalueforsourcecrmuserlink) {
            this.targetuservalueforsourcecrmuserlink = targetuservalueforsourcecrmuserlink;
            this.changedFields = changedFields.add("targetuservalueforsourcecrmuserlink");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _targetsystemuserid_value(String _targetsystemuserid_value) {
            this._targetsystemuserid_value = _targetsystemuserid_value;
            this.changedFields = changedFields.add("_targetsystemuserid_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder processcode(Integer processcode) {
            this.processcode = processcode;
            this.changedFields = changedFields.add("processcode");
            return this;
        }

        public Builder ownermappingidunique(String ownermappingidunique) {
            this.ownermappingidunique = ownermappingidunique;
            this.changedFields = changedFields.add("ownermappingidunique");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder targetsystemuserdomainname(String targetsystemuserdomainname) {
            this.targetsystemuserdomainname = targetsystemuserdomainname;
            this.changedFields = changedFields.add("targetsystemuserdomainname");
            return this;
        }

        public Builder _importmapid_value(String _importmapid_value) {
            this._importmapid_value = _importmapid_value;
            this.changedFields = changedFields.add("_importmapid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder sourceuservalueforsourcecrmuserlink(String sourceuservalueforsourcecrmuserlink) {
            this.sourceuservalueforsourcecrmuserlink = sourceuservalueforsourcecrmuserlink;
            this.changedFields = changedFields.add("sourceuservalueforsourcecrmuserlink");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder sourcesystemusername(String sourcesystemusername) {
            this.sourcesystemusername = sourcesystemusername;
            this.changedFields = changedFields.add("sourcesystemusername");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Ownermapping build() {
            Ownermapping _x = new Ownermapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ownermapping";
            _x.solutionid = solutionid;
            _x.ownermappingid = ownermappingid;
            _x.targetuservalueforsourcecrmuserlink = targetuservalueforsourcecrmuserlink;
            _x.modifiedon = modifiedon;
            _x.statuscode = statuscode;
            _x._targetsystemuserid_value = _targetsystemuserid_value;
            _x.introducedversion = introducedversion;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.processcode = processcode;
            _x.ownermappingidunique = ownermappingidunique;
            _x.ismanaged = ismanaged;
            _x.targetsystemuserdomainname = targetsystemuserdomainname;
            _x._importmapid_value = _importmapid_value;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.sourceuservalueforsourcecrmuserlink = sourceuservalueforsourcecrmuserlink;
            _x.overwritetime = overwritetime;
            _x.sourcesystemusername = sourcesystemusername;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.statecode = statecode;
            _x.componentstate = componentstate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && ownermappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(ownermappingid.toString()));
        }
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Ownermapping withSolutionid(String solutionid) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="ownermappingid")
    @JsonIgnore
    public Optional<String> getOwnermappingid() {
        return Optional.ofNullable(ownermappingid);
    }

    public Ownermapping withOwnermappingid(String ownermappingid) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("ownermappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.ownermappingid = ownermappingid;
        return _x;
    }

    @Property(name="targetuservalueforsourcecrmuserlink")
    @JsonIgnore
    public Optional<String> getTargetuservalueforsourcecrmuserlink() {
        return Optional.ofNullable(targetuservalueforsourcecrmuserlink);
    }

    public Ownermapping withTargetuservalueforsourcecrmuserlink(String targetuservalueforsourcecrmuserlink) {
        Checks.checkIsAscii(targetuservalueforsourcecrmuserlink);
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("targetuservalueforsourcecrmuserlink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.targetuservalueforsourcecrmuserlink = targetuservalueforsourcecrmuserlink;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Ownermapping withModifiedon(OffsetDateTime modifiedon) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Ownermapping withStatuscode(Integer statuscode) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_targetsystemuserid_value")
    @JsonIgnore
    public Optional<String> get_targetsystemuserid_value() {
        return Optional.ofNullable(_targetsystemuserid_value);
    }

    public Ownermapping with_targetsystemuserid_value(String _targetsystemuserid_value) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("_targetsystemuserid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x._targetsystemuserid_value = _targetsystemuserid_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Ownermapping withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Ownermapping with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="processcode")
    @JsonIgnore
    public Optional<Integer> getProcesscode() {
        return Optional.ofNullable(processcode);
    }

    public Ownermapping withProcesscode(Integer processcode) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("processcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.processcode = processcode;
        return _x;
    }

    @Property(name="ownermappingidunique")
    @JsonIgnore
    public Optional<String> getOwnermappingidunique() {
        return Optional.ofNullable(ownermappingidunique);
    }

    public Ownermapping withOwnermappingidunique(String ownermappingidunique) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("ownermappingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.ownermappingidunique = ownermappingidunique;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Ownermapping withIsmanaged(Boolean ismanaged) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="targetsystemuserdomainname")
    @JsonIgnore
    public Optional<String> getTargetsystemuserdomainname() {
        return Optional.ofNullable(targetsystemuserdomainname);
    }

    public Ownermapping withTargetsystemuserdomainname(String targetsystemuserdomainname) {
        Checks.checkIsAscii(targetsystemuserdomainname);
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("targetsystemuserdomainname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.targetsystemuserdomainname = targetsystemuserdomainname;
        return _x;
    }

    @Property(name="_importmapid_value")
    @JsonIgnore
    public Optional<String> get_importmapid_value() {
        return Optional.ofNullable(_importmapid_value);
    }

    public Ownermapping with_importmapid_value(String _importmapid_value) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("_importmapid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x._importmapid_value = _importmapid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Ownermapping withCreatedon(OffsetDateTime createdon) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Ownermapping with_createdby_value(String _createdby_value) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Ownermapping with_modifiedby_value(String _modifiedby_value) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="sourceuservalueforsourcecrmuserlink")
    @JsonIgnore
    public Optional<String> getSourceuservalueforsourcecrmuserlink() {
        return Optional.ofNullable(sourceuservalueforsourcecrmuserlink);
    }

    public Ownermapping withSourceuservalueforsourcecrmuserlink(String sourceuservalueforsourcecrmuserlink) {
        Checks.checkIsAscii(sourceuservalueforsourcecrmuserlink);
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("sourceuservalueforsourcecrmuserlink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.sourceuservalueforsourcecrmuserlink = sourceuservalueforsourcecrmuserlink;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Ownermapping withOverwritetime(OffsetDateTime overwritetime) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="sourcesystemusername")
    @JsonIgnore
    public Optional<String> getSourcesystemusername() {
        return Optional.ofNullable(sourcesystemusername);
    }

    public Ownermapping withSourcesystemusername(String sourcesystemusername) {
        Checks.checkIsAscii(sourcesystemusername);
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("sourcesystemusername");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.sourcesystemusername = sourcesystemusername;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Ownermapping with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Ownermapping withStatecode(Integer statecode) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Ownermapping withComponentstate(Integer componentstate) {
        Ownermapping _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ownermapping");
        _x.componentstate = componentstate;
        return _x;
    }

    public Ownermapping withUnmappedField(String name, String value) {
        Ownermapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="targetsystemuserid")
    @JsonIgnore
    public SystemuserRequest getTargetsystemuserid() {
        return new SystemuserRequest(contextPath.addSegment("targetsystemuserid"), RequestHelper.getValue(unmappedFields, "targetsystemuserid"));
    }

    @NavigationProperty(name="importmapid")
    @JsonIgnore
    public ImportmapRequest getImportmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), RequestHelper.getValue(unmappedFields, "importmapid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ownermapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Ownermapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Ownermapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Ownermapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Ownermapping _copy() {
        Ownermapping _x = new Ownermapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionid = solutionid;
        _x.ownermappingid = ownermappingid;
        _x.targetuservalueforsourcecrmuserlink = targetuservalueforsourcecrmuserlink;
        _x.modifiedon = modifiedon;
        _x.statuscode = statuscode;
        _x._targetsystemuserid_value = _targetsystemuserid_value;
        _x.introducedversion = introducedversion;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.processcode = processcode;
        _x.ownermappingidunique = ownermappingidunique;
        _x.ismanaged = ismanaged;
        _x.targetsystemuserdomainname = targetsystemuserdomainname;
        _x._importmapid_value = _importmapid_value;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.sourceuservalueforsourcecrmuserlink = sourceuservalueforsourcecrmuserlink;
        _x.overwritetime = overwritetime;
        _x.sourcesystemusername = sourcesystemusername;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.statecode = statecode;
        _x.componentstate = componentstate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Ownermapping[");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("ownermappingid=");
        b.append(this.ownermappingid);
        b.append(", ");
        b.append("targetuservalueforsourcecrmuserlink=");
        b.append(this.targetuservalueforsourcecrmuserlink);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_targetsystemuserid_value=");
        b.append(this._targetsystemuserid_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("processcode=");
        b.append(this.processcode);
        b.append(", ");
        b.append("ownermappingidunique=");
        b.append(this.ownermappingidunique);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("targetsystemuserdomainname=");
        b.append(this.targetsystemuserdomainname);
        b.append(", ");
        b.append("_importmapid_value=");
        b.append(this._importmapid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("sourceuservalueforsourcecrmuserlink=");
        b.append(this.sourceuservalueforsourcecrmuserlink);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("sourcesystemusername=");
        b.append(this.sourcesystemusername);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
