package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AciviewmapperCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfiginstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfigmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppmoduleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitnewsarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ComplexcontrolCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionroleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontrolCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontroldefaultconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontrolresourceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspaceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspacepermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DataperformanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DisplaystringCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DocumenttemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailserverprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EntityanalyticsconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExpiredprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldsecurityprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportjobCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgebaserecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LanguagelocaleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MetricCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemassociationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_helppageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthrulesetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NavigationsettingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NewprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OfficegraphdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PluginassemblyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PlugintypeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PlugintypestatisticCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PositionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostcommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostlikeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PublisherCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecommendeddocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessagefilterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepsecureconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ServiceendpointCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SimilarityruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SitemapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentattributeconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentrelationshipconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SubjectCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemformCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TerritoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ThemeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TracelogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TransactioncurrencyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TranslationprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UsermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WebresourceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WebwizardCollectionRequest;
import microsoft.dynamics.crm.entity.request.CalendarRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TemplateRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "autoapplydefaultoncasecreate", 
    "maxverboseloggingsynccycles", 
    "privilegeusergroupid", 
    "expiresubscriptionsindays", 
    "numberformat", 
    "globalhelpurlenabled", 
    "widgetproperties", 
    "taskbasedflowenabled", 
    "iscontextualhelpenabled", 
    "isquickcreateenabledforopportunityclose", 
    "recurrenceexpansionsynchcreatemax", 
    "generatealertsforinformation", 
    "enablesmartmatching", 
    "orderprefix", 
    "reportscripterrors", 
    "organizationstate", 
    "sessiontimeoutreminderinmins", 
    "allowwebexcelexport", 
    "mobileofflineminlicenseprod", 
    "caseprefix", 
    "longdateformatcode", 
    "usepositionhierarchy", 
    "trackingtokenidbase", 
    "allowentityonlyaudit", 
    "globalappendurlparametersenabled", 
    "generatealertsforwarnings", 
    "maximumentitieswithactivesla", 
    "privreportinggroupid", 
    "invoiceprefix", 
    "quoteprefix", 
    "mailboxintermittentissueminrange", 
    "isassignedtaskssyncenabled", 
    "issopintegrationenabled", 
    "ismobileclientondemandsyncenabled", 
    "isgeospatialazuremapsintegrationenabled", 
    "servestaticresourcesfromazurecdn", 
    "isautodatacaptureenabled", 
    "isemailserverprofilecontentfilteringenabled", 
    "isluisenabledford365bot", 
    "blockedattachments", 
    "isconflictdetectionenabledformobileclient", 
    "businesscardoptions", 
    "goalrollupfrequency", 
    "parsedtableprefix", 
    "isreadauditenabled", 
    "requireapprovalforuseremail", 
    "emailsendpollingperiod", 
    "useinbuiltrulefordefaultpricelistselection", 
    "isrichtextnotesenabled", 
    "hashdeltasubjectcount", 
    "recurrenceexpansionjobbatchinterval", 
    "fiscalperiodformat", 
    "officegraphdelveurl", 
    "maxrecordsforlookupfilters", 
    "sharepointdeploymenttype", 
    "isrelationshipinsightsenabled", 
    "requireapprovalforqueueemail", 
    "tokenexpiry", 
    "postmessagewhitelistdomains", 
    "localeid", 
    "createdon", 
    "isduplicatedetectionenabledforonlinecreateupdate", 
    "contentsecuritypolicyconfiguration", 
    "inactivitytimeoutenabled", 
    "displaynavigationtour", 
    "isautosaveenabled", 
    "supportuserid", 
    "currencydisplayoption", 
    "tokenkey", 
    "pinpointlanguagecode", 
    "isappointmentattachmentsyncenabled", 
    "isenabledforallroles", 
    "enablelpauthoring", 
    "mobileofflineminlicensetrial", 
    "auditretentionperiod", 
    "officeappsautodeploymentenabled", 
    "hashfilterkeywords", 
    "isnotesanalysisenabled", 
    "iscontactmailingaddresssyncenabled", 
    "ismailboxforcedunlockingenabled", 
    "isexternalfilestorageenabled", 
    "mobileofflinesyncinterval", 
    "tagmaxaggressivecycles", 
    "utcconversiontimezonecode", 
    "grantaccesstonetworkservice", 
    "iscontentsecuritypolicyenabled", 
    "isdelveactionhubintegrationenabled", 
    "allowoutlookscheduledsyncs", 
    "maximumdynamicpropertiesallowed", 
    "numbergroupformat", 
    "entityimageid", 
    "trackingtokeniddigits", 
    "defaultrecurrenceendrangetype", 
    "yammernetworkpermalink", 
    "bulkoperationprefix", 
    "oobpricecalculationenabled", 
    "futureexpansionwindow", 
    "ispresenceenabled", 
    "pastexpansionwindow", 
    "maximumslakpiperentitywithactivesla", 
    "ismsteamssettingchangedbyuser", 
    "picture", 
    "azureschedulerjobcollectionname", 
    "isofficegraphenabled", 
    "orgdborgsettings", 
    "ismodeldrivenappsinmsteamsenabled", 
    "rierrorstatus", 
    "allowlegacydialogsembedding", 
    "emailcorrelationenabled", 
    "maxappointmentdurationdays", 
    "microsoftflowenvironment", 
    "tracelogmaximumageindays", 
    "isduplicatedetectionenabledforimport", 
    "iscustomcontrolsincanvasappsenabled", 
    "enforcereadonlyplugins", 
    "createproductswithoutparentinactivestate", 
    "enableunifiedinterfaceshellrefresh", 
    "textanalyticsenabled", 
    "expirechangetrackingindays", 
    "usereadform", 
    "basecurrencysymbol", 
    "fiscalyearperiodconnect", 
    "maxsupportedinternetexplorerversion", 
    "fiscalperiodformatperiod", 
    "bingmapsapikey", 
    "isactionsupportfeatureenabled", 
    "restrictstatusupdate", 
    "defaultthemedata", 
    "isonedriveenabled", 
    "externalpartycorrelationkeys", 
    "auditretentionperiodv2", 
    "negativeformatcode", 
    "ispricelistmandatory", 
    "timeseparator", 
    "maxproductsinbundle", 
    "slapausestates", 
    "v3calloutconfighash", 
    "plugintracelogsetting", 
    "syncoptinselectionstatus", 
    "syncbulkoperationmaxlimit", 
    "allowofflinescheduledsyncs", 
    "basecurrencyprecision", 
    "socialinsightsinstance", 
    "ishierarchicalsecuritymodelenabled", 
    "privacystatementurl", 
    "minoutlooksyncinterval", 
    "currentimportsequencenumber", 
    "isuseraccessauditenabled", 
    "fiscalyearformatprefix", 
    "enablebingmapsintegration", 
    "maxslaitemspersla", 
    "syncbulkoperationbatchsize", 
    "tagpollingperiod", 
    "suppresssla", 
    "clientfeatureset", 
    "versionnumber", 
    "isemailmonitoringallowed", 
    "maxverboseloggingmailbox", 
    "ismanualsalesforecastingenabled", 
    "isduplicatedetectionenabled", 
    "schemanameprefix", 
    "paipreviewscenarioenabled", 
    "autoapplysla", 
    "ismsteamscollaborationenabled", 
    "incomingemailexchangeemailretrievalbatchsize", 
    "ismailboxinactivebackoffenabled", 
    "cortanaproactiveexperienceenabled", 
    "goalrollupexpirytime", 
    "isplaybookenabled", 
    "showkbarticledeprecationnotification", 
    "isappmode", 
    "_modifiedby_value", 
    "contractprefix", 
    "allowautounsubscribe", 
    "ignoreinternalemail", 
    "ispreviewforautocaptureenabled", 
    "minofflinesyncinterval", 
    "highcontrastthemedata", 
    "systemuserid", 
    "orginsightsenabled", 
    "maxactionstepsinbpf", 
    "socialinsightstermsaccepted", 
    "defaultemailsettings", 
    "generatealertsforerrors", 
    "getstartedpanecontentenabled", 
    "sqlaccessgroupname", 
    "autoapplydefaultoncaseupdate", 
    "negativecurrencyformatcode", 
    "cascadestatusupdate", 
    "powerbifeatureenabled", 
    "fullnameconventioncode", 
    "allowaddressbooksyncs", 
    "notifymailboxownerofemailserverlevelalerts", 
    "usequickfindviewforgridsearch", 
    "discountcalculationmethod", 
    "organizationid", 
    "mailboxpermanentissueminrange", 
    "kmsettings", 
    "isfulltextsearchenabled", 
    "hashminaddresscount", 
    "dateseparator", 
    "weekstartdaycode", 
    "allowuserformmodepreference", 
    "numberseparator", 
    "campaignprefix", 
    "productrecommendationsenabled", 
    "recurrencedefaultnumberofoccurrences", 
    "ismsteamsusersyncenabled", 
    "quickfindrecordlimitenabled", 
    "pricingdecimalprecision", 
    "useskypeprotocol", 
    "rendersecureiframeforemail", 
    "inactivitytimeoutinmins", 
    "sessiontimeoutenabled", 
    "minaddressbooksyncinterval", 
    "externalbaseurl", 
    "issalesassistantenabled", 
    "_defaultmobileofflineprofileid_value", 
    "amdesignator", 
    "enableimmersiveskypeintegration", 
    "kbprefix", 
    "bounddashboarddefaultcardexpanded", 
    "hashmaxcount", 
    "reportinggroupname", 
    "isdelegateaccessenabled", 
    "aciwebendpointurl", 
    "maxuploadfilesize", 
    "_modifiedonbehalfby_value", 
    "fiscalyeardisplaycode", 
    "yammeroauthaccesstokenexpired", 
    "externalpartyentitysettings", 
    "defaultcountrycode", 
    "isactivityanalysisenabled", 
    "recurrenceexpansionjobbatchsize", 
    "_basecurrencyid_value", 
    "featureset", 
    "istextwrapenabled", 
    "calendartype", 
    "allowclientmessagebarad", 
    "usergroupid", 
    "isdisabled", 
    "isduplicatedetectionenabledforofflinesync", 
    "languagecode", 
    "appdesignerexperienceenabled", 
    "categoryprefix", 
    "ispreviewenabledforactioncard", 
    "ismobileofflineenabled", 
    "fiscalcalendarstart", 
    "isexternalsearchindexenabled", 
    "maximumactivebusinessprocessflowsallowedperentity", 
    "enablelivepersonacarduci", 
    "timeformatcode", 
    "dayssincerecordlastmodifiedmaxvalue", 
    "_acknowledgementtemplateid_value", 
    "maxdepthforhierarchicalsecuritymodel", 
    "currencysymbol", 
    "isfolderbasedtrackingenabled", 
    "isdefaultcountrycodecheckenabled", 
    "entityimage", 
    "fiscalyearformatyear", 
    "entityimage_timestamp", 
    "privreportinggroupname", 
    "yearstartweekcode", 
    "uselegacyrendering", 
    "maximumtrackingnumber", 
    "fiscalyearformatsuffix", 
    "allowautoresponsecreation", 
    "allowlegacyclientexperience", 
    "ismsteamsenabled", 
    "enablemicrosoftflowintegration", 
    "currentparsedtablenumber", 
    "socialinsightsenabled", 
    "_createdby_value", 
    "initialversion", 
    "delegatedadminuserid", 
    "isfiscalperiodmonthbased", 
    "fiscalperiodtype", 
    "inactivitytimeoutreminderinmins", 
    "disabledreason", 
    "uniquespecifierlength", 
    "ispdfgenerationenabled", 
    "enablelivepersoncardintegrationinoffice", 
    "maxrecordsforexporttoexcel", 
    "useraccessauditinginterval", 
    "_createdonbehalfby_value", 
    "kaprefix", 
    "allowmarketingemailexecution", 
    "sqmenabled", 
    "timeformatstring", 
    "iscontextualemailenabled", 
    "dateformatcode", 
    "webresourcehash", 
    "syncoptinselection", 
    "sortid", 
    "globalhelpurl", 
    "isallmoneydecimal", 
    "isauditenabled", 
    "fiscalyearformat", 
    "sendbulkemailinuci", 
    "defaultcrmcustomname", 
    "currencyformatcode", 
    "isbpfentitycustomizationfeatureenabled", 
    "maxconditionsformobileofflinefilters", 
    "businessclosurecalendarid", 
    "showweeknumber", 
    "isactioncardenabled", 
    "sessiontimeoutinmins", 
    "appointmentricheditorexperience", 
    "_defaultemailserverprofileid_value", 
    "integrationuserid", 
    "entityimage_url", 
    "isnewaddproductexperienceenabled", 
    "pmdesignator", 
    "sampledataimportid", 
    "name", 
    "currencydecimalprecision", 
    "emailconnectionchannel", 
    "ispreviewforemailmonitoringallowed", 
    "allowunresolvedpartiesonemailsend", 
    "ispaienabled", 
    "isautodatacapturev2enabled", 
    "allowautounsubscribeacknowledgement", 
    "nexttrackingnumber", 
    "enablepricingoncreate", 
    "parsedtablecolumnprefix", 
    "allowusersseeappdownloadmessage", 
    "decimalsymbol", 
    "modifiedon", 
    "signupoutlookdownloadfwlink", 
    "isresourcebookingexchangesyncenabled", 
    "disablesocialcare", 
    "resolvesimilarunresolvedemailaddress", 
    "unresolveemailaddressifmultiplematch", 
    "sharetopreviousowneronassign", 
    "iswriteinproductsallowed", 
    "reportinggroupid", 
    "qualifyleadadditionaloptions", 
    "isfolderautocreatedonsp", 
    "maxfolderbasedtrackingmappings", 
    "sqlaccessgroupid", 
    "trackingprefix", 
    "yammergroupid", 
    "dateformatstring", 
    "yammerpostmethod", 
    "timezoneruleversionnumber"})
@JsonInclude(Include.NON_NULL)
public class Organization extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.organization";
    }

    @JsonProperty("autoapplydefaultoncasecreate")
    protected Boolean autoapplydefaultoncasecreate;

    @JsonProperty("maxverboseloggingsynccycles")
    protected Integer maxverboseloggingsynccycles;

    @JsonProperty("privilegeusergroupid")
    protected String privilegeusergroupid;

    @JsonProperty("expiresubscriptionsindays")
    protected Integer expiresubscriptionsindays;

    @JsonProperty("numberformat")
    protected String numberformat;

    @JsonProperty("globalhelpurlenabled")
    protected Boolean globalhelpurlenabled;

    @JsonProperty("widgetproperties")
    protected String widgetproperties;

    @JsonProperty("taskbasedflowenabled")
    protected Boolean taskbasedflowenabled;

    @JsonProperty("iscontextualhelpenabled")
    protected Boolean iscontextualhelpenabled;

    @JsonProperty("isquickcreateenabledforopportunityclose")
    protected Boolean isquickcreateenabledforopportunityclose;

    @JsonProperty("recurrenceexpansionsynchcreatemax")
    protected Integer recurrenceexpansionsynchcreatemax;

    @JsonProperty("generatealertsforinformation")
    protected Boolean generatealertsforinformation;

    @JsonProperty("enablesmartmatching")
    protected Boolean enablesmartmatching;

    @JsonProperty("orderprefix")
    protected String orderprefix;

    @JsonProperty("reportscripterrors")
    protected Integer reportscripterrors;

    @JsonProperty("organizationstate")
    protected Integer organizationstate;

    @JsonProperty("sessiontimeoutreminderinmins")
    protected Integer sessiontimeoutreminderinmins;

    @JsonProperty("allowwebexcelexport")
    protected Boolean allowwebexcelexport;

    @JsonProperty("mobileofflineminlicenseprod")
    protected Integer mobileofflineminlicenseprod;

    @JsonProperty("caseprefix")
    protected String caseprefix;

    @JsonProperty("longdateformatcode")
    protected Integer longdateformatcode;

    @JsonProperty("usepositionhierarchy")
    protected Boolean usepositionhierarchy;

    @JsonProperty("trackingtokenidbase")
    protected Integer trackingtokenidbase;

    @JsonProperty("allowentityonlyaudit")
    protected Boolean allowentityonlyaudit;

    @JsonProperty("globalappendurlparametersenabled")
    protected Boolean globalappendurlparametersenabled;

    @JsonProperty("generatealertsforwarnings")
    protected Boolean generatealertsforwarnings;

    @JsonProperty("maximumentitieswithactivesla")
    protected Integer maximumentitieswithactivesla;

    @JsonProperty("privreportinggroupid")
    protected String privreportinggroupid;

    @JsonProperty("invoiceprefix")
    protected String invoiceprefix;

    @JsonProperty("quoteprefix")
    protected String quoteprefix;

    @JsonProperty("mailboxintermittentissueminrange")
    protected Integer mailboxintermittentissueminrange;

    @JsonProperty("isassignedtaskssyncenabled")
    protected Boolean isassignedtaskssyncenabled;

    @JsonProperty("issopintegrationenabled")
    protected Boolean issopintegrationenabled;

    @JsonProperty("ismobileclientondemandsyncenabled")
    protected Boolean ismobileclientondemandsyncenabled;

    @JsonProperty("isgeospatialazuremapsintegrationenabled")
    protected Boolean isgeospatialazuremapsintegrationenabled;

    @JsonProperty("servestaticresourcesfromazurecdn")
    protected Boolean servestaticresourcesfromazurecdn;

    @JsonProperty("isautodatacaptureenabled")
    protected Boolean isautodatacaptureenabled;

    @JsonProperty("isemailserverprofilecontentfilteringenabled")
    protected Boolean isemailserverprofilecontentfilteringenabled;

    @JsonProperty("isluisenabledford365bot")
    protected Boolean isluisenabledford365bot;

    @JsonProperty("blockedattachments")
    protected String blockedattachments;

    @JsonProperty("isconflictdetectionenabledformobileclient")
    protected Boolean isconflictdetectionenabledformobileclient;

    @JsonProperty("businesscardoptions")
    protected String businesscardoptions;

    @JsonProperty("goalrollupfrequency")
    protected Integer goalrollupfrequency;

    @JsonProperty("parsedtableprefix")
    protected String parsedtableprefix;

    @JsonProperty("isreadauditenabled")
    protected Boolean isreadauditenabled;

    @JsonProperty("requireapprovalforuseremail")
    protected Boolean requireapprovalforuseremail;

    @JsonProperty("emailsendpollingperiod")
    protected Integer emailsendpollingperiod;

    @JsonProperty("useinbuiltrulefordefaultpricelistselection")
    protected Boolean useinbuiltrulefordefaultpricelistselection;

    @JsonProperty("isrichtextnotesenabled")
    protected Boolean isrichtextnotesenabled;

    @JsonProperty("hashdeltasubjectcount")
    protected Integer hashdeltasubjectcount;

    @JsonProperty("recurrenceexpansionjobbatchinterval")
    protected Integer recurrenceexpansionjobbatchinterval;

    @JsonProperty("fiscalperiodformat")
    protected String fiscalperiodformat;

    @JsonProperty("officegraphdelveurl")
    protected String officegraphdelveurl;

    @JsonProperty("maxrecordsforlookupfilters")
    protected Integer maxrecordsforlookupfilters;

    @JsonProperty("sharepointdeploymenttype")
    protected Integer sharepointdeploymenttype;

    @JsonProperty("isrelationshipinsightsenabled")
    protected Boolean isrelationshipinsightsenabled;

    @JsonProperty("requireapprovalforqueueemail")
    protected Boolean requireapprovalforqueueemail;

    @JsonProperty("tokenexpiry")
    protected Integer tokenexpiry;

    @JsonProperty("postmessagewhitelistdomains")
    protected String postmessagewhitelistdomains;

    @JsonProperty("localeid")
    protected Integer localeid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("isduplicatedetectionenabledforonlinecreateupdate")
    protected Boolean isduplicatedetectionenabledforonlinecreateupdate;

    @JsonProperty("contentsecuritypolicyconfiguration")
    protected String contentsecuritypolicyconfiguration;

    @JsonProperty("inactivitytimeoutenabled")
    protected Boolean inactivitytimeoutenabled;

    @JsonProperty("displaynavigationtour")
    protected Boolean displaynavigationtour;

    @JsonProperty("isautosaveenabled")
    protected Boolean isautosaveenabled;

    @JsonProperty("supportuserid")
    protected String supportuserid;

    @JsonProperty("currencydisplayoption")
    protected Integer currencydisplayoption;

    @JsonProperty("tokenkey")
    protected String tokenkey;

    @JsonProperty("pinpointlanguagecode")
    protected Integer pinpointlanguagecode;

    @JsonProperty("isappointmentattachmentsyncenabled")
    protected Boolean isappointmentattachmentsyncenabled;

    @JsonProperty("isenabledforallroles")
    protected Boolean isenabledforallroles;

    @JsonProperty("enablelpauthoring")
    protected Boolean enablelpauthoring;

    @JsonProperty("mobileofflineminlicensetrial")
    protected Integer mobileofflineminlicensetrial;

    @JsonProperty("auditretentionperiod")
    protected Integer auditretentionperiod;

    @JsonProperty("officeappsautodeploymentenabled")
    protected Boolean officeappsautodeploymentenabled;

    @JsonProperty("hashfilterkeywords")
    protected String hashfilterkeywords;

    @JsonProperty("isnotesanalysisenabled")
    protected Boolean isnotesanalysisenabled;

    @JsonProperty("iscontactmailingaddresssyncenabled")
    protected Boolean iscontactmailingaddresssyncenabled;

    @JsonProperty("ismailboxforcedunlockingenabled")
    protected Boolean ismailboxforcedunlockingenabled;

    @JsonProperty("isexternalfilestorageenabled")
    protected Boolean isexternalfilestorageenabled;

    @JsonProperty("mobileofflinesyncinterval")
    protected Integer mobileofflinesyncinterval;

    @JsonProperty("tagmaxaggressivecycles")
    protected Integer tagmaxaggressivecycles;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("grantaccesstonetworkservice")
    protected Boolean grantaccesstonetworkservice;

    @JsonProperty("iscontentsecuritypolicyenabled")
    protected Boolean iscontentsecuritypolicyenabled;

    @JsonProperty("isdelveactionhubintegrationenabled")
    protected Boolean isdelveactionhubintegrationenabled;

    @JsonProperty("allowoutlookscheduledsyncs")
    protected Boolean allowoutlookscheduledsyncs;

    @JsonProperty("maximumdynamicpropertiesallowed")
    protected Integer maximumdynamicpropertiesallowed;

    @JsonProperty("numbergroupformat")
    protected String numbergroupformat;

    @JsonProperty("entityimageid")
    protected String entityimageid;

    @JsonProperty("trackingtokeniddigits")
    protected Integer trackingtokeniddigits;

    @JsonProperty("defaultrecurrenceendrangetype")
    protected Integer defaultrecurrenceendrangetype;

    @JsonProperty("yammernetworkpermalink")
    protected String yammernetworkpermalink;

    @JsonProperty("bulkoperationprefix")
    protected String bulkoperationprefix;

    @JsonProperty("oobpricecalculationenabled")
    protected Boolean oobpricecalculationenabled;

    @JsonProperty("futureexpansionwindow")
    protected Integer futureexpansionwindow;

    @JsonProperty("ispresenceenabled")
    protected Boolean ispresenceenabled;

    @JsonProperty("pastexpansionwindow")
    protected Integer pastexpansionwindow;

    @JsonProperty("maximumslakpiperentitywithactivesla")
    protected Integer maximumslakpiperentitywithactivesla;

    @JsonProperty("ismsteamssettingchangedbyuser")
    protected Boolean ismsteamssettingchangedbyuser;

    @JsonProperty("picture")
    protected String picture;

    @JsonProperty("azureschedulerjobcollectionname")
    protected String azureschedulerjobcollectionname;

    @JsonProperty("isofficegraphenabled")
    protected Boolean isofficegraphenabled;

    @JsonProperty("orgdborgsettings")
    protected String orgdborgsettings;

    @JsonProperty("ismodeldrivenappsinmsteamsenabled")
    protected Boolean ismodeldrivenappsinmsteamsenabled;

    @JsonProperty("rierrorstatus")
    protected Integer rierrorstatus;

    @JsonProperty("allowlegacydialogsembedding")
    protected Boolean allowlegacydialogsembedding;

    @JsonProperty("emailcorrelationenabled")
    protected Boolean emailcorrelationenabled;

    @JsonProperty("maxappointmentdurationdays")
    protected Integer maxappointmentdurationdays;

    @JsonProperty("microsoftflowenvironment")
    protected String microsoftflowenvironment;

    @JsonProperty("tracelogmaximumageindays")
    protected Integer tracelogmaximumageindays;

    @JsonProperty("isduplicatedetectionenabledforimport")
    protected Boolean isduplicatedetectionenabledforimport;

    @JsonProperty("iscustomcontrolsincanvasappsenabled")
    protected Boolean iscustomcontrolsincanvasappsenabled;

    @JsonProperty("enforcereadonlyplugins")
    protected Boolean enforcereadonlyplugins;

    @JsonProperty("createproductswithoutparentinactivestate")
    protected Boolean createproductswithoutparentinactivestate;

    @JsonProperty("enableunifiedinterfaceshellrefresh")
    protected Boolean enableunifiedinterfaceshellrefresh;

    @JsonProperty("textanalyticsenabled")
    protected Boolean textanalyticsenabled;

    @JsonProperty("expirechangetrackingindays")
    protected Integer expirechangetrackingindays;

    @JsonProperty("usereadform")
    protected Boolean usereadform;

    @JsonProperty("basecurrencysymbol")
    protected String basecurrencysymbol;

    @JsonProperty("fiscalyearperiodconnect")
    protected String fiscalyearperiodconnect;

    @JsonProperty("maxsupportedinternetexplorerversion")
    protected Integer maxsupportedinternetexplorerversion;

    @JsonProperty("fiscalperiodformatperiod")
    protected Integer fiscalperiodformatperiod;

    @JsonProperty("bingmapsapikey")
    protected String bingmapsapikey;

    @JsonProperty("isactionsupportfeatureenabled")
    protected Boolean isactionsupportfeatureenabled;

    @JsonProperty("restrictstatusupdate")
    protected Boolean restrictstatusupdate;

    @JsonProperty("defaultthemedata")
    protected String defaultthemedata;

    @JsonProperty("isonedriveenabled")
    protected Boolean isonedriveenabled;

    @JsonProperty("externalpartycorrelationkeys")
    protected String externalpartycorrelationkeys;

    @JsonProperty("auditretentionperiodv2")
    protected Integer auditretentionperiodv2;

    @JsonProperty("negativeformatcode")
    protected Integer negativeformatcode;

    @JsonProperty("ispricelistmandatory")
    protected Boolean ispricelistmandatory;

    @JsonProperty("timeseparator")
    protected String timeseparator;

    @JsonProperty("maxproductsinbundle")
    protected Integer maxproductsinbundle;

    @JsonProperty("slapausestates")
    protected String slapausestates;

    @JsonProperty("v3calloutconfighash")
    protected String v3calloutconfighash;

    @JsonProperty("plugintracelogsetting")
    protected Integer plugintracelogsetting;

    @JsonProperty("syncoptinselectionstatus")
    protected Integer syncoptinselectionstatus;

    @JsonProperty("syncbulkoperationmaxlimit")
    protected Integer syncbulkoperationmaxlimit;

    @JsonProperty("allowofflinescheduledsyncs")
    protected Boolean allowofflinescheduledsyncs;

    @JsonProperty("basecurrencyprecision")
    protected Integer basecurrencyprecision;

    @JsonProperty("socialinsightsinstance")
    protected String socialinsightsinstance;

    @JsonProperty("ishierarchicalsecuritymodelenabled")
    protected Boolean ishierarchicalsecuritymodelenabled;

    @JsonProperty("privacystatementurl")
    protected String privacystatementurl;

    @JsonProperty("minoutlooksyncinterval")
    protected Integer minoutlooksyncinterval;

    @JsonProperty("currentimportsequencenumber")
    protected Integer currentimportsequencenumber;

    @JsonProperty("isuseraccessauditenabled")
    protected Boolean isuseraccessauditenabled;

    @JsonProperty("fiscalyearformatprefix")
    protected Integer fiscalyearformatprefix;

    @JsonProperty("enablebingmapsintegration")
    protected Boolean enablebingmapsintegration;

    @JsonProperty("maxslaitemspersla")
    protected Integer maxslaitemspersla;

    @JsonProperty("syncbulkoperationbatchsize")
    protected Integer syncbulkoperationbatchsize;

    @JsonProperty("tagpollingperiod")
    protected Integer tagpollingperiod;

    @JsonProperty("suppresssla")
    protected Boolean suppresssla;

    @JsonProperty("clientfeatureset")
    protected String clientfeatureset;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("isemailmonitoringallowed")
    protected Boolean isemailmonitoringallowed;

    @JsonProperty("maxverboseloggingmailbox")
    protected Integer maxverboseloggingmailbox;

    @JsonProperty("ismanualsalesforecastingenabled")
    protected Boolean ismanualsalesforecastingenabled;

    @JsonProperty("isduplicatedetectionenabled")
    protected Boolean isduplicatedetectionenabled;

    @JsonProperty("schemanameprefix")
    protected String schemanameprefix;

    @JsonProperty("paipreviewscenarioenabled")
    protected Boolean paipreviewscenarioenabled;

    @JsonProperty("autoapplysla")
    protected Boolean autoapplysla;

    @JsonProperty("ismsteamscollaborationenabled")
    protected Boolean ismsteamscollaborationenabled;

    @JsonProperty("incomingemailexchangeemailretrievalbatchsize")
    protected Integer incomingemailexchangeemailretrievalbatchsize;

    @JsonProperty("ismailboxinactivebackoffenabled")
    protected Boolean ismailboxinactivebackoffenabled;

    @JsonProperty("cortanaproactiveexperienceenabled")
    protected Boolean cortanaproactiveexperienceenabled;

    @JsonProperty("goalrollupexpirytime")
    protected Integer goalrollupexpirytime;

    @JsonProperty("isplaybookenabled")
    protected Boolean isplaybookenabled;

    @JsonProperty("showkbarticledeprecationnotification")
    protected Boolean showkbarticledeprecationnotification;

    @JsonProperty("isappmode")
    protected Boolean isappmode;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("contractprefix")
    protected String contractprefix;

    @JsonProperty("allowautounsubscribe")
    protected Boolean allowautounsubscribe;

    @JsonProperty("ignoreinternalemail")
    protected Boolean ignoreinternalemail;

    @JsonProperty("ispreviewforautocaptureenabled")
    protected Boolean ispreviewforautocaptureenabled;

    @JsonProperty("minofflinesyncinterval")
    protected Integer minofflinesyncinterval;

    @JsonProperty("highcontrastthemedata")
    protected String highcontrastthemedata;

    @JsonProperty("systemuserid")
    protected String systemuserid;

    @JsonProperty("orginsightsenabled")
    protected Boolean orginsightsenabled;

    @JsonProperty("maxactionstepsinbpf")
    protected Integer maxactionstepsinbpf;

    @JsonProperty("socialinsightstermsaccepted")
    protected Boolean socialinsightstermsaccepted;

    @JsonProperty("defaultemailsettings")
    protected String defaultemailsettings;

    @JsonProperty("generatealertsforerrors")
    protected Boolean generatealertsforerrors;

    @JsonProperty("getstartedpanecontentenabled")
    protected Boolean getstartedpanecontentenabled;

    @JsonProperty("sqlaccessgroupname")
    protected String sqlaccessgroupname;

    @JsonProperty("autoapplydefaultoncaseupdate")
    protected Boolean autoapplydefaultoncaseupdate;

    @JsonProperty("negativecurrencyformatcode")
    protected Integer negativecurrencyformatcode;

    @JsonProperty("cascadestatusupdate")
    protected Boolean cascadestatusupdate;

    @JsonProperty("powerbifeatureenabled")
    protected Boolean powerbifeatureenabled;

    @JsonProperty("fullnameconventioncode")
    protected Integer fullnameconventioncode;

    @JsonProperty("allowaddressbooksyncs")
    protected Boolean allowaddressbooksyncs;

    @JsonProperty("notifymailboxownerofemailserverlevelalerts")
    protected Boolean notifymailboxownerofemailserverlevelalerts;

    @JsonProperty("usequickfindviewforgridsearch")
    protected Boolean usequickfindviewforgridsearch;

    @JsonProperty("discountcalculationmethod")
    protected Integer discountcalculationmethod;

    @JsonProperty("organizationid")
    protected String organizationid;

    @JsonProperty("mailboxpermanentissueminrange")
    protected Integer mailboxpermanentissueminrange;

    @JsonProperty("kmsettings")
    protected String kmsettings;

    @JsonProperty("isfulltextsearchenabled")
    protected Boolean isfulltextsearchenabled;

    @JsonProperty("hashminaddresscount")
    protected Integer hashminaddresscount;

    @JsonProperty("dateseparator")
    protected String dateseparator;

    @JsonProperty("weekstartdaycode")
    protected Integer weekstartdaycode;

    @JsonProperty("allowuserformmodepreference")
    protected Boolean allowuserformmodepreference;

    @JsonProperty("numberseparator")
    protected String numberseparator;

    @JsonProperty("campaignprefix")
    protected String campaignprefix;

    @JsonProperty("productrecommendationsenabled")
    protected Boolean productrecommendationsenabled;

    @JsonProperty("recurrencedefaultnumberofoccurrences")
    protected Integer recurrencedefaultnumberofoccurrences;

    @JsonProperty("ismsteamsusersyncenabled")
    protected Boolean ismsteamsusersyncenabled;

    @JsonProperty("quickfindrecordlimitenabled")
    protected Boolean quickfindrecordlimitenabled;

    @JsonProperty("pricingdecimalprecision")
    protected Integer pricingdecimalprecision;

    @JsonProperty("useskypeprotocol")
    protected Boolean useskypeprotocol;

    @JsonProperty("rendersecureiframeforemail")
    protected Boolean rendersecureiframeforemail;

    @JsonProperty("inactivitytimeoutinmins")
    protected Integer inactivitytimeoutinmins;

    @JsonProperty("sessiontimeoutenabled")
    protected Boolean sessiontimeoutenabled;

    @JsonProperty("minaddressbooksyncinterval")
    protected Integer minaddressbooksyncinterval;

    @JsonProperty("externalbaseurl")
    protected String externalbaseurl;

    @JsonProperty("issalesassistantenabled")
    protected Boolean issalesassistantenabled;

    @JsonProperty("_defaultmobileofflineprofileid_value")
    protected String _defaultmobileofflineprofileid_value;

    @JsonProperty("amdesignator")
    protected String amdesignator;

    @JsonProperty("enableimmersiveskypeintegration")
    protected Boolean enableimmersiveskypeintegration;

    @JsonProperty("kbprefix")
    protected String kbprefix;

    @JsonProperty("bounddashboarddefaultcardexpanded")
    protected Boolean bounddashboarddefaultcardexpanded;

    @JsonProperty("hashmaxcount")
    protected Integer hashmaxcount;

    @JsonProperty("reportinggroupname")
    protected String reportinggroupname;

    @JsonProperty("isdelegateaccessenabled")
    protected Boolean isdelegateaccessenabled;

    @JsonProperty("aciwebendpointurl")
    protected String aciwebendpointurl;

    @JsonProperty("maxuploadfilesize")
    protected Integer maxuploadfilesize;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("fiscalyeardisplaycode")
    protected Integer fiscalyeardisplaycode;

    @JsonProperty("yammeroauthaccesstokenexpired")
    protected Boolean yammeroauthaccesstokenexpired;

    @JsonProperty("externalpartyentitysettings")
    protected String externalpartyentitysettings;

    @JsonProperty("defaultcountrycode")
    protected String defaultcountrycode;

    @JsonProperty("isactivityanalysisenabled")
    protected Boolean isactivityanalysisenabled;

    @JsonProperty("recurrenceexpansionjobbatchsize")
    protected Integer recurrenceexpansionjobbatchsize;

    @JsonProperty("_basecurrencyid_value")
    protected String _basecurrencyid_value;

    @JsonProperty("featureset")
    protected String featureset;

    @JsonProperty("istextwrapenabled")
    protected Boolean istextwrapenabled;

    @JsonProperty("calendartype")
    protected Integer calendartype;

    @JsonProperty("allowclientmessagebarad")
    protected Boolean allowclientmessagebarad;

    @JsonProperty("usergroupid")
    protected String usergroupid;

    @JsonProperty("isdisabled")
    protected Boolean isdisabled;

    @JsonProperty("isduplicatedetectionenabledforofflinesync")
    protected Boolean isduplicatedetectionenabledforofflinesync;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("appdesignerexperienceenabled")
    protected Boolean appdesignerexperienceenabled;

    @JsonProperty("categoryprefix")
    protected String categoryprefix;

    @JsonProperty("ispreviewenabledforactioncard")
    protected Boolean ispreviewenabledforactioncard;

    @JsonProperty("ismobileofflineenabled")
    protected Boolean ismobileofflineenabled;

    @JsonProperty("fiscalcalendarstart")
    protected OffsetDateTime fiscalcalendarstart;

    @JsonProperty("isexternalsearchindexenabled")
    protected Boolean isexternalsearchindexenabled;

    @JsonProperty("maximumactivebusinessprocessflowsallowedperentity")
    protected Integer maximumactivebusinessprocessflowsallowedperentity;

    @JsonProperty("enablelivepersonacarduci")
    protected Boolean enablelivepersonacarduci;

    @JsonProperty("timeformatcode")
    protected Integer timeformatcode;

    @JsonProperty("dayssincerecordlastmodifiedmaxvalue")
    protected Integer dayssincerecordlastmodifiedmaxvalue;

    @JsonProperty("_acknowledgementtemplateid_value")
    protected String _acknowledgementtemplateid_value;

    @JsonProperty("maxdepthforhierarchicalsecuritymodel")
    protected Integer maxdepthforhierarchicalsecuritymodel;

    @JsonProperty("currencysymbol")
    protected String currencysymbol;

    @JsonProperty("isfolderbasedtrackingenabled")
    protected Boolean isfolderbasedtrackingenabled;

    @JsonProperty("isdefaultcountrycodecheckenabled")
    protected Boolean isdefaultcountrycodecheckenabled;

    @JsonProperty("entityimage")
    protected byte[] entityimage;

    @JsonProperty("fiscalyearformatyear")
    protected Integer fiscalyearformatyear;

    @JsonProperty("entityimage_timestamp")
    protected Long entityimage_timestamp;

    @JsonProperty("privreportinggroupname")
    protected String privreportinggroupname;

    @JsonProperty("yearstartweekcode")
    protected Integer yearstartweekcode;

    @JsonProperty("uselegacyrendering")
    protected Boolean uselegacyrendering;

    @JsonProperty("maximumtrackingnumber")
    protected Integer maximumtrackingnumber;

    @JsonProperty("fiscalyearformatsuffix")
    protected Integer fiscalyearformatsuffix;

    @JsonProperty("allowautoresponsecreation")
    protected Boolean allowautoresponsecreation;

    @JsonProperty("allowlegacyclientexperience")
    protected Boolean allowlegacyclientexperience;

    @JsonProperty("ismsteamsenabled")
    protected Boolean ismsteamsenabled;

    @JsonProperty("enablemicrosoftflowintegration")
    protected Boolean enablemicrosoftflowintegration;

    @JsonProperty("currentparsedtablenumber")
    protected Integer currentparsedtablenumber;

    @JsonProperty("socialinsightsenabled")
    protected Boolean socialinsightsenabled;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("initialversion")
    protected String initialversion;

    @JsonProperty("delegatedadminuserid")
    protected String delegatedadminuserid;

    @JsonProperty("isfiscalperiodmonthbased")
    protected Boolean isfiscalperiodmonthbased;

    @JsonProperty("fiscalperiodtype")
    protected Integer fiscalperiodtype;

    @JsonProperty("inactivitytimeoutreminderinmins")
    protected Integer inactivitytimeoutreminderinmins;

    @JsonProperty("disabledreason")
    protected String disabledreason;

    @JsonProperty("uniquespecifierlength")
    protected Integer uniquespecifierlength;

    @JsonProperty("ispdfgenerationenabled")
    protected String ispdfgenerationenabled;

    @JsonProperty("enablelivepersoncardintegrationinoffice")
    protected Boolean enablelivepersoncardintegrationinoffice;

    @JsonProperty("maxrecordsforexporttoexcel")
    protected Integer maxrecordsforexporttoexcel;

    @JsonProperty("useraccessauditinginterval")
    protected Integer useraccessauditinginterval;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("kaprefix")
    protected String kaprefix;

    @JsonProperty("allowmarketingemailexecution")
    protected Boolean allowmarketingemailexecution;

    @JsonProperty("sqmenabled")
    protected Boolean sqmenabled;

    @JsonProperty("timeformatstring")
    protected String timeformatstring;

    @JsonProperty("iscontextualemailenabled")
    protected Boolean iscontextualemailenabled;

    @JsonProperty("dateformatcode")
    protected Integer dateformatcode;

    @JsonProperty("webresourcehash")
    protected String webresourcehash;

    @JsonProperty("syncoptinselection")
    protected Boolean syncoptinselection;

    @JsonProperty("sortid")
    protected Integer sortid;

    @JsonProperty("globalhelpurl")
    protected String globalhelpurl;

    @JsonProperty("isallmoneydecimal")
    protected Boolean isallmoneydecimal;

    @JsonProperty("isauditenabled")
    protected Boolean isauditenabled;

    @JsonProperty("fiscalyearformat")
    protected String fiscalyearformat;

    @JsonProperty("sendbulkemailinuci")
    protected Boolean sendbulkemailinuci;

    @JsonProperty("defaultcrmcustomname")
    protected String defaultcrmcustomname;

    @JsonProperty("currencyformatcode")
    protected Integer currencyformatcode;

    @JsonProperty("isbpfentitycustomizationfeatureenabled")
    protected Boolean isbpfentitycustomizationfeatureenabled;

    @JsonProperty("maxconditionsformobileofflinefilters")
    protected Integer maxconditionsformobileofflinefilters;

    @JsonProperty("businessclosurecalendarid")
    protected String businessclosurecalendarid;

    @JsonProperty("showweeknumber")
    protected Boolean showweeknumber;

    @JsonProperty("isactioncardenabled")
    protected Boolean isactioncardenabled;

    @JsonProperty("sessiontimeoutinmins")
    protected Integer sessiontimeoutinmins;

    @JsonProperty("appointmentricheditorexperience")
    protected Boolean appointmentricheditorexperience;

    @JsonProperty("_defaultemailserverprofileid_value")
    protected String _defaultemailserverprofileid_value;

    @JsonProperty("integrationuserid")
    protected String integrationuserid;

    @JsonProperty("entityimage_url")
    protected String entityimage_url;

    @JsonProperty("isnewaddproductexperienceenabled")
    protected Boolean isnewaddproductexperienceenabled;

    @JsonProperty("pmdesignator")
    protected String pmdesignator;

    @JsonProperty("sampledataimportid")
    protected String sampledataimportid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("currencydecimalprecision")
    protected Integer currencydecimalprecision;

    @JsonProperty("emailconnectionchannel")
    protected Integer emailconnectionchannel;

    @JsonProperty("ispreviewforemailmonitoringallowed")
    protected Boolean ispreviewforemailmonitoringallowed;

    @JsonProperty("allowunresolvedpartiesonemailsend")
    protected Boolean allowunresolvedpartiesonemailsend;

    @JsonProperty("ispaienabled")
    protected Boolean ispaienabled;

    @JsonProperty("isautodatacapturev2enabled")
    protected Boolean isautodatacapturev2enabled;

    @JsonProperty("allowautounsubscribeacknowledgement")
    protected Boolean allowautounsubscribeacknowledgement;

    @JsonProperty("nexttrackingnumber")
    protected Integer nexttrackingnumber;

    @JsonProperty("enablepricingoncreate")
    protected Boolean enablepricingoncreate;

    @JsonProperty("parsedtablecolumnprefix")
    protected String parsedtablecolumnprefix;

    @JsonProperty("allowusersseeappdownloadmessage")
    protected Boolean allowusersseeappdownloadmessage;

    @JsonProperty("decimalsymbol")
    protected String decimalsymbol;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("signupoutlookdownloadfwlink")
    protected String signupoutlookdownloadfwlink;

    @JsonProperty("isresourcebookingexchangesyncenabled")
    protected Boolean isresourcebookingexchangesyncenabled;

    @JsonProperty("disablesocialcare")
    protected Boolean disablesocialcare;

    @JsonProperty("resolvesimilarunresolvedemailaddress")
    protected Boolean resolvesimilarunresolvedemailaddress;

    @JsonProperty("unresolveemailaddressifmultiplematch")
    protected Boolean unresolveemailaddressifmultiplematch;

    @JsonProperty("sharetopreviousowneronassign")
    protected Boolean sharetopreviousowneronassign;

    @JsonProperty("iswriteinproductsallowed")
    protected Boolean iswriteinproductsallowed;

    @JsonProperty("reportinggroupid")
    protected String reportinggroupid;

    @JsonProperty("qualifyleadadditionaloptions")
    protected String qualifyleadadditionaloptions;

    @JsonProperty("isfolderautocreatedonsp")
    protected Boolean isfolderautocreatedonsp;

    @JsonProperty("maxfolderbasedtrackingmappings")
    protected Integer maxfolderbasedtrackingmappings;

    @JsonProperty("sqlaccessgroupid")
    protected String sqlaccessgroupid;

    @JsonProperty("trackingprefix")
    protected String trackingprefix;

    @JsonProperty("yammergroupid")
    protected Integer yammergroupid;

    @JsonProperty("dateformatstring")
    protected String dateformatstring;

    @JsonProperty("yammerpostmethod")
    protected Integer yammerpostmethod;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    protected Organization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderOrganization() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean autoapplydefaultoncasecreate;
        private Integer maxverboseloggingsynccycles;
        private String privilegeusergroupid;
        private Integer expiresubscriptionsindays;
        private String numberformat;
        private Boolean globalhelpurlenabled;
        private String widgetproperties;
        private Boolean taskbasedflowenabled;
        private Boolean iscontextualhelpenabled;
        private Boolean isquickcreateenabledforopportunityclose;
        private Integer recurrenceexpansionsynchcreatemax;
        private Boolean generatealertsforinformation;
        private Boolean enablesmartmatching;
        private String orderprefix;
        private Integer reportscripterrors;
        private Integer organizationstate;
        private Integer sessiontimeoutreminderinmins;
        private Boolean allowwebexcelexport;
        private Integer mobileofflineminlicenseprod;
        private String caseprefix;
        private Integer longdateformatcode;
        private Boolean usepositionhierarchy;
        private Integer trackingtokenidbase;
        private Boolean allowentityonlyaudit;
        private Boolean globalappendurlparametersenabled;
        private Boolean generatealertsforwarnings;
        private Integer maximumentitieswithactivesla;
        private String privreportinggroupid;
        private String invoiceprefix;
        private String quoteprefix;
        private Integer mailboxintermittentissueminrange;
        private Boolean isassignedtaskssyncenabled;
        private Boolean issopintegrationenabled;
        private Boolean ismobileclientondemandsyncenabled;
        private Boolean isgeospatialazuremapsintegrationenabled;
        private Boolean servestaticresourcesfromazurecdn;
        private Boolean isautodatacaptureenabled;
        private Boolean isemailserverprofilecontentfilteringenabled;
        private Boolean isluisenabledford365bot;
        private String blockedattachments;
        private Boolean isconflictdetectionenabledformobileclient;
        private String businesscardoptions;
        private Integer goalrollupfrequency;
        private String parsedtableprefix;
        private Boolean isreadauditenabled;
        private Boolean requireapprovalforuseremail;
        private Integer emailsendpollingperiod;
        private Boolean useinbuiltrulefordefaultpricelistselection;
        private Boolean isrichtextnotesenabled;
        private Integer hashdeltasubjectcount;
        private Integer recurrenceexpansionjobbatchinterval;
        private String fiscalperiodformat;
        private String officegraphdelveurl;
        private Integer maxrecordsforlookupfilters;
        private Integer sharepointdeploymenttype;
        private Boolean isrelationshipinsightsenabled;
        private Boolean requireapprovalforqueueemail;
        private Integer tokenexpiry;
        private String postmessagewhitelistdomains;
        private Integer localeid;
        private OffsetDateTime createdon;
        private Boolean isduplicatedetectionenabledforonlinecreateupdate;
        private String contentsecuritypolicyconfiguration;
        private Boolean inactivitytimeoutenabled;
        private Boolean displaynavigationtour;
        private Boolean isautosaveenabled;
        private String supportuserid;
        private Integer currencydisplayoption;
        private String tokenkey;
        private Integer pinpointlanguagecode;
        private Boolean isappointmentattachmentsyncenabled;
        private Boolean isenabledforallroles;
        private Boolean enablelpauthoring;
        private Integer mobileofflineminlicensetrial;
        private Integer auditretentionperiod;
        private Boolean officeappsautodeploymentenabled;
        private String hashfilterkeywords;
        private Boolean isnotesanalysisenabled;
        private Boolean iscontactmailingaddresssyncenabled;
        private Boolean ismailboxforcedunlockingenabled;
        private Boolean isexternalfilestorageenabled;
        private Integer mobileofflinesyncinterval;
        private Integer tagmaxaggressivecycles;
        private Integer utcconversiontimezonecode;
        private Boolean grantaccesstonetworkservice;
        private Boolean iscontentsecuritypolicyenabled;
        private Boolean isdelveactionhubintegrationenabled;
        private Boolean allowoutlookscheduledsyncs;
        private Integer maximumdynamicpropertiesallowed;
        private String numbergroupformat;
        private String entityimageid;
        private Integer trackingtokeniddigits;
        private Integer defaultrecurrenceendrangetype;
        private String yammernetworkpermalink;
        private String bulkoperationprefix;
        private Boolean oobpricecalculationenabled;
        private Integer futureexpansionwindow;
        private Boolean ispresenceenabled;
        private Integer pastexpansionwindow;
        private Integer maximumslakpiperentitywithactivesla;
        private Boolean ismsteamssettingchangedbyuser;
        private String picture;
        private String azureschedulerjobcollectionname;
        private Boolean isofficegraphenabled;
        private String orgdborgsettings;
        private Boolean ismodeldrivenappsinmsteamsenabled;
        private Integer rierrorstatus;
        private Boolean allowlegacydialogsembedding;
        private Boolean emailcorrelationenabled;
        private Integer maxappointmentdurationdays;
        private String microsoftflowenvironment;
        private Integer tracelogmaximumageindays;
        private Boolean isduplicatedetectionenabledforimport;
        private Boolean iscustomcontrolsincanvasappsenabled;
        private Boolean enforcereadonlyplugins;
        private Boolean createproductswithoutparentinactivestate;
        private Boolean enableunifiedinterfaceshellrefresh;
        private Boolean textanalyticsenabled;
        private Integer expirechangetrackingindays;
        private Boolean usereadform;
        private String basecurrencysymbol;
        private String fiscalyearperiodconnect;
        private Integer maxsupportedinternetexplorerversion;
        private Integer fiscalperiodformatperiod;
        private String bingmapsapikey;
        private Boolean isactionsupportfeatureenabled;
        private Boolean restrictstatusupdate;
        private String defaultthemedata;
        private Boolean isonedriveenabled;
        private String externalpartycorrelationkeys;
        private Integer auditretentionperiodv2;
        private Integer negativeformatcode;
        private Boolean ispricelistmandatory;
        private String timeseparator;
        private Integer maxproductsinbundle;
        private String slapausestates;
        private String v3calloutconfighash;
        private Integer plugintracelogsetting;
        private Integer syncoptinselectionstatus;
        private Integer syncbulkoperationmaxlimit;
        private Boolean allowofflinescheduledsyncs;
        private Integer basecurrencyprecision;
        private String socialinsightsinstance;
        private Boolean ishierarchicalsecuritymodelenabled;
        private String privacystatementurl;
        private Integer minoutlooksyncinterval;
        private Integer currentimportsequencenumber;
        private Boolean isuseraccessauditenabled;
        private Integer fiscalyearformatprefix;
        private Boolean enablebingmapsintegration;
        private Integer maxslaitemspersla;
        private Integer syncbulkoperationbatchsize;
        private Integer tagpollingperiod;
        private Boolean suppresssla;
        private String clientfeatureset;
        private Long versionnumber;
        private Boolean isemailmonitoringallowed;
        private Integer maxverboseloggingmailbox;
        private Boolean ismanualsalesforecastingenabled;
        private Boolean isduplicatedetectionenabled;
        private String schemanameprefix;
        private Boolean paipreviewscenarioenabled;
        private Boolean autoapplysla;
        private Boolean ismsteamscollaborationenabled;
        private Integer incomingemailexchangeemailretrievalbatchsize;
        private Boolean ismailboxinactivebackoffenabled;
        private Boolean cortanaproactiveexperienceenabled;
        private Integer goalrollupexpirytime;
        private Boolean isplaybookenabled;
        private Boolean showkbarticledeprecationnotification;
        private Boolean isappmode;
        private String _modifiedby_value;
        private String contractprefix;
        private Boolean allowautounsubscribe;
        private Boolean ignoreinternalemail;
        private Boolean ispreviewforautocaptureenabled;
        private Integer minofflinesyncinterval;
        private String highcontrastthemedata;
        private String systemuserid;
        private Boolean orginsightsenabled;
        private Integer maxactionstepsinbpf;
        private Boolean socialinsightstermsaccepted;
        private String defaultemailsettings;
        private Boolean generatealertsforerrors;
        private Boolean getstartedpanecontentenabled;
        private String sqlaccessgroupname;
        private Boolean autoapplydefaultoncaseupdate;
        private Integer negativecurrencyformatcode;
        private Boolean cascadestatusupdate;
        private Boolean powerbifeatureenabled;
        private Integer fullnameconventioncode;
        private Boolean allowaddressbooksyncs;
        private Boolean notifymailboxownerofemailserverlevelalerts;
        private Boolean usequickfindviewforgridsearch;
        private Integer discountcalculationmethod;
        private String organizationid;
        private Integer mailboxpermanentissueminrange;
        private String kmsettings;
        private Boolean isfulltextsearchenabled;
        private Integer hashminaddresscount;
        private String dateseparator;
        private Integer weekstartdaycode;
        private Boolean allowuserformmodepreference;
        private String numberseparator;
        private String campaignprefix;
        private Boolean productrecommendationsenabled;
        private Integer recurrencedefaultnumberofoccurrences;
        private Boolean ismsteamsusersyncenabled;
        private Boolean quickfindrecordlimitenabled;
        private Integer pricingdecimalprecision;
        private Boolean useskypeprotocol;
        private Boolean rendersecureiframeforemail;
        private Integer inactivitytimeoutinmins;
        private Boolean sessiontimeoutenabled;
        private Integer minaddressbooksyncinterval;
        private String externalbaseurl;
        private Boolean issalesassistantenabled;
        private String _defaultmobileofflineprofileid_value;
        private String amdesignator;
        private Boolean enableimmersiveskypeintegration;
        private String kbprefix;
        private Boolean bounddashboarddefaultcardexpanded;
        private Integer hashmaxcount;
        private String reportinggroupname;
        private Boolean isdelegateaccessenabled;
        private String aciwebendpointurl;
        private Integer maxuploadfilesize;
        private String _modifiedonbehalfby_value;
        private Integer fiscalyeardisplaycode;
        private Boolean yammeroauthaccesstokenexpired;
        private String externalpartyentitysettings;
        private String defaultcountrycode;
        private Boolean isactivityanalysisenabled;
        private Integer recurrenceexpansionjobbatchsize;
        private String _basecurrencyid_value;
        private String featureset;
        private Boolean istextwrapenabled;
        private Integer calendartype;
        private Boolean allowclientmessagebarad;
        private String usergroupid;
        private Boolean isdisabled;
        private Boolean isduplicatedetectionenabledforofflinesync;
        private Integer languagecode;
        private Boolean appdesignerexperienceenabled;
        private String categoryprefix;
        private Boolean ispreviewenabledforactioncard;
        private Boolean ismobileofflineenabled;
        private OffsetDateTime fiscalcalendarstart;
        private Boolean isexternalsearchindexenabled;
        private Integer maximumactivebusinessprocessflowsallowedperentity;
        private Boolean enablelivepersonacarduci;
        private Integer timeformatcode;
        private Integer dayssincerecordlastmodifiedmaxvalue;
        private String _acknowledgementtemplateid_value;
        private Integer maxdepthforhierarchicalsecuritymodel;
        private String currencysymbol;
        private Boolean isfolderbasedtrackingenabled;
        private Boolean isdefaultcountrycodecheckenabled;
        private byte[] entityimage;
        private Integer fiscalyearformatyear;
        private Long entityimage_timestamp;
        private String privreportinggroupname;
        private Integer yearstartweekcode;
        private Boolean uselegacyrendering;
        private Integer maximumtrackingnumber;
        private Integer fiscalyearformatsuffix;
        private Boolean allowautoresponsecreation;
        private Boolean allowlegacyclientexperience;
        private Boolean ismsteamsenabled;
        private Boolean enablemicrosoftflowintegration;
        private Integer currentparsedtablenumber;
        private Boolean socialinsightsenabled;
        private String _createdby_value;
        private String initialversion;
        private String delegatedadminuserid;
        private Boolean isfiscalperiodmonthbased;
        private Integer fiscalperiodtype;
        private Integer inactivitytimeoutreminderinmins;
        private String disabledreason;
        private Integer uniquespecifierlength;
        private String ispdfgenerationenabled;
        private Boolean enablelivepersoncardintegrationinoffice;
        private Integer maxrecordsforexporttoexcel;
        private Integer useraccessauditinginterval;
        private String _createdonbehalfby_value;
        private String kaprefix;
        private Boolean allowmarketingemailexecution;
        private Boolean sqmenabled;
        private String timeformatstring;
        private Boolean iscontextualemailenabled;
        private Integer dateformatcode;
        private String webresourcehash;
        private Boolean syncoptinselection;
        private Integer sortid;
        private String globalhelpurl;
        private Boolean isallmoneydecimal;
        private Boolean isauditenabled;
        private String fiscalyearformat;
        private Boolean sendbulkemailinuci;
        private String defaultcrmcustomname;
        private Integer currencyformatcode;
        private Boolean isbpfentitycustomizationfeatureenabled;
        private Integer maxconditionsformobileofflinefilters;
        private String businessclosurecalendarid;
        private Boolean showweeknumber;
        private Boolean isactioncardenabled;
        private Integer sessiontimeoutinmins;
        private Boolean appointmentricheditorexperience;
        private String _defaultemailserverprofileid_value;
        private String integrationuserid;
        private String entityimage_url;
        private Boolean isnewaddproductexperienceenabled;
        private String pmdesignator;
        private String sampledataimportid;
        private String name;
        private Integer currencydecimalprecision;
        private Integer emailconnectionchannel;
        private Boolean ispreviewforemailmonitoringallowed;
        private Boolean allowunresolvedpartiesonemailsend;
        private Boolean ispaienabled;
        private Boolean isautodatacapturev2enabled;
        private Boolean allowautounsubscribeacknowledgement;
        private Integer nexttrackingnumber;
        private Boolean enablepricingoncreate;
        private String parsedtablecolumnprefix;
        private Boolean allowusersseeappdownloadmessage;
        private String decimalsymbol;
        private OffsetDateTime modifiedon;
        private String signupoutlookdownloadfwlink;
        private Boolean isresourcebookingexchangesyncenabled;
        private Boolean disablesocialcare;
        private Boolean resolvesimilarunresolvedemailaddress;
        private Boolean unresolveemailaddressifmultiplematch;
        private Boolean sharetopreviousowneronassign;
        private Boolean iswriteinproductsallowed;
        private String reportinggroupid;
        private String qualifyleadadditionaloptions;
        private Boolean isfolderautocreatedonsp;
        private Integer maxfolderbasedtrackingmappings;
        private String sqlaccessgroupid;
        private String trackingprefix;
        private Integer yammergroupid;
        private String dateformatstring;
        private Integer yammerpostmethod;
        private Integer timezoneruleversionnumber;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder autoapplydefaultoncasecreate(Boolean autoapplydefaultoncasecreate) {
            this.autoapplydefaultoncasecreate = autoapplydefaultoncasecreate;
            this.changedFields = changedFields.add("autoapplydefaultoncasecreate");
            return this;
        }

        public Builder maxverboseloggingsynccycles(Integer maxverboseloggingsynccycles) {
            this.maxverboseloggingsynccycles = maxverboseloggingsynccycles;
            this.changedFields = changedFields.add("maxverboseloggingsynccycles");
            return this;
        }

        public Builder privilegeusergroupid(String privilegeusergroupid) {
            this.privilegeusergroupid = privilegeusergroupid;
            this.changedFields = changedFields.add("privilegeusergroupid");
            return this;
        }

        public Builder expiresubscriptionsindays(Integer expiresubscriptionsindays) {
            this.expiresubscriptionsindays = expiresubscriptionsindays;
            this.changedFields = changedFields.add("expiresubscriptionsindays");
            return this;
        }

        public Builder numberformat(String numberformat) {
            this.numberformat = numberformat;
            this.changedFields = changedFields.add("numberformat");
            return this;
        }

        public Builder globalhelpurlenabled(Boolean globalhelpurlenabled) {
            this.globalhelpurlenabled = globalhelpurlenabled;
            this.changedFields = changedFields.add("globalhelpurlenabled");
            return this;
        }

        public Builder widgetproperties(String widgetproperties) {
            this.widgetproperties = widgetproperties;
            this.changedFields = changedFields.add("widgetproperties");
            return this;
        }

        public Builder taskbasedflowenabled(Boolean taskbasedflowenabled) {
            this.taskbasedflowenabled = taskbasedflowenabled;
            this.changedFields = changedFields.add("taskbasedflowenabled");
            return this;
        }

        public Builder iscontextualhelpenabled(Boolean iscontextualhelpenabled) {
            this.iscontextualhelpenabled = iscontextualhelpenabled;
            this.changedFields = changedFields.add("iscontextualhelpenabled");
            return this;
        }

        public Builder isquickcreateenabledforopportunityclose(Boolean isquickcreateenabledforopportunityclose) {
            this.isquickcreateenabledforopportunityclose = isquickcreateenabledforopportunityclose;
            this.changedFields = changedFields.add("isquickcreateenabledforopportunityclose");
            return this;
        }

        public Builder recurrenceexpansionsynchcreatemax(Integer recurrenceexpansionsynchcreatemax) {
            this.recurrenceexpansionsynchcreatemax = recurrenceexpansionsynchcreatemax;
            this.changedFields = changedFields.add("recurrenceexpansionsynchcreatemax");
            return this;
        }

        public Builder generatealertsforinformation(Boolean generatealertsforinformation) {
            this.generatealertsforinformation = generatealertsforinformation;
            this.changedFields = changedFields.add("generatealertsforinformation");
            return this;
        }

        public Builder enablesmartmatching(Boolean enablesmartmatching) {
            this.enablesmartmatching = enablesmartmatching;
            this.changedFields = changedFields.add("enablesmartmatching");
            return this;
        }

        public Builder orderprefix(String orderprefix) {
            this.orderprefix = orderprefix;
            this.changedFields = changedFields.add("orderprefix");
            return this;
        }

        public Builder reportscripterrors(Integer reportscripterrors) {
            this.reportscripterrors = reportscripterrors;
            this.changedFields = changedFields.add("reportscripterrors");
            return this;
        }

        public Builder organizationstate(Integer organizationstate) {
            this.organizationstate = organizationstate;
            this.changedFields = changedFields.add("organizationstate");
            return this;
        }

        public Builder sessiontimeoutreminderinmins(Integer sessiontimeoutreminderinmins) {
            this.sessiontimeoutreminderinmins = sessiontimeoutreminderinmins;
            this.changedFields = changedFields.add("sessiontimeoutreminderinmins");
            return this;
        }

        public Builder allowwebexcelexport(Boolean allowwebexcelexport) {
            this.allowwebexcelexport = allowwebexcelexport;
            this.changedFields = changedFields.add("allowwebexcelexport");
            return this;
        }

        public Builder mobileofflineminlicenseprod(Integer mobileofflineminlicenseprod) {
            this.mobileofflineminlicenseprod = mobileofflineminlicenseprod;
            this.changedFields = changedFields.add("mobileofflineminlicenseprod");
            return this;
        }

        public Builder caseprefix(String caseprefix) {
            this.caseprefix = caseprefix;
            this.changedFields = changedFields.add("caseprefix");
            return this;
        }

        public Builder longdateformatcode(Integer longdateformatcode) {
            this.longdateformatcode = longdateformatcode;
            this.changedFields = changedFields.add("longdateformatcode");
            return this;
        }

        public Builder usepositionhierarchy(Boolean usepositionhierarchy) {
            this.usepositionhierarchy = usepositionhierarchy;
            this.changedFields = changedFields.add("usepositionhierarchy");
            return this;
        }

        public Builder trackingtokenidbase(Integer trackingtokenidbase) {
            this.trackingtokenidbase = trackingtokenidbase;
            this.changedFields = changedFields.add("trackingtokenidbase");
            return this;
        }

        public Builder allowentityonlyaudit(Boolean allowentityonlyaudit) {
            this.allowentityonlyaudit = allowentityonlyaudit;
            this.changedFields = changedFields.add("allowentityonlyaudit");
            return this;
        }

        public Builder globalappendurlparametersenabled(Boolean globalappendurlparametersenabled) {
            this.globalappendurlparametersenabled = globalappendurlparametersenabled;
            this.changedFields = changedFields.add("globalappendurlparametersenabled");
            return this;
        }

        public Builder generatealertsforwarnings(Boolean generatealertsforwarnings) {
            this.generatealertsforwarnings = generatealertsforwarnings;
            this.changedFields = changedFields.add("generatealertsforwarnings");
            return this;
        }

        public Builder maximumentitieswithactivesla(Integer maximumentitieswithactivesla) {
            this.maximumentitieswithactivesla = maximumentitieswithactivesla;
            this.changedFields = changedFields.add("maximumentitieswithactivesla");
            return this;
        }

        public Builder privreportinggroupid(String privreportinggroupid) {
            this.privreportinggroupid = privreportinggroupid;
            this.changedFields = changedFields.add("privreportinggroupid");
            return this;
        }

        public Builder invoiceprefix(String invoiceprefix) {
            this.invoiceprefix = invoiceprefix;
            this.changedFields = changedFields.add("invoiceprefix");
            return this;
        }

        public Builder quoteprefix(String quoteprefix) {
            this.quoteprefix = quoteprefix;
            this.changedFields = changedFields.add("quoteprefix");
            return this;
        }

        public Builder mailboxintermittentissueminrange(Integer mailboxintermittentissueminrange) {
            this.mailboxintermittentissueminrange = mailboxintermittentissueminrange;
            this.changedFields = changedFields.add("mailboxintermittentissueminrange");
            return this;
        }

        public Builder isassignedtaskssyncenabled(Boolean isassignedtaskssyncenabled) {
            this.isassignedtaskssyncenabled = isassignedtaskssyncenabled;
            this.changedFields = changedFields.add("isassignedtaskssyncenabled");
            return this;
        }

        public Builder issopintegrationenabled(Boolean issopintegrationenabled) {
            this.issopintegrationenabled = issopintegrationenabled;
            this.changedFields = changedFields.add("issopintegrationenabled");
            return this;
        }

        public Builder ismobileclientondemandsyncenabled(Boolean ismobileclientondemandsyncenabled) {
            this.ismobileclientondemandsyncenabled = ismobileclientondemandsyncenabled;
            this.changedFields = changedFields.add("ismobileclientondemandsyncenabled");
            return this;
        }

        public Builder isgeospatialazuremapsintegrationenabled(Boolean isgeospatialazuremapsintegrationenabled) {
            this.isgeospatialazuremapsintegrationenabled = isgeospatialazuremapsintegrationenabled;
            this.changedFields = changedFields.add("isgeospatialazuremapsintegrationenabled");
            return this;
        }

        public Builder servestaticresourcesfromazurecdn(Boolean servestaticresourcesfromazurecdn) {
            this.servestaticresourcesfromazurecdn = servestaticresourcesfromazurecdn;
            this.changedFields = changedFields.add("servestaticresourcesfromazurecdn");
            return this;
        }

        public Builder isautodatacaptureenabled(Boolean isautodatacaptureenabled) {
            this.isautodatacaptureenabled = isautodatacaptureenabled;
            this.changedFields = changedFields.add("isautodatacaptureenabled");
            return this;
        }

        public Builder isemailserverprofilecontentfilteringenabled(Boolean isemailserverprofilecontentfilteringenabled) {
            this.isemailserverprofilecontentfilteringenabled = isemailserverprofilecontentfilteringenabled;
            this.changedFields = changedFields.add("isemailserverprofilecontentfilteringenabled");
            return this;
        }

        public Builder isluisenabledford365bot(Boolean isluisenabledford365bot) {
            this.isluisenabledford365bot = isluisenabledford365bot;
            this.changedFields = changedFields.add("isluisenabledford365bot");
            return this;
        }

        public Builder blockedattachments(String blockedattachments) {
            this.blockedattachments = blockedattachments;
            this.changedFields = changedFields.add("blockedattachments");
            return this;
        }

        public Builder isconflictdetectionenabledformobileclient(Boolean isconflictdetectionenabledformobileclient) {
            this.isconflictdetectionenabledformobileclient = isconflictdetectionenabledformobileclient;
            this.changedFields = changedFields.add("isconflictdetectionenabledformobileclient");
            return this;
        }

        public Builder businesscardoptions(String businesscardoptions) {
            this.businesscardoptions = businesscardoptions;
            this.changedFields = changedFields.add("businesscardoptions");
            return this;
        }

        public Builder goalrollupfrequency(Integer goalrollupfrequency) {
            this.goalrollupfrequency = goalrollupfrequency;
            this.changedFields = changedFields.add("goalrollupfrequency");
            return this;
        }

        public Builder parsedtableprefix(String parsedtableprefix) {
            this.parsedtableprefix = parsedtableprefix;
            this.changedFields = changedFields.add("parsedtableprefix");
            return this;
        }

        public Builder isreadauditenabled(Boolean isreadauditenabled) {
            this.isreadauditenabled = isreadauditenabled;
            this.changedFields = changedFields.add("isreadauditenabled");
            return this;
        }

        public Builder requireapprovalforuseremail(Boolean requireapprovalforuseremail) {
            this.requireapprovalforuseremail = requireapprovalforuseremail;
            this.changedFields = changedFields.add("requireapprovalforuseremail");
            return this;
        }

        public Builder emailsendpollingperiod(Integer emailsendpollingperiod) {
            this.emailsendpollingperiod = emailsendpollingperiod;
            this.changedFields = changedFields.add("emailsendpollingperiod");
            return this;
        }

        public Builder useinbuiltrulefordefaultpricelistselection(Boolean useinbuiltrulefordefaultpricelistselection) {
            this.useinbuiltrulefordefaultpricelistselection = useinbuiltrulefordefaultpricelistselection;
            this.changedFields = changedFields.add("useinbuiltrulefordefaultpricelistselection");
            return this;
        }

        public Builder isrichtextnotesenabled(Boolean isrichtextnotesenabled) {
            this.isrichtextnotesenabled = isrichtextnotesenabled;
            this.changedFields = changedFields.add("isrichtextnotesenabled");
            return this;
        }

        public Builder hashdeltasubjectcount(Integer hashdeltasubjectcount) {
            this.hashdeltasubjectcount = hashdeltasubjectcount;
            this.changedFields = changedFields.add("hashdeltasubjectcount");
            return this;
        }

        public Builder recurrenceexpansionjobbatchinterval(Integer recurrenceexpansionjobbatchinterval) {
            this.recurrenceexpansionjobbatchinterval = recurrenceexpansionjobbatchinterval;
            this.changedFields = changedFields.add("recurrenceexpansionjobbatchinterval");
            return this;
        }

        public Builder fiscalperiodformat(String fiscalperiodformat) {
            this.fiscalperiodformat = fiscalperiodformat;
            this.changedFields = changedFields.add("fiscalperiodformat");
            return this;
        }

        public Builder officegraphdelveurl(String officegraphdelveurl) {
            this.officegraphdelveurl = officegraphdelveurl;
            this.changedFields = changedFields.add("officegraphdelveurl");
            return this;
        }

        public Builder maxrecordsforlookupfilters(Integer maxrecordsforlookupfilters) {
            this.maxrecordsforlookupfilters = maxrecordsforlookupfilters;
            this.changedFields = changedFields.add("maxrecordsforlookupfilters");
            return this;
        }

        public Builder sharepointdeploymenttype(Integer sharepointdeploymenttype) {
            this.sharepointdeploymenttype = sharepointdeploymenttype;
            this.changedFields = changedFields.add("sharepointdeploymenttype");
            return this;
        }

        public Builder isrelationshipinsightsenabled(Boolean isrelationshipinsightsenabled) {
            this.isrelationshipinsightsenabled = isrelationshipinsightsenabled;
            this.changedFields = changedFields.add("isrelationshipinsightsenabled");
            return this;
        }

        public Builder requireapprovalforqueueemail(Boolean requireapprovalforqueueemail) {
            this.requireapprovalforqueueemail = requireapprovalforqueueemail;
            this.changedFields = changedFields.add("requireapprovalforqueueemail");
            return this;
        }

        public Builder tokenexpiry(Integer tokenexpiry) {
            this.tokenexpiry = tokenexpiry;
            this.changedFields = changedFields.add("tokenexpiry");
            return this;
        }

        public Builder postmessagewhitelistdomains(String postmessagewhitelistdomains) {
            this.postmessagewhitelistdomains = postmessagewhitelistdomains;
            this.changedFields = changedFields.add("postmessagewhitelistdomains");
            return this;
        }

        public Builder localeid(Integer localeid) {
            this.localeid = localeid;
            this.changedFields = changedFields.add("localeid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder isduplicatedetectionenabledforonlinecreateupdate(Boolean isduplicatedetectionenabledforonlinecreateupdate) {
            this.isduplicatedetectionenabledforonlinecreateupdate = isduplicatedetectionenabledforonlinecreateupdate;
            this.changedFields = changedFields.add("isduplicatedetectionenabledforonlinecreateupdate");
            return this;
        }

        public Builder contentsecuritypolicyconfiguration(String contentsecuritypolicyconfiguration) {
            this.contentsecuritypolicyconfiguration = contentsecuritypolicyconfiguration;
            this.changedFields = changedFields.add("contentsecuritypolicyconfiguration");
            return this;
        }

        public Builder inactivitytimeoutenabled(Boolean inactivitytimeoutenabled) {
            this.inactivitytimeoutenabled = inactivitytimeoutenabled;
            this.changedFields = changedFields.add("inactivitytimeoutenabled");
            return this;
        }

        public Builder displaynavigationtour(Boolean displaynavigationtour) {
            this.displaynavigationtour = displaynavigationtour;
            this.changedFields = changedFields.add("displaynavigationtour");
            return this;
        }

        public Builder isautosaveenabled(Boolean isautosaveenabled) {
            this.isautosaveenabled = isautosaveenabled;
            this.changedFields = changedFields.add("isautosaveenabled");
            return this;
        }

        public Builder supportuserid(String supportuserid) {
            this.supportuserid = supportuserid;
            this.changedFields = changedFields.add("supportuserid");
            return this;
        }

        public Builder currencydisplayoption(Integer currencydisplayoption) {
            this.currencydisplayoption = currencydisplayoption;
            this.changedFields = changedFields.add("currencydisplayoption");
            return this;
        }

        public Builder tokenkey(String tokenkey) {
            this.tokenkey = tokenkey;
            this.changedFields = changedFields.add("tokenkey");
            return this;
        }

        public Builder pinpointlanguagecode(Integer pinpointlanguagecode) {
            this.pinpointlanguagecode = pinpointlanguagecode;
            this.changedFields = changedFields.add("pinpointlanguagecode");
            return this;
        }

        public Builder isappointmentattachmentsyncenabled(Boolean isappointmentattachmentsyncenabled) {
            this.isappointmentattachmentsyncenabled = isappointmentattachmentsyncenabled;
            this.changedFields = changedFields.add("isappointmentattachmentsyncenabled");
            return this;
        }

        public Builder isenabledforallroles(Boolean isenabledforallroles) {
            this.isenabledforallroles = isenabledforallroles;
            this.changedFields = changedFields.add("isenabledforallroles");
            return this;
        }

        public Builder enablelpauthoring(Boolean enablelpauthoring) {
            this.enablelpauthoring = enablelpauthoring;
            this.changedFields = changedFields.add("enablelpauthoring");
            return this;
        }

        public Builder mobileofflineminlicensetrial(Integer mobileofflineminlicensetrial) {
            this.mobileofflineminlicensetrial = mobileofflineminlicensetrial;
            this.changedFields = changedFields.add("mobileofflineminlicensetrial");
            return this;
        }

        public Builder auditretentionperiod(Integer auditretentionperiod) {
            this.auditretentionperiod = auditretentionperiod;
            this.changedFields = changedFields.add("auditretentionperiod");
            return this;
        }

        public Builder officeappsautodeploymentenabled(Boolean officeappsautodeploymentenabled) {
            this.officeappsautodeploymentenabled = officeappsautodeploymentenabled;
            this.changedFields = changedFields.add("officeappsautodeploymentenabled");
            return this;
        }

        public Builder hashfilterkeywords(String hashfilterkeywords) {
            this.hashfilterkeywords = hashfilterkeywords;
            this.changedFields = changedFields.add("hashfilterkeywords");
            return this;
        }

        public Builder isnotesanalysisenabled(Boolean isnotesanalysisenabled) {
            this.isnotesanalysisenabled = isnotesanalysisenabled;
            this.changedFields = changedFields.add("isnotesanalysisenabled");
            return this;
        }

        public Builder iscontactmailingaddresssyncenabled(Boolean iscontactmailingaddresssyncenabled) {
            this.iscontactmailingaddresssyncenabled = iscontactmailingaddresssyncenabled;
            this.changedFields = changedFields.add("iscontactmailingaddresssyncenabled");
            return this;
        }

        public Builder ismailboxforcedunlockingenabled(Boolean ismailboxforcedunlockingenabled) {
            this.ismailboxforcedunlockingenabled = ismailboxforcedunlockingenabled;
            this.changedFields = changedFields.add("ismailboxforcedunlockingenabled");
            return this;
        }

        public Builder isexternalfilestorageenabled(Boolean isexternalfilestorageenabled) {
            this.isexternalfilestorageenabled = isexternalfilestorageenabled;
            this.changedFields = changedFields.add("isexternalfilestorageenabled");
            return this;
        }

        public Builder mobileofflinesyncinterval(Integer mobileofflinesyncinterval) {
            this.mobileofflinesyncinterval = mobileofflinesyncinterval;
            this.changedFields = changedFields.add("mobileofflinesyncinterval");
            return this;
        }

        public Builder tagmaxaggressivecycles(Integer tagmaxaggressivecycles) {
            this.tagmaxaggressivecycles = tagmaxaggressivecycles;
            this.changedFields = changedFields.add("tagmaxaggressivecycles");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder grantaccesstonetworkservice(Boolean grantaccesstonetworkservice) {
            this.grantaccesstonetworkservice = grantaccesstonetworkservice;
            this.changedFields = changedFields.add("grantaccesstonetworkservice");
            return this;
        }

        public Builder iscontentsecuritypolicyenabled(Boolean iscontentsecuritypolicyenabled) {
            this.iscontentsecuritypolicyenabled = iscontentsecuritypolicyenabled;
            this.changedFields = changedFields.add("iscontentsecuritypolicyenabled");
            return this;
        }

        public Builder isdelveactionhubintegrationenabled(Boolean isdelveactionhubintegrationenabled) {
            this.isdelveactionhubintegrationenabled = isdelveactionhubintegrationenabled;
            this.changedFields = changedFields.add("isdelveactionhubintegrationenabled");
            return this;
        }

        public Builder allowoutlookscheduledsyncs(Boolean allowoutlookscheduledsyncs) {
            this.allowoutlookscheduledsyncs = allowoutlookscheduledsyncs;
            this.changedFields = changedFields.add("allowoutlookscheduledsyncs");
            return this;
        }

        public Builder maximumdynamicpropertiesallowed(Integer maximumdynamicpropertiesallowed) {
            this.maximumdynamicpropertiesallowed = maximumdynamicpropertiesallowed;
            this.changedFields = changedFields.add("maximumdynamicpropertiesallowed");
            return this;
        }

        public Builder numbergroupformat(String numbergroupformat) {
            this.numbergroupformat = numbergroupformat;
            this.changedFields = changedFields.add("numbergroupformat");
            return this;
        }

        public Builder entityimageid(String entityimageid) {
            this.entityimageid = entityimageid;
            this.changedFields = changedFields.add("entityimageid");
            return this;
        }

        public Builder trackingtokeniddigits(Integer trackingtokeniddigits) {
            this.trackingtokeniddigits = trackingtokeniddigits;
            this.changedFields = changedFields.add("trackingtokeniddigits");
            return this;
        }

        public Builder defaultrecurrenceendrangetype(Integer defaultrecurrenceendrangetype) {
            this.defaultrecurrenceendrangetype = defaultrecurrenceendrangetype;
            this.changedFields = changedFields.add("defaultrecurrenceendrangetype");
            return this;
        }

        public Builder yammernetworkpermalink(String yammernetworkpermalink) {
            this.yammernetworkpermalink = yammernetworkpermalink;
            this.changedFields = changedFields.add("yammernetworkpermalink");
            return this;
        }

        public Builder bulkoperationprefix(String bulkoperationprefix) {
            this.bulkoperationprefix = bulkoperationprefix;
            this.changedFields = changedFields.add("bulkoperationprefix");
            return this;
        }

        public Builder oobpricecalculationenabled(Boolean oobpricecalculationenabled) {
            this.oobpricecalculationenabled = oobpricecalculationenabled;
            this.changedFields = changedFields.add("oobpricecalculationenabled");
            return this;
        }

        public Builder futureexpansionwindow(Integer futureexpansionwindow) {
            this.futureexpansionwindow = futureexpansionwindow;
            this.changedFields = changedFields.add("futureexpansionwindow");
            return this;
        }

        public Builder ispresenceenabled(Boolean ispresenceenabled) {
            this.ispresenceenabled = ispresenceenabled;
            this.changedFields = changedFields.add("ispresenceenabled");
            return this;
        }

        public Builder pastexpansionwindow(Integer pastexpansionwindow) {
            this.pastexpansionwindow = pastexpansionwindow;
            this.changedFields = changedFields.add("pastexpansionwindow");
            return this;
        }

        public Builder maximumslakpiperentitywithactivesla(Integer maximumslakpiperentitywithactivesla) {
            this.maximumslakpiperentitywithactivesla = maximumslakpiperentitywithactivesla;
            this.changedFields = changedFields.add("maximumslakpiperentitywithactivesla");
            return this;
        }

        public Builder ismsteamssettingchangedbyuser(Boolean ismsteamssettingchangedbyuser) {
            this.ismsteamssettingchangedbyuser = ismsteamssettingchangedbyuser;
            this.changedFields = changedFields.add("ismsteamssettingchangedbyuser");
            return this;
        }

        public Builder picture(String picture) {
            this.picture = picture;
            this.changedFields = changedFields.add("picture");
            return this;
        }

        public Builder azureschedulerjobcollectionname(String azureschedulerjobcollectionname) {
            this.azureschedulerjobcollectionname = azureschedulerjobcollectionname;
            this.changedFields = changedFields.add("azureschedulerjobcollectionname");
            return this;
        }

        public Builder isofficegraphenabled(Boolean isofficegraphenabled) {
            this.isofficegraphenabled = isofficegraphenabled;
            this.changedFields = changedFields.add("isofficegraphenabled");
            return this;
        }

        public Builder orgdborgsettings(String orgdborgsettings) {
            this.orgdborgsettings = orgdborgsettings;
            this.changedFields = changedFields.add("orgdborgsettings");
            return this;
        }

        public Builder ismodeldrivenappsinmsteamsenabled(Boolean ismodeldrivenappsinmsteamsenabled) {
            this.ismodeldrivenappsinmsteamsenabled = ismodeldrivenappsinmsteamsenabled;
            this.changedFields = changedFields.add("ismodeldrivenappsinmsteamsenabled");
            return this;
        }

        public Builder rierrorstatus(Integer rierrorstatus) {
            this.rierrorstatus = rierrorstatus;
            this.changedFields = changedFields.add("rierrorstatus");
            return this;
        }

        public Builder allowlegacydialogsembedding(Boolean allowlegacydialogsembedding) {
            this.allowlegacydialogsembedding = allowlegacydialogsembedding;
            this.changedFields = changedFields.add("allowlegacydialogsembedding");
            return this;
        }

        public Builder emailcorrelationenabled(Boolean emailcorrelationenabled) {
            this.emailcorrelationenabled = emailcorrelationenabled;
            this.changedFields = changedFields.add("emailcorrelationenabled");
            return this;
        }

        public Builder maxappointmentdurationdays(Integer maxappointmentdurationdays) {
            this.maxappointmentdurationdays = maxappointmentdurationdays;
            this.changedFields = changedFields.add("maxappointmentdurationdays");
            return this;
        }

        public Builder microsoftflowenvironment(String microsoftflowenvironment) {
            this.microsoftflowenvironment = microsoftflowenvironment;
            this.changedFields = changedFields.add("microsoftflowenvironment");
            return this;
        }

        public Builder tracelogmaximumageindays(Integer tracelogmaximumageindays) {
            this.tracelogmaximumageindays = tracelogmaximumageindays;
            this.changedFields = changedFields.add("tracelogmaximumageindays");
            return this;
        }

        public Builder isduplicatedetectionenabledforimport(Boolean isduplicatedetectionenabledforimport) {
            this.isduplicatedetectionenabledforimport = isduplicatedetectionenabledforimport;
            this.changedFields = changedFields.add("isduplicatedetectionenabledforimport");
            return this;
        }

        public Builder iscustomcontrolsincanvasappsenabled(Boolean iscustomcontrolsincanvasappsenabled) {
            this.iscustomcontrolsincanvasappsenabled = iscustomcontrolsincanvasappsenabled;
            this.changedFields = changedFields.add("iscustomcontrolsincanvasappsenabled");
            return this;
        }

        public Builder enforcereadonlyplugins(Boolean enforcereadonlyplugins) {
            this.enforcereadonlyplugins = enforcereadonlyplugins;
            this.changedFields = changedFields.add("enforcereadonlyplugins");
            return this;
        }

        public Builder createproductswithoutparentinactivestate(Boolean createproductswithoutparentinactivestate) {
            this.createproductswithoutparentinactivestate = createproductswithoutparentinactivestate;
            this.changedFields = changedFields.add("createproductswithoutparentinactivestate");
            return this;
        }

        public Builder enableunifiedinterfaceshellrefresh(Boolean enableunifiedinterfaceshellrefresh) {
            this.enableunifiedinterfaceshellrefresh = enableunifiedinterfaceshellrefresh;
            this.changedFields = changedFields.add("enableunifiedinterfaceshellrefresh");
            return this;
        }

        public Builder textanalyticsenabled(Boolean textanalyticsenabled) {
            this.textanalyticsenabled = textanalyticsenabled;
            this.changedFields = changedFields.add("textanalyticsenabled");
            return this;
        }

        public Builder expirechangetrackingindays(Integer expirechangetrackingindays) {
            this.expirechangetrackingindays = expirechangetrackingindays;
            this.changedFields = changedFields.add("expirechangetrackingindays");
            return this;
        }

        public Builder usereadform(Boolean usereadform) {
            this.usereadform = usereadform;
            this.changedFields = changedFields.add("usereadform");
            return this;
        }

        public Builder basecurrencysymbol(String basecurrencysymbol) {
            this.basecurrencysymbol = basecurrencysymbol;
            this.changedFields = changedFields.add("basecurrencysymbol");
            return this;
        }

        public Builder fiscalyearperiodconnect(String fiscalyearperiodconnect) {
            this.fiscalyearperiodconnect = fiscalyearperiodconnect;
            this.changedFields = changedFields.add("fiscalyearperiodconnect");
            return this;
        }

        public Builder maxsupportedinternetexplorerversion(Integer maxsupportedinternetexplorerversion) {
            this.maxsupportedinternetexplorerversion = maxsupportedinternetexplorerversion;
            this.changedFields = changedFields.add("maxsupportedinternetexplorerversion");
            return this;
        }

        public Builder fiscalperiodformatperiod(Integer fiscalperiodformatperiod) {
            this.fiscalperiodformatperiod = fiscalperiodformatperiod;
            this.changedFields = changedFields.add("fiscalperiodformatperiod");
            return this;
        }

        public Builder bingmapsapikey(String bingmapsapikey) {
            this.bingmapsapikey = bingmapsapikey;
            this.changedFields = changedFields.add("bingmapsapikey");
            return this;
        }

        public Builder isactionsupportfeatureenabled(Boolean isactionsupportfeatureenabled) {
            this.isactionsupportfeatureenabled = isactionsupportfeatureenabled;
            this.changedFields = changedFields.add("isactionsupportfeatureenabled");
            return this;
        }

        public Builder restrictstatusupdate(Boolean restrictstatusupdate) {
            this.restrictstatusupdate = restrictstatusupdate;
            this.changedFields = changedFields.add("restrictstatusupdate");
            return this;
        }

        public Builder defaultthemedata(String defaultthemedata) {
            this.defaultthemedata = defaultthemedata;
            this.changedFields = changedFields.add("defaultthemedata");
            return this;
        }

        public Builder isonedriveenabled(Boolean isonedriveenabled) {
            this.isonedriveenabled = isonedriveenabled;
            this.changedFields = changedFields.add("isonedriveenabled");
            return this;
        }

        public Builder externalpartycorrelationkeys(String externalpartycorrelationkeys) {
            this.externalpartycorrelationkeys = externalpartycorrelationkeys;
            this.changedFields = changedFields.add("externalpartycorrelationkeys");
            return this;
        }

        public Builder auditretentionperiodv2(Integer auditretentionperiodv2) {
            this.auditretentionperiodv2 = auditretentionperiodv2;
            this.changedFields = changedFields.add("auditretentionperiodv2");
            return this;
        }

        public Builder negativeformatcode(Integer negativeformatcode) {
            this.negativeformatcode = negativeformatcode;
            this.changedFields = changedFields.add("negativeformatcode");
            return this;
        }

        public Builder ispricelistmandatory(Boolean ispricelistmandatory) {
            this.ispricelistmandatory = ispricelistmandatory;
            this.changedFields = changedFields.add("ispricelistmandatory");
            return this;
        }

        public Builder timeseparator(String timeseparator) {
            this.timeseparator = timeseparator;
            this.changedFields = changedFields.add("timeseparator");
            return this;
        }

        public Builder maxproductsinbundle(Integer maxproductsinbundle) {
            this.maxproductsinbundle = maxproductsinbundle;
            this.changedFields = changedFields.add("maxproductsinbundle");
            return this;
        }

        public Builder slapausestates(String slapausestates) {
            this.slapausestates = slapausestates;
            this.changedFields = changedFields.add("slapausestates");
            return this;
        }

        public Builder v3calloutconfighash(String v3calloutconfighash) {
            this.v3calloutconfighash = v3calloutconfighash;
            this.changedFields = changedFields.add("v3calloutconfighash");
            return this;
        }

        public Builder plugintracelogsetting(Integer plugintracelogsetting) {
            this.plugintracelogsetting = plugintracelogsetting;
            this.changedFields = changedFields.add("plugintracelogsetting");
            return this;
        }

        public Builder syncoptinselectionstatus(Integer syncoptinselectionstatus) {
            this.syncoptinselectionstatus = syncoptinselectionstatus;
            this.changedFields = changedFields.add("syncoptinselectionstatus");
            return this;
        }

        public Builder syncbulkoperationmaxlimit(Integer syncbulkoperationmaxlimit) {
            this.syncbulkoperationmaxlimit = syncbulkoperationmaxlimit;
            this.changedFields = changedFields.add("syncbulkoperationmaxlimit");
            return this;
        }

        public Builder allowofflinescheduledsyncs(Boolean allowofflinescheduledsyncs) {
            this.allowofflinescheduledsyncs = allowofflinescheduledsyncs;
            this.changedFields = changedFields.add("allowofflinescheduledsyncs");
            return this;
        }

        public Builder basecurrencyprecision(Integer basecurrencyprecision) {
            this.basecurrencyprecision = basecurrencyprecision;
            this.changedFields = changedFields.add("basecurrencyprecision");
            return this;
        }

        public Builder socialinsightsinstance(String socialinsightsinstance) {
            this.socialinsightsinstance = socialinsightsinstance;
            this.changedFields = changedFields.add("socialinsightsinstance");
            return this;
        }

        public Builder ishierarchicalsecuritymodelenabled(Boolean ishierarchicalsecuritymodelenabled) {
            this.ishierarchicalsecuritymodelenabled = ishierarchicalsecuritymodelenabled;
            this.changedFields = changedFields.add("ishierarchicalsecuritymodelenabled");
            return this;
        }

        public Builder privacystatementurl(String privacystatementurl) {
            this.privacystatementurl = privacystatementurl;
            this.changedFields = changedFields.add("privacystatementurl");
            return this;
        }

        public Builder minoutlooksyncinterval(Integer minoutlooksyncinterval) {
            this.minoutlooksyncinterval = minoutlooksyncinterval;
            this.changedFields = changedFields.add("minoutlooksyncinterval");
            return this;
        }

        public Builder currentimportsequencenumber(Integer currentimportsequencenumber) {
            this.currentimportsequencenumber = currentimportsequencenumber;
            this.changedFields = changedFields.add("currentimportsequencenumber");
            return this;
        }

        public Builder isuseraccessauditenabled(Boolean isuseraccessauditenabled) {
            this.isuseraccessauditenabled = isuseraccessauditenabled;
            this.changedFields = changedFields.add("isuseraccessauditenabled");
            return this;
        }

        public Builder fiscalyearformatprefix(Integer fiscalyearformatprefix) {
            this.fiscalyearformatprefix = fiscalyearformatprefix;
            this.changedFields = changedFields.add("fiscalyearformatprefix");
            return this;
        }

        public Builder enablebingmapsintegration(Boolean enablebingmapsintegration) {
            this.enablebingmapsintegration = enablebingmapsintegration;
            this.changedFields = changedFields.add("enablebingmapsintegration");
            return this;
        }

        public Builder maxslaitemspersla(Integer maxslaitemspersla) {
            this.maxslaitemspersla = maxslaitemspersla;
            this.changedFields = changedFields.add("maxslaitemspersla");
            return this;
        }

        public Builder syncbulkoperationbatchsize(Integer syncbulkoperationbatchsize) {
            this.syncbulkoperationbatchsize = syncbulkoperationbatchsize;
            this.changedFields = changedFields.add("syncbulkoperationbatchsize");
            return this;
        }

        public Builder tagpollingperiod(Integer tagpollingperiod) {
            this.tagpollingperiod = tagpollingperiod;
            this.changedFields = changedFields.add("tagpollingperiod");
            return this;
        }

        public Builder suppresssla(Boolean suppresssla) {
            this.suppresssla = suppresssla;
            this.changedFields = changedFields.add("suppresssla");
            return this;
        }

        public Builder clientfeatureset(String clientfeatureset) {
            this.clientfeatureset = clientfeatureset;
            this.changedFields = changedFields.add("clientfeatureset");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder isemailmonitoringallowed(Boolean isemailmonitoringallowed) {
            this.isemailmonitoringallowed = isemailmonitoringallowed;
            this.changedFields = changedFields.add("isemailmonitoringallowed");
            return this;
        }

        public Builder maxverboseloggingmailbox(Integer maxverboseloggingmailbox) {
            this.maxverboseloggingmailbox = maxverboseloggingmailbox;
            this.changedFields = changedFields.add("maxverboseloggingmailbox");
            return this;
        }

        public Builder ismanualsalesforecastingenabled(Boolean ismanualsalesforecastingenabled) {
            this.ismanualsalesforecastingenabled = ismanualsalesforecastingenabled;
            this.changedFields = changedFields.add("ismanualsalesforecastingenabled");
            return this;
        }

        public Builder isduplicatedetectionenabled(Boolean isduplicatedetectionenabled) {
            this.isduplicatedetectionenabled = isduplicatedetectionenabled;
            this.changedFields = changedFields.add("isduplicatedetectionenabled");
            return this;
        }

        public Builder schemanameprefix(String schemanameprefix) {
            this.schemanameprefix = schemanameprefix;
            this.changedFields = changedFields.add("schemanameprefix");
            return this;
        }

        public Builder paipreviewscenarioenabled(Boolean paipreviewscenarioenabled) {
            this.paipreviewscenarioenabled = paipreviewscenarioenabled;
            this.changedFields = changedFields.add("paipreviewscenarioenabled");
            return this;
        }

        public Builder autoapplysla(Boolean autoapplysla) {
            this.autoapplysla = autoapplysla;
            this.changedFields = changedFields.add("autoapplysla");
            return this;
        }

        public Builder ismsteamscollaborationenabled(Boolean ismsteamscollaborationenabled) {
            this.ismsteamscollaborationenabled = ismsteamscollaborationenabled;
            this.changedFields = changedFields.add("ismsteamscollaborationenabled");
            return this;
        }

        public Builder incomingemailexchangeemailretrievalbatchsize(Integer incomingemailexchangeemailretrievalbatchsize) {
            this.incomingemailexchangeemailretrievalbatchsize = incomingemailexchangeemailretrievalbatchsize;
            this.changedFields = changedFields.add("incomingemailexchangeemailretrievalbatchsize");
            return this;
        }

        public Builder ismailboxinactivebackoffenabled(Boolean ismailboxinactivebackoffenabled) {
            this.ismailboxinactivebackoffenabled = ismailboxinactivebackoffenabled;
            this.changedFields = changedFields.add("ismailboxinactivebackoffenabled");
            return this;
        }

        public Builder cortanaproactiveexperienceenabled(Boolean cortanaproactiveexperienceenabled) {
            this.cortanaproactiveexperienceenabled = cortanaproactiveexperienceenabled;
            this.changedFields = changedFields.add("cortanaproactiveexperienceenabled");
            return this;
        }

        public Builder goalrollupexpirytime(Integer goalrollupexpirytime) {
            this.goalrollupexpirytime = goalrollupexpirytime;
            this.changedFields = changedFields.add("goalrollupexpirytime");
            return this;
        }

        public Builder isplaybookenabled(Boolean isplaybookenabled) {
            this.isplaybookenabled = isplaybookenabled;
            this.changedFields = changedFields.add("isplaybookenabled");
            return this;
        }

        public Builder showkbarticledeprecationnotification(Boolean showkbarticledeprecationnotification) {
            this.showkbarticledeprecationnotification = showkbarticledeprecationnotification;
            this.changedFields = changedFields.add("showkbarticledeprecationnotification");
            return this;
        }

        public Builder isappmode(Boolean isappmode) {
            this.isappmode = isappmode;
            this.changedFields = changedFields.add("isappmode");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder contractprefix(String contractprefix) {
            this.contractprefix = contractprefix;
            this.changedFields = changedFields.add("contractprefix");
            return this;
        }

        public Builder allowautounsubscribe(Boolean allowautounsubscribe) {
            this.allowautounsubscribe = allowautounsubscribe;
            this.changedFields = changedFields.add("allowautounsubscribe");
            return this;
        }

        public Builder ignoreinternalemail(Boolean ignoreinternalemail) {
            this.ignoreinternalemail = ignoreinternalemail;
            this.changedFields = changedFields.add("ignoreinternalemail");
            return this;
        }

        public Builder ispreviewforautocaptureenabled(Boolean ispreviewforautocaptureenabled) {
            this.ispreviewforautocaptureenabled = ispreviewforautocaptureenabled;
            this.changedFields = changedFields.add("ispreviewforautocaptureenabled");
            return this;
        }

        public Builder minofflinesyncinterval(Integer minofflinesyncinterval) {
            this.minofflinesyncinterval = minofflinesyncinterval;
            this.changedFields = changedFields.add("minofflinesyncinterval");
            return this;
        }

        public Builder highcontrastthemedata(String highcontrastthemedata) {
            this.highcontrastthemedata = highcontrastthemedata;
            this.changedFields = changedFields.add("highcontrastthemedata");
            return this;
        }

        public Builder systemuserid(String systemuserid) {
            this.systemuserid = systemuserid;
            this.changedFields = changedFields.add("systemuserid");
            return this;
        }

        public Builder orginsightsenabled(Boolean orginsightsenabled) {
            this.orginsightsenabled = orginsightsenabled;
            this.changedFields = changedFields.add("orginsightsenabled");
            return this;
        }

        public Builder maxactionstepsinbpf(Integer maxactionstepsinbpf) {
            this.maxactionstepsinbpf = maxactionstepsinbpf;
            this.changedFields = changedFields.add("maxactionstepsinbpf");
            return this;
        }

        public Builder socialinsightstermsaccepted(Boolean socialinsightstermsaccepted) {
            this.socialinsightstermsaccepted = socialinsightstermsaccepted;
            this.changedFields = changedFields.add("socialinsightstermsaccepted");
            return this;
        }

        public Builder defaultemailsettings(String defaultemailsettings) {
            this.defaultemailsettings = defaultemailsettings;
            this.changedFields = changedFields.add("defaultemailsettings");
            return this;
        }

        public Builder generatealertsforerrors(Boolean generatealertsforerrors) {
            this.generatealertsforerrors = generatealertsforerrors;
            this.changedFields = changedFields.add("generatealertsforerrors");
            return this;
        }

        public Builder getstartedpanecontentenabled(Boolean getstartedpanecontentenabled) {
            this.getstartedpanecontentenabled = getstartedpanecontentenabled;
            this.changedFields = changedFields.add("getstartedpanecontentenabled");
            return this;
        }

        public Builder sqlaccessgroupname(String sqlaccessgroupname) {
            this.sqlaccessgroupname = sqlaccessgroupname;
            this.changedFields = changedFields.add("sqlaccessgroupname");
            return this;
        }

        public Builder autoapplydefaultoncaseupdate(Boolean autoapplydefaultoncaseupdate) {
            this.autoapplydefaultoncaseupdate = autoapplydefaultoncaseupdate;
            this.changedFields = changedFields.add("autoapplydefaultoncaseupdate");
            return this;
        }

        public Builder negativecurrencyformatcode(Integer negativecurrencyformatcode) {
            this.negativecurrencyformatcode = negativecurrencyformatcode;
            this.changedFields = changedFields.add("negativecurrencyformatcode");
            return this;
        }

        public Builder cascadestatusupdate(Boolean cascadestatusupdate) {
            this.cascadestatusupdate = cascadestatusupdate;
            this.changedFields = changedFields.add("cascadestatusupdate");
            return this;
        }

        public Builder powerbifeatureenabled(Boolean powerbifeatureenabled) {
            this.powerbifeatureenabled = powerbifeatureenabled;
            this.changedFields = changedFields.add("powerbifeatureenabled");
            return this;
        }

        public Builder fullnameconventioncode(Integer fullnameconventioncode) {
            this.fullnameconventioncode = fullnameconventioncode;
            this.changedFields = changedFields.add("fullnameconventioncode");
            return this;
        }

        public Builder allowaddressbooksyncs(Boolean allowaddressbooksyncs) {
            this.allowaddressbooksyncs = allowaddressbooksyncs;
            this.changedFields = changedFields.add("allowaddressbooksyncs");
            return this;
        }

        public Builder notifymailboxownerofemailserverlevelalerts(Boolean notifymailboxownerofemailserverlevelalerts) {
            this.notifymailboxownerofemailserverlevelalerts = notifymailboxownerofemailserverlevelalerts;
            this.changedFields = changedFields.add("notifymailboxownerofemailserverlevelalerts");
            return this;
        }

        public Builder usequickfindviewforgridsearch(Boolean usequickfindviewforgridsearch) {
            this.usequickfindviewforgridsearch = usequickfindviewforgridsearch;
            this.changedFields = changedFields.add("usequickfindviewforgridsearch");
            return this;
        }

        public Builder discountcalculationmethod(Integer discountcalculationmethod) {
            this.discountcalculationmethod = discountcalculationmethod;
            this.changedFields = changedFields.add("discountcalculationmethod");
            return this;
        }

        public Builder organizationid(String organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Builder mailboxpermanentissueminrange(Integer mailboxpermanentissueminrange) {
            this.mailboxpermanentissueminrange = mailboxpermanentissueminrange;
            this.changedFields = changedFields.add("mailboxpermanentissueminrange");
            return this;
        }

        public Builder kmsettings(String kmsettings) {
            this.kmsettings = kmsettings;
            this.changedFields = changedFields.add("kmsettings");
            return this;
        }

        public Builder isfulltextsearchenabled(Boolean isfulltextsearchenabled) {
            this.isfulltextsearchenabled = isfulltextsearchenabled;
            this.changedFields = changedFields.add("isfulltextsearchenabled");
            return this;
        }

        public Builder hashminaddresscount(Integer hashminaddresscount) {
            this.hashminaddresscount = hashminaddresscount;
            this.changedFields = changedFields.add("hashminaddresscount");
            return this;
        }

        public Builder dateseparator(String dateseparator) {
            this.dateseparator = dateseparator;
            this.changedFields = changedFields.add("dateseparator");
            return this;
        }

        public Builder weekstartdaycode(Integer weekstartdaycode) {
            this.weekstartdaycode = weekstartdaycode;
            this.changedFields = changedFields.add("weekstartdaycode");
            return this;
        }

        public Builder allowuserformmodepreference(Boolean allowuserformmodepreference) {
            this.allowuserformmodepreference = allowuserformmodepreference;
            this.changedFields = changedFields.add("allowuserformmodepreference");
            return this;
        }

        public Builder numberseparator(String numberseparator) {
            this.numberseparator = numberseparator;
            this.changedFields = changedFields.add("numberseparator");
            return this;
        }

        public Builder campaignprefix(String campaignprefix) {
            this.campaignprefix = campaignprefix;
            this.changedFields = changedFields.add("campaignprefix");
            return this;
        }

        public Builder productrecommendationsenabled(Boolean productrecommendationsenabled) {
            this.productrecommendationsenabled = productrecommendationsenabled;
            this.changedFields = changedFields.add("productrecommendationsenabled");
            return this;
        }

        public Builder recurrencedefaultnumberofoccurrences(Integer recurrencedefaultnumberofoccurrences) {
            this.recurrencedefaultnumberofoccurrences = recurrencedefaultnumberofoccurrences;
            this.changedFields = changedFields.add("recurrencedefaultnumberofoccurrences");
            return this;
        }

        public Builder ismsteamsusersyncenabled(Boolean ismsteamsusersyncenabled) {
            this.ismsteamsusersyncenabled = ismsteamsusersyncenabled;
            this.changedFields = changedFields.add("ismsteamsusersyncenabled");
            return this;
        }

        public Builder quickfindrecordlimitenabled(Boolean quickfindrecordlimitenabled) {
            this.quickfindrecordlimitenabled = quickfindrecordlimitenabled;
            this.changedFields = changedFields.add("quickfindrecordlimitenabled");
            return this;
        }

        public Builder pricingdecimalprecision(Integer pricingdecimalprecision) {
            this.pricingdecimalprecision = pricingdecimalprecision;
            this.changedFields = changedFields.add("pricingdecimalprecision");
            return this;
        }

        public Builder useskypeprotocol(Boolean useskypeprotocol) {
            this.useskypeprotocol = useskypeprotocol;
            this.changedFields = changedFields.add("useskypeprotocol");
            return this;
        }

        public Builder rendersecureiframeforemail(Boolean rendersecureiframeforemail) {
            this.rendersecureiframeforemail = rendersecureiframeforemail;
            this.changedFields = changedFields.add("rendersecureiframeforemail");
            return this;
        }

        public Builder inactivitytimeoutinmins(Integer inactivitytimeoutinmins) {
            this.inactivitytimeoutinmins = inactivitytimeoutinmins;
            this.changedFields = changedFields.add("inactivitytimeoutinmins");
            return this;
        }

        public Builder sessiontimeoutenabled(Boolean sessiontimeoutenabled) {
            this.sessiontimeoutenabled = sessiontimeoutenabled;
            this.changedFields = changedFields.add("sessiontimeoutenabled");
            return this;
        }

        public Builder minaddressbooksyncinterval(Integer minaddressbooksyncinterval) {
            this.minaddressbooksyncinterval = minaddressbooksyncinterval;
            this.changedFields = changedFields.add("minaddressbooksyncinterval");
            return this;
        }

        public Builder externalbaseurl(String externalbaseurl) {
            this.externalbaseurl = externalbaseurl;
            this.changedFields = changedFields.add("externalbaseurl");
            return this;
        }

        public Builder issalesassistantenabled(Boolean issalesassistantenabled) {
            this.issalesassistantenabled = issalesassistantenabled;
            this.changedFields = changedFields.add("issalesassistantenabled");
            return this;
        }

        public Builder _defaultmobileofflineprofileid_value(String _defaultmobileofflineprofileid_value) {
            this._defaultmobileofflineprofileid_value = _defaultmobileofflineprofileid_value;
            this.changedFields = changedFields.add("_defaultmobileofflineprofileid_value");
            return this;
        }

        public Builder amdesignator(String amdesignator) {
            this.amdesignator = amdesignator;
            this.changedFields = changedFields.add("amdesignator");
            return this;
        }

        public Builder enableimmersiveskypeintegration(Boolean enableimmersiveskypeintegration) {
            this.enableimmersiveskypeintegration = enableimmersiveskypeintegration;
            this.changedFields = changedFields.add("enableimmersiveskypeintegration");
            return this;
        }

        public Builder kbprefix(String kbprefix) {
            this.kbprefix = kbprefix;
            this.changedFields = changedFields.add("kbprefix");
            return this;
        }

        public Builder bounddashboarddefaultcardexpanded(Boolean bounddashboarddefaultcardexpanded) {
            this.bounddashboarddefaultcardexpanded = bounddashboarddefaultcardexpanded;
            this.changedFields = changedFields.add("bounddashboarddefaultcardexpanded");
            return this;
        }

        public Builder hashmaxcount(Integer hashmaxcount) {
            this.hashmaxcount = hashmaxcount;
            this.changedFields = changedFields.add("hashmaxcount");
            return this;
        }

        public Builder reportinggroupname(String reportinggroupname) {
            this.reportinggroupname = reportinggroupname;
            this.changedFields = changedFields.add("reportinggroupname");
            return this;
        }

        public Builder isdelegateaccessenabled(Boolean isdelegateaccessenabled) {
            this.isdelegateaccessenabled = isdelegateaccessenabled;
            this.changedFields = changedFields.add("isdelegateaccessenabled");
            return this;
        }

        public Builder aciwebendpointurl(String aciwebendpointurl) {
            this.aciwebendpointurl = aciwebendpointurl;
            this.changedFields = changedFields.add("aciwebendpointurl");
            return this;
        }

        public Builder maxuploadfilesize(Integer maxuploadfilesize) {
            this.maxuploadfilesize = maxuploadfilesize;
            this.changedFields = changedFields.add("maxuploadfilesize");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder fiscalyeardisplaycode(Integer fiscalyeardisplaycode) {
            this.fiscalyeardisplaycode = fiscalyeardisplaycode;
            this.changedFields = changedFields.add("fiscalyeardisplaycode");
            return this;
        }

        public Builder yammeroauthaccesstokenexpired(Boolean yammeroauthaccesstokenexpired) {
            this.yammeroauthaccesstokenexpired = yammeroauthaccesstokenexpired;
            this.changedFields = changedFields.add("yammeroauthaccesstokenexpired");
            return this;
        }

        public Builder externalpartyentitysettings(String externalpartyentitysettings) {
            this.externalpartyentitysettings = externalpartyentitysettings;
            this.changedFields = changedFields.add("externalpartyentitysettings");
            return this;
        }

        public Builder defaultcountrycode(String defaultcountrycode) {
            this.defaultcountrycode = defaultcountrycode;
            this.changedFields = changedFields.add("defaultcountrycode");
            return this;
        }

        public Builder isactivityanalysisenabled(Boolean isactivityanalysisenabled) {
            this.isactivityanalysisenabled = isactivityanalysisenabled;
            this.changedFields = changedFields.add("isactivityanalysisenabled");
            return this;
        }

        public Builder recurrenceexpansionjobbatchsize(Integer recurrenceexpansionjobbatchsize) {
            this.recurrenceexpansionjobbatchsize = recurrenceexpansionjobbatchsize;
            this.changedFields = changedFields.add("recurrenceexpansionjobbatchsize");
            return this;
        }

        public Builder _basecurrencyid_value(String _basecurrencyid_value) {
            this._basecurrencyid_value = _basecurrencyid_value;
            this.changedFields = changedFields.add("_basecurrencyid_value");
            return this;
        }

        public Builder featureset(String featureset) {
            this.featureset = featureset;
            this.changedFields = changedFields.add("featureset");
            return this;
        }

        public Builder istextwrapenabled(Boolean istextwrapenabled) {
            this.istextwrapenabled = istextwrapenabled;
            this.changedFields = changedFields.add("istextwrapenabled");
            return this;
        }

        public Builder calendartype(Integer calendartype) {
            this.calendartype = calendartype;
            this.changedFields = changedFields.add("calendartype");
            return this;
        }

        public Builder allowclientmessagebarad(Boolean allowclientmessagebarad) {
            this.allowclientmessagebarad = allowclientmessagebarad;
            this.changedFields = changedFields.add("allowclientmessagebarad");
            return this;
        }

        public Builder usergroupid(String usergroupid) {
            this.usergroupid = usergroupid;
            this.changedFields = changedFields.add("usergroupid");
            return this;
        }

        public Builder isdisabled(Boolean isdisabled) {
            this.isdisabled = isdisabled;
            this.changedFields = changedFields.add("isdisabled");
            return this;
        }

        public Builder isduplicatedetectionenabledforofflinesync(Boolean isduplicatedetectionenabledforofflinesync) {
            this.isduplicatedetectionenabledforofflinesync = isduplicatedetectionenabledforofflinesync;
            this.changedFields = changedFields.add("isduplicatedetectionenabledforofflinesync");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder appdesignerexperienceenabled(Boolean appdesignerexperienceenabled) {
            this.appdesignerexperienceenabled = appdesignerexperienceenabled;
            this.changedFields = changedFields.add("appdesignerexperienceenabled");
            return this;
        }

        public Builder categoryprefix(String categoryprefix) {
            this.categoryprefix = categoryprefix;
            this.changedFields = changedFields.add("categoryprefix");
            return this;
        }

        public Builder ispreviewenabledforactioncard(Boolean ispreviewenabledforactioncard) {
            this.ispreviewenabledforactioncard = ispreviewenabledforactioncard;
            this.changedFields = changedFields.add("ispreviewenabledforactioncard");
            return this;
        }

        public Builder ismobileofflineenabled(Boolean ismobileofflineenabled) {
            this.ismobileofflineenabled = ismobileofflineenabled;
            this.changedFields = changedFields.add("ismobileofflineenabled");
            return this;
        }

        public Builder fiscalcalendarstart(OffsetDateTime fiscalcalendarstart) {
            this.fiscalcalendarstart = fiscalcalendarstart;
            this.changedFields = changedFields.add("fiscalcalendarstart");
            return this;
        }

        public Builder isexternalsearchindexenabled(Boolean isexternalsearchindexenabled) {
            this.isexternalsearchindexenabled = isexternalsearchindexenabled;
            this.changedFields = changedFields.add("isexternalsearchindexenabled");
            return this;
        }

        public Builder maximumactivebusinessprocessflowsallowedperentity(Integer maximumactivebusinessprocessflowsallowedperentity) {
            this.maximumactivebusinessprocessflowsallowedperentity = maximumactivebusinessprocessflowsallowedperentity;
            this.changedFields = changedFields.add("maximumactivebusinessprocessflowsallowedperentity");
            return this;
        }

        public Builder enablelivepersonacarduci(Boolean enablelivepersonacarduci) {
            this.enablelivepersonacarduci = enablelivepersonacarduci;
            this.changedFields = changedFields.add("enablelivepersonacarduci");
            return this;
        }

        public Builder timeformatcode(Integer timeformatcode) {
            this.timeformatcode = timeformatcode;
            this.changedFields = changedFields.add("timeformatcode");
            return this;
        }

        public Builder dayssincerecordlastmodifiedmaxvalue(Integer dayssincerecordlastmodifiedmaxvalue) {
            this.dayssincerecordlastmodifiedmaxvalue = dayssincerecordlastmodifiedmaxvalue;
            this.changedFields = changedFields.add("dayssincerecordlastmodifiedmaxvalue");
            return this;
        }

        public Builder _acknowledgementtemplateid_value(String _acknowledgementtemplateid_value) {
            this._acknowledgementtemplateid_value = _acknowledgementtemplateid_value;
            this.changedFields = changedFields.add("_acknowledgementtemplateid_value");
            return this;
        }

        public Builder maxdepthforhierarchicalsecuritymodel(Integer maxdepthforhierarchicalsecuritymodel) {
            this.maxdepthforhierarchicalsecuritymodel = maxdepthforhierarchicalsecuritymodel;
            this.changedFields = changedFields.add("maxdepthforhierarchicalsecuritymodel");
            return this;
        }

        public Builder currencysymbol(String currencysymbol) {
            this.currencysymbol = currencysymbol;
            this.changedFields = changedFields.add("currencysymbol");
            return this;
        }

        public Builder isfolderbasedtrackingenabled(Boolean isfolderbasedtrackingenabled) {
            this.isfolderbasedtrackingenabled = isfolderbasedtrackingenabled;
            this.changedFields = changedFields.add("isfolderbasedtrackingenabled");
            return this;
        }

        public Builder isdefaultcountrycodecheckenabled(Boolean isdefaultcountrycodecheckenabled) {
            this.isdefaultcountrycodecheckenabled = isdefaultcountrycodecheckenabled;
            this.changedFields = changedFields.add("isdefaultcountrycodecheckenabled");
            return this;
        }

        public Builder entityimage(byte[] entityimage) {
            this.entityimage = entityimage;
            this.changedFields = changedFields.add("entityimage");
            return this;
        }

        public Builder fiscalyearformatyear(Integer fiscalyearformatyear) {
            this.fiscalyearformatyear = fiscalyearformatyear;
            this.changedFields = changedFields.add("fiscalyearformatyear");
            return this;
        }

        public Builder entityimage_timestamp(Long entityimage_timestamp) {
            this.entityimage_timestamp = entityimage_timestamp;
            this.changedFields = changedFields.add("entityimage_timestamp");
            return this;
        }

        public Builder privreportinggroupname(String privreportinggroupname) {
            this.privreportinggroupname = privreportinggroupname;
            this.changedFields = changedFields.add("privreportinggroupname");
            return this;
        }

        public Builder yearstartweekcode(Integer yearstartweekcode) {
            this.yearstartweekcode = yearstartweekcode;
            this.changedFields = changedFields.add("yearstartweekcode");
            return this;
        }

        public Builder uselegacyrendering(Boolean uselegacyrendering) {
            this.uselegacyrendering = uselegacyrendering;
            this.changedFields = changedFields.add("uselegacyrendering");
            return this;
        }

        public Builder maximumtrackingnumber(Integer maximumtrackingnumber) {
            this.maximumtrackingnumber = maximumtrackingnumber;
            this.changedFields = changedFields.add("maximumtrackingnumber");
            return this;
        }

        public Builder fiscalyearformatsuffix(Integer fiscalyearformatsuffix) {
            this.fiscalyearformatsuffix = fiscalyearformatsuffix;
            this.changedFields = changedFields.add("fiscalyearformatsuffix");
            return this;
        }

        public Builder allowautoresponsecreation(Boolean allowautoresponsecreation) {
            this.allowautoresponsecreation = allowautoresponsecreation;
            this.changedFields = changedFields.add("allowautoresponsecreation");
            return this;
        }

        public Builder allowlegacyclientexperience(Boolean allowlegacyclientexperience) {
            this.allowlegacyclientexperience = allowlegacyclientexperience;
            this.changedFields = changedFields.add("allowlegacyclientexperience");
            return this;
        }

        public Builder ismsteamsenabled(Boolean ismsteamsenabled) {
            this.ismsteamsenabled = ismsteamsenabled;
            this.changedFields = changedFields.add("ismsteamsenabled");
            return this;
        }

        public Builder enablemicrosoftflowintegration(Boolean enablemicrosoftflowintegration) {
            this.enablemicrosoftflowintegration = enablemicrosoftflowintegration;
            this.changedFields = changedFields.add("enablemicrosoftflowintegration");
            return this;
        }

        public Builder currentparsedtablenumber(Integer currentparsedtablenumber) {
            this.currentparsedtablenumber = currentparsedtablenumber;
            this.changedFields = changedFields.add("currentparsedtablenumber");
            return this;
        }

        public Builder socialinsightsenabled(Boolean socialinsightsenabled) {
            this.socialinsightsenabled = socialinsightsenabled;
            this.changedFields = changedFields.add("socialinsightsenabled");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder initialversion(String initialversion) {
            this.initialversion = initialversion;
            this.changedFields = changedFields.add("initialversion");
            return this;
        }

        public Builder delegatedadminuserid(String delegatedadminuserid) {
            this.delegatedadminuserid = delegatedadminuserid;
            this.changedFields = changedFields.add("delegatedadminuserid");
            return this;
        }

        public Builder isfiscalperiodmonthbased(Boolean isfiscalperiodmonthbased) {
            this.isfiscalperiodmonthbased = isfiscalperiodmonthbased;
            this.changedFields = changedFields.add("isfiscalperiodmonthbased");
            return this;
        }

        public Builder fiscalperiodtype(Integer fiscalperiodtype) {
            this.fiscalperiodtype = fiscalperiodtype;
            this.changedFields = changedFields.add("fiscalperiodtype");
            return this;
        }

        public Builder inactivitytimeoutreminderinmins(Integer inactivitytimeoutreminderinmins) {
            this.inactivitytimeoutreminderinmins = inactivitytimeoutreminderinmins;
            this.changedFields = changedFields.add("inactivitytimeoutreminderinmins");
            return this;
        }

        public Builder disabledreason(String disabledreason) {
            this.disabledreason = disabledreason;
            this.changedFields = changedFields.add("disabledreason");
            return this;
        }

        public Builder uniquespecifierlength(Integer uniquespecifierlength) {
            this.uniquespecifierlength = uniquespecifierlength;
            this.changedFields = changedFields.add("uniquespecifierlength");
            return this;
        }

        public Builder ispdfgenerationenabled(String ispdfgenerationenabled) {
            this.ispdfgenerationenabled = ispdfgenerationenabled;
            this.changedFields = changedFields.add("ispdfgenerationenabled");
            return this;
        }

        public Builder enablelivepersoncardintegrationinoffice(Boolean enablelivepersoncardintegrationinoffice) {
            this.enablelivepersoncardintegrationinoffice = enablelivepersoncardintegrationinoffice;
            this.changedFields = changedFields.add("enablelivepersoncardintegrationinoffice");
            return this;
        }

        public Builder maxrecordsforexporttoexcel(Integer maxrecordsforexporttoexcel) {
            this.maxrecordsforexporttoexcel = maxrecordsforexporttoexcel;
            this.changedFields = changedFields.add("maxrecordsforexporttoexcel");
            return this;
        }

        public Builder useraccessauditinginterval(Integer useraccessauditinginterval) {
            this.useraccessauditinginterval = useraccessauditinginterval;
            this.changedFields = changedFields.add("useraccessauditinginterval");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder kaprefix(String kaprefix) {
            this.kaprefix = kaprefix;
            this.changedFields = changedFields.add("kaprefix");
            return this;
        }

        public Builder allowmarketingemailexecution(Boolean allowmarketingemailexecution) {
            this.allowmarketingemailexecution = allowmarketingemailexecution;
            this.changedFields = changedFields.add("allowmarketingemailexecution");
            return this;
        }

        public Builder sqmenabled(Boolean sqmenabled) {
            this.sqmenabled = sqmenabled;
            this.changedFields = changedFields.add("sqmenabled");
            return this;
        }

        public Builder timeformatstring(String timeformatstring) {
            this.timeformatstring = timeformatstring;
            this.changedFields = changedFields.add("timeformatstring");
            return this;
        }

        public Builder iscontextualemailenabled(Boolean iscontextualemailenabled) {
            this.iscontextualemailenabled = iscontextualemailenabled;
            this.changedFields = changedFields.add("iscontextualemailenabled");
            return this;
        }

        public Builder dateformatcode(Integer dateformatcode) {
            this.dateformatcode = dateformatcode;
            this.changedFields = changedFields.add("dateformatcode");
            return this;
        }

        public Builder webresourcehash(String webresourcehash) {
            this.webresourcehash = webresourcehash;
            this.changedFields = changedFields.add("webresourcehash");
            return this;
        }

        public Builder syncoptinselection(Boolean syncoptinselection) {
            this.syncoptinselection = syncoptinselection;
            this.changedFields = changedFields.add("syncoptinselection");
            return this;
        }

        public Builder sortid(Integer sortid) {
            this.sortid = sortid;
            this.changedFields = changedFields.add("sortid");
            return this;
        }

        public Builder globalhelpurl(String globalhelpurl) {
            this.globalhelpurl = globalhelpurl;
            this.changedFields = changedFields.add("globalhelpurl");
            return this;
        }

        public Builder isallmoneydecimal(Boolean isallmoneydecimal) {
            this.isallmoneydecimal = isallmoneydecimal;
            this.changedFields = changedFields.add("isallmoneydecimal");
            return this;
        }

        public Builder isauditenabled(Boolean isauditenabled) {
            this.isauditenabled = isauditenabled;
            this.changedFields = changedFields.add("isauditenabled");
            return this;
        }

        public Builder fiscalyearformat(String fiscalyearformat) {
            this.fiscalyearformat = fiscalyearformat;
            this.changedFields = changedFields.add("fiscalyearformat");
            return this;
        }

        public Builder sendbulkemailinuci(Boolean sendbulkemailinuci) {
            this.sendbulkemailinuci = sendbulkemailinuci;
            this.changedFields = changedFields.add("sendbulkemailinuci");
            return this;
        }

        public Builder defaultcrmcustomname(String defaultcrmcustomname) {
            this.defaultcrmcustomname = defaultcrmcustomname;
            this.changedFields = changedFields.add("defaultcrmcustomname");
            return this;
        }

        public Builder currencyformatcode(Integer currencyformatcode) {
            this.currencyformatcode = currencyformatcode;
            this.changedFields = changedFields.add("currencyformatcode");
            return this;
        }

        public Builder isbpfentitycustomizationfeatureenabled(Boolean isbpfentitycustomizationfeatureenabled) {
            this.isbpfentitycustomizationfeatureenabled = isbpfentitycustomizationfeatureenabled;
            this.changedFields = changedFields.add("isbpfentitycustomizationfeatureenabled");
            return this;
        }

        public Builder maxconditionsformobileofflinefilters(Integer maxconditionsformobileofflinefilters) {
            this.maxconditionsformobileofflinefilters = maxconditionsformobileofflinefilters;
            this.changedFields = changedFields.add("maxconditionsformobileofflinefilters");
            return this;
        }

        public Builder businessclosurecalendarid(String businessclosurecalendarid) {
            this.businessclosurecalendarid = businessclosurecalendarid;
            this.changedFields = changedFields.add("businessclosurecalendarid");
            return this;
        }

        public Builder showweeknumber(Boolean showweeknumber) {
            this.showweeknumber = showweeknumber;
            this.changedFields = changedFields.add("showweeknumber");
            return this;
        }

        public Builder isactioncardenabled(Boolean isactioncardenabled) {
            this.isactioncardenabled = isactioncardenabled;
            this.changedFields = changedFields.add("isactioncardenabled");
            return this;
        }

        public Builder sessiontimeoutinmins(Integer sessiontimeoutinmins) {
            this.sessiontimeoutinmins = sessiontimeoutinmins;
            this.changedFields = changedFields.add("sessiontimeoutinmins");
            return this;
        }

        public Builder appointmentricheditorexperience(Boolean appointmentricheditorexperience) {
            this.appointmentricheditorexperience = appointmentricheditorexperience;
            this.changedFields = changedFields.add("appointmentricheditorexperience");
            return this;
        }

        public Builder _defaultemailserverprofileid_value(String _defaultemailserverprofileid_value) {
            this._defaultemailserverprofileid_value = _defaultemailserverprofileid_value;
            this.changedFields = changedFields.add("_defaultemailserverprofileid_value");
            return this;
        }

        public Builder integrationuserid(String integrationuserid) {
            this.integrationuserid = integrationuserid;
            this.changedFields = changedFields.add("integrationuserid");
            return this;
        }

        public Builder entityimage_url(String entityimage_url) {
            this.entityimage_url = entityimage_url;
            this.changedFields = changedFields.add("entityimage_url");
            return this;
        }

        public Builder isnewaddproductexperienceenabled(Boolean isnewaddproductexperienceenabled) {
            this.isnewaddproductexperienceenabled = isnewaddproductexperienceenabled;
            this.changedFields = changedFields.add("isnewaddproductexperienceenabled");
            return this;
        }

        public Builder pmdesignator(String pmdesignator) {
            this.pmdesignator = pmdesignator;
            this.changedFields = changedFields.add("pmdesignator");
            return this;
        }

        public Builder sampledataimportid(String sampledataimportid) {
            this.sampledataimportid = sampledataimportid;
            this.changedFields = changedFields.add("sampledataimportid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder currencydecimalprecision(Integer currencydecimalprecision) {
            this.currencydecimalprecision = currencydecimalprecision;
            this.changedFields = changedFields.add("currencydecimalprecision");
            return this;
        }

        public Builder emailconnectionchannel(Integer emailconnectionchannel) {
            this.emailconnectionchannel = emailconnectionchannel;
            this.changedFields = changedFields.add("emailconnectionchannel");
            return this;
        }

        public Builder ispreviewforemailmonitoringallowed(Boolean ispreviewforemailmonitoringallowed) {
            this.ispreviewforemailmonitoringallowed = ispreviewforemailmonitoringallowed;
            this.changedFields = changedFields.add("ispreviewforemailmonitoringallowed");
            return this;
        }

        public Builder allowunresolvedpartiesonemailsend(Boolean allowunresolvedpartiesonemailsend) {
            this.allowunresolvedpartiesonemailsend = allowunresolvedpartiesonemailsend;
            this.changedFields = changedFields.add("allowunresolvedpartiesonemailsend");
            return this;
        }

        public Builder ispaienabled(Boolean ispaienabled) {
            this.ispaienabled = ispaienabled;
            this.changedFields = changedFields.add("ispaienabled");
            return this;
        }

        public Builder isautodatacapturev2enabled(Boolean isautodatacapturev2enabled) {
            this.isautodatacapturev2enabled = isautodatacapturev2enabled;
            this.changedFields = changedFields.add("isautodatacapturev2enabled");
            return this;
        }

        public Builder allowautounsubscribeacknowledgement(Boolean allowautounsubscribeacknowledgement) {
            this.allowautounsubscribeacknowledgement = allowautounsubscribeacknowledgement;
            this.changedFields = changedFields.add("allowautounsubscribeacknowledgement");
            return this;
        }

        public Builder nexttrackingnumber(Integer nexttrackingnumber) {
            this.nexttrackingnumber = nexttrackingnumber;
            this.changedFields = changedFields.add("nexttrackingnumber");
            return this;
        }

        public Builder enablepricingoncreate(Boolean enablepricingoncreate) {
            this.enablepricingoncreate = enablepricingoncreate;
            this.changedFields = changedFields.add("enablepricingoncreate");
            return this;
        }

        public Builder parsedtablecolumnprefix(String parsedtablecolumnprefix) {
            this.parsedtablecolumnprefix = parsedtablecolumnprefix;
            this.changedFields = changedFields.add("parsedtablecolumnprefix");
            return this;
        }

        public Builder allowusersseeappdownloadmessage(Boolean allowusersseeappdownloadmessage) {
            this.allowusersseeappdownloadmessage = allowusersseeappdownloadmessage;
            this.changedFields = changedFields.add("allowusersseeappdownloadmessage");
            return this;
        }

        public Builder decimalsymbol(String decimalsymbol) {
            this.decimalsymbol = decimalsymbol;
            this.changedFields = changedFields.add("decimalsymbol");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder signupoutlookdownloadfwlink(String signupoutlookdownloadfwlink) {
            this.signupoutlookdownloadfwlink = signupoutlookdownloadfwlink;
            this.changedFields = changedFields.add("signupoutlookdownloadfwlink");
            return this;
        }

        public Builder isresourcebookingexchangesyncenabled(Boolean isresourcebookingexchangesyncenabled) {
            this.isresourcebookingexchangesyncenabled = isresourcebookingexchangesyncenabled;
            this.changedFields = changedFields.add("isresourcebookingexchangesyncenabled");
            return this;
        }

        public Builder disablesocialcare(Boolean disablesocialcare) {
            this.disablesocialcare = disablesocialcare;
            this.changedFields = changedFields.add("disablesocialcare");
            return this;
        }

        public Builder resolvesimilarunresolvedemailaddress(Boolean resolvesimilarunresolvedemailaddress) {
            this.resolvesimilarunresolvedemailaddress = resolvesimilarunresolvedemailaddress;
            this.changedFields = changedFields.add("resolvesimilarunresolvedemailaddress");
            return this;
        }

        public Builder unresolveemailaddressifmultiplematch(Boolean unresolveemailaddressifmultiplematch) {
            this.unresolveemailaddressifmultiplematch = unresolveemailaddressifmultiplematch;
            this.changedFields = changedFields.add("unresolveemailaddressifmultiplematch");
            return this;
        }

        public Builder sharetopreviousowneronassign(Boolean sharetopreviousowneronassign) {
            this.sharetopreviousowneronassign = sharetopreviousowneronassign;
            this.changedFields = changedFields.add("sharetopreviousowneronassign");
            return this;
        }

        public Builder iswriteinproductsallowed(Boolean iswriteinproductsallowed) {
            this.iswriteinproductsallowed = iswriteinproductsallowed;
            this.changedFields = changedFields.add("iswriteinproductsallowed");
            return this;
        }

        public Builder reportinggroupid(String reportinggroupid) {
            this.reportinggroupid = reportinggroupid;
            this.changedFields = changedFields.add("reportinggroupid");
            return this;
        }

        public Builder qualifyleadadditionaloptions(String qualifyleadadditionaloptions) {
            this.qualifyleadadditionaloptions = qualifyleadadditionaloptions;
            this.changedFields = changedFields.add("qualifyleadadditionaloptions");
            return this;
        }

        public Builder isfolderautocreatedonsp(Boolean isfolderautocreatedonsp) {
            this.isfolderautocreatedonsp = isfolderautocreatedonsp;
            this.changedFields = changedFields.add("isfolderautocreatedonsp");
            return this;
        }

        public Builder maxfolderbasedtrackingmappings(Integer maxfolderbasedtrackingmappings) {
            this.maxfolderbasedtrackingmappings = maxfolderbasedtrackingmappings;
            this.changedFields = changedFields.add("maxfolderbasedtrackingmappings");
            return this;
        }

        public Builder sqlaccessgroupid(String sqlaccessgroupid) {
            this.sqlaccessgroupid = sqlaccessgroupid;
            this.changedFields = changedFields.add("sqlaccessgroupid");
            return this;
        }

        public Builder trackingprefix(String trackingprefix) {
            this.trackingprefix = trackingprefix;
            this.changedFields = changedFields.add("trackingprefix");
            return this;
        }

        public Builder yammergroupid(Integer yammergroupid) {
            this.yammergroupid = yammergroupid;
            this.changedFields = changedFields.add("yammergroupid");
            return this;
        }

        public Builder dateformatstring(String dateformatstring) {
            this.dateformatstring = dateformatstring;
            this.changedFields = changedFields.add("dateformatstring");
            return this;
        }

        public Builder yammerpostmethod(Integer yammerpostmethod) {
            this.yammerpostmethod = yammerpostmethod;
            this.changedFields = changedFields.add("yammerpostmethod");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Organization build() {
            Organization _x = new Organization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.organization";
            _x.autoapplydefaultoncasecreate = autoapplydefaultoncasecreate;
            _x.maxverboseloggingsynccycles = maxverboseloggingsynccycles;
            _x.privilegeusergroupid = privilegeusergroupid;
            _x.expiresubscriptionsindays = expiresubscriptionsindays;
            _x.numberformat = numberformat;
            _x.globalhelpurlenabled = globalhelpurlenabled;
            _x.widgetproperties = widgetproperties;
            _x.taskbasedflowenabled = taskbasedflowenabled;
            _x.iscontextualhelpenabled = iscontextualhelpenabled;
            _x.isquickcreateenabledforopportunityclose = isquickcreateenabledforopportunityclose;
            _x.recurrenceexpansionsynchcreatemax = recurrenceexpansionsynchcreatemax;
            _x.generatealertsforinformation = generatealertsforinformation;
            _x.enablesmartmatching = enablesmartmatching;
            _x.orderprefix = orderprefix;
            _x.reportscripterrors = reportscripterrors;
            _x.organizationstate = organizationstate;
            _x.sessiontimeoutreminderinmins = sessiontimeoutreminderinmins;
            _x.allowwebexcelexport = allowwebexcelexport;
            _x.mobileofflineminlicenseprod = mobileofflineminlicenseprod;
            _x.caseprefix = caseprefix;
            _x.longdateformatcode = longdateformatcode;
            _x.usepositionhierarchy = usepositionhierarchy;
            _x.trackingtokenidbase = trackingtokenidbase;
            _x.allowentityonlyaudit = allowentityonlyaudit;
            _x.globalappendurlparametersenabled = globalappendurlparametersenabled;
            _x.generatealertsforwarnings = generatealertsforwarnings;
            _x.maximumentitieswithactivesla = maximumentitieswithactivesla;
            _x.privreportinggroupid = privreportinggroupid;
            _x.invoiceprefix = invoiceprefix;
            _x.quoteprefix = quoteprefix;
            _x.mailboxintermittentissueminrange = mailboxintermittentissueminrange;
            _x.isassignedtaskssyncenabled = isassignedtaskssyncenabled;
            _x.issopintegrationenabled = issopintegrationenabled;
            _x.ismobileclientondemandsyncenabled = ismobileclientondemandsyncenabled;
            _x.isgeospatialazuremapsintegrationenabled = isgeospatialazuremapsintegrationenabled;
            _x.servestaticresourcesfromazurecdn = servestaticresourcesfromazurecdn;
            _x.isautodatacaptureenabled = isautodatacaptureenabled;
            _x.isemailserverprofilecontentfilteringenabled = isemailserverprofilecontentfilteringenabled;
            _x.isluisenabledford365bot = isluisenabledford365bot;
            _x.blockedattachments = blockedattachments;
            _x.isconflictdetectionenabledformobileclient = isconflictdetectionenabledformobileclient;
            _x.businesscardoptions = businesscardoptions;
            _x.goalrollupfrequency = goalrollupfrequency;
            _x.parsedtableprefix = parsedtableprefix;
            _x.isreadauditenabled = isreadauditenabled;
            _x.requireapprovalforuseremail = requireapprovalforuseremail;
            _x.emailsendpollingperiod = emailsendpollingperiod;
            _x.useinbuiltrulefordefaultpricelistselection = useinbuiltrulefordefaultpricelistselection;
            _x.isrichtextnotesenabled = isrichtextnotesenabled;
            _x.hashdeltasubjectcount = hashdeltasubjectcount;
            _x.recurrenceexpansionjobbatchinterval = recurrenceexpansionjobbatchinterval;
            _x.fiscalperiodformat = fiscalperiodformat;
            _x.officegraphdelveurl = officegraphdelveurl;
            _x.maxrecordsforlookupfilters = maxrecordsforlookupfilters;
            _x.sharepointdeploymenttype = sharepointdeploymenttype;
            _x.isrelationshipinsightsenabled = isrelationshipinsightsenabled;
            _x.requireapprovalforqueueemail = requireapprovalforqueueemail;
            _x.tokenexpiry = tokenexpiry;
            _x.postmessagewhitelistdomains = postmessagewhitelistdomains;
            _x.localeid = localeid;
            _x.createdon = createdon;
            _x.isduplicatedetectionenabledforonlinecreateupdate = isduplicatedetectionenabledforonlinecreateupdate;
            _x.contentsecuritypolicyconfiguration = contentsecuritypolicyconfiguration;
            _x.inactivitytimeoutenabled = inactivitytimeoutenabled;
            _x.displaynavigationtour = displaynavigationtour;
            _x.isautosaveenabled = isautosaveenabled;
            _x.supportuserid = supportuserid;
            _x.currencydisplayoption = currencydisplayoption;
            _x.tokenkey = tokenkey;
            _x.pinpointlanguagecode = pinpointlanguagecode;
            _x.isappointmentattachmentsyncenabled = isappointmentattachmentsyncenabled;
            _x.isenabledforallroles = isenabledforallroles;
            _x.enablelpauthoring = enablelpauthoring;
            _x.mobileofflineminlicensetrial = mobileofflineminlicensetrial;
            _x.auditretentionperiod = auditretentionperiod;
            _x.officeappsautodeploymentenabled = officeappsautodeploymentenabled;
            _x.hashfilterkeywords = hashfilterkeywords;
            _x.isnotesanalysisenabled = isnotesanalysisenabled;
            _x.iscontactmailingaddresssyncenabled = iscontactmailingaddresssyncenabled;
            _x.ismailboxforcedunlockingenabled = ismailboxforcedunlockingenabled;
            _x.isexternalfilestorageenabled = isexternalfilestorageenabled;
            _x.mobileofflinesyncinterval = mobileofflinesyncinterval;
            _x.tagmaxaggressivecycles = tagmaxaggressivecycles;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.grantaccesstonetworkservice = grantaccesstonetworkservice;
            _x.iscontentsecuritypolicyenabled = iscontentsecuritypolicyenabled;
            _x.isdelveactionhubintegrationenabled = isdelveactionhubintegrationenabled;
            _x.allowoutlookscheduledsyncs = allowoutlookscheduledsyncs;
            _x.maximumdynamicpropertiesallowed = maximumdynamicpropertiesallowed;
            _x.numbergroupformat = numbergroupformat;
            _x.entityimageid = entityimageid;
            _x.trackingtokeniddigits = trackingtokeniddigits;
            _x.defaultrecurrenceendrangetype = defaultrecurrenceendrangetype;
            _x.yammernetworkpermalink = yammernetworkpermalink;
            _x.bulkoperationprefix = bulkoperationprefix;
            _x.oobpricecalculationenabled = oobpricecalculationenabled;
            _x.futureexpansionwindow = futureexpansionwindow;
            _x.ispresenceenabled = ispresenceenabled;
            _x.pastexpansionwindow = pastexpansionwindow;
            _x.maximumslakpiperentitywithactivesla = maximumslakpiperentitywithactivesla;
            _x.ismsteamssettingchangedbyuser = ismsteamssettingchangedbyuser;
            _x.picture = picture;
            _x.azureschedulerjobcollectionname = azureschedulerjobcollectionname;
            _x.isofficegraphenabled = isofficegraphenabled;
            _x.orgdborgsettings = orgdborgsettings;
            _x.ismodeldrivenappsinmsteamsenabled = ismodeldrivenappsinmsteamsenabled;
            _x.rierrorstatus = rierrorstatus;
            _x.allowlegacydialogsembedding = allowlegacydialogsembedding;
            _x.emailcorrelationenabled = emailcorrelationenabled;
            _x.maxappointmentdurationdays = maxappointmentdurationdays;
            _x.microsoftflowenvironment = microsoftflowenvironment;
            _x.tracelogmaximumageindays = tracelogmaximumageindays;
            _x.isduplicatedetectionenabledforimport = isduplicatedetectionenabledforimport;
            _x.iscustomcontrolsincanvasappsenabled = iscustomcontrolsincanvasappsenabled;
            _x.enforcereadonlyplugins = enforcereadonlyplugins;
            _x.createproductswithoutparentinactivestate = createproductswithoutparentinactivestate;
            _x.enableunifiedinterfaceshellrefresh = enableunifiedinterfaceshellrefresh;
            _x.textanalyticsenabled = textanalyticsenabled;
            _x.expirechangetrackingindays = expirechangetrackingindays;
            _x.usereadform = usereadform;
            _x.basecurrencysymbol = basecurrencysymbol;
            _x.fiscalyearperiodconnect = fiscalyearperiodconnect;
            _x.maxsupportedinternetexplorerversion = maxsupportedinternetexplorerversion;
            _x.fiscalperiodformatperiod = fiscalperiodformatperiod;
            _x.bingmapsapikey = bingmapsapikey;
            _x.isactionsupportfeatureenabled = isactionsupportfeatureenabled;
            _x.restrictstatusupdate = restrictstatusupdate;
            _x.defaultthemedata = defaultthemedata;
            _x.isonedriveenabled = isonedriveenabled;
            _x.externalpartycorrelationkeys = externalpartycorrelationkeys;
            _x.auditretentionperiodv2 = auditretentionperiodv2;
            _x.negativeformatcode = negativeformatcode;
            _x.ispricelistmandatory = ispricelistmandatory;
            _x.timeseparator = timeseparator;
            _x.maxproductsinbundle = maxproductsinbundle;
            _x.slapausestates = slapausestates;
            _x.v3calloutconfighash = v3calloutconfighash;
            _x.plugintracelogsetting = plugintracelogsetting;
            _x.syncoptinselectionstatus = syncoptinselectionstatus;
            _x.syncbulkoperationmaxlimit = syncbulkoperationmaxlimit;
            _x.allowofflinescheduledsyncs = allowofflinescheduledsyncs;
            _x.basecurrencyprecision = basecurrencyprecision;
            _x.socialinsightsinstance = socialinsightsinstance;
            _x.ishierarchicalsecuritymodelenabled = ishierarchicalsecuritymodelenabled;
            _x.privacystatementurl = privacystatementurl;
            _x.minoutlooksyncinterval = minoutlooksyncinterval;
            _x.currentimportsequencenumber = currentimportsequencenumber;
            _x.isuseraccessauditenabled = isuseraccessauditenabled;
            _x.fiscalyearformatprefix = fiscalyearformatprefix;
            _x.enablebingmapsintegration = enablebingmapsintegration;
            _x.maxslaitemspersla = maxslaitemspersla;
            _x.syncbulkoperationbatchsize = syncbulkoperationbatchsize;
            _x.tagpollingperiod = tagpollingperiod;
            _x.suppresssla = suppresssla;
            _x.clientfeatureset = clientfeatureset;
            _x.versionnumber = versionnumber;
            _x.isemailmonitoringallowed = isemailmonitoringallowed;
            _x.maxverboseloggingmailbox = maxverboseloggingmailbox;
            _x.ismanualsalesforecastingenabled = ismanualsalesforecastingenabled;
            _x.isduplicatedetectionenabled = isduplicatedetectionenabled;
            _x.schemanameprefix = schemanameprefix;
            _x.paipreviewscenarioenabled = paipreviewscenarioenabled;
            _x.autoapplysla = autoapplysla;
            _x.ismsteamscollaborationenabled = ismsteamscollaborationenabled;
            _x.incomingemailexchangeemailretrievalbatchsize = incomingemailexchangeemailretrievalbatchsize;
            _x.ismailboxinactivebackoffenabled = ismailboxinactivebackoffenabled;
            _x.cortanaproactiveexperienceenabled = cortanaproactiveexperienceenabled;
            _x.goalrollupexpirytime = goalrollupexpirytime;
            _x.isplaybookenabled = isplaybookenabled;
            _x.showkbarticledeprecationnotification = showkbarticledeprecationnotification;
            _x.isappmode = isappmode;
            _x._modifiedby_value = _modifiedby_value;
            _x.contractprefix = contractprefix;
            _x.allowautounsubscribe = allowautounsubscribe;
            _x.ignoreinternalemail = ignoreinternalemail;
            _x.ispreviewforautocaptureenabled = ispreviewforautocaptureenabled;
            _x.minofflinesyncinterval = minofflinesyncinterval;
            _x.highcontrastthemedata = highcontrastthemedata;
            _x.systemuserid = systemuserid;
            _x.orginsightsenabled = orginsightsenabled;
            _x.maxactionstepsinbpf = maxactionstepsinbpf;
            _x.socialinsightstermsaccepted = socialinsightstermsaccepted;
            _x.defaultemailsettings = defaultemailsettings;
            _x.generatealertsforerrors = generatealertsforerrors;
            _x.getstartedpanecontentenabled = getstartedpanecontentenabled;
            _x.sqlaccessgroupname = sqlaccessgroupname;
            _x.autoapplydefaultoncaseupdate = autoapplydefaultoncaseupdate;
            _x.negativecurrencyformatcode = negativecurrencyformatcode;
            _x.cascadestatusupdate = cascadestatusupdate;
            _x.powerbifeatureenabled = powerbifeatureenabled;
            _x.fullnameconventioncode = fullnameconventioncode;
            _x.allowaddressbooksyncs = allowaddressbooksyncs;
            _x.notifymailboxownerofemailserverlevelalerts = notifymailboxownerofemailserverlevelalerts;
            _x.usequickfindviewforgridsearch = usequickfindviewforgridsearch;
            _x.discountcalculationmethod = discountcalculationmethod;
            _x.organizationid = organizationid;
            _x.mailboxpermanentissueminrange = mailboxpermanentissueminrange;
            _x.kmsettings = kmsettings;
            _x.isfulltextsearchenabled = isfulltextsearchenabled;
            _x.hashminaddresscount = hashminaddresscount;
            _x.dateseparator = dateseparator;
            _x.weekstartdaycode = weekstartdaycode;
            _x.allowuserformmodepreference = allowuserformmodepreference;
            _x.numberseparator = numberseparator;
            _x.campaignprefix = campaignprefix;
            _x.productrecommendationsenabled = productrecommendationsenabled;
            _x.recurrencedefaultnumberofoccurrences = recurrencedefaultnumberofoccurrences;
            _x.ismsteamsusersyncenabled = ismsteamsusersyncenabled;
            _x.quickfindrecordlimitenabled = quickfindrecordlimitenabled;
            _x.pricingdecimalprecision = pricingdecimalprecision;
            _x.useskypeprotocol = useskypeprotocol;
            _x.rendersecureiframeforemail = rendersecureiframeforemail;
            _x.inactivitytimeoutinmins = inactivitytimeoutinmins;
            _x.sessiontimeoutenabled = sessiontimeoutenabled;
            _x.minaddressbooksyncinterval = minaddressbooksyncinterval;
            _x.externalbaseurl = externalbaseurl;
            _x.issalesassistantenabled = issalesassistantenabled;
            _x._defaultmobileofflineprofileid_value = _defaultmobileofflineprofileid_value;
            _x.amdesignator = amdesignator;
            _x.enableimmersiveskypeintegration = enableimmersiveskypeintegration;
            _x.kbprefix = kbprefix;
            _x.bounddashboarddefaultcardexpanded = bounddashboarddefaultcardexpanded;
            _x.hashmaxcount = hashmaxcount;
            _x.reportinggroupname = reportinggroupname;
            _x.isdelegateaccessenabled = isdelegateaccessenabled;
            _x.aciwebendpointurl = aciwebendpointurl;
            _x.maxuploadfilesize = maxuploadfilesize;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.fiscalyeardisplaycode = fiscalyeardisplaycode;
            _x.yammeroauthaccesstokenexpired = yammeroauthaccesstokenexpired;
            _x.externalpartyentitysettings = externalpartyentitysettings;
            _x.defaultcountrycode = defaultcountrycode;
            _x.isactivityanalysisenabled = isactivityanalysisenabled;
            _x.recurrenceexpansionjobbatchsize = recurrenceexpansionjobbatchsize;
            _x._basecurrencyid_value = _basecurrencyid_value;
            _x.featureset = featureset;
            _x.istextwrapenabled = istextwrapenabled;
            _x.calendartype = calendartype;
            _x.allowclientmessagebarad = allowclientmessagebarad;
            _x.usergroupid = usergroupid;
            _x.isdisabled = isdisabled;
            _x.isduplicatedetectionenabledforofflinesync = isduplicatedetectionenabledforofflinesync;
            _x.languagecode = languagecode;
            _x.appdesignerexperienceenabled = appdesignerexperienceenabled;
            _x.categoryprefix = categoryprefix;
            _x.ispreviewenabledforactioncard = ispreviewenabledforactioncard;
            _x.ismobileofflineenabled = ismobileofflineenabled;
            _x.fiscalcalendarstart = fiscalcalendarstart;
            _x.isexternalsearchindexenabled = isexternalsearchindexenabled;
            _x.maximumactivebusinessprocessflowsallowedperentity = maximumactivebusinessprocessflowsallowedperentity;
            _x.enablelivepersonacarduci = enablelivepersonacarduci;
            _x.timeformatcode = timeformatcode;
            _x.dayssincerecordlastmodifiedmaxvalue = dayssincerecordlastmodifiedmaxvalue;
            _x._acknowledgementtemplateid_value = _acknowledgementtemplateid_value;
            _x.maxdepthforhierarchicalsecuritymodel = maxdepthforhierarchicalsecuritymodel;
            _x.currencysymbol = currencysymbol;
            _x.isfolderbasedtrackingenabled = isfolderbasedtrackingenabled;
            _x.isdefaultcountrycodecheckenabled = isdefaultcountrycodecheckenabled;
            _x.entityimage = entityimage;
            _x.fiscalyearformatyear = fiscalyearformatyear;
            _x.entityimage_timestamp = entityimage_timestamp;
            _x.privreportinggroupname = privreportinggroupname;
            _x.yearstartweekcode = yearstartweekcode;
            _x.uselegacyrendering = uselegacyrendering;
            _x.maximumtrackingnumber = maximumtrackingnumber;
            _x.fiscalyearformatsuffix = fiscalyearformatsuffix;
            _x.allowautoresponsecreation = allowautoresponsecreation;
            _x.allowlegacyclientexperience = allowlegacyclientexperience;
            _x.ismsteamsenabled = ismsteamsenabled;
            _x.enablemicrosoftflowintegration = enablemicrosoftflowintegration;
            _x.currentparsedtablenumber = currentparsedtablenumber;
            _x.socialinsightsenabled = socialinsightsenabled;
            _x._createdby_value = _createdby_value;
            _x.initialversion = initialversion;
            _x.delegatedadminuserid = delegatedadminuserid;
            _x.isfiscalperiodmonthbased = isfiscalperiodmonthbased;
            _x.fiscalperiodtype = fiscalperiodtype;
            _x.inactivitytimeoutreminderinmins = inactivitytimeoutreminderinmins;
            _x.disabledreason = disabledreason;
            _x.uniquespecifierlength = uniquespecifierlength;
            _x.ispdfgenerationenabled = ispdfgenerationenabled;
            _x.enablelivepersoncardintegrationinoffice = enablelivepersoncardintegrationinoffice;
            _x.maxrecordsforexporttoexcel = maxrecordsforexporttoexcel;
            _x.useraccessauditinginterval = useraccessauditinginterval;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.kaprefix = kaprefix;
            _x.allowmarketingemailexecution = allowmarketingemailexecution;
            _x.sqmenabled = sqmenabled;
            _x.timeformatstring = timeformatstring;
            _x.iscontextualemailenabled = iscontextualemailenabled;
            _x.dateformatcode = dateformatcode;
            _x.webresourcehash = webresourcehash;
            _x.syncoptinselection = syncoptinselection;
            _x.sortid = sortid;
            _x.globalhelpurl = globalhelpurl;
            _x.isallmoneydecimal = isallmoneydecimal;
            _x.isauditenabled = isauditenabled;
            _x.fiscalyearformat = fiscalyearformat;
            _x.sendbulkemailinuci = sendbulkemailinuci;
            _x.defaultcrmcustomname = defaultcrmcustomname;
            _x.currencyformatcode = currencyformatcode;
            _x.isbpfentitycustomizationfeatureenabled = isbpfentitycustomizationfeatureenabled;
            _x.maxconditionsformobileofflinefilters = maxconditionsformobileofflinefilters;
            _x.businessclosurecalendarid = businessclosurecalendarid;
            _x.showweeknumber = showweeknumber;
            _x.isactioncardenabled = isactioncardenabled;
            _x.sessiontimeoutinmins = sessiontimeoutinmins;
            _x.appointmentricheditorexperience = appointmentricheditorexperience;
            _x._defaultemailserverprofileid_value = _defaultemailserverprofileid_value;
            _x.integrationuserid = integrationuserid;
            _x.entityimage_url = entityimage_url;
            _x.isnewaddproductexperienceenabled = isnewaddproductexperienceenabled;
            _x.pmdesignator = pmdesignator;
            _x.sampledataimportid = sampledataimportid;
            _x.name = name;
            _x.currencydecimalprecision = currencydecimalprecision;
            _x.emailconnectionchannel = emailconnectionchannel;
            _x.ispreviewforemailmonitoringallowed = ispreviewforemailmonitoringallowed;
            _x.allowunresolvedpartiesonemailsend = allowunresolvedpartiesonemailsend;
            _x.ispaienabled = ispaienabled;
            _x.isautodatacapturev2enabled = isautodatacapturev2enabled;
            _x.allowautounsubscribeacknowledgement = allowautounsubscribeacknowledgement;
            _x.nexttrackingnumber = nexttrackingnumber;
            _x.enablepricingoncreate = enablepricingoncreate;
            _x.parsedtablecolumnprefix = parsedtablecolumnprefix;
            _x.allowusersseeappdownloadmessage = allowusersseeappdownloadmessage;
            _x.decimalsymbol = decimalsymbol;
            _x.modifiedon = modifiedon;
            _x.signupoutlookdownloadfwlink = signupoutlookdownloadfwlink;
            _x.isresourcebookingexchangesyncenabled = isresourcebookingexchangesyncenabled;
            _x.disablesocialcare = disablesocialcare;
            _x.resolvesimilarunresolvedemailaddress = resolvesimilarunresolvedemailaddress;
            _x.unresolveemailaddressifmultiplematch = unresolveemailaddressifmultiplematch;
            _x.sharetopreviousowneronassign = sharetopreviousowneronassign;
            _x.iswriteinproductsallowed = iswriteinproductsallowed;
            _x.reportinggroupid = reportinggroupid;
            _x.qualifyleadadditionaloptions = qualifyleadadditionaloptions;
            _x.isfolderautocreatedonsp = isfolderautocreatedonsp;
            _x.maxfolderbasedtrackingmappings = maxfolderbasedtrackingmappings;
            _x.sqlaccessgroupid = sqlaccessgroupid;
            _x.trackingprefix = trackingprefix;
            _x.yammergroupid = yammergroupid;
            _x.dateformatstring = dateformatstring;
            _x.yammerpostmethod = yammerpostmethod;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && organizationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(organizationid.toString()));
        }
    }

    @Property(name="autoapplydefaultoncasecreate")
    @JsonIgnore
    public Optional<Boolean> getAutoapplydefaultoncasecreate() {
        return Optional.ofNullable(autoapplydefaultoncasecreate);
    }

    public Organization withAutoapplydefaultoncasecreate(Boolean autoapplydefaultoncasecreate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("autoapplydefaultoncasecreate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.autoapplydefaultoncasecreate = autoapplydefaultoncasecreate;
        return _x;
    }

    @Property(name="maxverboseloggingsynccycles")
    @JsonIgnore
    public Optional<Integer> getMaxverboseloggingsynccycles() {
        return Optional.ofNullable(maxverboseloggingsynccycles);
    }

    public Organization withMaxverboseloggingsynccycles(Integer maxverboseloggingsynccycles) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxverboseloggingsynccycles");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxverboseloggingsynccycles = maxverboseloggingsynccycles;
        return _x;
    }

    @Property(name="privilegeusergroupid")
    @JsonIgnore
    public Optional<String> getPrivilegeusergroupid() {
        return Optional.ofNullable(privilegeusergroupid);
    }

    public Organization withPrivilegeusergroupid(String privilegeusergroupid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("privilegeusergroupid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.privilegeusergroupid = privilegeusergroupid;
        return _x;
    }

    @Property(name="expiresubscriptionsindays")
    @JsonIgnore
    public Optional<Integer> getExpiresubscriptionsindays() {
        return Optional.ofNullable(expiresubscriptionsindays);
    }

    public Organization withExpiresubscriptionsindays(Integer expiresubscriptionsindays) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("expiresubscriptionsindays");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.expiresubscriptionsindays = expiresubscriptionsindays;
        return _x;
    }

    @Property(name="numberformat")
    @JsonIgnore
    public Optional<String> getNumberformat() {
        return Optional.ofNullable(numberformat);
    }

    public Organization withNumberformat(String numberformat) {
        Checks.checkIsAscii(numberformat);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("numberformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.numberformat = numberformat;
        return _x;
    }

    @Property(name="globalhelpurlenabled")
    @JsonIgnore
    public Optional<Boolean> getGlobalhelpurlenabled() {
        return Optional.ofNullable(globalhelpurlenabled);
    }

    public Organization withGlobalhelpurlenabled(Boolean globalhelpurlenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("globalhelpurlenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.globalhelpurlenabled = globalhelpurlenabled;
        return _x;
    }

    @Property(name="widgetproperties")
    @JsonIgnore
    public Optional<String> getWidgetproperties() {
        return Optional.ofNullable(widgetproperties);
    }

    public Organization withWidgetproperties(String widgetproperties) {
        Checks.checkIsAscii(widgetproperties);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("widgetproperties");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.widgetproperties = widgetproperties;
        return _x;
    }

    @Property(name="taskbasedflowenabled")
    @JsonIgnore
    public Optional<Boolean> getTaskbasedflowenabled() {
        return Optional.ofNullable(taskbasedflowenabled);
    }

    public Organization withTaskbasedflowenabled(Boolean taskbasedflowenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("taskbasedflowenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.taskbasedflowenabled = taskbasedflowenabled;
        return _x;
    }

    @Property(name="iscontextualhelpenabled")
    @JsonIgnore
    public Optional<Boolean> getIscontextualhelpenabled() {
        return Optional.ofNullable(iscontextualhelpenabled);
    }

    public Organization withIscontextualhelpenabled(Boolean iscontextualhelpenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("iscontextualhelpenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.iscontextualhelpenabled = iscontextualhelpenabled;
        return _x;
    }

    @Property(name="isquickcreateenabledforopportunityclose")
    @JsonIgnore
    public Optional<Boolean> getIsquickcreateenabledforopportunityclose() {
        return Optional.ofNullable(isquickcreateenabledforopportunityclose);
    }

    public Organization withIsquickcreateenabledforopportunityclose(Boolean isquickcreateenabledforopportunityclose) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isquickcreateenabledforopportunityclose");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isquickcreateenabledforopportunityclose = isquickcreateenabledforopportunityclose;
        return _x;
    }

    @Property(name="recurrenceexpansionsynchcreatemax")
    @JsonIgnore
    public Optional<Integer> getRecurrenceexpansionsynchcreatemax() {
        return Optional.ofNullable(recurrenceexpansionsynchcreatemax);
    }

    public Organization withRecurrenceexpansionsynchcreatemax(Integer recurrenceexpansionsynchcreatemax) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("recurrenceexpansionsynchcreatemax");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.recurrenceexpansionsynchcreatemax = recurrenceexpansionsynchcreatemax;
        return _x;
    }

    @Property(name="generatealertsforinformation")
    @JsonIgnore
    public Optional<Boolean> getGeneratealertsforinformation() {
        return Optional.ofNullable(generatealertsforinformation);
    }

    public Organization withGeneratealertsforinformation(Boolean generatealertsforinformation) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("generatealertsforinformation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.generatealertsforinformation = generatealertsforinformation;
        return _x;
    }

    @Property(name="enablesmartmatching")
    @JsonIgnore
    public Optional<Boolean> getEnablesmartmatching() {
        return Optional.ofNullable(enablesmartmatching);
    }

    public Organization withEnablesmartmatching(Boolean enablesmartmatching) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enablesmartmatching");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enablesmartmatching = enablesmartmatching;
        return _x;
    }

    @Property(name="orderprefix")
    @JsonIgnore
    public Optional<String> getOrderprefix() {
        return Optional.ofNullable(orderprefix);
    }

    public Organization withOrderprefix(String orderprefix) {
        Checks.checkIsAscii(orderprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("orderprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.orderprefix = orderprefix;
        return _x;
    }

    @Property(name="reportscripterrors")
    @JsonIgnore
    public Optional<Integer> getReportscripterrors() {
        return Optional.ofNullable(reportscripterrors);
    }

    public Organization withReportscripterrors(Integer reportscripterrors) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("reportscripterrors");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.reportscripterrors = reportscripterrors;
        return _x;
    }

    @Property(name="organizationstate")
    @JsonIgnore
    public Optional<Integer> getOrganizationstate() {
        return Optional.ofNullable(organizationstate);
    }

    public Organization withOrganizationstate(Integer organizationstate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("organizationstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.organizationstate = organizationstate;
        return _x;
    }

    @Property(name="sessiontimeoutreminderinmins")
    @JsonIgnore
    public Optional<Integer> getSessiontimeoutreminderinmins() {
        return Optional.ofNullable(sessiontimeoutreminderinmins);
    }

    public Organization withSessiontimeoutreminderinmins(Integer sessiontimeoutreminderinmins) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sessiontimeoutreminderinmins");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sessiontimeoutreminderinmins = sessiontimeoutreminderinmins;
        return _x;
    }

    @Property(name="allowwebexcelexport")
    @JsonIgnore
    public Optional<Boolean> getAllowwebexcelexport() {
        return Optional.ofNullable(allowwebexcelexport);
    }

    public Organization withAllowwebexcelexport(Boolean allowwebexcelexport) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowwebexcelexport");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowwebexcelexport = allowwebexcelexport;
        return _x;
    }

    @Property(name="mobileofflineminlicenseprod")
    @JsonIgnore
    public Optional<Integer> getMobileofflineminlicenseprod() {
        return Optional.ofNullable(mobileofflineminlicenseprod);
    }

    public Organization withMobileofflineminlicenseprod(Integer mobileofflineminlicenseprod) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineminlicenseprod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.mobileofflineminlicenseprod = mobileofflineminlicenseprod;
        return _x;
    }

    @Property(name="caseprefix")
    @JsonIgnore
    public Optional<String> getCaseprefix() {
        return Optional.ofNullable(caseprefix);
    }

    public Organization withCaseprefix(String caseprefix) {
        Checks.checkIsAscii(caseprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("caseprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.caseprefix = caseprefix;
        return _x;
    }

    @Property(name="longdateformatcode")
    @JsonIgnore
    public Optional<Integer> getLongdateformatcode() {
        return Optional.ofNullable(longdateformatcode);
    }

    public Organization withLongdateformatcode(Integer longdateformatcode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("longdateformatcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.longdateformatcode = longdateformatcode;
        return _x;
    }

    @Property(name="usepositionhierarchy")
    @JsonIgnore
    public Optional<Boolean> getUsepositionhierarchy() {
        return Optional.ofNullable(usepositionhierarchy);
    }

    public Organization withUsepositionhierarchy(Boolean usepositionhierarchy) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("usepositionhierarchy");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.usepositionhierarchy = usepositionhierarchy;
        return _x;
    }

    @Property(name="trackingtokenidbase")
    @JsonIgnore
    public Optional<Integer> getTrackingtokenidbase() {
        return Optional.ofNullable(trackingtokenidbase);
    }

    public Organization withTrackingtokenidbase(Integer trackingtokenidbase) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("trackingtokenidbase");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.trackingtokenidbase = trackingtokenidbase;
        return _x;
    }

    @Property(name="allowentityonlyaudit")
    @JsonIgnore
    public Optional<Boolean> getAllowentityonlyaudit() {
        return Optional.ofNullable(allowentityonlyaudit);
    }

    public Organization withAllowentityonlyaudit(Boolean allowentityonlyaudit) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowentityonlyaudit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowentityonlyaudit = allowentityonlyaudit;
        return _x;
    }

    @Property(name="globalappendurlparametersenabled")
    @JsonIgnore
    public Optional<Boolean> getGlobalappendurlparametersenabled() {
        return Optional.ofNullable(globalappendurlparametersenabled);
    }

    public Organization withGlobalappendurlparametersenabled(Boolean globalappendurlparametersenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("globalappendurlparametersenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.globalappendurlparametersenabled = globalappendurlparametersenabled;
        return _x;
    }

    @Property(name="generatealertsforwarnings")
    @JsonIgnore
    public Optional<Boolean> getGeneratealertsforwarnings() {
        return Optional.ofNullable(generatealertsforwarnings);
    }

    public Organization withGeneratealertsforwarnings(Boolean generatealertsforwarnings) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("generatealertsforwarnings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.generatealertsforwarnings = generatealertsforwarnings;
        return _x;
    }

    @Property(name="maximumentitieswithactivesla")
    @JsonIgnore
    public Optional<Integer> getMaximumentitieswithactivesla() {
        return Optional.ofNullable(maximumentitieswithactivesla);
    }

    public Organization withMaximumentitieswithactivesla(Integer maximumentitieswithactivesla) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maximumentitieswithactivesla");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maximumentitieswithactivesla = maximumentitieswithactivesla;
        return _x;
    }

    @Property(name="privreportinggroupid")
    @JsonIgnore
    public Optional<String> getPrivreportinggroupid() {
        return Optional.ofNullable(privreportinggroupid);
    }

    public Organization withPrivreportinggroupid(String privreportinggroupid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("privreportinggroupid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.privreportinggroupid = privreportinggroupid;
        return _x;
    }

    @Property(name="invoiceprefix")
    @JsonIgnore
    public Optional<String> getInvoiceprefix() {
        return Optional.ofNullable(invoiceprefix);
    }

    public Organization withInvoiceprefix(String invoiceprefix) {
        Checks.checkIsAscii(invoiceprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("invoiceprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.invoiceprefix = invoiceprefix;
        return _x;
    }

    @Property(name="quoteprefix")
    @JsonIgnore
    public Optional<String> getQuoteprefix() {
        return Optional.ofNullable(quoteprefix);
    }

    public Organization withQuoteprefix(String quoteprefix) {
        Checks.checkIsAscii(quoteprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("quoteprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.quoteprefix = quoteprefix;
        return _x;
    }

    @Property(name="mailboxintermittentissueminrange")
    @JsonIgnore
    public Optional<Integer> getMailboxintermittentissueminrange() {
        return Optional.ofNullable(mailboxintermittentissueminrange);
    }

    public Organization withMailboxintermittentissueminrange(Integer mailboxintermittentissueminrange) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("mailboxintermittentissueminrange");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.mailboxintermittentissueminrange = mailboxintermittentissueminrange;
        return _x;
    }

    @Property(name="isassignedtaskssyncenabled")
    @JsonIgnore
    public Optional<Boolean> getIsassignedtaskssyncenabled() {
        return Optional.ofNullable(isassignedtaskssyncenabled);
    }

    public Organization withIsassignedtaskssyncenabled(Boolean isassignedtaskssyncenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isassignedtaskssyncenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isassignedtaskssyncenabled = isassignedtaskssyncenabled;
        return _x;
    }

    @Property(name="issopintegrationenabled")
    @JsonIgnore
    public Optional<Boolean> getIssopintegrationenabled() {
        return Optional.ofNullable(issopintegrationenabled);
    }

    public Organization withIssopintegrationenabled(Boolean issopintegrationenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("issopintegrationenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.issopintegrationenabled = issopintegrationenabled;
        return _x;
    }

    @Property(name="ismobileclientondemandsyncenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmobileclientondemandsyncenabled() {
        return Optional.ofNullable(ismobileclientondemandsyncenabled);
    }

    public Organization withIsmobileclientondemandsyncenabled(Boolean ismobileclientondemandsyncenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismobileclientondemandsyncenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismobileclientondemandsyncenabled = ismobileclientondemandsyncenabled;
        return _x;
    }

    @Property(name="isgeospatialazuremapsintegrationenabled")
    @JsonIgnore
    public Optional<Boolean> getIsgeospatialazuremapsintegrationenabled() {
        return Optional.ofNullable(isgeospatialazuremapsintegrationenabled);
    }

    public Organization withIsgeospatialazuremapsintegrationenabled(Boolean isgeospatialazuremapsintegrationenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isgeospatialazuremapsintegrationenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isgeospatialazuremapsintegrationenabled = isgeospatialazuremapsintegrationenabled;
        return _x;
    }

    @Property(name="servestaticresourcesfromazurecdn")
    @JsonIgnore
    public Optional<Boolean> getServestaticresourcesfromazurecdn() {
        return Optional.ofNullable(servestaticresourcesfromazurecdn);
    }

    public Organization withServestaticresourcesfromazurecdn(Boolean servestaticresourcesfromazurecdn) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("servestaticresourcesfromazurecdn");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.servestaticresourcesfromazurecdn = servestaticresourcesfromazurecdn;
        return _x;
    }

    @Property(name="isautodatacaptureenabled")
    @JsonIgnore
    public Optional<Boolean> getIsautodatacaptureenabled() {
        return Optional.ofNullable(isautodatacaptureenabled);
    }

    public Organization withIsautodatacaptureenabled(Boolean isautodatacaptureenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isautodatacaptureenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isautodatacaptureenabled = isautodatacaptureenabled;
        return _x;
    }

    @Property(name="isemailserverprofilecontentfilteringenabled")
    @JsonIgnore
    public Optional<Boolean> getIsemailserverprofilecontentfilteringenabled() {
        return Optional.ofNullable(isemailserverprofilecontentfilteringenabled);
    }

    public Organization withIsemailserverprofilecontentfilteringenabled(Boolean isemailserverprofilecontentfilteringenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isemailserverprofilecontentfilteringenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isemailserverprofilecontentfilteringenabled = isemailserverprofilecontentfilteringenabled;
        return _x;
    }

    @Property(name="isluisenabledford365bot")
    @JsonIgnore
    public Optional<Boolean> getIsluisenabledford365bot() {
        return Optional.ofNullable(isluisenabledford365bot);
    }

    public Organization withIsluisenabledford365bot(Boolean isluisenabledford365bot) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isluisenabledford365bot");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isluisenabledford365bot = isluisenabledford365bot;
        return _x;
    }

    @Property(name="blockedattachments")
    @JsonIgnore
    public Optional<String> getBlockedattachments() {
        return Optional.ofNullable(blockedattachments);
    }

    public Organization withBlockedattachments(String blockedattachments) {
        Checks.checkIsAscii(blockedattachments);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("blockedattachments");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.blockedattachments = blockedattachments;
        return _x;
    }

    @Property(name="isconflictdetectionenabledformobileclient")
    @JsonIgnore
    public Optional<Boolean> getIsconflictdetectionenabledformobileclient() {
        return Optional.ofNullable(isconflictdetectionenabledformobileclient);
    }

    public Organization withIsconflictdetectionenabledformobileclient(Boolean isconflictdetectionenabledformobileclient) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isconflictdetectionenabledformobileclient");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isconflictdetectionenabledformobileclient = isconflictdetectionenabledformobileclient;
        return _x;
    }

    @Property(name="businesscardoptions")
    @JsonIgnore
    public Optional<String> getBusinesscardoptions() {
        return Optional.ofNullable(businesscardoptions);
    }

    public Organization withBusinesscardoptions(String businesscardoptions) {
        Checks.checkIsAscii(businesscardoptions);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("businesscardoptions");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.businesscardoptions = businesscardoptions;
        return _x;
    }

    @Property(name="goalrollupfrequency")
    @JsonIgnore
    public Optional<Integer> getGoalrollupfrequency() {
        return Optional.ofNullable(goalrollupfrequency);
    }

    public Organization withGoalrollupfrequency(Integer goalrollupfrequency) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("goalrollupfrequency");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.goalrollupfrequency = goalrollupfrequency;
        return _x;
    }

    @Property(name="parsedtableprefix")
    @JsonIgnore
    public Optional<String> getParsedtableprefix() {
        return Optional.ofNullable(parsedtableprefix);
    }

    public Organization withParsedtableprefix(String parsedtableprefix) {
        Checks.checkIsAscii(parsedtableprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("parsedtableprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.parsedtableprefix = parsedtableprefix;
        return _x;
    }

    @Property(name="isreadauditenabled")
    @JsonIgnore
    public Optional<Boolean> getIsreadauditenabled() {
        return Optional.ofNullable(isreadauditenabled);
    }

    public Organization withIsreadauditenabled(Boolean isreadauditenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isreadauditenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isreadauditenabled = isreadauditenabled;
        return _x;
    }

    @Property(name="requireapprovalforuseremail")
    @JsonIgnore
    public Optional<Boolean> getRequireapprovalforuseremail() {
        return Optional.ofNullable(requireapprovalforuseremail);
    }

    public Organization withRequireapprovalforuseremail(Boolean requireapprovalforuseremail) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("requireapprovalforuseremail");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.requireapprovalforuseremail = requireapprovalforuseremail;
        return _x;
    }

    @Property(name="emailsendpollingperiod")
    @JsonIgnore
    public Optional<Integer> getEmailsendpollingperiod() {
        return Optional.ofNullable(emailsendpollingperiod);
    }

    public Organization withEmailsendpollingperiod(Integer emailsendpollingperiod) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("emailsendpollingperiod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.emailsendpollingperiod = emailsendpollingperiod;
        return _x;
    }

    @Property(name="useinbuiltrulefordefaultpricelistselection")
    @JsonIgnore
    public Optional<Boolean> getUseinbuiltrulefordefaultpricelistselection() {
        return Optional.ofNullable(useinbuiltrulefordefaultpricelistselection);
    }

    public Organization withUseinbuiltrulefordefaultpricelistselection(Boolean useinbuiltrulefordefaultpricelistselection) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("useinbuiltrulefordefaultpricelistselection");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.useinbuiltrulefordefaultpricelistselection = useinbuiltrulefordefaultpricelistselection;
        return _x;
    }

    @Property(name="isrichtextnotesenabled")
    @JsonIgnore
    public Optional<Boolean> getIsrichtextnotesenabled() {
        return Optional.ofNullable(isrichtextnotesenabled);
    }

    public Organization withIsrichtextnotesenabled(Boolean isrichtextnotesenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isrichtextnotesenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isrichtextnotesenabled = isrichtextnotesenabled;
        return _x;
    }

    @Property(name="hashdeltasubjectcount")
    @JsonIgnore
    public Optional<Integer> getHashdeltasubjectcount() {
        return Optional.ofNullable(hashdeltasubjectcount);
    }

    public Organization withHashdeltasubjectcount(Integer hashdeltasubjectcount) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("hashdeltasubjectcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.hashdeltasubjectcount = hashdeltasubjectcount;
        return _x;
    }

    @Property(name="recurrenceexpansionjobbatchinterval")
    @JsonIgnore
    public Optional<Integer> getRecurrenceexpansionjobbatchinterval() {
        return Optional.ofNullable(recurrenceexpansionjobbatchinterval);
    }

    public Organization withRecurrenceexpansionjobbatchinterval(Integer recurrenceexpansionjobbatchinterval) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("recurrenceexpansionjobbatchinterval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.recurrenceexpansionjobbatchinterval = recurrenceexpansionjobbatchinterval;
        return _x;
    }

    @Property(name="fiscalperiodformat")
    @JsonIgnore
    public Optional<String> getFiscalperiodformat() {
        return Optional.ofNullable(fiscalperiodformat);
    }

    public Organization withFiscalperiodformat(String fiscalperiodformat) {
        Checks.checkIsAscii(fiscalperiodformat);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalperiodformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalperiodformat = fiscalperiodformat;
        return _x;
    }

    @Property(name="officegraphdelveurl")
    @JsonIgnore
    public Optional<String> getOfficegraphdelveurl() {
        return Optional.ofNullable(officegraphdelveurl);
    }

    public Organization withOfficegraphdelveurl(String officegraphdelveurl) {
        Checks.checkIsAscii(officegraphdelveurl);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("officegraphdelveurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.officegraphdelveurl = officegraphdelveurl;
        return _x;
    }

    @Property(name="maxrecordsforlookupfilters")
    @JsonIgnore
    public Optional<Integer> getMaxrecordsforlookupfilters() {
        return Optional.ofNullable(maxrecordsforlookupfilters);
    }

    public Organization withMaxrecordsforlookupfilters(Integer maxrecordsforlookupfilters) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxrecordsforlookupfilters");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxrecordsforlookupfilters = maxrecordsforlookupfilters;
        return _x;
    }

    @Property(name="sharepointdeploymenttype")
    @JsonIgnore
    public Optional<Integer> getSharepointdeploymenttype() {
        return Optional.ofNullable(sharepointdeploymenttype);
    }

    public Organization withSharepointdeploymenttype(Integer sharepointdeploymenttype) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sharepointdeploymenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sharepointdeploymenttype = sharepointdeploymenttype;
        return _x;
    }

    @Property(name="isrelationshipinsightsenabled")
    @JsonIgnore
    public Optional<Boolean> getIsrelationshipinsightsenabled() {
        return Optional.ofNullable(isrelationshipinsightsenabled);
    }

    public Organization withIsrelationshipinsightsenabled(Boolean isrelationshipinsightsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isrelationshipinsightsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isrelationshipinsightsenabled = isrelationshipinsightsenabled;
        return _x;
    }

    @Property(name="requireapprovalforqueueemail")
    @JsonIgnore
    public Optional<Boolean> getRequireapprovalforqueueemail() {
        return Optional.ofNullable(requireapprovalforqueueemail);
    }

    public Organization withRequireapprovalforqueueemail(Boolean requireapprovalforqueueemail) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("requireapprovalforqueueemail");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.requireapprovalforqueueemail = requireapprovalforqueueemail;
        return _x;
    }

    @Property(name="tokenexpiry")
    @JsonIgnore
    public Optional<Integer> getTokenexpiry() {
        return Optional.ofNullable(tokenexpiry);
    }

    public Organization withTokenexpiry(Integer tokenexpiry) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("tokenexpiry");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.tokenexpiry = tokenexpiry;
        return _x;
    }

    @Property(name="postmessagewhitelistdomains")
    @JsonIgnore
    public Optional<String> getPostmessagewhitelistdomains() {
        return Optional.ofNullable(postmessagewhitelistdomains);
    }

    public Organization withPostmessagewhitelistdomains(String postmessagewhitelistdomains) {
        Checks.checkIsAscii(postmessagewhitelistdomains);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("postmessagewhitelistdomains");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.postmessagewhitelistdomains = postmessagewhitelistdomains;
        return _x;
    }

    @Property(name="localeid")
    @JsonIgnore
    public Optional<Integer> getLocaleid() {
        return Optional.ofNullable(localeid);
    }

    public Organization withLocaleid(Integer localeid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("localeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.localeid = localeid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Organization withCreatedon(OffsetDateTime createdon) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="isduplicatedetectionenabledforonlinecreateupdate")
    @JsonIgnore
    public Optional<Boolean> getIsduplicatedetectionenabledforonlinecreateupdate() {
        return Optional.ofNullable(isduplicatedetectionenabledforonlinecreateupdate);
    }

    public Organization withIsduplicatedetectionenabledforonlinecreateupdate(Boolean isduplicatedetectionenabledforonlinecreateupdate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isduplicatedetectionenabledforonlinecreateupdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isduplicatedetectionenabledforonlinecreateupdate = isduplicatedetectionenabledforonlinecreateupdate;
        return _x;
    }

    @Property(name="contentsecuritypolicyconfiguration")
    @JsonIgnore
    public Optional<String> getContentsecuritypolicyconfiguration() {
        return Optional.ofNullable(contentsecuritypolicyconfiguration);
    }

    public Organization withContentsecuritypolicyconfiguration(String contentsecuritypolicyconfiguration) {
        Checks.checkIsAscii(contentsecuritypolicyconfiguration);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("contentsecuritypolicyconfiguration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.contentsecuritypolicyconfiguration = contentsecuritypolicyconfiguration;
        return _x;
    }

    @Property(name="inactivitytimeoutenabled")
    @JsonIgnore
    public Optional<Boolean> getInactivitytimeoutenabled() {
        return Optional.ofNullable(inactivitytimeoutenabled);
    }

    public Organization withInactivitytimeoutenabled(Boolean inactivitytimeoutenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("inactivitytimeoutenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.inactivitytimeoutenabled = inactivitytimeoutenabled;
        return _x;
    }

    @Property(name="displaynavigationtour")
    @JsonIgnore
    public Optional<Boolean> getDisplaynavigationtour() {
        return Optional.ofNullable(displaynavigationtour);
    }

    public Organization withDisplaynavigationtour(Boolean displaynavigationtour) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("displaynavigationtour");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.displaynavigationtour = displaynavigationtour;
        return _x;
    }

    @Property(name="isautosaveenabled")
    @JsonIgnore
    public Optional<Boolean> getIsautosaveenabled() {
        return Optional.ofNullable(isautosaveenabled);
    }

    public Organization withIsautosaveenabled(Boolean isautosaveenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isautosaveenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isautosaveenabled = isautosaveenabled;
        return _x;
    }

    @Property(name="supportuserid")
    @JsonIgnore
    public Optional<String> getSupportuserid() {
        return Optional.ofNullable(supportuserid);
    }

    public Organization withSupportuserid(String supportuserid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("supportuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.supportuserid = supportuserid;
        return _x;
    }

    @Property(name="currencydisplayoption")
    @JsonIgnore
    public Optional<Integer> getCurrencydisplayoption() {
        return Optional.ofNullable(currencydisplayoption);
    }

    public Organization withCurrencydisplayoption(Integer currencydisplayoption) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("currencydisplayoption");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.currencydisplayoption = currencydisplayoption;
        return _x;
    }

    @Property(name="tokenkey")
    @JsonIgnore
    public Optional<String> getTokenkey() {
        return Optional.ofNullable(tokenkey);
    }

    public Organization withTokenkey(String tokenkey) {
        Checks.checkIsAscii(tokenkey);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("tokenkey");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.tokenkey = tokenkey;
        return _x;
    }

    @Property(name="pinpointlanguagecode")
    @JsonIgnore
    public Optional<Integer> getPinpointlanguagecode() {
        return Optional.ofNullable(pinpointlanguagecode);
    }

    public Organization withPinpointlanguagecode(Integer pinpointlanguagecode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("pinpointlanguagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.pinpointlanguagecode = pinpointlanguagecode;
        return _x;
    }

    @Property(name="isappointmentattachmentsyncenabled")
    @JsonIgnore
    public Optional<Boolean> getIsappointmentattachmentsyncenabled() {
        return Optional.ofNullable(isappointmentattachmentsyncenabled);
    }

    public Organization withIsappointmentattachmentsyncenabled(Boolean isappointmentattachmentsyncenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isappointmentattachmentsyncenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isappointmentattachmentsyncenabled = isappointmentattachmentsyncenabled;
        return _x;
    }

    @Property(name="isenabledforallroles")
    @JsonIgnore
    public Optional<Boolean> getIsenabledforallroles() {
        return Optional.ofNullable(isenabledforallroles);
    }

    public Organization withIsenabledforallroles(Boolean isenabledforallroles) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isenabledforallroles");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isenabledforallroles = isenabledforallroles;
        return _x;
    }

    @Property(name="enablelpauthoring")
    @JsonIgnore
    public Optional<Boolean> getEnablelpauthoring() {
        return Optional.ofNullable(enablelpauthoring);
    }

    public Organization withEnablelpauthoring(Boolean enablelpauthoring) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enablelpauthoring");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enablelpauthoring = enablelpauthoring;
        return _x;
    }

    @Property(name="mobileofflineminlicensetrial")
    @JsonIgnore
    public Optional<Integer> getMobileofflineminlicensetrial() {
        return Optional.ofNullable(mobileofflineminlicensetrial);
    }

    public Organization withMobileofflineminlicensetrial(Integer mobileofflineminlicensetrial) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineminlicensetrial");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.mobileofflineminlicensetrial = mobileofflineminlicensetrial;
        return _x;
    }

    @Property(name="auditretentionperiod")
    @JsonIgnore
    public Optional<Integer> getAuditretentionperiod() {
        return Optional.ofNullable(auditretentionperiod);
    }

    public Organization withAuditretentionperiod(Integer auditretentionperiod) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("auditretentionperiod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.auditretentionperiod = auditretentionperiod;
        return _x;
    }

    @Property(name="officeappsautodeploymentenabled")
    @JsonIgnore
    public Optional<Boolean> getOfficeappsautodeploymentenabled() {
        return Optional.ofNullable(officeappsautodeploymentenabled);
    }

    public Organization withOfficeappsautodeploymentenabled(Boolean officeappsautodeploymentenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("officeappsautodeploymentenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.officeappsautodeploymentenabled = officeappsautodeploymentenabled;
        return _x;
    }

    @Property(name="hashfilterkeywords")
    @JsonIgnore
    public Optional<String> getHashfilterkeywords() {
        return Optional.ofNullable(hashfilterkeywords);
    }

    public Organization withHashfilterkeywords(String hashfilterkeywords) {
        Checks.checkIsAscii(hashfilterkeywords);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("hashfilterkeywords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.hashfilterkeywords = hashfilterkeywords;
        return _x;
    }

    @Property(name="isnotesanalysisenabled")
    @JsonIgnore
    public Optional<Boolean> getIsnotesanalysisenabled() {
        return Optional.ofNullable(isnotesanalysisenabled);
    }

    public Organization withIsnotesanalysisenabled(Boolean isnotesanalysisenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isnotesanalysisenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isnotesanalysisenabled = isnotesanalysisenabled;
        return _x;
    }

    @Property(name="iscontactmailingaddresssyncenabled")
    @JsonIgnore
    public Optional<Boolean> getIscontactmailingaddresssyncenabled() {
        return Optional.ofNullable(iscontactmailingaddresssyncenabled);
    }

    public Organization withIscontactmailingaddresssyncenabled(Boolean iscontactmailingaddresssyncenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("iscontactmailingaddresssyncenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.iscontactmailingaddresssyncenabled = iscontactmailingaddresssyncenabled;
        return _x;
    }

    @Property(name="ismailboxforcedunlockingenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmailboxforcedunlockingenabled() {
        return Optional.ofNullable(ismailboxforcedunlockingenabled);
    }

    public Organization withIsmailboxforcedunlockingenabled(Boolean ismailboxforcedunlockingenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismailboxforcedunlockingenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismailboxforcedunlockingenabled = ismailboxforcedunlockingenabled;
        return _x;
    }

    @Property(name="isexternalfilestorageenabled")
    @JsonIgnore
    public Optional<Boolean> getIsexternalfilestorageenabled() {
        return Optional.ofNullable(isexternalfilestorageenabled);
    }

    public Organization withIsexternalfilestorageenabled(Boolean isexternalfilestorageenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isexternalfilestorageenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isexternalfilestorageenabled = isexternalfilestorageenabled;
        return _x;
    }

    @Property(name="mobileofflinesyncinterval")
    @JsonIgnore
    public Optional<Integer> getMobileofflinesyncinterval() {
        return Optional.ofNullable(mobileofflinesyncinterval);
    }

    public Organization withMobileofflinesyncinterval(Integer mobileofflinesyncinterval) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("mobileofflinesyncinterval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.mobileofflinesyncinterval = mobileofflinesyncinterval;
        return _x;
    }

    @Property(name="tagmaxaggressivecycles")
    @JsonIgnore
    public Optional<Integer> getTagmaxaggressivecycles() {
        return Optional.ofNullable(tagmaxaggressivecycles);
    }

    public Organization withTagmaxaggressivecycles(Integer tagmaxaggressivecycles) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("tagmaxaggressivecycles");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.tagmaxaggressivecycles = tagmaxaggressivecycles;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Organization withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="grantaccesstonetworkservice")
    @JsonIgnore
    public Optional<Boolean> getGrantaccesstonetworkservice() {
        return Optional.ofNullable(grantaccesstonetworkservice);
    }

    public Organization withGrantaccesstonetworkservice(Boolean grantaccesstonetworkservice) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("grantaccesstonetworkservice");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.grantaccesstonetworkservice = grantaccesstonetworkservice;
        return _x;
    }

    @Property(name="iscontentsecuritypolicyenabled")
    @JsonIgnore
    public Optional<Boolean> getIscontentsecuritypolicyenabled() {
        return Optional.ofNullable(iscontentsecuritypolicyenabled);
    }

    public Organization withIscontentsecuritypolicyenabled(Boolean iscontentsecuritypolicyenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("iscontentsecuritypolicyenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.iscontentsecuritypolicyenabled = iscontentsecuritypolicyenabled;
        return _x;
    }

    @Property(name="isdelveactionhubintegrationenabled")
    @JsonIgnore
    public Optional<Boolean> getIsdelveactionhubintegrationenabled() {
        return Optional.ofNullable(isdelveactionhubintegrationenabled);
    }

    public Organization withIsdelveactionhubintegrationenabled(Boolean isdelveactionhubintegrationenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isdelveactionhubintegrationenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isdelveactionhubintegrationenabled = isdelveactionhubintegrationenabled;
        return _x;
    }

    @Property(name="allowoutlookscheduledsyncs")
    @JsonIgnore
    public Optional<Boolean> getAllowoutlookscheduledsyncs() {
        return Optional.ofNullable(allowoutlookscheduledsyncs);
    }

    public Organization withAllowoutlookscheduledsyncs(Boolean allowoutlookscheduledsyncs) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowoutlookscheduledsyncs");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowoutlookscheduledsyncs = allowoutlookscheduledsyncs;
        return _x;
    }

    @Property(name="maximumdynamicpropertiesallowed")
    @JsonIgnore
    public Optional<Integer> getMaximumdynamicpropertiesallowed() {
        return Optional.ofNullable(maximumdynamicpropertiesallowed);
    }

    public Organization withMaximumdynamicpropertiesallowed(Integer maximumdynamicpropertiesallowed) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maximumdynamicpropertiesallowed");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maximumdynamicpropertiesallowed = maximumdynamicpropertiesallowed;
        return _x;
    }

    @Property(name="numbergroupformat")
    @JsonIgnore
    public Optional<String> getNumbergroupformat() {
        return Optional.ofNullable(numbergroupformat);
    }

    public Organization withNumbergroupformat(String numbergroupformat) {
        Checks.checkIsAscii(numbergroupformat);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("numbergroupformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.numbergroupformat = numbergroupformat;
        return _x;
    }

    @Property(name="entityimageid")
    @JsonIgnore
    public Optional<String> getEntityimageid() {
        return Optional.ofNullable(entityimageid);
    }

    public Organization withEntityimageid(String entityimageid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("entityimageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.entityimageid = entityimageid;
        return _x;
    }

    @Property(name="trackingtokeniddigits")
    @JsonIgnore
    public Optional<Integer> getTrackingtokeniddigits() {
        return Optional.ofNullable(trackingtokeniddigits);
    }

    public Organization withTrackingtokeniddigits(Integer trackingtokeniddigits) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("trackingtokeniddigits");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.trackingtokeniddigits = trackingtokeniddigits;
        return _x;
    }

    @Property(name="defaultrecurrenceendrangetype")
    @JsonIgnore
    public Optional<Integer> getDefaultrecurrenceendrangetype() {
        return Optional.ofNullable(defaultrecurrenceendrangetype);
    }

    public Organization withDefaultrecurrenceendrangetype(Integer defaultrecurrenceendrangetype) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("defaultrecurrenceendrangetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.defaultrecurrenceendrangetype = defaultrecurrenceendrangetype;
        return _x;
    }

    @Property(name="yammernetworkpermalink")
    @JsonIgnore
    public Optional<String> getYammernetworkpermalink() {
        return Optional.ofNullable(yammernetworkpermalink);
    }

    public Organization withYammernetworkpermalink(String yammernetworkpermalink) {
        Checks.checkIsAscii(yammernetworkpermalink);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("yammernetworkpermalink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.yammernetworkpermalink = yammernetworkpermalink;
        return _x;
    }

    @Property(name="bulkoperationprefix")
    @JsonIgnore
    public Optional<String> getBulkoperationprefix() {
        return Optional.ofNullable(bulkoperationprefix);
    }

    public Organization withBulkoperationprefix(String bulkoperationprefix) {
        Checks.checkIsAscii(bulkoperationprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("bulkoperationprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.bulkoperationprefix = bulkoperationprefix;
        return _x;
    }

    @Property(name="oobpricecalculationenabled")
    @JsonIgnore
    public Optional<Boolean> getOobpricecalculationenabled() {
        return Optional.ofNullable(oobpricecalculationenabled);
    }

    public Organization withOobpricecalculationenabled(Boolean oobpricecalculationenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("oobpricecalculationenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.oobpricecalculationenabled = oobpricecalculationenabled;
        return _x;
    }

    @Property(name="futureexpansionwindow")
    @JsonIgnore
    public Optional<Integer> getFutureexpansionwindow() {
        return Optional.ofNullable(futureexpansionwindow);
    }

    public Organization withFutureexpansionwindow(Integer futureexpansionwindow) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("futureexpansionwindow");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.futureexpansionwindow = futureexpansionwindow;
        return _x;
    }

    @Property(name="ispresenceenabled")
    @JsonIgnore
    public Optional<Boolean> getIspresenceenabled() {
        return Optional.ofNullable(ispresenceenabled);
    }

    public Organization withIspresenceenabled(Boolean ispresenceenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ispresenceenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ispresenceenabled = ispresenceenabled;
        return _x;
    }

    @Property(name="pastexpansionwindow")
    @JsonIgnore
    public Optional<Integer> getPastexpansionwindow() {
        return Optional.ofNullable(pastexpansionwindow);
    }

    public Organization withPastexpansionwindow(Integer pastexpansionwindow) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("pastexpansionwindow");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.pastexpansionwindow = pastexpansionwindow;
        return _x;
    }

    @Property(name="maximumslakpiperentitywithactivesla")
    @JsonIgnore
    public Optional<Integer> getMaximumslakpiperentitywithactivesla() {
        return Optional.ofNullable(maximumslakpiperentitywithactivesla);
    }

    public Organization withMaximumslakpiperentitywithactivesla(Integer maximumslakpiperentitywithactivesla) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maximumslakpiperentitywithactivesla");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maximumslakpiperentitywithactivesla = maximumslakpiperentitywithactivesla;
        return _x;
    }

    @Property(name="ismsteamssettingchangedbyuser")
    @JsonIgnore
    public Optional<Boolean> getIsmsteamssettingchangedbyuser() {
        return Optional.ofNullable(ismsteamssettingchangedbyuser);
    }

    public Organization withIsmsteamssettingchangedbyuser(Boolean ismsteamssettingchangedbyuser) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismsteamssettingchangedbyuser");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismsteamssettingchangedbyuser = ismsteamssettingchangedbyuser;
        return _x;
    }

    @Property(name="picture")
    @JsonIgnore
    public Optional<String> getPicture() {
        return Optional.ofNullable(picture);
    }

    public Organization withPicture(String picture) {
        Checks.checkIsAscii(picture);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("picture");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.picture = picture;
        return _x;
    }

    @Property(name="azureschedulerjobcollectionname")
    @JsonIgnore
    public Optional<String> getAzureschedulerjobcollectionname() {
        return Optional.ofNullable(azureschedulerjobcollectionname);
    }

    public Organization withAzureschedulerjobcollectionname(String azureschedulerjobcollectionname) {
        Checks.checkIsAscii(azureschedulerjobcollectionname);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("azureschedulerjobcollectionname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.azureschedulerjobcollectionname = azureschedulerjobcollectionname;
        return _x;
    }

    @Property(name="isofficegraphenabled")
    @JsonIgnore
    public Optional<Boolean> getIsofficegraphenabled() {
        return Optional.ofNullable(isofficegraphenabled);
    }

    public Organization withIsofficegraphenabled(Boolean isofficegraphenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isofficegraphenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isofficegraphenabled = isofficegraphenabled;
        return _x;
    }

    @Property(name="orgdborgsettings")
    @JsonIgnore
    public Optional<String> getOrgdborgsettings() {
        return Optional.ofNullable(orgdborgsettings);
    }

    public Organization withOrgdborgsettings(String orgdborgsettings) {
        Checks.checkIsAscii(orgdborgsettings);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("orgdborgsettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.orgdborgsettings = orgdborgsettings;
        return _x;
    }

    @Property(name="ismodeldrivenappsinmsteamsenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmodeldrivenappsinmsteamsenabled() {
        return Optional.ofNullable(ismodeldrivenappsinmsteamsenabled);
    }

    public Organization withIsmodeldrivenappsinmsteamsenabled(Boolean ismodeldrivenappsinmsteamsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismodeldrivenappsinmsteamsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismodeldrivenappsinmsteamsenabled = ismodeldrivenappsinmsteamsenabled;
        return _x;
    }

    @Property(name="rierrorstatus")
    @JsonIgnore
    public Optional<Integer> getRierrorstatus() {
        return Optional.ofNullable(rierrorstatus);
    }

    public Organization withRierrorstatus(Integer rierrorstatus) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("rierrorstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.rierrorstatus = rierrorstatus;
        return _x;
    }

    @Property(name="allowlegacydialogsembedding")
    @JsonIgnore
    public Optional<Boolean> getAllowlegacydialogsembedding() {
        return Optional.ofNullable(allowlegacydialogsembedding);
    }

    public Organization withAllowlegacydialogsembedding(Boolean allowlegacydialogsembedding) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowlegacydialogsembedding");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowlegacydialogsembedding = allowlegacydialogsembedding;
        return _x;
    }

    @Property(name="emailcorrelationenabled")
    @JsonIgnore
    public Optional<Boolean> getEmailcorrelationenabled() {
        return Optional.ofNullable(emailcorrelationenabled);
    }

    public Organization withEmailcorrelationenabled(Boolean emailcorrelationenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("emailcorrelationenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.emailcorrelationenabled = emailcorrelationenabled;
        return _x;
    }

    @Property(name="maxappointmentdurationdays")
    @JsonIgnore
    public Optional<Integer> getMaxappointmentdurationdays() {
        return Optional.ofNullable(maxappointmentdurationdays);
    }

    public Organization withMaxappointmentdurationdays(Integer maxappointmentdurationdays) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxappointmentdurationdays");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxappointmentdurationdays = maxappointmentdurationdays;
        return _x;
    }

    @Property(name="microsoftflowenvironment")
    @JsonIgnore
    public Optional<String> getMicrosoftflowenvironment() {
        return Optional.ofNullable(microsoftflowenvironment);
    }

    public Organization withMicrosoftflowenvironment(String microsoftflowenvironment) {
        Checks.checkIsAscii(microsoftflowenvironment);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("microsoftflowenvironment");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.microsoftflowenvironment = microsoftflowenvironment;
        return _x;
    }

    @Property(name="tracelogmaximumageindays")
    @JsonIgnore
    public Optional<Integer> getTracelogmaximumageindays() {
        return Optional.ofNullable(tracelogmaximumageindays);
    }

    public Organization withTracelogmaximumageindays(Integer tracelogmaximumageindays) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("tracelogmaximumageindays");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.tracelogmaximumageindays = tracelogmaximumageindays;
        return _x;
    }

    @Property(name="isduplicatedetectionenabledforimport")
    @JsonIgnore
    public Optional<Boolean> getIsduplicatedetectionenabledforimport() {
        return Optional.ofNullable(isduplicatedetectionenabledforimport);
    }

    public Organization withIsduplicatedetectionenabledforimport(Boolean isduplicatedetectionenabledforimport) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isduplicatedetectionenabledforimport");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isduplicatedetectionenabledforimport = isduplicatedetectionenabledforimport;
        return _x;
    }

    @Property(name="iscustomcontrolsincanvasappsenabled")
    @JsonIgnore
    public Optional<Boolean> getIscustomcontrolsincanvasappsenabled() {
        return Optional.ofNullable(iscustomcontrolsincanvasappsenabled);
    }

    public Organization withIscustomcontrolsincanvasappsenabled(Boolean iscustomcontrolsincanvasappsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("iscustomcontrolsincanvasappsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.iscustomcontrolsincanvasappsenabled = iscustomcontrolsincanvasappsenabled;
        return _x;
    }

    @Property(name="enforcereadonlyplugins")
    @JsonIgnore
    public Optional<Boolean> getEnforcereadonlyplugins() {
        return Optional.ofNullable(enforcereadonlyplugins);
    }

    public Organization withEnforcereadonlyplugins(Boolean enforcereadonlyplugins) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enforcereadonlyplugins");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enforcereadonlyplugins = enforcereadonlyplugins;
        return _x;
    }

    @Property(name="createproductswithoutparentinactivestate")
    @JsonIgnore
    public Optional<Boolean> getCreateproductswithoutparentinactivestate() {
        return Optional.ofNullable(createproductswithoutparentinactivestate);
    }

    public Organization withCreateproductswithoutparentinactivestate(Boolean createproductswithoutparentinactivestate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("createproductswithoutparentinactivestate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.createproductswithoutparentinactivestate = createproductswithoutparentinactivestate;
        return _x;
    }

    @Property(name="enableunifiedinterfaceshellrefresh")
    @JsonIgnore
    public Optional<Boolean> getEnableunifiedinterfaceshellrefresh() {
        return Optional.ofNullable(enableunifiedinterfaceshellrefresh);
    }

    public Organization withEnableunifiedinterfaceshellrefresh(Boolean enableunifiedinterfaceshellrefresh) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enableunifiedinterfaceshellrefresh");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enableunifiedinterfaceshellrefresh = enableunifiedinterfaceshellrefresh;
        return _x;
    }

    @Property(name="textanalyticsenabled")
    @JsonIgnore
    public Optional<Boolean> getTextanalyticsenabled() {
        return Optional.ofNullable(textanalyticsenabled);
    }

    public Organization withTextanalyticsenabled(Boolean textanalyticsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("textanalyticsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.textanalyticsenabled = textanalyticsenabled;
        return _x;
    }

    @Property(name="expirechangetrackingindays")
    @JsonIgnore
    public Optional<Integer> getExpirechangetrackingindays() {
        return Optional.ofNullable(expirechangetrackingindays);
    }

    public Organization withExpirechangetrackingindays(Integer expirechangetrackingindays) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("expirechangetrackingindays");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.expirechangetrackingindays = expirechangetrackingindays;
        return _x;
    }

    @Property(name="usereadform")
    @JsonIgnore
    public Optional<Boolean> getUsereadform() {
        return Optional.ofNullable(usereadform);
    }

    public Organization withUsereadform(Boolean usereadform) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("usereadform");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.usereadform = usereadform;
        return _x;
    }

    @Property(name="basecurrencysymbol")
    @JsonIgnore
    public Optional<String> getBasecurrencysymbol() {
        return Optional.ofNullable(basecurrencysymbol);
    }

    public Organization withBasecurrencysymbol(String basecurrencysymbol) {
        Checks.checkIsAscii(basecurrencysymbol);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("basecurrencysymbol");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.basecurrencysymbol = basecurrencysymbol;
        return _x;
    }

    @Property(name="fiscalyearperiodconnect")
    @JsonIgnore
    public Optional<String> getFiscalyearperiodconnect() {
        return Optional.ofNullable(fiscalyearperiodconnect);
    }

    public Organization withFiscalyearperiodconnect(String fiscalyearperiodconnect) {
        Checks.checkIsAscii(fiscalyearperiodconnect);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalyearperiodconnect");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalyearperiodconnect = fiscalyearperiodconnect;
        return _x;
    }

    @Property(name="maxsupportedinternetexplorerversion")
    @JsonIgnore
    public Optional<Integer> getMaxsupportedinternetexplorerversion() {
        return Optional.ofNullable(maxsupportedinternetexplorerversion);
    }

    public Organization withMaxsupportedinternetexplorerversion(Integer maxsupportedinternetexplorerversion) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxsupportedinternetexplorerversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxsupportedinternetexplorerversion = maxsupportedinternetexplorerversion;
        return _x;
    }

    @Property(name="fiscalperiodformatperiod")
    @JsonIgnore
    public Optional<Integer> getFiscalperiodformatperiod() {
        return Optional.ofNullable(fiscalperiodformatperiod);
    }

    public Organization withFiscalperiodformatperiod(Integer fiscalperiodformatperiod) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalperiodformatperiod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalperiodformatperiod = fiscalperiodformatperiod;
        return _x;
    }

    @Property(name="bingmapsapikey")
    @JsonIgnore
    public Optional<String> getBingmapsapikey() {
        return Optional.ofNullable(bingmapsapikey);
    }

    public Organization withBingmapsapikey(String bingmapsapikey) {
        Checks.checkIsAscii(bingmapsapikey);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("bingmapsapikey");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.bingmapsapikey = bingmapsapikey;
        return _x;
    }

    @Property(name="isactionsupportfeatureenabled")
    @JsonIgnore
    public Optional<Boolean> getIsactionsupportfeatureenabled() {
        return Optional.ofNullable(isactionsupportfeatureenabled);
    }

    public Organization withIsactionsupportfeatureenabled(Boolean isactionsupportfeatureenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isactionsupportfeatureenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isactionsupportfeatureenabled = isactionsupportfeatureenabled;
        return _x;
    }

    @Property(name="restrictstatusupdate")
    @JsonIgnore
    public Optional<Boolean> getRestrictstatusupdate() {
        return Optional.ofNullable(restrictstatusupdate);
    }

    public Organization withRestrictstatusupdate(Boolean restrictstatusupdate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("restrictstatusupdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.restrictstatusupdate = restrictstatusupdate;
        return _x;
    }

    @Property(name="defaultthemedata")
    @JsonIgnore
    public Optional<String> getDefaultthemedata() {
        return Optional.ofNullable(defaultthemedata);
    }

    public Organization withDefaultthemedata(String defaultthemedata) {
        Checks.checkIsAscii(defaultthemedata);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("defaultthemedata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.defaultthemedata = defaultthemedata;
        return _x;
    }

    @Property(name="isonedriveenabled")
    @JsonIgnore
    public Optional<Boolean> getIsonedriveenabled() {
        return Optional.ofNullable(isonedriveenabled);
    }

    public Organization withIsonedriveenabled(Boolean isonedriveenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isonedriveenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isonedriveenabled = isonedriveenabled;
        return _x;
    }

    @Property(name="externalpartycorrelationkeys")
    @JsonIgnore
    public Optional<String> getExternalpartycorrelationkeys() {
        return Optional.ofNullable(externalpartycorrelationkeys);
    }

    public Organization withExternalpartycorrelationkeys(String externalpartycorrelationkeys) {
        Checks.checkIsAscii(externalpartycorrelationkeys);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("externalpartycorrelationkeys");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.externalpartycorrelationkeys = externalpartycorrelationkeys;
        return _x;
    }

    @Property(name="auditretentionperiodv2")
    @JsonIgnore
    public Optional<Integer> getAuditretentionperiodv2() {
        return Optional.ofNullable(auditretentionperiodv2);
    }

    public Organization withAuditretentionperiodv2(Integer auditretentionperiodv2) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("auditretentionperiodv2");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.auditretentionperiodv2 = auditretentionperiodv2;
        return _x;
    }

    @Property(name="negativeformatcode")
    @JsonIgnore
    public Optional<Integer> getNegativeformatcode() {
        return Optional.ofNullable(negativeformatcode);
    }

    public Organization withNegativeformatcode(Integer negativeformatcode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("negativeformatcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.negativeformatcode = negativeformatcode;
        return _x;
    }

    @Property(name="ispricelistmandatory")
    @JsonIgnore
    public Optional<Boolean> getIspricelistmandatory() {
        return Optional.ofNullable(ispricelistmandatory);
    }

    public Organization withIspricelistmandatory(Boolean ispricelistmandatory) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ispricelistmandatory");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ispricelistmandatory = ispricelistmandatory;
        return _x;
    }

    @Property(name="timeseparator")
    @JsonIgnore
    public Optional<String> getTimeseparator() {
        return Optional.ofNullable(timeseparator);
    }

    public Organization withTimeseparator(String timeseparator) {
        Checks.checkIsAscii(timeseparator);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("timeseparator");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.timeseparator = timeseparator;
        return _x;
    }

    @Property(name="maxproductsinbundle")
    @JsonIgnore
    public Optional<Integer> getMaxproductsinbundle() {
        return Optional.ofNullable(maxproductsinbundle);
    }

    public Organization withMaxproductsinbundle(Integer maxproductsinbundle) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxproductsinbundle");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxproductsinbundle = maxproductsinbundle;
        return _x;
    }

    @Property(name="slapausestates")
    @JsonIgnore
    public Optional<String> getSlapausestates() {
        return Optional.ofNullable(slapausestates);
    }

    public Organization withSlapausestates(String slapausestates) {
        Checks.checkIsAscii(slapausestates);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("slapausestates");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.slapausestates = slapausestates;
        return _x;
    }

    @Property(name="v3calloutconfighash")
    @JsonIgnore
    public Optional<String> getV3calloutconfighash() {
        return Optional.ofNullable(v3calloutconfighash);
    }

    public Organization withV3calloutconfighash(String v3calloutconfighash) {
        Checks.checkIsAscii(v3calloutconfighash);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("v3calloutconfighash");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.v3calloutconfighash = v3calloutconfighash;
        return _x;
    }

    @Property(name="plugintracelogsetting")
    @JsonIgnore
    public Optional<Integer> getPlugintracelogsetting() {
        return Optional.ofNullable(plugintracelogsetting);
    }

    public Organization withPlugintracelogsetting(Integer plugintracelogsetting) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("plugintracelogsetting");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.plugintracelogsetting = plugintracelogsetting;
        return _x;
    }

    @Property(name="syncoptinselectionstatus")
    @JsonIgnore
    public Optional<Integer> getSyncoptinselectionstatus() {
        return Optional.ofNullable(syncoptinselectionstatus);
    }

    public Organization withSyncoptinselectionstatus(Integer syncoptinselectionstatus) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("syncoptinselectionstatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.syncoptinselectionstatus = syncoptinselectionstatus;
        return _x;
    }

    @Property(name="syncbulkoperationmaxlimit")
    @JsonIgnore
    public Optional<Integer> getSyncbulkoperationmaxlimit() {
        return Optional.ofNullable(syncbulkoperationmaxlimit);
    }

    public Organization withSyncbulkoperationmaxlimit(Integer syncbulkoperationmaxlimit) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("syncbulkoperationmaxlimit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.syncbulkoperationmaxlimit = syncbulkoperationmaxlimit;
        return _x;
    }

    @Property(name="allowofflinescheduledsyncs")
    @JsonIgnore
    public Optional<Boolean> getAllowofflinescheduledsyncs() {
        return Optional.ofNullable(allowofflinescheduledsyncs);
    }

    public Organization withAllowofflinescheduledsyncs(Boolean allowofflinescheduledsyncs) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowofflinescheduledsyncs");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowofflinescheduledsyncs = allowofflinescheduledsyncs;
        return _x;
    }

    @Property(name="basecurrencyprecision")
    @JsonIgnore
    public Optional<Integer> getBasecurrencyprecision() {
        return Optional.ofNullable(basecurrencyprecision);
    }

    public Organization withBasecurrencyprecision(Integer basecurrencyprecision) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("basecurrencyprecision");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.basecurrencyprecision = basecurrencyprecision;
        return _x;
    }

    @Property(name="socialinsightsinstance")
    @JsonIgnore
    public Optional<String> getSocialinsightsinstance() {
        return Optional.ofNullable(socialinsightsinstance);
    }

    public Organization withSocialinsightsinstance(String socialinsightsinstance) {
        Checks.checkIsAscii(socialinsightsinstance);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("socialinsightsinstance");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.socialinsightsinstance = socialinsightsinstance;
        return _x;
    }

    @Property(name="ishierarchicalsecuritymodelenabled")
    @JsonIgnore
    public Optional<Boolean> getIshierarchicalsecuritymodelenabled() {
        return Optional.ofNullable(ishierarchicalsecuritymodelenabled);
    }

    public Organization withIshierarchicalsecuritymodelenabled(Boolean ishierarchicalsecuritymodelenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ishierarchicalsecuritymodelenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ishierarchicalsecuritymodelenabled = ishierarchicalsecuritymodelenabled;
        return _x;
    }

    @Property(name="privacystatementurl")
    @JsonIgnore
    public Optional<String> getPrivacystatementurl() {
        return Optional.ofNullable(privacystatementurl);
    }

    public Organization withPrivacystatementurl(String privacystatementurl) {
        Checks.checkIsAscii(privacystatementurl);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("privacystatementurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.privacystatementurl = privacystatementurl;
        return _x;
    }

    @Property(name="minoutlooksyncinterval")
    @JsonIgnore
    public Optional<Integer> getMinoutlooksyncinterval() {
        return Optional.ofNullable(minoutlooksyncinterval);
    }

    public Organization withMinoutlooksyncinterval(Integer minoutlooksyncinterval) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("minoutlooksyncinterval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.minoutlooksyncinterval = minoutlooksyncinterval;
        return _x;
    }

    @Property(name="currentimportsequencenumber")
    @JsonIgnore
    public Optional<Integer> getCurrentimportsequencenumber() {
        return Optional.ofNullable(currentimportsequencenumber);
    }

    public Organization withCurrentimportsequencenumber(Integer currentimportsequencenumber) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("currentimportsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.currentimportsequencenumber = currentimportsequencenumber;
        return _x;
    }

    @Property(name="isuseraccessauditenabled")
    @JsonIgnore
    public Optional<Boolean> getIsuseraccessauditenabled() {
        return Optional.ofNullable(isuseraccessauditenabled);
    }

    public Organization withIsuseraccessauditenabled(Boolean isuseraccessauditenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isuseraccessauditenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isuseraccessauditenabled = isuseraccessauditenabled;
        return _x;
    }

    @Property(name="fiscalyearformatprefix")
    @JsonIgnore
    public Optional<Integer> getFiscalyearformatprefix() {
        return Optional.ofNullable(fiscalyearformatprefix);
    }

    public Organization withFiscalyearformatprefix(Integer fiscalyearformatprefix) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalyearformatprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalyearformatprefix = fiscalyearformatprefix;
        return _x;
    }

    @Property(name="enablebingmapsintegration")
    @JsonIgnore
    public Optional<Boolean> getEnablebingmapsintegration() {
        return Optional.ofNullable(enablebingmapsintegration);
    }

    public Organization withEnablebingmapsintegration(Boolean enablebingmapsintegration) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enablebingmapsintegration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enablebingmapsintegration = enablebingmapsintegration;
        return _x;
    }

    @Property(name="maxslaitemspersla")
    @JsonIgnore
    public Optional<Integer> getMaxslaitemspersla() {
        return Optional.ofNullable(maxslaitemspersla);
    }

    public Organization withMaxslaitemspersla(Integer maxslaitemspersla) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxslaitemspersla");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxslaitemspersla = maxslaitemspersla;
        return _x;
    }

    @Property(name="syncbulkoperationbatchsize")
    @JsonIgnore
    public Optional<Integer> getSyncbulkoperationbatchsize() {
        return Optional.ofNullable(syncbulkoperationbatchsize);
    }

    public Organization withSyncbulkoperationbatchsize(Integer syncbulkoperationbatchsize) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("syncbulkoperationbatchsize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.syncbulkoperationbatchsize = syncbulkoperationbatchsize;
        return _x;
    }

    @Property(name="tagpollingperiod")
    @JsonIgnore
    public Optional<Integer> getTagpollingperiod() {
        return Optional.ofNullable(tagpollingperiod);
    }

    public Organization withTagpollingperiod(Integer tagpollingperiod) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("tagpollingperiod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.tagpollingperiod = tagpollingperiod;
        return _x;
    }

    @Property(name="suppresssla")
    @JsonIgnore
    public Optional<Boolean> getSuppresssla() {
        return Optional.ofNullable(suppresssla);
    }

    public Organization withSuppresssla(Boolean suppresssla) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("suppresssla");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.suppresssla = suppresssla;
        return _x;
    }

    @Property(name="clientfeatureset")
    @JsonIgnore
    public Optional<String> getClientfeatureset() {
        return Optional.ofNullable(clientfeatureset);
    }

    public Organization withClientfeatureset(String clientfeatureset) {
        Checks.checkIsAscii(clientfeatureset);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("clientfeatureset");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.clientfeatureset = clientfeatureset;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Organization withVersionnumber(Long versionnumber) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="isemailmonitoringallowed")
    @JsonIgnore
    public Optional<Boolean> getIsemailmonitoringallowed() {
        return Optional.ofNullable(isemailmonitoringallowed);
    }

    public Organization withIsemailmonitoringallowed(Boolean isemailmonitoringallowed) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isemailmonitoringallowed");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isemailmonitoringallowed = isemailmonitoringallowed;
        return _x;
    }

    @Property(name="maxverboseloggingmailbox")
    @JsonIgnore
    public Optional<Integer> getMaxverboseloggingmailbox() {
        return Optional.ofNullable(maxverboseloggingmailbox);
    }

    public Organization withMaxverboseloggingmailbox(Integer maxverboseloggingmailbox) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxverboseloggingmailbox");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxverboseloggingmailbox = maxverboseloggingmailbox;
        return _x;
    }

    @Property(name="ismanualsalesforecastingenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmanualsalesforecastingenabled() {
        return Optional.ofNullable(ismanualsalesforecastingenabled);
    }

    public Organization withIsmanualsalesforecastingenabled(Boolean ismanualsalesforecastingenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismanualsalesforecastingenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismanualsalesforecastingenabled = ismanualsalesforecastingenabled;
        return _x;
    }

    @Property(name="isduplicatedetectionenabled")
    @JsonIgnore
    public Optional<Boolean> getIsduplicatedetectionenabled() {
        return Optional.ofNullable(isduplicatedetectionenabled);
    }

    public Organization withIsduplicatedetectionenabled(Boolean isduplicatedetectionenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isduplicatedetectionenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isduplicatedetectionenabled = isduplicatedetectionenabled;
        return _x;
    }

    @Property(name="schemanameprefix")
    @JsonIgnore
    public Optional<String> getSchemanameprefix() {
        return Optional.ofNullable(schemanameprefix);
    }

    public Organization withSchemanameprefix(String schemanameprefix) {
        Checks.checkIsAscii(schemanameprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("schemanameprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.schemanameprefix = schemanameprefix;
        return _x;
    }

    @Property(name="paipreviewscenarioenabled")
    @JsonIgnore
    public Optional<Boolean> getPaipreviewscenarioenabled() {
        return Optional.ofNullable(paipreviewscenarioenabled);
    }

    public Organization withPaipreviewscenarioenabled(Boolean paipreviewscenarioenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("paipreviewscenarioenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.paipreviewscenarioenabled = paipreviewscenarioenabled;
        return _x;
    }

    @Property(name="autoapplysla")
    @JsonIgnore
    public Optional<Boolean> getAutoapplysla() {
        return Optional.ofNullable(autoapplysla);
    }

    public Organization withAutoapplysla(Boolean autoapplysla) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("autoapplysla");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.autoapplysla = autoapplysla;
        return _x;
    }

    @Property(name="ismsteamscollaborationenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmsteamscollaborationenabled() {
        return Optional.ofNullable(ismsteamscollaborationenabled);
    }

    public Organization withIsmsteamscollaborationenabled(Boolean ismsteamscollaborationenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismsteamscollaborationenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismsteamscollaborationenabled = ismsteamscollaborationenabled;
        return _x;
    }

    @Property(name="incomingemailexchangeemailretrievalbatchsize")
    @JsonIgnore
    public Optional<Integer> getIncomingemailexchangeemailretrievalbatchsize() {
        return Optional.ofNullable(incomingemailexchangeemailretrievalbatchsize);
    }

    public Organization withIncomingemailexchangeemailretrievalbatchsize(Integer incomingemailexchangeemailretrievalbatchsize) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("incomingemailexchangeemailretrievalbatchsize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.incomingemailexchangeemailretrievalbatchsize = incomingemailexchangeemailretrievalbatchsize;
        return _x;
    }

    @Property(name="ismailboxinactivebackoffenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmailboxinactivebackoffenabled() {
        return Optional.ofNullable(ismailboxinactivebackoffenabled);
    }

    public Organization withIsmailboxinactivebackoffenabled(Boolean ismailboxinactivebackoffenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismailboxinactivebackoffenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismailboxinactivebackoffenabled = ismailboxinactivebackoffenabled;
        return _x;
    }

    @Property(name="cortanaproactiveexperienceenabled")
    @JsonIgnore
    public Optional<Boolean> getCortanaproactiveexperienceenabled() {
        return Optional.ofNullable(cortanaproactiveexperienceenabled);
    }

    public Organization withCortanaproactiveexperienceenabled(Boolean cortanaproactiveexperienceenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("cortanaproactiveexperienceenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.cortanaproactiveexperienceenabled = cortanaproactiveexperienceenabled;
        return _x;
    }

    @Property(name="goalrollupexpirytime")
    @JsonIgnore
    public Optional<Integer> getGoalrollupexpirytime() {
        return Optional.ofNullable(goalrollupexpirytime);
    }

    public Organization withGoalrollupexpirytime(Integer goalrollupexpirytime) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("goalrollupexpirytime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.goalrollupexpirytime = goalrollupexpirytime;
        return _x;
    }

    @Property(name="isplaybookenabled")
    @JsonIgnore
    public Optional<Boolean> getIsplaybookenabled() {
        return Optional.ofNullable(isplaybookenabled);
    }

    public Organization withIsplaybookenabled(Boolean isplaybookenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isplaybookenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isplaybookenabled = isplaybookenabled;
        return _x;
    }

    @Property(name="showkbarticledeprecationnotification")
    @JsonIgnore
    public Optional<Boolean> getShowkbarticledeprecationnotification() {
        return Optional.ofNullable(showkbarticledeprecationnotification);
    }

    public Organization withShowkbarticledeprecationnotification(Boolean showkbarticledeprecationnotification) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("showkbarticledeprecationnotification");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.showkbarticledeprecationnotification = showkbarticledeprecationnotification;
        return _x;
    }

    @Property(name="isappmode")
    @JsonIgnore
    public Optional<Boolean> getIsappmode() {
        return Optional.ofNullable(isappmode);
    }

    public Organization withIsappmode(Boolean isappmode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isappmode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isappmode = isappmode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Organization with_modifiedby_value(String _modifiedby_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="contractprefix")
    @JsonIgnore
    public Optional<String> getContractprefix() {
        return Optional.ofNullable(contractprefix);
    }

    public Organization withContractprefix(String contractprefix) {
        Checks.checkIsAscii(contractprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("contractprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.contractprefix = contractprefix;
        return _x;
    }

    @Property(name="allowautounsubscribe")
    @JsonIgnore
    public Optional<Boolean> getAllowautounsubscribe() {
        return Optional.ofNullable(allowautounsubscribe);
    }

    public Organization withAllowautounsubscribe(Boolean allowautounsubscribe) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowautounsubscribe");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowautounsubscribe = allowautounsubscribe;
        return _x;
    }

    @Property(name="ignoreinternalemail")
    @JsonIgnore
    public Optional<Boolean> getIgnoreinternalemail() {
        return Optional.ofNullable(ignoreinternalemail);
    }

    public Organization withIgnoreinternalemail(Boolean ignoreinternalemail) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ignoreinternalemail");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ignoreinternalemail = ignoreinternalemail;
        return _x;
    }

    @Property(name="ispreviewforautocaptureenabled")
    @JsonIgnore
    public Optional<Boolean> getIspreviewforautocaptureenabled() {
        return Optional.ofNullable(ispreviewforautocaptureenabled);
    }

    public Organization withIspreviewforautocaptureenabled(Boolean ispreviewforautocaptureenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ispreviewforautocaptureenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ispreviewforautocaptureenabled = ispreviewforautocaptureenabled;
        return _x;
    }

    @Property(name="minofflinesyncinterval")
    @JsonIgnore
    public Optional<Integer> getMinofflinesyncinterval() {
        return Optional.ofNullable(minofflinesyncinterval);
    }

    public Organization withMinofflinesyncinterval(Integer minofflinesyncinterval) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("minofflinesyncinterval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.minofflinesyncinterval = minofflinesyncinterval;
        return _x;
    }

    @Property(name="highcontrastthemedata")
    @JsonIgnore
    public Optional<String> getHighcontrastthemedata() {
        return Optional.ofNullable(highcontrastthemedata);
    }

    public Organization withHighcontrastthemedata(String highcontrastthemedata) {
        Checks.checkIsAscii(highcontrastthemedata);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("highcontrastthemedata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.highcontrastthemedata = highcontrastthemedata;
        return _x;
    }

    @Property(name="systemuserid")
    @JsonIgnore
    public Optional<String> getSystemuserid() {
        return Optional.ofNullable(systemuserid);
    }

    public Organization withSystemuserid(String systemuserid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("systemuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.systemuserid = systemuserid;
        return _x;
    }

    @Property(name="orginsightsenabled")
    @JsonIgnore
    public Optional<Boolean> getOrginsightsenabled() {
        return Optional.ofNullable(orginsightsenabled);
    }

    public Organization withOrginsightsenabled(Boolean orginsightsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("orginsightsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.orginsightsenabled = orginsightsenabled;
        return _x;
    }

    @Property(name="maxactionstepsinbpf")
    @JsonIgnore
    public Optional<Integer> getMaxactionstepsinbpf() {
        return Optional.ofNullable(maxactionstepsinbpf);
    }

    public Organization withMaxactionstepsinbpf(Integer maxactionstepsinbpf) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxactionstepsinbpf");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxactionstepsinbpf = maxactionstepsinbpf;
        return _x;
    }

    @Property(name="socialinsightstermsaccepted")
    @JsonIgnore
    public Optional<Boolean> getSocialinsightstermsaccepted() {
        return Optional.ofNullable(socialinsightstermsaccepted);
    }

    public Organization withSocialinsightstermsaccepted(Boolean socialinsightstermsaccepted) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("socialinsightstermsaccepted");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.socialinsightstermsaccepted = socialinsightstermsaccepted;
        return _x;
    }

    @Property(name="defaultemailsettings")
    @JsonIgnore
    public Optional<String> getDefaultemailsettings() {
        return Optional.ofNullable(defaultemailsettings);
    }

    public Organization withDefaultemailsettings(String defaultemailsettings) {
        Checks.checkIsAscii(defaultemailsettings);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("defaultemailsettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.defaultemailsettings = defaultemailsettings;
        return _x;
    }

    @Property(name="generatealertsforerrors")
    @JsonIgnore
    public Optional<Boolean> getGeneratealertsforerrors() {
        return Optional.ofNullable(generatealertsforerrors);
    }

    public Organization withGeneratealertsforerrors(Boolean generatealertsforerrors) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("generatealertsforerrors");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.generatealertsforerrors = generatealertsforerrors;
        return _x;
    }

    @Property(name="getstartedpanecontentenabled")
    @JsonIgnore
    public Optional<Boolean> getGetstartedpanecontentenabled() {
        return Optional.ofNullable(getstartedpanecontentenabled);
    }

    public Organization withGetstartedpanecontentenabled(Boolean getstartedpanecontentenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("getstartedpanecontentenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.getstartedpanecontentenabled = getstartedpanecontentenabled;
        return _x;
    }

    @Property(name="sqlaccessgroupname")
    @JsonIgnore
    public Optional<String> getSqlaccessgroupname() {
        return Optional.ofNullable(sqlaccessgroupname);
    }

    public Organization withSqlaccessgroupname(String sqlaccessgroupname) {
        Checks.checkIsAscii(sqlaccessgroupname);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sqlaccessgroupname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sqlaccessgroupname = sqlaccessgroupname;
        return _x;
    }

    @Property(name="autoapplydefaultoncaseupdate")
    @JsonIgnore
    public Optional<Boolean> getAutoapplydefaultoncaseupdate() {
        return Optional.ofNullable(autoapplydefaultoncaseupdate);
    }

    public Organization withAutoapplydefaultoncaseupdate(Boolean autoapplydefaultoncaseupdate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("autoapplydefaultoncaseupdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.autoapplydefaultoncaseupdate = autoapplydefaultoncaseupdate;
        return _x;
    }

    @Property(name="negativecurrencyformatcode")
    @JsonIgnore
    public Optional<Integer> getNegativecurrencyformatcode() {
        return Optional.ofNullable(negativecurrencyformatcode);
    }

    public Organization withNegativecurrencyformatcode(Integer negativecurrencyformatcode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("negativecurrencyformatcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.negativecurrencyformatcode = negativecurrencyformatcode;
        return _x;
    }

    @Property(name="cascadestatusupdate")
    @JsonIgnore
    public Optional<Boolean> getCascadestatusupdate() {
        return Optional.ofNullable(cascadestatusupdate);
    }

    public Organization withCascadestatusupdate(Boolean cascadestatusupdate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("cascadestatusupdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.cascadestatusupdate = cascadestatusupdate;
        return _x;
    }

    @Property(name="powerbifeatureenabled")
    @JsonIgnore
    public Optional<Boolean> getPowerbifeatureenabled() {
        return Optional.ofNullable(powerbifeatureenabled);
    }

    public Organization withPowerbifeatureenabled(Boolean powerbifeatureenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("powerbifeatureenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.powerbifeatureenabled = powerbifeatureenabled;
        return _x;
    }

    @Property(name="fullnameconventioncode")
    @JsonIgnore
    public Optional<Integer> getFullnameconventioncode() {
        return Optional.ofNullable(fullnameconventioncode);
    }

    public Organization withFullnameconventioncode(Integer fullnameconventioncode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fullnameconventioncode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fullnameconventioncode = fullnameconventioncode;
        return _x;
    }

    @Property(name="allowaddressbooksyncs")
    @JsonIgnore
    public Optional<Boolean> getAllowaddressbooksyncs() {
        return Optional.ofNullable(allowaddressbooksyncs);
    }

    public Organization withAllowaddressbooksyncs(Boolean allowaddressbooksyncs) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowaddressbooksyncs");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowaddressbooksyncs = allowaddressbooksyncs;
        return _x;
    }

    @Property(name="notifymailboxownerofemailserverlevelalerts")
    @JsonIgnore
    public Optional<Boolean> getNotifymailboxownerofemailserverlevelalerts() {
        return Optional.ofNullable(notifymailboxownerofemailserverlevelalerts);
    }

    public Organization withNotifymailboxownerofemailserverlevelalerts(Boolean notifymailboxownerofemailserverlevelalerts) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("notifymailboxownerofemailserverlevelalerts");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.notifymailboxownerofemailserverlevelalerts = notifymailboxownerofemailserverlevelalerts;
        return _x;
    }

    @Property(name="usequickfindviewforgridsearch")
    @JsonIgnore
    public Optional<Boolean> getUsequickfindviewforgridsearch() {
        return Optional.ofNullable(usequickfindviewforgridsearch);
    }

    public Organization withUsequickfindviewforgridsearch(Boolean usequickfindviewforgridsearch) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("usequickfindviewforgridsearch");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.usequickfindviewforgridsearch = usequickfindviewforgridsearch;
        return _x;
    }

    @Property(name="discountcalculationmethod")
    @JsonIgnore
    public Optional<Integer> getDiscountcalculationmethod() {
        return Optional.ofNullable(discountcalculationmethod);
    }

    public Organization withDiscountcalculationmethod(Integer discountcalculationmethod) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("discountcalculationmethod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.discountcalculationmethod = discountcalculationmethod;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<String> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Organization withOrganizationid(String organizationid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.organizationid = organizationid;
        return _x;
    }

    @Property(name="mailboxpermanentissueminrange")
    @JsonIgnore
    public Optional<Integer> getMailboxpermanentissueminrange() {
        return Optional.ofNullable(mailboxpermanentissueminrange);
    }

    public Organization withMailboxpermanentissueminrange(Integer mailboxpermanentissueminrange) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("mailboxpermanentissueminrange");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.mailboxpermanentissueminrange = mailboxpermanentissueminrange;
        return _x;
    }

    @Property(name="kmsettings")
    @JsonIgnore
    public Optional<String> getKmsettings() {
        return Optional.ofNullable(kmsettings);
    }

    public Organization withKmsettings(String kmsettings) {
        Checks.checkIsAscii(kmsettings);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("kmsettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.kmsettings = kmsettings;
        return _x;
    }

    @Property(name="isfulltextsearchenabled")
    @JsonIgnore
    public Optional<Boolean> getIsfulltextsearchenabled() {
        return Optional.ofNullable(isfulltextsearchenabled);
    }

    public Organization withIsfulltextsearchenabled(Boolean isfulltextsearchenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isfulltextsearchenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isfulltextsearchenabled = isfulltextsearchenabled;
        return _x;
    }

    @Property(name="hashminaddresscount")
    @JsonIgnore
    public Optional<Integer> getHashminaddresscount() {
        return Optional.ofNullable(hashminaddresscount);
    }

    public Organization withHashminaddresscount(Integer hashminaddresscount) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("hashminaddresscount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.hashminaddresscount = hashminaddresscount;
        return _x;
    }

    @Property(name="dateseparator")
    @JsonIgnore
    public Optional<String> getDateseparator() {
        return Optional.ofNullable(dateseparator);
    }

    public Organization withDateseparator(String dateseparator) {
        Checks.checkIsAscii(dateseparator);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("dateseparator");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.dateseparator = dateseparator;
        return _x;
    }

    @Property(name="weekstartdaycode")
    @JsonIgnore
    public Optional<Integer> getWeekstartdaycode() {
        return Optional.ofNullable(weekstartdaycode);
    }

    public Organization withWeekstartdaycode(Integer weekstartdaycode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("weekstartdaycode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.weekstartdaycode = weekstartdaycode;
        return _x;
    }

    @Property(name="allowuserformmodepreference")
    @JsonIgnore
    public Optional<Boolean> getAllowuserformmodepreference() {
        return Optional.ofNullable(allowuserformmodepreference);
    }

    public Organization withAllowuserformmodepreference(Boolean allowuserformmodepreference) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowuserformmodepreference");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowuserformmodepreference = allowuserformmodepreference;
        return _x;
    }

    @Property(name="numberseparator")
    @JsonIgnore
    public Optional<String> getNumberseparator() {
        return Optional.ofNullable(numberseparator);
    }

    public Organization withNumberseparator(String numberseparator) {
        Checks.checkIsAscii(numberseparator);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("numberseparator");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.numberseparator = numberseparator;
        return _x;
    }

    @Property(name="campaignprefix")
    @JsonIgnore
    public Optional<String> getCampaignprefix() {
        return Optional.ofNullable(campaignprefix);
    }

    public Organization withCampaignprefix(String campaignprefix) {
        Checks.checkIsAscii(campaignprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("campaignprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.campaignprefix = campaignprefix;
        return _x;
    }

    @Property(name="productrecommendationsenabled")
    @JsonIgnore
    public Optional<Boolean> getProductrecommendationsenabled() {
        return Optional.ofNullable(productrecommendationsenabled);
    }

    public Organization withProductrecommendationsenabled(Boolean productrecommendationsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("productrecommendationsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.productrecommendationsenabled = productrecommendationsenabled;
        return _x;
    }

    @Property(name="recurrencedefaultnumberofoccurrences")
    @JsonIgnore
    public Optional<Integer> getRecurrencedefaultnumberofoccurrences() {
        return Optional.ofNullable(recurrencedefaultnumberofoccurrences);
    }

    public Organization withRecurrencedefaultnumberofoccurrences(Integer recurrencedefaultnumberofoccurrences) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("recurrencedefaultnumberofoccurrences");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.recurrencedefaultnumberofoccurrences = recurrencedefaultnumberofoccurrences;
        return _x;
    }

    @Property(name="ismsteamsusersyncenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmsteamsusersyncenabled() {
        return Optional.ofNullable(ismsteamsusersyncenabled);
    }

    public Organization withIsmsteamsusersyncenabled(Boolean ismsteamsusersyncenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismsteamsusersyncenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismsteamsusersyncenabled = ismsteamsusersyncenabled;
        return _x;
    }

    @Property(name="quickfindrecordlimitenabled")
    @JsonIgnore
    public Optional<Boolean> getQuickfindrecordlimitenabled() {
        return Optional.ofNullable(quickfindrecordlimitenabled);
    }

    public Organization withQuickfindrecordlimitenabled(Boolean quickfindrecordlimitenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("quickfindrecordlimitenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.quickfindrecordlimitenabled = quickfindrecordlimitenabled;
        return _x;
    }

    @Property(name="pricingdecimalprecision")
    @JsonIgnore
    public Optional<Integer> getPricingdecimalprecision() {
        return Optional.ofNullable(pricingdecimalprecision);
    }

    public Organization withPricingdecimalprecision(Integer pricingdecimalprecision) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("pricingdecimalprecision");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.pricingdecimalprecision = pricingdecimalprecision;
        return _x;
    }

    @Property(name="useskypeprotocol")
    @JsonIgnore
    public Optional<Boolean> getUseskypeprotocol() {
        return Optional.ofNullable(useskypeprotocol);
    }

    public Organization withUseskypeprotocol(Boolean useskypeprotocol) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("useskypeprotocol");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.useskypeprotocol = useskypeprotocol;
        return _x;
    }

    @Property(name="rendersecureiframeforemail")
    @JsonIgnore
    public Optional<Boolean> getRendersecureiframeforemail() {
        return Optional.ofNullable(rendersecureiframeforemail);
    }

    public Organization withRendersecureiframeforemail(Boolean rendersecureiframeforemail) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("rendersecureiframeforemail");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.rendersecureiframeforemail = rendersecureiframeforemail;
        return _x;
    }

    @Property(name="inactivitytimeoutinmins")
    @JsonIgnore
    public Optional<Integer> getInactivitytimeoutinmins() {
        return Optional.ofNullable(inactivitytimeoutinmins);
    }

    public Organization withInactivitytimeoutinmins(Integer inactivitytimeoutinmins) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("inactivitytimeoutinmins");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.inactivitytimeoutinmins = inactivitytimeoutinmins;
        return _x;
    }

    @Property(name="sessiontimeoutenabled")
    @JsonIgnore
    public Optional<Boolean> getSessiontimeoutenabled() {
        return Optional.ofNullable(sessiontimeoutenabled);
    }

    public Organization withSessiontimeoutenabled(Boolean sessiontimeoutenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sessiontimeoutenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sessiontimeoutenabled = sessiontimeoutenabled;
        return _x;
    }

    @Property(name="minaddressbooksyncinterval")
    @JsonIgnore
    public Optional<Integer> getMinaddressbooksyncinterval() {
        return Optional.ofNullable(minaddressbooksyncinterval);
    }

    public Organization withMinaddressbooksyncinterval(Integer minaddressbooksyncinterval) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("minaddressbooksyncinterval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.minaddressbooksyncinterval = minaddressbooksyncinterval;
        return _x;
    }

    @Property(name="externalbaseurl")
    @JsonIgnore
    public Optional<String> getExternalbaseurl() {
        return Optional.ofNullable(externalbaseurl);
    }

    public Organization withExternalbaseurl(String externalbaseurl) {
        Checks.checkIsAscii(externalbaseurl);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("externalbaseurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.externalbaseurl = externalbaseurl;
        return _x;
    }

    @Property(name="issalesassistantenabled")
    @JsonIgnore
    public Optional<Boolean> getIssalesassistantenabled() {
        return Optional.ofNullable(issalesassistantenabled);
    }

    public Organization withIssalesassistantenabled(Boolean issalesassistantenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("issalesassistantenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.issalesassistantenabled = issalesassistantenabled;
        return _x;
    }

    @Property(name="_defaultmobileofflineprofileid_value")
    @JsonIgnore
    public Optional<String> get_defaultmobileofflineprofileid_value() {
        return Optional.ofNullable(_defaultmobileofflineprofileid_value);
    }

    public Organization with_defaultmobileofflineprofileid_value(String _defaultmobileofflineprofileid_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_defaultmobileofflineprofileid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._defaultmobileofflineprofileid_value = _defaultmobileofflineprofileid_value;
        return _x;
    }

    @Property(name="amdesignator")
    @JsonIgnore
    public Optional<String> getAmdesignator() {
        return Optional.ofNullable(amdesignator);
    }

    public Organization withAmdesignator(String amdesignator) {
        Checks.checkIsAscii(amdesignator);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("amdesignator");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.amdesignator = amdesignator;
        return _x;
    }

    @Property(name="enableimmersiveskypeintegration")
    @JsonIgnore
    public Optional<Boolean> getEnableimmersiveskypeintegration() {
        return Optional.ofNullable(enableimmersiveskypeintegration);
    }

    public Organization withEnableimmersiveskypeintegration(Boolean enableimmersiveskypeintegration) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enableimmersiveskypeintegration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enableimmersiveskypeintegration = enableimmersiveskypeintegration;
        return _x;
    }

    @Property(name="kbprefix")
    @JsonIgnore
    public Optional<String> getKbprefix() {
        return Optional.ofNullable(kbprefix);
    }

    public Organization withKbprefix(String kbprefix) {
        Checks.checkIsAscii(kbprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("kbprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.kbprefix = kbprefix;
        return _x;
    }

    @Property(name="bounddashboarddefaultcardexpanded")
    @JsonIgnore
    public Optional<Boolean> getBounddashboarddefaultcardexpanded() {
        return Optional.ofNullable(bounddashboarddefaultcardexpanded);
    }

    public Organization withBounddashboarddefaultcardexpanded(Boolean bounddashboarddefaultcardexpanded) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("bounddashboarddefaultcardexpanded");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.bounddashboarddefaultcardexpanded = bounddashboarddefaultcardexpanded;
        return _x;
    }

    @Property(name="hashmaxcount")
    @JsonIgnore
    public Optional<Integer> getHashmaxcount() {
        return Optional.ofNullable(hashmaxcount);
    }

    public Organization withHashmaxcount(Integer hashmaxcount) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("hashmaxcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.hashmaxcount = hashmaxcount;
        return _x;
    }

    @Property(name="reportinggroupname")
    @JsonIgnore
    public Optional<String> getReportinggroupname() {
        return Optional.ofNullable(reportinggroupname);
    }

    public Organization withReportinggroupname(String reportinggroupname) {
        Checks.checkIsAscii(reportinggroupname);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("reportinggroupname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.reportinggroupname = reportinggroupname;
        return _x;
    }

    @Property(name="isdelegateaccessenabled")
    @JsonIgnore
    public Optional<Boolean> getIsdelegateaccessenabled() {
        return Optional.ofNullable(isdelegateaccessenabled);
    }

    public Organization withIsdelegateaccessenabled(Boolean isdelegateaccessenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isdelegateaccessenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isdelegateaccessenabled = isdelegateaccessenabled;
        return _x;
    }

    @Property(name="aciwebendpointurl")
    @JsonIgnore
    public Optional<String> getAciwebendpointurl() {
        return Optional.ofNullable(aciwebendpointurl);
    }

    public Organization withAciwebendpointurl(String aciwebendpointurl) {
        Checks.checkIsAscii(aciwebendpointurl);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("aciwebendpointurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.aciwebendpointurl = aciwebendpointurl;
        return _x;
    }

    @Property(name="maxuploadfilesize")
    @JsonIgnore
    public Optional<Integer> getMaxuploadfilesize() {
        return Optional.ofNullable(maxuploadfilesize);
    }

    public Organization withMaxuploadfilesize(Integer maxuploadfilesize) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxuploadfilesize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxuploadfilesize = maxuploadfilesize;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Organization with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="fiscalyeardisplaycode")
    @JsonIgnore
    public Optional<Integer> getFiscalyeardisplaycode() {
        return Optional.ofNullable(fiscalyeardisplaycode);
    }

    public Organization withFiscalyeardisplaycode(Integer fiscalyeardisplaycode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalyeardisplaycode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalyeardisplaycode = fiscalyeardisplaycode;
        return _x;
    }

    @Property(name="yammeroauthaccesstokenexpired")
    @JsonIgnore
    public Optional<Boolean> getYammeroauthaccesstokenexpired() {
        return Optional.ofNullable(yammeroauthaccesstokenexpired);
    }

    public Organization withYammeroauthaccesstokenexpired(Boolean yammeroauthaccesstokenexpired) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("yammeroauthaccesstokenexpired");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.yammeroauthaccesstokenexpired = yammeroauthaccesstokenexpired;
        return _x;
    }

    @Property(name="externalpartyentitysettings")
    @JsonIgnore
    public Optional<String> getExternalpartyentitysettings() {
        return Optional.ofNullable(externalpartyentitysettings);
    }

    public Organization withExternalpartyentitysettings(String externalpartyentitysettings) {
        Checks.checkIsAscii(externalpartyentitysettings);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("externalpartyentitysettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.externalpartyentitysettings = externalpartyentitysettings;
        return _x;
    }

    @Property(name="defaultcountrycode")
    @JsonIgnore
    public Optional<String> getDefaultcountrycode() {
        return Optional.ofNullable(defaultcountrycode);
    }

    public Organization withDefaultcountrycode(String defaultcountrycode) {
        Checks.checkIsAscii(defaultcountrycode);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("defaultcountrycode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.defaultcountrycode = defaultcountrycode;
        return _x;
    }

    @Property(name="isactivityanalysisenabled")
    @JsonIgnore
    public Optional<Boolean> getIsactivityanalysisenabled() {
        return Optional.ofNullable(isactivityanalysisenabled);
    }

    public Organization withIsactivityanalysisenabled(Boolean isactivityanalysisenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isactivityanalysisenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isactivityanalysisenabled = isactivityanalysisenabled;
        return _x;
    }

    @Property(name="recurrenceexpansionjobbatchsize")
    @JsonIgnore
    public Optional<Integer> getRecurrenceexpansionjobbatchsize() {
        return Optional.ofNullable(recurrenceexpansionjobbatchsize);
    }

    public Organization withRecurrenceexpansionjobbatchsize(Integer recurrenceexpansionjobbatchsize) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("recurrenceexpansionjobbatchsize");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.recurrenceexpansionjobbatchsize = recurrenceexpansionjobbatchsize;
        return _x;
    }

    @Property(name="_basecurrencyid_value")
    @JsonIgnore
    public Optional<String> get_basecurrencyid_value() {
        return Optional.ofNullable(_basecurrencyid_value);
    }

    public Organization with_basecurrencyid_value(String _basecurrencyid_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_basecurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._basecurrencyid_value = _basecurrencyid_value;
        return _x;
    }

    @Property(name="featureset")
    @JsonIgnore
    public Optional<String> getFeatureset() {
        return Optional.ofNullable(featureset);
    }

    public Organization withFeatureset(String featureset) {
        Checks.checkIsAscii(featureset);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("featureset");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.featureset = featureset;
        return _x;
    }

    @Property(name="istextwrapenabled")
    @JsonIgnore
    public Optional<Boolean> getIstextwrapenabled() {
        return Optional.ofNullable(istextwrapenabled);
    }

    public Organization withIstextwrapenabled(Boolean istextwrapenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("istextwrapenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.istextwrapenabled = istextwrapenabled;
        return _x;
    }

    @Property(name="calendartype")
    @JsonIgnore
    public Optional<Integer> getCalendartype() {
        return Optional.ofNullable(calendartype);
    }

    public Organization withCalendartype(Integer calendartype) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("calendartype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.calendartype = calendartype;
        return _x;
    }

    @Property(name="allowclientmessagebarad")
    @JsonIgnore
    public Optional<Boolean> getAllowclientmessagebarad() {
        return Optional.ofNullable(allowclientmessagebarad);
    }

    public Organization withAllowclientmessagebarad(Boolean allowclientmessagebarad) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowclientmessagebarad");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowclientmessagebarad = allowclientmessagebarad;
        return _x;
    }

    @Property(name="usergroupid")
    @JsonIgnore
    public Optional<String> getUsergroupid() {
        return Optional.ofNullable(usergroupid);
    }

    public Organization withUsergroupid(String usergroupid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("usergroupid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.usergroupid = usergroupid;
        return _x;
    }

    @Property(name="isdisabled")
    @JsonIgnore
    public Optional<Boolean> getIsdisabled() {
        return Optional.ofNullable(isdisabled);
    }

    public Organization withIsdisabled(Boolean isdisabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isdisabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isdisabled = isdisabled;
        return _x;
    }

    @Property(name="isduplicatedetectionenabledforofflinesync")
    @JsonIgnore
    public Optional<Boolean> getIsduplicatedetectionenabledforofflinesync() {
        return Optional.ofNullable(isduplicatedetectionenabledforofflinesync);
    }

    public Organization withIsduplicatedetectionenabledforofflinesync(Boolean isduplicatedetectionenabledforofflinesync) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isduplicatedetectionenabledforofflinesync");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isduplicatedetectionenabledforofflinesync = isduplicatedetectionenabledforofflinesync;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Organization withLanguagecode(Integer languagecode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="appdesignerexperienceenabled")
    @JsonIgnore
    public Optional<Boolean> getAppdesignerexperienceenabled() {
        return Optional.ofNullable(appdesignerexperienceenabled);
    }

    public Organization withAppdesignerexperienceenabled(Boolean appdesignerexperienceenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("appdesignerexperienceenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.appdesignerexperienceenabled = appdesignerexperienceenabled;
        return _x;
    }

    @Property(name="categoryprefix")
    @JsonIgnore
    public Optional<String> getCategoryprefix() {
        return Optional.ofNullable(categoryprefix);
    }

    public Organization withCategoryprefix(String categoryprefix) {
        Checks.checkIsAscii(categoryprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("categoryprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.categoryprefix = categoryprefix;
        return _x;
    }

    @Property(name="ispreviewenabledforactioncard")
    @JsonIgnore
    public Optional<Boolean> getIspreviewenabledforactioncard() {
        return Optional.ofNullable(ispreviewenabledforactioncard);
    }

    public Organization withIspreviewenabledforactioncard(Boolean ispreviewenabledforactioncard) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ispreviewenabledforactioncard");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ispreviewenabledforactioncard = ispreviewenabledforactioncard;
        return _x;
    }

    @Property(name="ismobileofflineenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmobileofflineenabled() {
        return Optional.ofNullable(ismobileofflineenabled);
    }

    public Organization withIsmobileofflineenabled(Boolean ismobileofflineenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismobileofflineenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismobileofflineenabled = ismobileofflineenabled;
        return _x;
    }

    @Property(name="fiscalcalendarstart")
    @JsonIgnore
    public Optional<OffsetDateTime> getFiscalcalendarstart() {
        return Optional.ofNullable(fiscalcalendarstart);
    }

    public Organization withFiscalcalendarstart(OffsetDateTime fiscalcalendarstart) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalcalendarstart");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalcalendarstart = fiscalcalendarstart;
        return _x;
    }

    @Property(name="isexternalsearchindexenabled")
    @JsonIgnore
    public Optional<Boolean> getIsexternalsearchindexenabled() {
        return Optional.ofNullable(isexternalsearchindexenabled);
    }

    public Organization withIsexternalsearchindexenabled(Boolean isexternalsearchindexenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isexternalsearchindexenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isexternalsearchindexenabled = isexternalsearchindexenabled;
        return _x;
    }

    @Property(name="maximumactivebusinessprocessflowsallowedperentity")
    @JsonIgnore
    public Optional<Integer> getMaximumactivebusinessprocessflowsallowedperentity() {
        return Optional.ofNullable(maximumactivebusinessprocessflowsallowedperentity);
    }

    public Organization withMaximumactivebusinessprocessflowsallowedperentity(Integer maximumactivebusinessprocessflowsallowedperentity) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maximumactivebusinessprocessflowsallowedperentity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maximumactivebusinessprocessflowsallowedperentity = maximumactivebusinessprocessflowsallowedperentity;
        return _x;
    }

    @Property(name="enablelivepersonacarduci")
    @JsonIgnore
    public Optional<Boolean> getEnablelivepersonacarduci() {
        return Optional.ofNullable(enablelivepersonacarduci);
    }

    public Organization withEnablelivepersonacarduci(Boolean enablelivepersonacarduci) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enablelivepersonacarduci");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enablelivepersonacarduci = enablelivepersonacarduci;
        return _x;
    }

    @Property(name="timeformatcode")
    @JsonIgnore
    public Optional<Integer> getTimeformatcode() {
        return Optional.ofNullable(timeformatcode);
    }

    public Organization withTimeformatcode(Integer timeformatcode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("timeformatcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.timeformatcode = timeformatcode;
        return _x;
    }

    @Property(name="dayssincerecordlastmodifiedmaxvalue")
    @JsonIgnore
    public Optional<Integer> getDayssincerecordlastmodifiedmaxvalue() {
        return Optional.ofNullable(dayssincerecordlastmodifiedmaxvalue);
    }

    public Organization withDayssincerecordlastmodifiedmaxvalue(Integer dayssincerecordlastmodifiedmaxvalue) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("dayssincerecordlastmodifiedmaxvalue");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.dayssincerecordlastmodifiedmaxvalue = dayssincerecordlastmodifiedmaxvalue;
        return _x;
    }

    @Property(name="_acknowledgementtemplateid_value")
    @JsonIgnore
    public Optional<String> get_acknowledgementtemplateid_value() {
        return Optional.ofNullable(_acknowledgementtemplateid_value);
    }

    public Organization with_acknowledgementtemplateid_value(String _acknowledgementtemplateid_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_acknowledgementtemplateid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._acknowledgementtemplateid_value = _acknowledgementtemplateid_value;
        return _x;
    }

    @Property(name="maxdepthforhierarchicalsecuritymodel")
    @JsonIgnore
    public Optional<Integer> getMaxdepthforhierarchicalsecuritymodel() {
        return Optional.ofNullable(maxdepthforhierarchicalsecuritymodel);
    }

    public Organization withMaxdepthforhierarchicalsecuritymodel(Integer maxdepthforhierarchicalsecuritymodel) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxdepthforhierarchicalsecuritymodel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxdepthforhierarchicalsecuritymodel = maxdepthforhierarchicalsecuritymodel;
        return _x;
    }

    @Property(name="currencysymbol")
    @JsonIgnore
    public Optional<String> getCurrencysymbol() {
        return Optional.ofNullable(currencysymbol);
    }

    public Organization withCurrencysymbol(String currencysymbol) {
        Checks.checkIsAscii(currencysymbol);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("currencysymbol");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.currencysymbol = currencysymbol;
        return _x;
    }

    @Property(name="isfolderbasedtrackingenabled")
    @JsonIgnore
    public Optional<Boolean> getIsfolderbasedtrackingenabled() {
        return Optional.ofNullable(isfolderbasedtrackingenabled);
    }

    public Organization withIsfolderbasedtrackingenabled(Boolean isfolderbasedtrackingenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isfolderbasedtrackingenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isfolderbasedtrackingenabled = isfolderbasedtrackingenabled;
        return _x;
    }

    @Property(name="isdefaultcountrycodecheckenabled")
    @JsonIgnore
    public Optional<Boolean> getIsdefaultcountrycodecheckenabled() {
        return Optional.ofNullable(isdefaultcountrycodecheckenabled);
    }

    public Organization withIsdefaultcountrycodecheckenabled(Boolean isdefaultcountrycodecheckenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isdefaultcountrycodecheckenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isdefaultcountrycodecheckenabled = isdefaultcountrycodecheckenabled;
        return _x;
    }

    @Property(name="entityimage")
    @JsonIgnore
    public Optional<byte[]> getEntityimage() {
        return Optional.ofNullable(entityimage);
    }

    public Organization withEntityimage(byte[] entityimage) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("entityimage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.entityimage = entityimage;
        return _x;
    }

    @Property(name="fiscalyearformatyear")
    @JsonIgnore
    public Optional<Integer> getFiscalyearformatyear() {
        return Optional.ofNullable(fiscalyearformatyear);
    }

    public Organization withFiscalyearformatyear(Integer fiscalyearformatyear) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalyearformatyear");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalyearformatyear = fiscalyearformatyear;
        return _x;
    }

    @Property(name="entityimage_timestamp")
    @JsonIgnore
    public Optional<Long> getEntityimage_timestamp() {
        return Optional.ofNullable(entityimage_timestamp);
    }

    public Organization withEntityimage_timestamp(Long entityimage_timestamp) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("entityimage_timestamp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.entityimage_timestamp = entityimage_timestamp;
        return _x;
    }

    @Property(name="privreportinggroupname")
    @JsonIgnore
    public Optional<String> getPrivreportinggroupname() {
        return Optional.ofNullable(privreportinggroupname);
    }

    public Organization withPrivreportinggroupname(String privreportinggroupname) {
        Checks.checkIsAscii(privreportinggroupname);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("privreportinggroupname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.privreportinggroupname = privreportinggroupname;
        return _x;
    }

    @Property(name="yearstartweekcode")
    @JsonIgnore
    public Optional<Integer> getYearstartweekcode() {
        return Optional.ofNullable(yearstartweekcode);
    }

    public Organization withYearstartweekcode(Integer yearstartweekcode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("yearstartweekcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.yearstartweekcode = yearstartweekcode;
        return _x;
    }

    @Property(name="uselegacyrendering")
    @JsonIgnore
    public Optional<Boolean> getUselegacyrendering() {
        return Optional.ofNullable(uselegacyrendering);
    }

    public Organization withUselegacyrendering(Boolean uselegacyrendering) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("uselegacyrendering");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.uselegacyrendering = uselegacyrendering;
        return _x;
    }

    @Property(name="maximumtrackingnumber")
    @JsonIgnore
    public Optional<Integer> getMaximumtrackingnumber() {
        return Optional.ofNullable(maximumtrackingnumber);
    }

    public Organization withMaximumtrackingnumber(Integer maximumtrackingnumber) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maximumtrackingnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maximumtrackingnumber = maximumtrackingnumber;
        return _x;
    }

    @Property(name="fiscalyearformatsuffix")
    @JsonIgnore
    public Optional<Integer> getFiscalyearformatsuffix() {
        return Optional.ofNullable(fiscalyearformatsuffix);
    }

    public Organization withFiscalyearformatsuffix(Integer fiscalyearformatsuffix) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalyearformatsuffix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalyearformatsuffix = fiscalyearformatsuffix;
        return _x;
    }

    @Property(name="allowautoresponsecreation")
    @JsonIgnore
    public Optional<Boolean> getAllowautoresponsecreation() {
        return Optional.ofNullable(allowautoresponsecreation);
    }

    public Organization withAllowautoresponsecreation(Boolean allowautoresponsecreation) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowautoresponsecreation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowautoresponsecreation = allowautoresponsecreation;
        return _x;
    }

    @Property(name="allowlegacyclientexperience")
    @JsonIgnore
    public Optional<Boolean> getAllowlegacyclientexperience() {
        return Optional.ofNullable(allowlegacyclientexperience);
    }

    public Organization withAllowlegacyclientexperience(Boolean allowlegacyclientexperience) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowlegacyclientexperience");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowlegacyclientexperience = allowlegacyclientexperience;
        return _x;
    }

    @Property(name="ismsteamsenabled")
    @JsonIgnore
    public Optional<Boolean> getIsmsteamsenabled() {
        return Optional.ofNullable(ismsteamsenabled);
    }

    public Organization withIsmsteamsenabled(Boolean ismsteamsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ismsteamsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ismsteamsenabled = ismsteamsenabled;
        return _x;
    }

    @Property(name="enablemicrosoftflowintegration")
    @JsonIgnore
    public Optional<Boolean> getEnablemicrosoftflowintegration() {
        return Optional.ofNullable(enablemicrosoftflowintegration);
    }

    public Organization withEnablemicrosoftflowintegration(Boolean enablemicrosoftflowintegration) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enablemicrosoftflowintegration");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enablemicrosoftflowintegration = enablemicrosoftflowintegration;
        return _x;
    }

    @Property(name="currentparsedtablenumber")
    @JsonIgnore
    public Optional<Integer> getCurrentparsedtablenumber() {
        return Optional.ofNullable(currentparsedtablenumber);
    }

    public Organization withCurrentparsedtablenumber(Integer currentparsedtablenumber) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("currentparsedtablenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.currentparsedtablenumber = currentparsedtablenumber;
        return _x;
    }

    @Property(name="socialinsightsenabled")
    @JsonIgnore
    public Optional<Boolean> getSocialinsightsenabled() {
        return Optional.ofNullable(socialinsightsenabled);
    }

    public Organization withSocialinsightsenabled(Boolean socialinsightsenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("socialinsightsenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.socialinsightsenabled = socialinsightsenabled;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Organization with_createdby_value(String _createdby_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="initialversion")
    @JsonIgnore
    public Optional<String> getInitialversion() {
        return Optional.ofNullable(initialversion);
    }

    public Organization withInitialversion(String initialversion) {
        Checks.checkIsAscii(initialversion);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("initialversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.initialversion = initialversion;
        return _x;
    }

    @Property(name="delegatedadminuserid")
    @JsonIgnore
    public Optional<String> getDelegatedadminuserid() {
        return Optional.ofNullable(delegatedadminuserid);
    }

    public Organization withDelegatedadminuserid(String delegatedadminuserid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("delegatedadminuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.delegatedadminuserid = delegatedadminuserid;
        return _x;
    }

    @Property(name="isfiscalperiodmonthbased")
    @JsonIgnore
    public Optional<Boolean> getIsfiscalperiodmonthbased() {
        return Optional.ofNullable(isfiscalperiodmonthbased);
    }

    public Organization withIsfiscalperiodmonthbased(Boolean isfiscalperiodmonthbased) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isfiscalperiodmonthbased");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isfiscalperiodmonthbased = isfiscalperiodmonthbased;
        return _x;
    }

    @Property(name="fiscalperiodtype")
    @JsonIgnore
    public Optional<Integer> getFiscalperiodtype() {
        return Optional.ofNullable(fiscalperiodtype);
    }

    public Organization withFiscalperiodtype(Integer fiscalperiodtype) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalperiodtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalperiodtype = fiscalperiodtype;
        return _x;
    }

    @Property(name="inactivitytimeoutreminderinmins")
    @JsonIgnore
    public Optional<Integer> getInactivitytimeoutreminderinmins() {
        return Optional.ofNullable(inactivitytimeoutreminderinmins);
    }

    public Organization withInactivitytimeoutreminderinmins(Integer inactivitytimeoutreminderinmins) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("inactivitytimeoutreminderinmins");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.inactivitytimeoutreminderinmins = inactivitytimeoutreminderinmins;
        return _x;
    }

    @Property(name="disabledreason")
    @JsonIgnore
    public Optional<String> getDisabledreason() {
        return Optional.ofNullable(disabledreason);
    }

    public Organization withDisabledreason(String disabledreason) {
        Checks.checkIsAscii(disabledreason);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("disabledreason");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.disabledreason = disabledreason;
        return _x;
    }

    @Property(name="uniquespecifierlength")
    @JsonIgnore
    public Optional<Integer> getUniquespecifierlength() {
        return Optional.ofNullable(uniquespecifierlength);
    }

    public Organization withUniquespecifierlength(Integer uniquespecifierlength) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("uniquespecifierlength");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.uniquespecifierlength = uniquespecifierlength;
        return _x;
    }

    @Property(name="ispdfgenerationenabled")
    @JsonIgnore
    public Optional<String> getIspdfgenerationenabled() {
        return Optional.ofNullable(ispdfgenerationenabled);
    }

    public Organization withIspdfgenerationenabled(String ispdfgenerationenabled) {
        Checks.checkIsAscii(ispdfgenerationenabled);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ispdfgenerationenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ispdfgenerationenabled = ispdfgenerationenabled;
        return _x;
    }

    @Property(name="enablelivepersoncardintegrationinoffice")
    @JsonIgnore
    public Optional<Boolean> getEnablelivepersoncardintegrationinoffice() {
        return Optional.ofNullable(enablelivepersoncardintegrationinoffice);
    }

    public Organization withEnablelivepersoncardintegrationinoffice(Boolean enablelivepersoncardintegrationinoffice) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enablelivepersoncardintegrationinoffice");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enablelivepersoncardintegrationinoffice = enablelivepersoncardintegrationinoffice;
        return _x;
    }

    @Property(name="maxrecordsforexporttoexcel")
    @JsonIgnore
    public Optional<Integer> getMaxrecordsforexporttoexcel() {
        return Optional.ofNullable(maxrecordsforexporttoexcel);
    }

    public Organization withMaxrecordsforexporttoexcel(Integer maxrecordsforexporttoexcel) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxrecordsforexporttoexcel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxrecordsforexporttoexcel = maxrecordsforexporttoexcel;
        return _x;
    }

    @Property(name="useraccessauditinginterval")
    @JsonIgnore
    public Optional<Integer> getUseraccessauditinginterval() {
        return Optional.ofNullable(useraccessauditinginterval);
    }

    public Organization withUseraccessauditinginterval(Integer useraccessauditinginterval) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("useraccessauditinginterval");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.useraccessauditinginterval = useraccessauditinginterval;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Organization with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="kaprefix")
    @JsonIgnore
    public Optional<String> getKaprefix() {
        return Optional.ofNullable(kaprefix);
    }

    public Organization withKaprefix(String kaprefix) {
        Checks.checkIsAscii(kaprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("kaprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.kaprefix = kaprefix;
        return _x;
    }

    @Property(name="allowmarketingemailexecution")
    @JsonIgnore
    public Optional<Boolean> getAllowmarketingemailexecution() {
        return Optional.ofNullable(allowmarketingemailexecution);
    }

    public Organization withAllowmarketingemailexecution(Boolean allowmarketingemailexecution) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowmarketingemailexecution");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowmarketingemailexecution = allowmarketingemailexecution;
        return _x;
    }

    @Property(name="sqmenabled")
    @JsonIgnore
    public Optional<Boolean> getSqmenabled() {
        return Optional.ofNullable(sqmenabled);
    }

    public Organization withSqmenabled(Boolean sqmenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sqmenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sqmenabled = sqmenabled;
        return _x;
    }

    @Property(name="timeformatstring")
    @JsonIgnore
    public Optional<String> getTimeformatstring() {
        return Optional.ofNullable(timeformatstring);
    }

    public Organization withTimeformatstring(String timeformatstring) {
        Checks.checkIsAscii(timeformatstring);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("timeformatstring");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.timeformatstring = timeformatstring;
        return _x;
    }

    @Property(name="iscontextualemailenabled")
    @JsonIgnore
    public Optional<Boolean> getIscontextualemailenabled() {
        return Optional.ofNullable(iscontextualemailenabled);
    }

    public Organization withIscontextualemailenabled(Boolean iscontextualemailenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("iscontextualemailenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.iscontextualemailenabled = iscontextualemailenabled;
        return _x;
    }

    @Property(name="dateformatcode")
    @JsonIgnore
    public Optional<Integer> getDateformatcode() {
        return Optional.ofNullable(dateformatcode);
    }

    public Organization withDateformatcode(Integer dateformatcode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("dateformatcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.dateformatcode = dateformatcode;
        return _x;
    }

    @Property(name="webresourcehash")
    @JsonIgnore
    public Optional<String> getWebresourcehash() {
        return Optional.ofNullable(webresourcehash);
    }

    public Organization withWebresourcehash(String webresourcehash) {
        Checks.checkIsAscii(webresourcehash);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("webresourcehash");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.webresourcehash = webresourcehash;
        return _x;
    }

    @Property(name="syncoptinselection")
    @JsonIgnore
    public Optional<Boolean> getSyncoptinselection() {
        return Optional.ofNullable(syncoptinselection);
    }

    public Organization withSyncoptinselection(Boolean syncoptinselection) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("syncoptinselection");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.syncoptinselection = syncoptinselection;
        return _x;
    }

    @Property(name="sortid")
    @JsonIgnore
    public Optional<Integer> getSortid() {
        return Optional.ofNullable(sortid);
    }

    public Organization withSortid(Integer sortid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sortid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sortid = sortid;
        return _x;
    }

    @Property(name="globalhelpurl")
    @JsonIgnore
    public Optional<String> getGlobalhelpurl() {
        return Optional.ofNullable(globalhelpurl);
    }

    public Organization withGlobalhelpurl(String globalhelpurl) {
        Checks.checkIsAscii(globalhelpurl);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("globalhelpurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.globalhelpurl = globalhelpurl;
        return _x;
    }

    @Property(name="isallmoneydecimal")
    @JsonIgnore
    public Optional<Boolean> getIsallmoneydecimal() {
        return Optional.ofNullable(isallmoneydecimal);
    }

    public Organization withIsallmoneydecimal(Boolean isallmoneydecimal) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isallmoneydecimal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isallmoneydecimal = isallmoneydecimal;
        return _x;
    }

    @Property(name="isauditenabled")
    @JsonIgnore
    public Optional<Boolean> getIsauditenabled() {
        return Optional.ofNullable(isauditenabled);
    }

    public Organization withIsauditenabled(Boolean isauditenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isauditenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isauditenabled = isauditenabled;
        return _x;
    }

    @Property(name="fiscalyearformat")
    @JsonIgnore
    public Optional<String> getFiscalyearformat() {
        return Optional.ofNullable(fiscalyearformat);
    }

    public Organization withFiscalyearformat(String fiscalyearformat) {
        Checks.checkIsAscii(fiscalyearformat);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("fiscalyearformat");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.fiscalyearformat = fiscalyearformat;
        return _x;
    }

    @Property(name="sendbulkemailinuci")
    @JsonIgnore
    public Optional<Boolean> getSendbulkemailinuci() {
        return Optional.ofNullable(sendbulkemailinuci);
    }

    public Organization withSendbulkemailinuci(Boolean sendbulkemailinuci) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sendbulkemailinuci");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sendbulkemailinuci = sendbulkemailinuci;
        return _x;
    }

    @Property(name="defaultcrmcustomname")
    @JsonIgnore
    public Optional<String> getDefaultcrmcustomname() {
        return Optional.ofNullable(defaultcrmcustomname);
    }

    public Organization withDefaultcrmcustomname(String defaultcrmcustomname) {
        Checks.checkIsAscii(defaultcrmcustomname);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("defaultcrmcustomname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.defaultcrmcustomname = defaultcrmcustomname;
        return _x;
    }

    @Property(name="currencyformatcode")
    @JsonIgnore
    public Optional<Integer> getCurrencyformatcode() {
        return Optional.ofNullable(currencyformatcode);
    }

    public Organization withCurrencyformatcode(Integer currencyformatcode) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("currencyformatcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.currencyformatcode = currencyformatcode;
        return _x;
    }

    @Property(name="isbpfentitycustomizationfeatureenabled")
    @JsonIgnore
    public Optional<Boolean> getIsbpfentitycustomizationfeatureenabled() {
        return Optional.ofNullable(isbpfentitycustomizationfeatureenabled);
    }

    public Organization withIsbpfentitycustomizationfeatureenabled(Boolean isbpfentitycustomizationfeatureenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isbpfentitycustomizationfeatureenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isbpfentitycustomizationfeatureenabled = isbpfentitycustomizationfeatureenabled;
        return _x;
    }

    @Property(name="maxconditionsformobileofflinefilters")
    @JsonIgnore
    public Optional<Integer> getMaxconditionsformobileofflinefilters() {
        return Optional.ofNullable(maxconditionsformobileofflinefilters);
    }

    public Organization withMaxconditionsformobileofflinefilters(Integer maxconditionsformobileofflinefilters) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxconditionsformobileofflinefilters");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxconditionsformobileofflinefilters = maxconditionsformobileofflinefilters;
        return _x;
    }

    @Property(name="businessclosurecalendarid")
    @JsonIgnore
    public Optional<String> getBusinessclosurecalendarid() {
        return Optional.ofNullable(businessclosurecalendarid);
    }

    public Organization withBusinessclosurecalendarid(String businessclosurecalendarid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("businessclosurecalendarid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.businessclosurecalendarid = businessclosurecalendarid;
        return _x;
    }

    @Property(name="showweeknumber")
    @JsonIgnore
    public Optional<Boolean> getShowweeknumber() {
        return Optional.ofNullable(showweeknumber);
    }

    public Organization withShowweeknumber(Boolean showweeknumber) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("showweeknumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.showweeknumber = showweeknumber;
        return _x;
    }

    @Property(name="isactioncardenabled")
    @JsonIgnore
    public Optional<Boolean> getIsactioncardenabled() {
        return Optional.ofNullable(isactioncardenabled);
    }

    public Organization withIsactioncardenabled(Boolean isactioncardenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isactioncardenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isactioncardenabled = isactioncardenabled;
        return _x;
    }

    @Property(name="sessiontimeoutinmins")
    @JsonIgnore
    public Optional<Integer> getSessiontimeoutinmins() {
        return Optional.ofNullable(sessiontimeoutinmins);
    }

    public Organization withSessiontimeoutinmins(Integer sessiontimeoutinmins) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sessiontimeoutinmins");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sessiontimeoutinmins = sessiontimeoutinmins;
        return _x;
    }

    @Property(name="appointmentricheditorexperience")
    @JsonIgnore
    public Optional<Boolean> getAppointmentricheditorexperience() {
        return Optional.ofNullable(appointmentricheditorexperience);
    }

    public Organization withAppointmentricheditorexperience(Boolean appointmentricheditorexperience) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("appointmentricheditorexperience");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.appointmentricheditorexperience = appointmentricheditorexperience;
        return _x;
    }

    @Property(name="_defaultemailserverprofileid_value")
    @JsonIgnore
    public Optional<String> get_defaultemailserverprofileid_value() {
        return Optional.ofNullable(_defaultemailserverprofileid_value);
    }

    public Organization with_defaultemailserverprofileid_value(String _defaultemailserverprofileid_value) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("_defaultemailserverprofileid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x._defaultemailserverprofileid_value = _defaultemailserverprofileid_value;
        return _x;
    }

    @Property(name="integrationuserid")
    @JsonIgnore
    public Optional<String> getIntegrationuserid() {
        return Optional.ofNullable(integrationuserid);
    }

    public Organization withIntegrationuserid(String integrationuserid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("integrationuserid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.integrationuserid = integrationuserid;
        return _x;
    }

    @Property(name="entityimage_url")
    @JsonIgnore
    public Optional<String> getEntityimage_url() {
        return Optional.ofNullable(entityimage_url);
    }

    public Organization withEntityimage_url(String entityimage_url) {
        Checks.checkIsAscii(entityimage_url);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("entityimage_url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.entityimage_url = entityimage_url;
        return _x;
    }

    @Property(name="isnewaddproductexperienceenabled")
    @JsonIgnore
    public Optional<Boolean> getIsnewaddproductexperienceenabled() {
        return Optional.ofNullable(isnewaddproductexperienceenabled);
    }

    public Organization withIsnewaddproductexperienceenabled(Boolean isnewaddproductexperienceenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isnewaddproductexperienceenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isnewaddproductexperienceenabled = isnewaddproductexperienceenabled;
        return _x;
    }

    @Property(name="pmdesignator")
    @JsonIgnore
    public Optional<String> getPmdesignator() {
        return Optional.ofNullable(pmdesignator);
    }

    public Organization withPmdesignator(String pmdesignator) {
        Checks.checkIsAscii(pmdesignator);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("pmdesignator");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.pmdesignator = pmdesignator;
        return _x;
    }

    @Property(name="sampledataimportid")
    @JsonIgnore
    public Optional<String> getSampledataimportid() {
        return Optional.ofNullable(sampledataimportid);
    }

    public Organization withSampledataimportid(String sampledataimportid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sampledataimportid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sampledataimportid = sampledataimportid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Organization withName(String name) {
        Checks.checkIsAscii(name);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.name = name;
        return _x;
    }

    @Property(name="currencydecimalprecision")
    @JsonIgnore
    public Optional<Integer> getCurrencydecimalprecision() {
        return Optional.ofNullable(currencydecimalprecision);
    }

    public Organization withCurrencydecimalprecision(Integer currencydecimalprecision) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("currencydecimalprecision");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.currencydecimalprecision = currencydecimalprecision;
        return _x;
    }

    @Property(name="emailconnectionchannel")
    @JsonIgnore
    public Optional<Integer> getEmailconnectionchannel() {
        return Optional.ofNullable(emailconnectionchannel);
    }

    public Organization withEmailconnectionchannel(Integer emailconnectionchannel) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("emailconnectionchannel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.emailconnectionchannel = emailconnectionchannel;
        return _x;
    }

    @Property(name="ispreviewforemailmonitoringallowed")
    @JsonIgnore
    public Optional<Boolean> getIspreviewforemailmonitoringallowed() {
        return Optional.ofNullable(ispreviewforemailmonitoringallowed);
    }

    public Organization withIspreviewforemailmonitoringallowed(Boolean ispreviewforemailmonitoringallowed) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ispreviewforemailmonitoringallowed");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ispreviewforemailmonitoringallowed = ispreviewforemailmonitoringallowed;
        return _x;
    }

    @Property(name="allowunresolvedpartiesonemailsend")
    @JsonIgnore
    public Optional<Boolean> getAllowunresolvedpartiesonemailsend() {
        return Optional.ofNullable(allowunresolvedpartiesonemailsend);
    }

    public Organization withAllowunresolvedpartiesonemailsend(Boolean allowunresolvedpartiesonemailsend) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowunresolvedpartiesonemailsend");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowunresolvedpartiesonemailsend = allowunresolvedpartiesonemailsend;
        return _x;
    }

    @Property(name="ispaienabled")
    @JsonIgnore
    public Optional<Boolean> getIspaienabled() {
        return Optional.ofNullable(ispaienabled);
    }

    public Organization withIspaienabled(Boolean ispaienabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("ispaienabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.ispaienabled = ispaienabled;
        return _x;
    }

    @Property(name="isautodatacapturev2enabled")
    @JsonIgnore
    public Optional<Boolean> getIsautodatacapturev2enabled() {
        return Optional.ofNullable(isautodatacapturev2enabled);
    }

    public Organization withIsautodatacapturev2enabled(Boolean isautodatacapturev2enabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isautodatacapturev2enabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isautodatacapturev2enabled = isautodatacapturev2enabled;
        return _x;
    }

    @Property(name="allowautounsubscribeacknowledgement")
    @JsonIgnore
    public Optional<Boolean> getAllowautounsubscribeacknowledgement() {
        return Optional.ofNullable(allowautounsubscribeacknowledgement);
    }

    public Organization withAllowautounsubscribeacknowledgement(Boolean allowautounsubscribeacknowledgement) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowautounsubscribeacknowledgement");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowautounsubscribeacknowledgement = allowautounsubscribeacknowledgement;
        return _x;
    }

    @Property(name="nexttrackingnumber")
    @JsonIgnore
    public Optional<Integer> getNexttrackingnumber() {
        return Optional.ofNullable(nexttrackingnumber);
    }

    public Organization withNexttrackingnumber(Integer nexttrackingnumber) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("nexttrackingnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.nexttrackingnumber = nexttrackingnumber;
        return _x;
    }

    @Property(name="enablepricingoncreate")
    @JsonIgnore
    public Optional<Boolean> getEnablepricingoncreate() {
        return Optional.ofNullable(enablepricingoncreate);
    }

    public Organization withEnablepricingoncreate(Boolean enablepricingoncreate) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("enablepricingoncreate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.enablepricingoncreate = enablepricingoncreate;
        return _x;
    }

    @Property(name="parsedtablecolumnprefix")
    @JsonIgnore
    public Optional<String> getParsedtablecolumnprefix() {
        return Optional.ofNullable(parsedtablecolumnprefix);
    }

    public Organization withParsedtablecolumnprefix(String parsedtablecolumnprefix) {
        Checks.checkIsAscii(parsedtablecolumnprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("parsedtablecolumnprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.parsedtablecolumnprefix = parsedtablecolumnprefix;
        return _x;
    }

    @Property(name="allowusersseeappdownloadmessage")
    @JsonIgnore
    public Optional<Boolean> getAllowusersseeappdownloadmessage() {
        return Optional.ofNullable(allowusersseeappdownloadmessage);
    }

    public Organization withAllowusersseeappdownloadmessage(Boolean allowusersseeappdownloadmessage) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("allowusersseeappdownloadmessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.allowusersseeappdownloadmessage = allowusersseeappdownloadmessage;
        return _x;
    }

    @Property(name="decimalsymbol")
    @JsonIgnore
    public Optional<String> getDecimalsymbol() {
        return Optional.ofNullable(decimalsymbol);
    }

    public Organization withDecimalsymbol(String decimalsymbol) {
        Checks.checkIsAscii(decimalsymbol);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("decimalsymbol");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.decimalsymbol = decimalsymbol;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Organization withModifiedon(OffsetDateTime modifiedon) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="signupoutlookdownloadfwlink")
    @JsonIgnore
    public Optional<String> getSignupoutlookdownloadfwlink() {
        return Optional.ofNullable(signupoutlookdownloadfwlink);
    }

    public Organization withSignupoutlookdownloadfwlink(String signupoutlookdownloadfwlink) {
        Checks.checkIsAscii(signupoutlookdownloadfwlink);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("signupoutlookdownloadfwlink");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.signupoutlookdownloadfwlink = signupoutlookdownloadfwlink;
        return _x;
    }

    @Property(name="isresourcebookingexchangesyncenabled")
    @JsonIgnore
    public Optional<Boolean> getIsresourcebookingexchangesyncenabled() {
        return Optional.ofNullable(isresourcebookingexchangesyncenabled);
    }

    public Organization withIsresourcebookingexchangesyncenabled(Boolean isresourcebookingexchangesyncenabled) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isresourcebookingexchangesyncenabled");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isresourcebookingexchangesyncenabled = isresourcebookingexchangesyncenabled;
        return _x;
    }

    @Property(name="disablesocialcare")
    @JsonIgnore
    public Optional<Boolean> getDisablesocialcare() {
        return Optional.ofNullable(disablesocialcare);
    }

    public Organization withDisablesocialcare(Boolean disablesocialcare) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("disablesocialcare");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.disablesocialcare = disablesocialcare;
        return _x;
    }

    @Property(name="resolvesimilarunresolvedemailaddress")
    @JsonIgnore
    public Optional<Boolean> getResolvesimilarunresolvedemailaddress() {
        return Optional.ofNullable(resolvesimilarunresolvedemailaddress);
    }

    public Organization withResolvesimilarunresolvedemailaddress(Boolean resolvesimilarunresolvedemailaddress) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("resolvesimilarunresolvedemailaddress");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.resolvesimilarunresolvedemailaddress = resolvesimilarunresolvedemailaddress;
        return _x;
    }

    @Property(name="unresolveemailaddressifmultiplematch")
    @JsonIgnore
    public Optional<Boolean> getUnresolveemailaddressifmultiplematch() {
        return Optional.ofNullable(unresolveemailaddressifmultiplematch);
    }

    public Organization withUnresolveemailaddressifmultiplematch(Boolean unresolveemailaddressifmultiplematch) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("unresolveemailaddressifmultiplematch");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.unresolveemailaddressifmultiplematch = unresolveemailaddressifmultiplematch;
        return _x;
    }

    @Property(name="sharetopreviousowneronassign")
    @JsonIgnore
    public Optional<Boolean> getSharetopreviousowneronassign() {
        return Optional.ofNullable(sharetopreviousowneronassign);
    }

    public Organization withSharetopreviousowneronassign(Boolean sharetopreviousowneronassign) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sharetopreviousowneronassign");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sharetopreviousowneronassign = sharetopreviousowneronassign;
        return _x;
    }

    @Property(name="iswriteinproductsallowed")
    @JsonIgnore
    public Optional<Boolean> getIswriteinproductsallowed() {
        return Optional.ofNullable(iswriteinproductsallowed);
    }

    public Organization withIswriteinproductsallowed(Boolean iswriteinproductsallowed) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("iswriteinproductsallowed");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.iswriteinproductsallowed = iswriteinproductsallowed;
        return _x;
    }

    @Property(name="reportinggroupid")
    @JsonIgnore
    public Optional<String> getReportinggroupid() {
        return Optional.ofNullable(reportinggroupid);
    }

    public Organization withReportinggroupid(String reportinggroupid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("reportinggroupid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.reportinggroupid = reportinggroupid;
        return _x;
    }

    @Property(name="qualifyleadadditionaloptions")
    @JsonIgnore
    public Optional<String> getQualifyleadadditionaloptions() {
        return Optional.ofNullable(qualifyleadadditionaloptions);
    }

    public Organization withQualifyleadadditionaloptions(String qualifyleadadditionaloptions) {
        Checks.checkIsAscii(qualifyleadadditionaloptions);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("qualifyleadadditionaloptions");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.qualifyleadadditionaloptions = qualifyleadadditionaloptions;
        return _x;
    }

    @Property(name="isfolderautocreatedonsp")
    @JsonIgnore
    public Optional<Boolean> getIsfolderautocreatedonsp() {
        return Optional.ofNullable(isfolderautocreatedonsp);
    }

    public Organization withIsfolderautocreatedonsp(Boolean isfolderautocreatedonsp) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("isfolderautocreatedonsp");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.isfolderautocreatedonsp = isfolderautocreatedonsp;
        return _x;
    }

    @Property(name="maxfolderbasedtrackingmappings")
    @JsonIgnore
    public Optional<Integer> getMaxfolderbasedtrackingmappings() {
        return Optional.ofNullable(maxfolderbasedtrackingmappings);
    }

    public Organization withMaxfolderbasedtrackingmappings(Integer maxfolderbasedtrackingmappings) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("maxfolderbasedtrackingmappings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.maxfolderbasedtrackingmappings = maxfolderbasedtrackingmappings;
        return _x;
    }

    @Property(name="sqlaccessgroupid")
    @JsonIgnore
    public Optional<String> getSqlaccessgroupid() {
        return Optional.ofNullable(sqlaccessgroupid);
    }

    public Organization withSqlaccessgroupid(String sqlaccessgroupid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("sqlaccessgroupid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.sqlaccessgroupid = sqlaccessgroupid;
        return _x;
    }

    @Property(name="trackingprefix")
    @JsonIgnore
    public Optional<String> getTrackingprefix() {
        return Optional.ofNullable(trackingprefix);
    }

    public Organization withTrackingprefix(String trackingprefix) {
        Checks.checkIsAscii(trackingprefix);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("trackingprefix");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.trackingprefix = trackingprefix;
        return _x;
    }

    @Property(name="yammergroupid")
    @JsonIgnore
    public Optional<Integer> getYammergroupid() {
        return Optional.ofNullable(yammergroupid);
    }

    public Organization withYammergroupid(Integer yammergroupid) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("yammergroupid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.yammergroupid = yammergroupid;
        return _x;
    }

    @Property(name="dateformatstring")
    @JsonIgnore
    public Optional<String> getDateformatstring() {
        return Optional.ofNullable(dateformatstring);
    }

    public Organization withDateformatstring(String dateformatstring) {
        Checks.checkIsAscii(dateformatstring);
        Organization _x = _copy();
        _x.changedFields = changedFields.add("dateformatstring");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.dateformatstring = dateformatstring;
        return _x;
    }

    @Property(name="yammerpostmethod")
    @JsonIgnore
    public Optional<Integer> getYammerpostmethod() {
        return Optional.ofNullable(yammerpostmethod);
    }

    public Organization withYammerpostmethod(Integer yammerpostmethod) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("yammerpostmethod");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.yammerpostmethod = yammerpostmethod;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Organization withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Organization _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.organization");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    public Organization withUnmappedField(String name, String value) {
        Organization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="lk_principalobjectattributeaccess_organizationid")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getLk_principalobjectattributeaccess_organizationid() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("lk_principalobjectattributeaccess_organizationid"), RequestHelper.getValue(unmappedFields, "lk_principalobjectattributeaccess_organizationid"));
    }

    @NavigationProperty(name="organization_theme")
    @JsonIgnore
    public ThemeCollectionRequest getOrganization_theme() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("organization_theme"), RequestHelper.getValue(unmappedFields, "organization_theme"));
    }

    @NavigationProperty(name="organization_UserMapping")
    @JsonIgnore
    public UsermappingCollectionRequest getOrganization_UserMapping() {
        return new UsermappingCollectionRequest(
                        contextPath.addSegment("organization_UserMapping"), RequestHelper.getValue(unmappedFields, "organization_UserMapping"));
    }

    @NavigationProperty(name="organization_metric")
    @JsonIgnore
    public MetricCollectionRequest getOrganization_metric() {
        return new MetricCollectionRequest(
                        contextPath.addSegment("organization_metric"), RequestHelper.getValue(unmappedFields, "organization_metric"));
    }

    @NavigationProperty(name="organization_position")
    @JsonIgnore
    public PositionCollectionRequest getOrganization_position() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("organization_position"), RequestHelper.getValue(unmappedFields, "organization_position"));
    }

    @NavigationProperty(name="organization_officegraphdocument")
    @JsonIgnore
    public OfficegraphdocumentCollectionRequest getOrganization_officegraphdocument() {
        return new OfficegraphdocumentCollectionRequest(
                        contextPath.addSegment("organization_officegraphdocument"), RequestHelper.getValue(unmappedFields, "organization_officegraphdocument"));
    }

    @NavigationProperty(name="organization_recommendeddocument")
    @JsonIgnore
    public RecommendeddocumentCollectionRequest getOrganization_recommendeddocument() {
        return new RecommendeddocumentCollectionRequest(
                        contextPath.addSegment("organization_recommendeddocument"), RequestHelper.getValue(unmappedFields, "organization_recommendeddocument"));
    }

    @NavigationProperty(name="organization_KnowledgeBaseRecord")
    @JsonIgnore
    public KnowledgebaserecordCollectionRequest getOrganization_KnowledgeBaseRecord() {
        return new KnowledgebaserecordCollectionRequest(
                        contextPath.addSegment("organization_KnowledgeBaseRecord"), RequestHelper.getValue(unmappedFields, "organization_KnowledgeBaseRecord"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organization_sdkmessagefilter")
    @JsonIgnore
    public SdkmessagefilterCollectionRequest getOrganization_sdkmessagefilter() {
        return new SdkmessagefilterCollectionRequest(
                        contextPath.addSegment("organization_sdkmessagefilter"), RequestHelper.getValue(unmappedFields, "organization_sdkmessagefilter"));
    }

    @NavigationProperty(name="webresource_organization")
    @JsonIgnore
    public WebresourceCollectionRequest getWebresource_organization() {
        return new WebresourceCollectionRequest(
                        contextPath.addSegment("webresource_organization"), RequestHelper.getValue(unmappedFields, "webresource_organization"));
    }

    @NavigationProperty(name="organization_post")
    @JsonIgnore
    public PostCollectionRequest getOrganization_post() {
        return new PostCollectionRequest(
                        contextPath.addSegment("organization_post"), RequestHelper.getValue(unmappedFields, "organization_post"));
    }

    @NavigationProperty(name="organization_PostComment")
    @JsonIgnore
    public PostcommentCollectionRequest getOrganization_PostComment() {
        return new PostcommentCollectionRequest(
                        contextPath.addSegment("organization_PostComment"), RequestHelper.getValue(unmappedFields, "organization_PostComment"));
    }

    @NavigationProperty(name="organization_postlike")
    @JsonIgnore
    public PostlikeCollectionRequest getOrganization_postlike() {
        return new PostlikeCollectionRequest(
                        contextPath.addSegment("organization_postlike"), RequestHelper.getValue(unmappedFields, "organization_postlike"));
    }

    @NavigationProperty(name="organization_importjob")
    @JsonIgnore
    public ImportjobCollectionRequest getOrganization_importjob() {
        return new ImportjobCollectionRequest(
                        contextPath.addSegment("organization_importjob"), RequestHelper.getValue(unmappedFields, "organization_importjob"));
    }

    @NavigationProperty(name="organization_queues")
    @JsonIgnore
    public QueueCollectionRequest getOrganization_queues() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("organization_queues"), RequestHelper.getValue(unmappedFields, "organization_queues"));
    }

    @NavigationProperty(name="businessclosurecalendarid_calendar")
    @JsonIgnore
    public CalendarRequest getBusinessclosurecalendarid_calendar() {
        return new CalendarRequest(contextPath.addSegment("businessclosurecalendarid_calendar"), RequestHelper.getValue(unmappedFields, "businessclosurecalendarid_calendar"));
    }

    @NavigationProperty(name="organization_pluginassembly")
    @JsonIgnore
    public PluginassemblyCollectionRequest getOrganization_pluginassembly() {
        return new PluginassemblyCollectionRequest(
                        contextPath.addSegment("organization_pluginassembly"), RequestHelper.getValue(unmappedFields, "organization_pluginassembly"));
    }

    @NavigationProperty(name="lk_fieldsecurityprofile_organizationid")
    @JsonIgnore
    public FieldsecurityprofileCollectionRequest getLk_fieldsecurityprofile_organizationid() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("lk_fieldsecurityprofile_organizationid"), RequestHelper.getValue(unmappedFields, "lk_fieldsecurityprofile_organizationid"));
    }

    @NavigationProperty(name="organization_similarityrule")
    @JsonIgnore
    public SimilarityruleCollectionRequest getOrganization_similarityrule() {
        return new SimilarityruleCollectionRequest(
                        contextPath.addSegment("organization_similarityrule"), RequestHelper.getValue(unmappedFields, "organization_similarityrule"));
    }

    @NavigationProperty(name="organization_expiredprocess")
    @JsonIgnore
    public ExpiredprocessCollectionRequest getOrganization_expiredprocess() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("organization_expiredprocess"), RequestHelper.getValue(unmappedFields, "organization_expiredprocess"));
    }

    @NavigationProperty(name="organization_appconfiginstance")
    @JsonIgnore
    public AppconfiginstanceCollectionRequest getOrganization_appconfiginstance() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("organization_appconfiginstance"), RequestHelper.getValue(unmappedFields, "organization_appconfiginstance"));
    }

    @NavigationProperty(name="organization_saved_query_visualizations")
    @JsonIgnore
    public SavedqueryvisualizationCollectionRequest getOrganization_saved_query_visualizations() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("organization_saved_query_visualizations"), RequestHelper.getValue(unmappedFields, "organization_saved_query_visualizations"));
    }

    @NavigationProperty(name="organization_system_users")
    @JsonIgnore
    public SystemuserCollectionRequest getOrganization_system_users() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("organization_system_users"), RequestHelper.getValue(unmappedFields, "organization_system_users"));
    }

    @NavigationProperty(name="organization_publisher")
    @JsonIgnore
    public PublisherCollectionRequest getOrganization_publisher() {
        return new PublisherCollectionRequest(
                        contextPath.addSegment("organization_publisher"), RequestHelper.getValue(unmappedFields, "organization_publisher"));
    }

    @NavigationProperty(name="organization_plugintype")
    @JsonIgnore
    public PlugintypeCollectionRequest getOrganization_plugintype() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("organization_plugintype"), RequestHelper.getValue(unmappedFields, "organization_plugintype"));
    }

    @NavigationProperty(name="Organization_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getOrganization_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Organization_SyncErrors"), RequestHelper.getValue(unmappedFields, "Organization_SyncErrors"));
    }

    @NavigationProperty(name="lk_dataperformance_organizationid")
    @JsonIgnore
    public DataperformanceCollectionRequest getLk_dataperformance_organizationid() {
        return new DataperformanceCollectionRequest(
                        contextPath.addSegment("lk_dataperformance_organizationid"), RequestHelper.getValue(unmappedFields, "lk_dataperformance_organizationid"));
    }

    @NavigationProperty(name="organization_serviceendpoint")
    @JsonIgnore
    public ServiceendpointCollectionRequest getOrganization_serviceendpoint() {
        return new ServiceendpointCollectionRequest(
                        contextPath.addSegment("organization_serviceendpoint"), RequestHelper.getValue(unmappedFields, "organization_serviceendpoint"));
    }

    @NavigationProperty(name="organization_custom_displaystrings")
    @JsonIgnore
    public DisplaystringCollectionRequest getOrganization_custom_displaystrings() {
        return new DisplaystringCollectionRequest(
                        contextPath.addSegment("organization_custom_displaystrings"), RequestHelper.getValue(unmappedFields, "organization_custom_displaystrings"));
    }

    @NavigationProperty(name="organization_sdkmessageprocessingstep")
    @JsonIgnore
    public SdkmessageprocessingstepCollectionRequest getOrganization_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("organization_sdkmessageprocessingstep"), RequestHelper.getValue(unmappedFields, "organization_sdkmessageprocessingstep"));
    }

    @NavigationProperty(name="organization_plugintypestatistic")
    @JsonIgnore
    public PlugintypestatisticCollectionRequest getOrganization_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("organization_plugintypestatistic"), RequestHelper.getValue(unmappedFields, "organization_plugintypestatistic"));
    }

    @NavigationProperty(name="basecurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getBasecurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("basecurrencyid"), RequestHelper.getValue(unmappedFields, "basecurrencyid"));
    }

    @NavigationProperty(name="Organization_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getOrganization_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Organization_AsyncOperations"), RequestHelper.getValue(unmappedFields, "Organization_AsyncOperations"));
    }

    @NavigationProperty(name="organization_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileCollectionRequest getOrganization_emailserverprofile() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("organization_emailserverprofile"), RequestHelper.getValue(unmappedFields, "organization_emailserverprofile"));
    }

    @NavigationProperty(name="organization_saved_queries")
    @JsonIgnore
    public SavedqueryCollectionRequest getOrganization_saved_queries() {
        return new SavedqueryCollectionRequest(
                        contextPath.addSegment("organization_saved_queries"), RequestHelper.getValue(unmappedFields, "organization_saved_queries"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="organization_sitemap")
    @JsonIgnore
    public SitemapCollectionRequest getOrganization_sitemap() {
        return new SitemapCollectionRequest(
                        contextPath.addSegment("organization_sitemap"), RequestHelper.getValue(unmappedFields, "organization_sitemap"));
    }

    @NavigationProperty(name="organization_teams")
    @JsonIgnore
    public TeamCollectionRequest getOrganization_teams() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("organization_teams"), RequestHelper.getValue(unmappedFields, "organization_teams"));
    }

    @NavigationProperty(name="defaultmobileofflineprofileid")
    @JsonIgnore
    public MobileofflineprofileRequest getDefaultmobileofflineprofileid() {
        return new MobileofflineprofileRequest(contextPath.addSegment("defaultmobileofflineprofileid"), RequestHelper.getValue(unmappedFields, "defaultmobileofflineprofileid"));
    }

    @NavigationProperty(name="lk_documenttemplatebase_organization")
    @JsonIgnore
    public DocumenttemplateCollectionRequest getLk_documenttemplatebase_organization() {
        return new DocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_documenttemplatebase_organization"), RequestHelper.getValue(unmappedFields, "lk_documenttemplatebase_organization"));
    }

    @NavigationProperty(name="organization_queueitems")
    @JsonIgnore
    public QueueitemCollectionRequest getOrganization_queueitems() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("organization_queueitems"), RequestHelper.getValue(unmappedFields, "organization_queueitems"));
    }

    @NavigationProperty(name="organization_complexcontrols")
    @JsonIgnore
    public ComplexcontrolCollectionRequest getOrganization_complexcontrols() {
        return new ComplexcontrolCollectionRequest(
                        contextPath.addSegment("organization_complexcontrols"), RequestHelper.getValue(unmappedFields, "organization_complexcontrols"));
    }

    @NavigationProperty(name="organization_solution")
    @JsonIgnore
    public SolutionCollectionRequest getOrganization_solution() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("organization_solution"), RequestHelper.getValue(unmappedFields, "organization_solution"));
    }

    @NavigationProperty(name="organization_business_units")
    @JsonIgnore
    public BusinessunitCollectionRequest getOrganization_business_units() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("organization_business_units"), RequestHelper.getValue(unmappedFields, "organization_business_units"));
    }

    @NavigationProperty(name="MobileOfflineProfile_organization")
    @JsonIgnore
    public MobileofflineprofileCollectionRequest getMobileOfflineProfile_organization() {
        return new MobileofflineprofileCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfile_organization"), RequestHelper.getValue(unmappedFields, "MobileOfflineProfile_organization"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="organization_sdkmessageprocessingstepimage")
    @JsonIgnore
    public SdkmessageprocessingstepimageCollectionRequest getOrganization_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("organization_sdkmessageprocessingstepimage"), RequestHelper.getValue(unmappedFields, "organization_sdkmessageprocessingstepimage"));
    }

    @NavigationProperty(name="customcontrol_organization")
    @JsonIgnore
    public CustomcontrolCollectionRequest getCustomcontrol_organization() {
        return new CustomcontrolCollectionRequest(
                        contextPath.addSegment("customcontrol_organization"), RequestHelper.getValue(unmappedFields, "customcontrol_organization"));
    }

    @NavigationProperty(name="organization_sdkmessageprocessingstepsecureconfig")
    @JsonIgnore
    public SdkmessageprocessingstepsecureconfigCollectionRequest getOrganization_sdkmessageprocessingstepsecureconfig() {
        return new SdkmessageprocessingstepsecureconfigCollectionRequest(
                        contextPath.addSegment("organization_sdkmessageprocessingstepsecureconfig"), RequestHelper.getValue(unmappedFields, "organization_sdkmessageprocessingstepsecureconfig"));
    }

    @NavigationProperty(name="organization_roles")
    @JsonIgnore
    public RoleCollectionRequest getOrganization_roles() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("organization_roles"), RequestHelper.getValue(unmappedFields, "organization_roles"));
    }

    @NavigationProperty(name="organization_appconfigmaster")
    @JsonIgnore
    public AppconfigmasterCollectionRequest getOrganization_appconfigmaster() {
        return new AppconfigmasterCollectionRequest(
                        contextPath.addSegment("organization_appconfigmaster"), RequestHelper.getValue(unmappedFields, "organization_appconfigmaster"));
    }

    @NavigationProperty(name="MobileOfflineProfileItemAssociation_organization")
    @JsonIgnore
    public MobileofflineprofileitemassociationCollectionRequest getMobileOfflineProfileItemAssociation_organization() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfileItemAssociation_organization"), RequestHelper.getValue(unmappedFields, "MobileOfflineProfileItemAssociation_organization"));
    }

    @NavigationProperty(name="Organization_MailboxTrackingFolder")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getOrganization_MailboxTrackingFolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("Organization_MailboxTrackingFolder"), RequestHelper.getValue(unmappedFields, "Organization_MailboxTrackingFolder"));
    }

    @NavigationProperty(name="Organization_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getOrganization_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Organization_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "Organization_BulkDeleteFailures"));
    }

    @NavigationProperty(name="organization_translationprocess")
    @JsonIgnore
    public TranslationprocessCollectionRequest getOrganization_translationprocess() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("organization_translationprocess"), RequestHelper.getValue(unmappedFields, "organization_translationprocess"));
    }

    @NavigationProperty(name="organization_tracelog")
    @JsonIgnore
    public TracelogCollectionRequest getOrganization_tracelog() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("organization_tracelog"), RequestHelper.getValue(unmappedFields, "organization_tracelog"));
    }

    @NavigationProperty(name="organization_systemforms")
    @JsonIgnore
    public SystemformCollectionRequest getOrganization_systemforms() {
        return new SystemformCollectionRequest(
                        contextPath.addSegment("organization_systemforms"), RequestHelper.getValue(unmappedFields, "organization_systemforms"));
    }

    @NavigationProperty(name="organization_business_unit_news_articles")
    @JsonIgnore
    public BusinessunitnewsarticleCollectionRequest getOrganization_business_unit_news_articles() {
        return new BusinessunitnewsarticleCollectionRequest(
                        contextPath.addSegment("organization_business_unit_news_articles"), RequestHelper.getValue(unmappedFields, "organization_business_unit_news_articles"));
    }

    @NavigationProperty(name="organization_kb_articles")
    @JsonIgnore
    public KbarticleCollectionRequest getOrganization_kb_articles() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("organization_kb_articles"), RequestHelper.getValue(unmappedFields, "organization_kb_articles"));
    }

    @NavigationProperty(name="organization_sdkmessage")
    @JsonIgnore
    public SdkmessageCollectionRequest getOrganization_sdkmessage() {
        return new SdkmessageCollectionRequest(
                        contextPath.addSegment("organization_sdkmessage"), RequestHelper.getValue(unmappedFields, "organization_sdkmessage"));
    }

    @NavigationProperty(name="MobileOfflineProfileItem_organization")
    @JsonIgnore
    public MobileofflineprofileitemCollectionRequest getMobileOfflineProfileItem_organization() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfileItem_organization"), RequestHelper.getValue(unmappedFields, "MobileOfflineProfileItem_organization"));
    }

    @NavigationProperty(name="defaultemailserverprofileid")
    @JsonIgnore
    public EmailserverprofileRequest getDefaultemailserverprofileid() {
        return new EmailserverprofileRequest(contextPath.addSegment("defaultemailserverprofileid"), RequestHelper.getValue(unmappedFields, "defaultemailserverprofileid"));
    }

    @NavigationProperty(name="organization_kb_article_templates")
    @JsonIgnore
    public KbarticletemplateCollectionRequest getOrganization_kb_article_templates() {
        return new KbarticletemplateCollectionRequest(
                        contextPath.addSegment("organization_kb_article_templates"), RequestHelper.getValue(unmappedFields, "organization_kb_article_templates"));
    }

    @NavigationProperty(name="customcontrolresource_organization")
    @JsonIgnore
    public CustomcontrolresourceCollectionRequest getCustomcontrolresource_organization() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("customcontrolresource_organization"), RequestHelper.getValue(unmappedFields, "customcontrolresource_organization"));
    }

    @NavigationProperty(name="organization_mailbox")
    @JsonIgnore
    public MailboxCollectionRequest getOrganization_mailbox() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("organization_mailbox"), RequestHelper.getValue(unmappedFields, "organization_mailbox"));
    }

    @NavigationProperty(name="organization_calendars")
    @JsonIgnore
    public CalendarCollectionRequest getOrganization_calendars() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("organization_calendars"), RequestHelper.getValue(unmappedFields, "organization_calendars"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="organization_webwizard")
    @JsonIgnore
    public WebwizardCollectionRequest getOrganization_webwizard() {
        return new WebwizardCollectionRequest(
                        contextPath.addSegment("organization_webwizard"), RequestHelper.getValue(unmappedFields, "organization_webwizard"));
    }

    @NavigationProperty(name="organization_connection_roles")
    @JsonIgnore
    public ConnectionroleCollectionRequest getOrganization_connection_roles() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("organization_connection_roles"), RequestHelper.getValue(unmappedFields, "organization_connection_roles"));
    }

    @NavigationProperty(name="customcontroldefaultconfig_organization")
    @JsonIgnore
    public CustomcontroldefaultconfigCollectionRequest getCustomcontroldefaultconfig_organization() {
        return new CustomcontroldefaultconfigCollectionRequest(
                        contextPath.addSegment("customcontroldefaultconfig_organization"), RequestHelper.getValue(unmappedFields, "customcontroldefaultconfig_organization"));
    }

    @NavigationProperty(name="organization_transactioncurrencies")
    @JsonIgnore
    public TransactioncurrencyCollectionRequest getOrganization_transactioncurrencies() {
        return new TransactioncurrencyCollectionRequest(
                        contextPath.addSegment("organization_transactioncurrencies"), RequestHelper.getValue(unmappedFields, "organization_transactioncurrencies"));
    }

    @NavigationProperty(name="acknowledgementtemplateid")
    @JsonIgnore
    public TemplateRequest getAcknowledgementtemplateid() {
        return new TemplateRequest(contextPath.addSegment("acknowledgementtemplateid"), RequestHelper.getValue(unmappedFields, "acknowledgementtemplateid"));
    }

    @NavigationProperty(name="organization_newprocess")
    @JsonIgnore
    public NewprocessCollectionRequest getOrganization_newprocess() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("organization_newprocess"), RequestHelper.getValue(unmappedFields, "organization_newprocess"));
    }

    @NavigationProperty(name="organization_aciviewmapper")
    @JsonIgnore
    public AciviewmapperCollectionRequest getOrganization_aciviewmapper() {
        return new AciviewmapperCollectionRequest(
                        contextPath.addSegment("organization_aciviewmapper"), RequestHelper.getValue(unmappedFields, "organization_aciviewmapper"));
    }

    @NavigationProperty(name="languagelocale_organization")
    @JsonIgnore
    public LanguagelocaleCollectionRequest getLanguagelocale_organization() {
        return new LanguagelocaleCollectionRequest(
                        contextPath.addSegment("languagelocale_organization"), RequestHelper.getValue(unmappedFields, "languagelocale_organization"));
    }

    @NavigationProperty(name="organization_appconfig")
    @JsonIgnore
    public AppconfigCollectionRequest getOrganization_appconfig() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("organization_appconfig"), RequestHelper.getValue(unmappedFields, "organization_appconfig"));
    }

    @NavigationProperty(name="organization_appmodule")
    @JsonIgnore
    public AppmoduleCollectionRequest getOrganization_appmodule() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("organization_appmodule"), RequestHelper.getValue(unmappedFields, "organization_appmodule"));
    }

    @NavigationProperty(name="organization_navigationsetting")
    @JsonIgnore
    public NavigationsettingCollectionRequest getOrganization_navigationsetting() {
        return new NavigationsettingCollectionRequest(
                        contextPath.addSegment("organization_navigationsetting"), RequestHelper.getValue(unmappedFields, "organization_navigationsetting"));
    }

    @NavigationProperty(name="organization_subjects")
    @JsonIgnore
    public SubjectCollectionRequest getOrganization_subjects() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("organization_subjects"), RequestHelper.getValue(unmappedFields, "organization_subjects"));
    }

    @NavigationProperty(name="organization_solutioncomponentattributeconfiguration")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationCollectionRequest getOrganization_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("organization_solutioncomponentattributeconfiguration"), RequestHelper.getValue(unmappedFields, "organization_solutioncomponentattributeconfiguration"));
    }

    @NavigationProperty(name="organization_solutioncomponentconfiguration")
    @JsonIgnore
    public SolutioncomponentconfigurationCollectionRequest getOrganization_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("organization_solutioncomponentconfiguration"), RequestHelper.getValue(unmappedFields, "organization_solutioncomponentconfiguration"));
    }

    @NavigationProperty(name="organization_solutioncomponentrelationshipconfiguration")
    @JsonIgnore
    public SolutioncomponentrelationshipconfigurationCollectionRequest getOrganization_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("organization_solutioncomponentrelationshipconfiguration"), RequestHelper.getValue(unmappedFields, "organization_solutioncomponentrelationshipconfiguration"));
    }

    @NavigationProperty(name="organization_entityanalyticsconfig")
    @JsonIgnore
    public EntityanalyticsconfigCollectionRequest getOrganization_entityanalyticsconfig() {
        return new EntityanalyticsconfigCollectionRequest(
                        contextPath.addSegment("organization_entityanalyticsconfig"), RequestHelper.getValue(unmappedFields, "organization_entityanalyticsconfig"));
    }

    @NavigationProperty(name="organization_datalakeworkspace")
    @JsonIgnore
    public DatalakeworkspaceCollectionRequest getOrganization_datalakeworkspace() {
        return new DatalakeworkspaceCollectionRequest(
                        contextPath.addSegment("organization_datalakeworkspace"), RequestHelper.getValue(unmappedFields, "organization_datalakeworkspace"));
    }

    @NavigationProperty(name="organization_datalakeworkspacepermission")
    @JsonIgnore
    public DatalakeworkspacepermissionCollectionRequest getOrganization_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("organization_datalakeworkspacepermission"), RequestHelper.getValue(unmappedFields, "organization_datalakeworkspacepermission"));
    }

    @NavigationProperty(name="organization_msdyn_helppage")
    @JsonIgnore
    public Msdyn_helppageCollectionRequest getOrganization_msdyn_helppage() {
        return new Msdyn_helppageCollectionRequest(
                        contextPath.addSegment("organization_msdyn_helppage"), RequestHelper.getValue(unmappedFields, "organization_msdyn_helppage"));
    }

    @NavigationProperty(name="organization_territories")
    @JsonIgnore
    public TerritoryCollectionRequest getOrganization_territories() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("organization_territories"), RequestHelper.getValue(unmappedFields, "organization_territories"));
    }

    @NavigationProperty(name="organization_msdyn_solutionhealthruleset")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetCollectionRequest getOrganization_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetCollectionRequest(
                        contextPath.addSegment("organization_msdyn_solutionhealthruleset"), RequestHelper.getValue(unmappedFields, "organization_msdyn_solutionhealthruleset"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Organization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Organization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Organization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Organization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Organization _copy() {
        Organization _x = new Organization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.autoapplydefaultoncasecreate = autoapplydefaultoncasecreate;
        _x.maxverboseloggingsynccycles = maxverboseloggingsynccycles;
        _x.privilegeusergroupid = privilegeusergroupid;
        _x.expiresubscriptionsindays = expiresubscriptionsindays;
        _x.numberformat = numberformat;
        _x.globalhelpurlenabled = globalhelpurlenabled;
        _x.widgetproperties = widgetproperties;
        _x.taskbasedflowenabled = taskbasedflowenabled;
        _x.iscontextualhelpenabled = iscontextualhelpenabled;
        _x.isquickcreateenabledforopportunityclose = isquickcreateenabledforopportunityclose;
        _x.recurrenceexpansionsynchcreatemax = recurrenceexpansionsynchcreatemax;
        _x.generatealertsforinformation = generatealertsforinformation;
        _x.enablesmartmatching = enablesmartmatching;
        _x.orderprefix = orderprefix;
        _x.reportscripterrors = reportscripterrors;
        _x.organizationstate = organizationstate;
        _x.sessiontimeoutreminderinmins = sessiontimeoutreminderinmins;
        _x.allowwebexcelexport = allowwebexcelexport;
        _x.mobileofflineminlicenseprod = mobileofflineminlicenseprod;
        _x.caseprefix = caseprefix;
        _x.longdateformatcode = longdateformatcode;
        _x.usepositionhierarchy = usepositionhierarchy;
        _x.trackingtokenidbase = trackingtokenidbase;
        _x.allowentityonlyaudit = allowentityonlyaudit;
        _x.globalappendurlparametersenabled = globalappendurlparametersenabled;
        _x.generatealertsforwarnings = generatealertsforwarnings;
        _x.maximumentitieswithactivesla = maximumentitieswithactivesla;
        _x.privreportinggroupid = privreportinggroupid;
        _x.invoiceprefix = invoiceprefix;
        _x.quoteprefix = quoteprefix;
        _x.mailboxintermittentissueminrange = mailboxintermittentissueminrange;
        _x.isassignedtaskssyncenabled = isassignedtaskssyncenabled;
        _x.issopintegrationenabled = issopintegrationenabled;
        _x.ismobileclientondemandsyncenabled = ismobileclientondemandsyncenabled;
        _x.isgeospatialazuremapsintegrationenabled = isgeospatialazuremapsintegrationenabled;
        _x.servestaticresourcesfromazurecdn = servestaticresourcesfromazurecdn;
        _x.isautodatacaptureenabled = isautodatacaptureenabled;
        _x.isemailserverprofilecontentfilteringenabled = isemailserverprofilecontentfilteringenabled;
        _x.isluisenabledford365bot = isluisenabledford365bot;
        _x.blockedattachments = blockedattachments;
        _x.isconflictdetectionenabledformobileclient = isconflictdetectionenabledformobileclient;
        _x.businesscardoptions = businesscardoptions;
        _x.goalrollupfrequency = goalrollupfrequency;
        _x.parsedtableprefix = parsedtableprefix;
        _x.isreadauditenabled = isreadauditenabled;
        _x.requireapprovalforuseremail = requireapprovalforuseremail;
        _x.emailsendpollingperiod = emailsendpollingperiod;
        _x.useinbuiltrulefordefaultpricelistselection = useinbuiltrulefordefaultpricelistselection;
        _x.isrichtextnotesenabled = isrichtextnotesenabled;
        _x.hashdeltasubjectcount = hashdeltasubjectcount;
        _x.recurrenceexpansionjobbatchinterval = recurrenceexpansionjobbatchinterval;
        _x.fiscalperiodformat = fiscalperiodformat;
        _x.officegraphdelveurl = officegraphdelveurl;
        _x.maxrecordsforlookupfilters = maxrecordsforlookupfilters;
        _x.sharepointdeploymenttype = sharepointdeploymenttype;
        _x.isrelationshipinsightsenabled = isrelationshipinsightsenabled;
        _x.requireapprovalforqueueemail = requireapprovalforqueueemail;
        _x.tokenexpiry = tokenexpiry;
        _x.postmessagewhitelistdomains = postmessagewhitelistdomains;
        _x.localeid = localeid;
        _x.createdon = createdon;
        _x.isduplicatedetectionenabledforonlinecreateupdate = isduplicatedetectionenabledforonlinecreateupdate;
        _x.contentsecuritypolicyconfiguration = contentsecuritypolicyconfiguration;
        _x.inactivitytimeoutenabled = inactivitytimeoutenabled;
        _x.displaynavigationtour = displaynavigationtour;
        _x.isautosaveenabled = isautosaveenabled;
        _x.supportuserid = supportuserid;
        _x.currencydisplayoption = currencydisplayoption;
        _x.tokenkey = tokenkey;
        _x.pinpointlanguagecode = pinpointlanguagecode;
        _x.isappointmentattachmentsyncenabled = isappointmentattachmentsyncenabled;
        _x.isenabledforallroles = isenabledforallroles;
        _x.enablelpauthoring = enablelpauthoring;
        _x.mobileofflineminlicensetrial = mobileofflineminlicensetrial;
        _x.auditretentionperiod = auditretentionperiod;
        _x.officeappsautodeploymentenabled = officeappsautodeploymentenabled;
        _x.hashfilterkeywords = hashfilterkeywords;
        _x.isnotesanalysisenabled = isnotesanalysisenabled;
        _x.iscontactmailingaddresssyncenabled = iscontactmailingaddresssyncenabled;
        _x.ismailboxforcedunlockingenabled = ismailboxforcedunlockingenabled;
        _x.isexternalfilestorageenabled = isexternalfilestorageenabled;
        _x.mobileofflinesyncinterval = mobileofflinesyncinterval;
        _x.tagmaxaggressivecycles = tagmaxaggressivecycles;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.grantaccesstonetworkservice = grantaccesstonetworkservice;
        _x.iscontentsecuritypolicyenabled = iscontentsecuritypolicyenabled;
        _x.isdelveactionhubintegrationenabled = isdelveactionhubintegrationenabled;
        _x.allowoutlookscheduledsyncs = allowoutlookscheduledsyncs;
        _x.maximumdynamicpropertiesallowed = maximumdynamicpropertiesallowed;
        _x.numbergroupformat = numbergroupformat;
        _x.entityimageid = entityimageid;
        _x.trackingtokeniddigits = trackingtokeniddigits;
        _x.defaultrecurrenceendrangetype = defaultrecurrenceendrangetype;
        _x.yammernetworkpermalink = yammernetworkpermalink;
        _x.bulkoperationprefix = bulkoperationprefix;
        _x.oobpricecalculationenabled = oobpricecalculationenabled;
        _x.futureexpansionwindow = futureexpansionwindow;
        _x.ispresenceenabled = ispresenceenabled;
        _x.pastexpansionwindow = pastexpansionwindow;
        _x.maximumslakpiperentitywithactivesla = maximumslakpiperentitywithactivesla;
        _x.ismsteamssettingchangedbyuser = ismsteamssettingchangedbyuser;
        _x.picture = picture;
        _x.azureschedulerjobcollectionname = azureschedulerjobcollectionname;
        _x.isofficegraphenabled = isofficegraphenabled;
        _x.orgdborgsettings = orgdborgsettings;
        _x.ismodeldrivenappsinmsteamsenabled = ismodeldrivenappsinmsteamsenabled;
        _x.rierrorstatus = rierrorstatus;
        _x.allowlegacydialogsembedding = allowlegacydialogsembedding;
        _x.emailcorrelationenabled = emailcorrelationenabled;
        _x.maxappointmentdurationdays = maxappointmentdurationdays;
        _x.microsoftflowenvironment = microsoftflowenvironment;
        _x.tracelogmaximumageindays = tracelogmaximumageindays;
        _x.isduplicatedetectionenabledforimport = isduplicatedetectionenabledforimport;
        _x.iscustomcontrolsincanvasappsenabled = iscustomcontrolsincanvasappsenabled;
        _x.enforcereadonlyplugins = enforcereadonlyplugins;
        _x.createproductswithoutparentinactivestate = createproductswithoutparentinactivestate;
        _x.enableunifiedinterfaceshellrefresh = enableunifiedinterfaceshellrefresh;
        _x.textanalyticsenabled = textanalyticsenabled;
        _x.expirechangetrackingindays = expirechangetrackingindays;
        _x.usereadform = usereadform;
        _x.basecurrencysymbol = basecurrencysymbol;
        _x.fiscalyearperiodconnect = fiscalyearperiodconnect;
        _x.maxsupportedinternetexplorerversion = maxsupportedinternetexplorerversion;
        _x.fiscalperiodformatperiod = fiscalperiodformatperiod;
        _x.bingmapsapikey = bingmapsapikey;
        _x.isactionsupportfeatureenabled = isactionsupportfeatureenabled;
        _x.restrictstatusupdate = restrictstatusupdate;
        _x.defaultthemedata = defaultthemedata;
        _x.isonedriveenabled = isonedriveenabled;
        _x.externalpartycorrelationkeys = externalpartycorrelationkeys;
        _x.auditretentionperiodv2 = auditretentionperiodv2;
        _x.negativeformatcode = negativeformatcode;
        _x.ispricelistmandatory = ispricelistmandatory;
        _x.timeseparator = timeseparator;
        _x.maxproductsinbundle = maxproductsinbundle;
        _x.slapausestates = slapausestates;
        _x.v3calloutconfighash = v3calloutconfighash;
        _x.plugintracelogsetting = plugintracelogsetting;
        _x.syncoptinselectionstatus = syncoptinselectionstatus;
        _x.syncbulkoperationmaxlimit = syncbulkoperationmaxlimit;
        _x.allowofflinescheduledsyncs = allowofflinescheduledsyncs;
        _x.basecurrencyprecision = basecurrencyprecision;
        _x.socialinsightsinstance = socialinsightsinstance;
        _x.ishierarchicalsecuritymodelenabled = ishierarchicalsecuritymodelenabled;
        _x.privacystatementurl = privacystatementurl;
        _x.minoutlooksyncinterval = minoutlooksyncinterval;
        _x.currentimportsequencenumber = currentimportsequencenumber;
        _x.isuseraccessauditenabled = isuseraccessauditenabled;
        _x.fiscalyearformatprefix = fiscalyearformatprefix;
        _x.enablebingmapsintegration = enablebingmapsintegration;
        _x.maxslaitemspersla = maxslaitemspersla;
        _x.syncbulkoperationbatchsize = syncbulkoperationbatchsize;
        _x.tagpollingperiod = tagpollingperiod;
        _x.suppresssla = suppresssla;
        _x.clientfeatureset = clientfeatureset;
        _x.versionnumber = versionnumber;
        _x.isemailmonitoringallowed = isemailmonitoringallowed;
        _x.maxverboseloggingmailbox = maxverboseloggingmailbox;
        _x.ismanualsalesforecastingenabled = ismanualsalesforecastingenabled;
        _x.isduplicatedetectionenabled = isduplicatedetectionenabled;
        _x.schemanameprefix = schemanameprefix;
        _x.paipreviewscenarioenabled = paipreviewscenarioenabled;
        _x.autoapplysla = autoapplysla;
        _x.ismsteamscollaborationenabled = ismsteamscollaborationenabled;
        _x.incomingemailexchangeemailretrievalbatchsize = incomingemailexchangeemailretrievalbatchsize;
        _x.ismailboxinactivebackoffenabled = ismailboxinactivebackoffenabled;
        _x.cortanaproactiveexperienceenabled = cortanaproactiveexperienceenabled;
        _x.goalrollupexpirytime = goalrollupexpirytime;
        _x.isplaybookenabled = isplaybookenabled;
        _x.showkbarticledeprecationnotification = showkbarticledeprecationnotification;
        _x.isappmode = isappmode;
        _x._modifiedby_value = _modifiedby_value;
        _x.contractprefix = contractprefix;
        _x.allowautounsubscribe = allowautounsubscribe;
        _x.ignoreinternalemail = ignoreinternalemail;
        _x.ispreviewforautocaptureenabled = ispreviewforautocaptureenabled;
        _x.minofflinesyncinterval = minofflinesyncinterval;
        _x.highcontrastthemedata = highcontrastthemedata;
        _x.systemuserid = systemuserid;
        _x.orginsightsenabled = orginsightsenabled;
        _x.maxactionstepsinbpf = maxactionstepsinbpf;
        _x.socialinsightstermsaccepted = socialinsightstermsaccepted;
        _x.defaultemailsettings = defaultemailsettings;
        _x.generatealertsforerrors = generatealertsforerrors;
        _x.getstartedpanecontentenabled = getstartedpanecontentenabled;
        _x.sqlaccessgroupname = sqlaccessgroupname;
        _x.autoapplydefaultoncaseupdate = autoapplydefaultoncaseupdate;
        _x.negativecurrencyformatcode = negativecurrencyformatcode;
        _x.cascadestatusupdate = cascadestatusupdate;
        _x.powerbifeatureenabled = powerbifeatureenabled;
        _x.fullnameconventioncode = fullnameconventioncode;
        _x.allowaddressbooksyncs = allowaddressbooksyncs;
        _x.notifymailboxownerofemailserverlevelalerts = notifymailboxownerofemailserverlevelalerts;
        _x.usequickfindviewforgridsearch = usequickfindviewforgridsearch;
        _x.discountcalculationmethod = discountcalculationmethod;
        _x.organizationid = organizationid;
        _x.mailboxpermanentissueminrange = mailboxpermanentissueminrange;
        _x.kmsettings = kmsettings;
        _x.isfulltextsearchenabled = isfulltextsearchenabled;
        _x.hashminaddresscount = hashminaddresscount;
        _x.dateseparator = dateseparator;
        _x.weekstartdaycode = weekstartdaycode;
        _x.allowuserformmodepreference = allowuserformmodepreference;
        _x.numberseparator = numberseparator;
        _x.campaignprefix = campaignprefix;
        _x.productrecommendationsenabled = productrecommendationsenabled;
        _x.recurrencedefaultnumberofoccurrences = recurrencedefaultnumberofoccurrences;
        _x.ismsteamsusersyncenabled = ismsteamsusersyncenabled;
        _x.quickfindrecordlimitenabled = quickfindrecordlimitenabled;
        _x.pricingdecimalprecision = pricingdecimalprecision;
        _x.useskypeprotocol = useskypeprotocol;
        _x.rendersecureiframeforemail = rendersecureiframeforemail;
        _x.inactivitytimeoutinmins = inactivitytimeoutinmins;
        _x.sessiontimeoutenabled = sessiontimeoutenabled;
        _x.minaddressbooksyncinterval = minaddressbooksyncinterval;
        _x.externalbaseurl = externalbaseurl;
        _x.issalesassistantenabled = issalesassistantenabled;
        _x._defaultmobileofflineprofileid_value = _defaultmobileofflineprofileid_value;
        _x.amdesignator = amdesignator;
        _x.enableimmersiveskypeintegration = enableimmersiveskypeintegration;
        _x.kbprefix = kbprefix;
        _x.bounddashboarddefaultcardexpanded = bounddashboarddefaultcardexpanded;
        _x.hashmaxcount = hashmaxcount;
        _x.reportinggroupname = reportinggroupname;
        _x.isdelegateaccessenabled = isdelegateaccessenabled;
        _x.aciwebendpointurl = aciwebendpointurl;
        _x.maxuploadfilesize = maxuploadfilesize;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.fiscalyeardisplaycode = fiscalyeardisplaycode;
        _x.yammeroauthaccesstokenexpired = yammeroauthaccesstokenexpired;
        _x.externalpartyentitysettings = externalpartyentitysettings;
        _x.defaultcountrycode = defaultcountrycode;
        _x.isactivityanalysisenabled = isactivityanalysisenabled;
        _x.recurrenceexpansionjobbatchsize = recurrenceexpansionjobbatchsize;
        _x._basecurrencyid_value = _basecurrencyid_value;
        _x.featureset = featureset;
        _x.istextwrapenabled = istextwrapenabled;
        _x.calendartype = calendartype;
        _x.allowclientmessagebarad = allowclientmessagebarad;
        _x.usergroupid = usergroupid;
        _x.isdisabled = isdisabled;
        _x.isduplicatedetectionenabledforofflinesync = isduplicatedetectionenabledforofflinesync;
        _x.languagecode = languagecode;
        _x.appdesignerexperienceenabled = appdesignerexperienceenabled;
        _x.categoryprefix = categoryprefix;
        _x.ispreviewenabledforactioncard = ispreviewenabledforactioncard;
        _x.ismobileofflineenabled = ismobileofflineenabled;
        _x.fiscalcalendarstart = fiscalcalendarstart;
        _x.isexternalsearchindexenabled = isexternalsearchindexenabled;
        _x.maximumactivebusinessprocessflowsallowedperentity = maximumactivebusinessprocessflowsallowedperentity;
        _x.enablelivepersonacarduci = enablelivepersonacarduci;
        _x.timeformatcode = timeformatcode;
        _x.dayssincerecordlastmodifiedmaxvalue = dayssincerecordlastmodifiedmaxvalue;
        _x._acknowledgementtemplateid_value = _acknowledgementtemplateid_value;
        _x.maxdepthforhierarchicalsecuritymodel = maxdepthforhierarchicalsecuritymodel;
        _x.currencysymbol = currencysymbol;
        _x.isfolderbasedtrackingenabled = isfolderbasedtrackingenabled;
        _x.isdefaultcountrycodecheckenabled = isdefaultcountrycodecheckenabled;
        _x.entityimage = entityimage;
        _x.fiscalyearformatyear = fiscalyearformatyear;
        _x.entityimage_timestamp = entityimage_timestamp;
        _x.privreportinggroupname = privreportinggroupname;
        _x.yearstartweekcode = yearstartweekcode;
        _x.uselegacyrendering = uselegacyrendering;
        _x.maximumtrackingnumber = maximumtrackingnumber;
        _x.fiscalyearformatsuffix = fiscalyearformatsuffix;
        _x.allowautoresponsecreation = allowautoresponsecreation;
        _x.allowlegacyclientexperience = allowlegacyclientexperience;
        _x.ismsteamsenabled = ismsteamsenabled;
        _x.enablemicrosoftflowintegration = enablemicrosoftflowintegration;
        _x.currentparsedtablenumber = currentparsedtablenumber;
        _x.socialinsightsenabled = socialinsightsenabled;
        _x._createdby_value = _createdby_value;
        _x.initialversion = initialversion;
        _x.delegatedadminuserid = delegatedadminuserid;
        _x.isfiscalperiodmonthbased = isfiscalperiodmonthbased;
        _x.fiscalperiodtype = fiscalperiodtype;
        _x.inactivitytimeoutreminderinmins = inactivitytimeoutreminderinmins;
        _x.disabledreason = disabledreason;
        _x.uniquespecifierlength = uniquespecifierlength;
        _x.ispdfgenerationenabled = ispdfgenerationenabled;
        _x.enablelivepersoncardintegrationinoffice = enablelivepersoncardintegrationinoffice;
        _x.maxrecordsforexporttoexcel = maxrecordsforexporttoexcel;
        _x.useraccessauditinginterval = useraccessauditinginterval;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.kaprefix = kaprefix;
        _x.allowmarketingemailexecution = allowmarketingemailexecution;
        _x.sqmenabled = sqmenabled;
        _x.timeformatstring = timeformatstring;
        _x.iscontextualemailenabled = iscontextualemailenabled;
        _x.dateformatcode = dateformatcode;
        _x.webresourcehash = webresourcehash;
        _x.syncoptinselection = syncoptinselection;
        _x.sortid = sortid;
        _x.globalhelpurl = globalhelpurl;
        _x.isallmoneydecimal = isallmoneydecimal;
        _x.isauditenabled = isauditenabled;
        _x.fiscalyearformat = fiscalyearformat;
        _x.sendbulkemailinuci = sendbulkemailinuci;
        _x.defaultcrmcustomname = defaultcrmcustomname;
        _x.currencyformatcode = currencyformatcode;
        _x.isbpfentitycustomizationfeatureenabled = isbpfentitycustomizationfeatureenabled;
        _x.maxconditionsformobileofflinefilters = maxconditionsformobileofflinefilters;
        _x.businessclosurecalendarid = businessclosurecalendarid;
        _x.showweeknumber = showweeknumber;
        _x.isactioncardenabled = isactioncardenabled;
        _x.sessiontimeoutinmins = sessiontimeoutinmins;
        _x.appointmentricheditorexperience = appointmentricheditorexperience;
        _x._defaultemailserverprofileid_value = _defaultemailserverprofileid_value;
        _x.integrationuserid = integrationuserid;
        _x.entityimage_url = entityimage_url;
        _x.isnewaddproductexperienceenabled = isnewaddproductexperienceenabled;
        _x.pmdesignator = pmdesignator;
        _x.sampledataimportid = sampledataimportid;
        _x.name = name;
        _x.currencydecimalprecision = currencydecimalprecision;
        _x.emailconnectionchannel = emailconnectionchannel;
        _x.ispreviewforemailmonitoringallowed = ispreviewforemailmonitoringallowed;
        _x.allowunresolvedpartiesonemailsend = allowunresolvedpartiesonemailsend;
        _x.ispaienabled = ispaienabled;
        _x.isautodatacapturev2enabled = isautodatacapturev2enabled;
        _x.allowautounsubscribeacknowledgement = allowautounsubscribeacknowledgement;
        _x.nexttrackingnumber = nexttrackingnumber;
        _x.enablepricingoncreate = enablepricingoncreate;
        _x.parsedtablecolumnprefix = parsedtablecolumnprefix;
        _x.allowusersseeappdownloadmessage = allowusersseeappdownloadmessage;
        _x.decimalsymbol = decimalsymbol;
        _x.modifiedon = modifiedon;
        _x.signupoutlookdownloadfwlink = signupoutlookdownloadfwlink;
        _x.isresourcebookingexchangesyncenabled = isresourcebookingexchangesyncenabled;
        _x.disablesocialcare = disablesocialcare;
        _x.resolvesimilarunresolvedemailaddress = resolvesimilarunresolvedemailaddress;
        _x.unresolveemailaddressifmultiplematch = unresolveemailaddressifmultiplematch;
        _x.sharetopreviousowneronassign = sharetopreviousowneronassign;
        _x.iswriteinproductsallowed = iswriteinproductsallowed;
        _x.reportinggroupid = reportinggroupid;
        _x.qualifyleadadditionaloptions = qualifyleadadditionaloptions;
        _x.isfolderautocreatedonsp = isfolderautocreatedonsp;
        _x.maxfolderbasedtrackingmappings = maxfolderbasedtrackingmappings;
        _x.sqlaccessgroupid = sqlaccessgroupid;
        _x.trackingprefix = trackingprefix;
        _x.yammergroupid = yammergroupid;
        _x.dateformatstring = dateformatstring;
        _x.yammerpostmethod = yammerpostmethod;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Organization[");
        b.append("autoapplydefaultoncasecreate=");
        b.append(this.autoapplydefaultoncasecreate);
        b.append(", ");
        b.append("maxverboseloggingsynccycles=");
        b.append(this.maxverboseloggingsynccycles);
        b.append(", ");
        b.append("privilegeusergroupid=");
        b.append(this.privilegeusergroupid);
        b.append(", ");
        b.append("expiresubscriptionsindays=");
        b.append(this.expiresubscriptionsindays);
        b.append(", ");
        b.append("numberformat=");
        b.append(this.numberformat);
        b.append(", ");
        b.append("globalhelpurlenabled=");
        b.append(this.globalhelpurlenabled);
        b.append(", ");
        b.append("widgetproperties=");
        b.append(this.widgetproperties);
        b.append(", ");
        b.append("taskbasedflowenabled=");
        b.append(this.taskbasedflowenabled);
        b.append(", ");
        b.append("iscontextualhelpenabled=");
        b.append(this.iscontextualhelpenabled);
        b.append(", ");
        b.append("isquickcreateenabledforopportunityclose=");
        b.append(this.isquickcreateenabledforopportunityclose);
        b.append(", ");
        b.append("recurrenceexpansionsynchcreatemax=");
        b.append(this.recurrenceexpansionsynchcreatemax);
        b.append(", ");
        b.append("generatealertsforinformation=");
        b.append(this.generatealertsforinformation);
        b.append(", ");
        b.append("enablesmartmatching=");
        b.append(this.enablesmartmatching);
        b.append(", ");
        b.append("orderprefix=");
        b.append(this.orderprefix);
        b.append(", ");
        b.append("reportscripterrors=");
        b.append(this.reportscripterrors);
        b.append(", ");
        b.append("organizationstate=");
        b.append(this.organizationstate);
        b.append(", ");
        b.append("sessiontimeoutreminderinmins=");
        b.append(this.sessiontimeoutreminderinmins);
        b.append(", ");
        b.append("allowwebexcelexport=");
        b.append(this.allowwebexcelexport);
        b.append(", ");
        b.append("mobileofflineminlicenseprod=");
        b.append(this.mobileofflineminlicenseprod);
        b.append(", ");
        b.append("caseprefix=");
        b.append(this.caseprefix);
        b.append(", ");
        b.append("longdateformatcode=");
        b.append(this.longdateformatcode);
        b.append(", ");
        b.append("usepositionhierarchy=");
        b.append(this.usepositionhierarchy);
        b.append(", ");
        b.append("trackingtokenidbase=");
        b.append(this.trackingtokenidbase);
        b.append(", ");
        b.append("allowentityonlyaudit=");
        b.append(this.allowentityonlyaudit);
        b.append(", ");
        b.append("globalappendurlparametersenabled=");
        b.append(this.globalappendurlparametersenabled);
        b.append(", ");
        b.append("generatealertsforwarnings=");
        b.append(this.generatealertsforwarnings);
        b.append(", ");
        b.append("maximumentitieswithactivesla=");
        b.append(this.maximumentitieswithactivesla);
        b.append(", ");
        b.append("privreportinggroupid=");
        b.append(this.privreportinggroupid);
        b.append(", ");
        b.append("invoiceprefix=");
        b.append(this.invoiceprefix);
        b.append(", ");
        b.append("quoteprefix=");
        b.append(this.quoteprefix);
        b.append(", ");
        b.append("mailboxintermittentissueminrange=");
        b.append(this.mailboxintermittentissueminrange);
        b.append(", ");
        b.append("isassignedtaskssyncenabled=");
        b.append(this.isassignedtaskssyncenabled);
        b.append(", ");
        b.append("issopintegrationenabled=");
        b.append(this.issopintegrationenabled);
        b.append(", ");
        b.append("ismobileclientondemandsyncenabled=");
        b.append(this.ismobileclientondemandsyncenabled);
        b.append(", ");
        b.append("isgeospatialazuremapsintegrationenabled=");
        b.append(this.isgeospatialazuremapsintegrationenabled);
        b.append(", ");
        b.append("servestaticresourcesfromazurecdn=");
        b.append(this.servestaticresourcesfromazurecdn);
        b.append(", ");
        b.append("isautodatacaptureenabled=");
        b.append(this.isautodatacaptureenabled);
        b.append(", ");
        b.append("isemailserverprofilecontentfilteringenabled=");
        b.append(this.isemailserverprofilecontentfilteringenabled);
        b.append(", ");
        b.append("isluisenabledford365bot=");
        b.append(this.isluisenabledford365bot);
        b.append(", ");
        b.append("blockedattachments=");
        b.append(this.blockedattachments);
        b.append(", ");
        b.append("isconflictdetectionenabledformobileclient=");
        b.append(this.isconflictdetectionenabledformobileclient);
        b.append(", ");
        b.append("businesscardoptions=");
        b.append(this.businesscardoptions);
        b.append(", ");
        b.append("goalrollupfrequency=");
        b.append(this.goalrollupfrequency);
        b.append(", ");
        b.append("parsedtableprefix=");
        b.append(this.parsedtableprefix);
        b.append(", ");
        b.append("isreadauditenabled=");
        b.append(this.isreadauditenabled);
        b.append(", ");
        b.append("requireapprovalforuseremail=");
        b.append(this.requireapprovalforuseremail);
        b.append(", ");
        b.append("emailsendpollingperiod=");
        b.append(this.emailsendpollingperiod);
        b.append(", ");
        b.append("useinbuiltrulefordefaultpricelistselection=");
        b.append(this.useinbuiltrulefordefaultpricelistselection);
        b.append(", ");
        b.append("isrichtextnotesenabled=");
        b.append(this.isrichtextnotesenabled);
        b.append(", ");
        b.append("hashdeltasubjectcount=");
        b.append(this.hashdeltasubjectcount);
        b.append(", ");
        b.append("recurrenceexpansionjobbatchinterval=");
        b.append(this.recurrenceexpansionjobbatchinterval);
        b.append(", ");
        b.append("fiscalperiodformat=");
        b.append(this.fiscalperiodformat);
        b.append(", ");
        b.append("officegraphdelveurl=");
        b.append(this.officegraphdelveurl);
        b.append(", ");
        b.append("maxrecordsforlookupfilters=");
        b.append(this.maxrecordsforlookupfilters);
        b.append(", ");
        b.append("sharepointdeploymenttype=");
        b.append(this.sharepointdeploymenttype);
        b.append(", ");
        b.append("isrelationshipinsightsenabled=");
        b.append(this.isrelationshipinsightsenabled);
        b.append(", ");
        b.append("requireapprovalforqueueemail=");
        b.append(this.requireapprovalforqueueemail);
        b.append(", ");
        b.append("tokenexpiry=");
        b.append(this.tokenexpiry);
        b.append(", ");
        b.append("postmessagewhitelistdomains=");
        b.append(this.postmessagewhitelistdomains);
        b.append(", ");
        b.append("localeid=");
        b.append(this.localeid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("isduplicatedetectionenabledforonlinecreateupdate=");
        b.append(this.isduplicatedetectionenabledforonlinecreateupdate);
        b.append(", ");
        b.append("contentsecuritypolicyconfiguration=");
        b.append(this.contentsecuritypolicyconfiguration);
        b.append(", ");
        b.append("inactivitytimeoutenabled=");
        b.append(this.inactivitytimeoutenabled);
        b.append(", ");
        b.append("displaynavigationtour=");
        b.append(this.displaynavigationtour);
        b.append(", ");
        b.append("isautosaveenabled=");
        b.append(this.isautosaveenabled);
        b.append(", ");
        b.append("supportuserid=");
        b.append(this.supportuserid);
        b.append(", ");
        b.append("currencydisplayoption=");
        b.append(this.currencydisplayoption);
        b.append(", ");
        b.append("tokenkey=");
        b.append(this.tokenkey);
        b.append(", ");
        b.append("pinpointlanguagecode=");
        b.append(this.pinpointlanguagecode);
        b.append(", ");
        b.append("isappointmentattachmentsyncenabled=");
        b.append(this.isappointmentattachmentsyncenabled);
        b.append(", ");
        b.append("isenabledforallroles=");
        b.append(this.isenabledforallroles);
        b.append(", ");
        b.append("enablelpauthoring=");
        b.append(this.enablelpauthoring);
        b.append(", ");
        b.append("mobileofflineminlicensetrial=");
        b.append(this.mobileofflineminlicensetrial);
        b.append(", ");
        b.append("auditretentionperiod=");
        b.append(this.auditretentionperiod);
        b.append(", ");
        b.append("officeappsautodeploymentenabled=");
        b.append(this.officeappsautodeploymentenabled);
        b.append(", ");
        b.append("hashfilterkeywords=");
        b.append(this.hashfilterkeywords);
        b.append(", ");
        b.append("isnotesanalysisenabled=");
        b.append(this.isnotesanalysisenabled);
        b.append(", ");
        b.append("iscontactmailingaddresssyncenabled=");
        b.append(this.iscontactmailingaddresssyncenabled);
        b.append(", ");
        b.append("ismailboxforcedunlockingenabled=");
        b.append(this.ismailboxforcedunlockingenabled);
        b.append(", ");
        b.append("isexternalfilestorageenabled=");
        b.append(this.isexternalfilestorageenabled);
        b.append(", ");
        b.append("mobileofflinesyncinterval=");
        b.append(this.mobileofflinesyncinterval);
        b.append(", ");
        b.append("tagmaxaggressivecycles=");
        b.append(this.tagmaxaggressivecycles);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("grantaccesstonetworkservice=");
        b.append(this.grantaccesstonetworkservice);
        b.append(", ");
        b.append("iscontentsecuritypolicyenabled=");
        b.append(this.iscontentsecuritypolicyenabled);
        b.append(", ");
        b.append("isdelveactionhubintegrationenabled=");
        b.append(this.isdelveactionhubintegrationenabled);
        b.append(", ");
        b.append("allowoutlookscheduledsyncs=");
        b.append(this.allowoutlookscheduledsyncs);
        b.append(", ");
        b.append("maximumdynamicpropertiesallowed=");
        b.append(this.maximumdynamicpropertiesallowed);
        b.append(", ");
        b.append("numbergroupformat=");
        b.append(this.numbergroupformat);
        b.append(", ");
        b.append("entityimageid=");
        b.append(this.entityimageid);
        b.append(", ");
        b.append("trackingtokeniddigits=");
        b.append(this.trackingtokeniddigits);
        b.append(", ");
        b.append("defaultrecurrenceendrangetype=");
        b.append(this.defaultrecurrenceendrangetype);
        b.append(", ");
        b.append("yammernetworkpermalink=");
        b.append(this.yammernetworkpermalink);
        b.append(", ");
        b.append("bulkoperationprefix=");
        b.append(this.bulkoperationprefix);
        b.append(", ");
        b.append("oobpricecalculationenabled=");
        b.append(this.oobpricecalculationenabled);
        b.append(", ");
        b.append("futureexpansionwindow=");
        b.append(this.futureexpansionwindow);
        b.append(", ");
        b.append("ispresenceenabled=");
        b.append(this.ispresenceenabled);
        b.append(", ");
        b.append("pastexpansionwindow=");
        b.append(this.pastexpansionwindow);
        b.append(", ");
        b.append("maximumslakpiperentitywithactivesla=");
        b.append(this.maximumslakpiperentitywithactivesla);
        b.append(", ");
        b.append("ismsteamssettingchangedbyuser=");
        b.append(this.ismsteamssettingchangedbyuser);
        b.append(", ");
        b.append("picture=");
        b.append(this.picture);
        b.append(", ");
        b.append("azureschedulerjobcollectionname=");
        b.append(this.azureschedulerjobcollectionname);
        b.append(", ");
        b.append("isofficegraphenabled=");
        b.append(this.isofficegraphenabled);
        b.append(", ");
        b.append("orgdborgsettings=");
        b.append(this.orgdborgsettings);
        b.append(", ");
        b.append("ismodeldrivenappsinmsteamsenabled=");
        b.append(this.ismodeldrivenappsinmsteamsenabled);
        b.append(", ");
        b.append("rierrorstatus=");
        b.append(this.rierrorstatus);
        b.append(", ");
        b.append("allowlegacydialogsembedding=");
        b.append(this.allowlegacydialogsembedding);
        b.append(", ");
        b.append("emailcorrelationenabled=");
        b.append(this.emailcorrelationenabled);
        b.append(", ");
        b.append("maxappointmentdurationdays=");
        b.append(this.maxappointmentdurationdays);
        b.append(", ");
        b.append("microsoftflowenvironment=");
        b.append(this.microsoftflowenvironment);
        b.append(", ");
        b.append("tracelogmaximumageindays=");
        b.append(this.tracelogmaximumageindays);
        b.append(", ");
        b.append("isduplicatedetectionenabledforimport=");
        b.append(this.isduplicatedetectionenabledforimport);
        b.append(", ");
        b.append("iscustomcontrolsincanvasappsenabled=");
        b.append(this.iscustomcontrolsincanvasappsenabled);
        b.append(", ");
        b.append("enforcereadonlyplugins=");
        b.append(this.enforcereadonlyplugins);
        b.append(", ");
        b.append("createproductswithoutparentinactivestate=");
        b.append(this.createproductswithoutparentinactivestate);
        b.append(", ");
        b.append("enableunifiedinterfaceshellrefresh=");
        b.append(this.enableunifiedinterfaceshellrefresh);
        b.append(", ");
        b.append("textanalyticsenabled=");
        b.append(this.textanalyticsenabled);
        b.append(", ");
        b.append("expirechangetrackingindays=");
        b.append(this.expirechangetrackingindays);
        b.append(", ");
        b.append("usereadform=");
        b.append(this.usereadform);
        b.append(", ");
        b.append("basecurrencysymbol=");
        b.append(this.basecurrencysymbol);
        b.append(", ");
        b.append("fiscalyearperiodconnect=");
        b.append(this.fiscalyearperiodconnect);
        b.append(", ");
        b.append("maxsupportedinternetexplorerversion=");
        b.append(this.maxsupportedinternetexplorerversion);
        b.append(", ");
        b.append("fiscalperiodformatperiod=");
        b.append(this.fiscalperiodformatperiod);
        b.append(", ");
        b.append("bingmapsapikey=");
        b.append(this.bingmapsapikey);
        b.append(", ");
        b.append("isactionsupportfeatureenabled=");
        b.append(this.isactionsupportfeatureenabled);
        b.append(", ");
        b.append("restrictstatusupdate=");
        b.append(this.restrictstatusupdate);
        b.append(", ");
        b.append("defaultthemedata=");
        b.append(this.defaultthemedata);
        b.append(", ");
        b.append("isonedriveenabled=");
        b.append(this.isonedriveenabled);
        b.append(", ");
        b.append("externalpartycorrelationkeys=");
        b.append(this.externalpartycorrelationkeys);
        b.append(", ");
        b.append("auditretentionperiodv2=");
        b.append(this.auditretentionperiodv2);
        b.append(", ");
        b.append("negativeformatcode=");
        b.append(this.negativeformatcode);
        b.append(", ");
        b.append("ispricelistmandatory=");
        b.append(this.ispricelistmandatory);
        b.append(", ");
        b.append("timeseparator=");
        b.append(this.timeseparator);
        b.append(", ");
        b.append("maxproductsinbundle=");
        b.append(this.maxproductsinbundle);
        b.append(", ");
        b.append("slapausestates=");
        b.append(this.slapausestates);
        b.append(", ");
        b.append("v3calloutconfighash=");
        b.append(this.v3calloutconfighash);
        b.append(", ");
        b.append("plugintracelogsetting=");
        b.append(this.plugintracelogsetting);
        b.append(", ");
        b.append("syncoptinselectionstatus=");
        b.append(this.syncoptinselectionstatus);
        b.append(", ");
        b.append("syncbulkoperationmaxlimit=");
        b.append(this.syncbulkoperationmaxlimit);
        b.append(", ");
        b.append("allowofflinescheduledsyncs=");
        b.append(this.allowofflinescheduledsyncs);
        b.append(", ");
        b.append("basecurrencyprecision=");
        b.append(this.basecurrencyprecision);
        b.append(", ");
        b.append("socialinsightsinstance=");
        b.append(this.socialinsightsinstance);
        b.append(", ");
        b.append("ishierarchicalsecuritymodelenabled=");
        b.append(this.ishierarchicalsecuritymodelenabled);
        b.append(", ");
        b.append("privacystatementurl=");
        b.append(this.privacystatementurl);
        b.append(", ");
        b.append("minoutlooksyncinterval=");
        b.append(this.minoutlooksyncinterval);
        b.append(", ");
        b.append("currentimportsequencenumber=");
        b.append(this.currentimportsequencenumber);
        b.append(", ");
        b.append("isuseraccessauditenabled=");
        b.append(this.isuseraccessauditenabled);
        b.append(", ");
        b.append("fiscalyearformatprefix=");
        b.append(this.fiscalyearformatprefix);
        b.append(", ");
        b.append("enablebingmapsintegration=");
        b.append(this.enablebingmapsintegration);
        b.append(", ");
        b.append("maxslaitemspersla=");
        b.append(this.maxslaitemspersla);
        b.append(", ");
        b.append("syncbulkoperationbatchsize=");
        b.append(this.syncbulkoperationbatchsize);
        b.append(", ");
        b.append("tagpollingperiod=");
        b.append(this.tagpollingperiod);
        b.append(", ");
        b.append("suppresssla=");
        b.append(this.suppresssla);
        b.append(", ");
        b.append("clientfeatureset=");
        b.append(this.clientfeatureset);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("isemailmonitoringallowed=");
        b.append(this.isemailmonitoringallowed);
        b.append(", ");
        b.append("maxverboseloggingmailbox=");
        b.append(this.maxverboseloggingmailbox);
        b.append(", ");
        b.append("ismanualsalesforecastingenabled=");
        b.append(this.ismanualsalesforecastingenabled);
        b.append(", ");
        b.append("isduplicatedetectionenabled=");
        b.append(this.isduplicatedetectionenabled);
        b.append(", ");
        b.append("schemanameprefix=");
        b.append(this.schemanameprefix);
        b.append(", ");
        b.append("paipreviewscenarioenabled=");
        b.append(this.paipreviewscenarioenabled);
        b.append(", ");
        b.append("autoapplysla=");
        b.append(this.autoapplysla);
        b.append(", ");
        b.append("ismsteamscollaborationenabled=");
        b.append(this.ismsteamscollaborationenabled);
        b.append(", ");
        b.append("incomingemailexchangeemailretrievalbatchsize=");
        b.append(this.incomingemailexchangeemailretrievalbatchsize);
        b.append(", ");
        b.append("ismailboxinactivebackoffenabled=");
        b.append(this.ismailboxinactivebackoffenabled);
        b.append(", ");
        b.append("cortanaproactiveexperienceenabled=");
        b.append(this.cortanaproactiveexperienceenabled);
        b.append(", ");
        b.append("goalrollupexpirytime=");
        b.append(this.goalrollupexpirytime);
        b.append(", ");
        b.append("isplaybookenabled=");
        b.append(this.isplaybookenabled);
        b.append(", ");
        b.append("showkbarticledeprecationnotification=");
        b.append(this.showkbarticledeprecationnotification);
        b.append(", ");
        b.append("isappmode=");
        b.append(this.isappmode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("contractprefix=");
        b.append(this.contractprefix);
        b.append(", ");
        b.append("allowautounsubscribe=");
        b.append(this.allowautounsubscribe);
        b.append(", ");
        b.append("ignoreinternalemail=");
        b.append(this.ignoreinternalemail);
        b.append(", ");
        b.append("ispreviewforautocaptureenabled=");
        b.append(this.ispreviewforautocaptureenabled);
        b.append(", ");
        b.append("minofflinesyncinterval=");
        b.append(this.minofflinesyncinterval);
        b.append(", ");
        b.append("highcontrastthemedata=");
        b.append(this.highcontrastthemedata);
        b.append(", ");
        b.append("systemuserid=");
        b.append(this.systemuserid);
        b.append(", ");
        b.append("orginsightsenabled=");
        b.append(this.orginsightsenabled);
        b.append(", ");
        b.append("maxactionstepsinbpf=");
        b.append(this.maxactionstepsinbpf);
        b.append(", ");
        b.append("socialinsightstermsaccepted=");
        b.append(this.socialinsightstermsaccepted);
        b.append(", ");
        b.append("defaultemailsettings=");
        b.append(this.defaultemailsettings);
        b.append(", ");
        b.append("generatealertsforerrors=");
        b.append(this.generatealertsforerrors);
        b.append(", ");
        b.append("getstartedpanecontentenabled=");
        b.append(this.getstartedpanecontentenabled);
        b.append(", ");
        b.append("sqlaccessgroupname=");
        b.append(this.sqlaccessgroupname);
        b.append(", ");
        b.append("autoapplydefaultoncaseupdate=");
        b.append(this.autoapplydefaultoncaseupdate);
        b.append(", ");
        b.append("negativecurrencyformatcode=");
        b.append(this.negativecurrencyformatcode);
        b.append(", ");
        b.append("cascadestatusupdate=");
        b.append(this.cascadestatusupdate);
        b.append(", ");
        b.append("powerbifeatureenabled=");
        b.append(this.powerbifeatureenabled);
        b.append(", ");
        b.append("fullnameconventioncode=");
        b.append(this.fullnameconventioncode);
        b.append(", ");
        b.append("allowaddressbooksyncs=");
        b.append(this.allowaddressbooksyncs);
        b.append(", ");
        b.append("notifymailboxownerofemailserverlevelalerts=");
        b.append(this.notifymailboxownerofemailserverlevelalerts);
        b.append(", ");
        b.append("usequickfindviewforgridsearch=");
        b.append(this.usequickfindviewforgridsearch);
        b.append(", ");
        b.append("discountcalculationmethod=");
        b.append(this.discountcalculationmethod);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append(", ");
        b.append("mailboxpermanentissueminrange=");
        b.append(this.mailboxpermanentissueminrange);
        b.append(", ");
        b.append("kmsettings=");
        b.append(this.kmsettings);
        b.append(", ");
        b.append("isfulltextsearchenabled=");
        b.append(this.isfulltextsearchenabled);
        b.append(", ");
        b.append("hashminaddresscount=");
        b.append(this.hashminaddresscount);
        b.append(", ");
        b.append("dateseparator=");
        b.append(this.dateseparator);
        b.append(", ");
        b.append("weekstartdaycode=");
        b.append(this.weekstartdaycode);
        b.append(", ");
        b.append("allowuserformmodepreference=");
        b.append(this.allowuserformmodepreference);
        b.append(", ");
        b.append("numberseparator=");
        b.append(this.numberseparator);
        b.append(", ");
        b.append("campaignprefix=");
        b.append(this.campaignprefix);
        b.append(", ");
        b.append("productrecommendationsenabled=");
        b.append(this.productrecommendationsenabled);
        b.append(", ");
        b.append("recurrencedefaultnumberofoccurrences=");
        b.append(this.recurrencedefaultnumberofoccurrences);
        b.append(", ");
        b.append("ismsteamsusersyncenabled=");
        b.append(this.ismsteamsusersyncenabled);
        b.append(", ");
        b.append("quickfindrecordlimitenabled=");
        b.append(this.quickfindrecordlimitenabled);
        b.append(", ");
        b.append("pricingdecimalprecision=");
        b.append(this.pricingdecimalprecision);
        b.append(", ");
        b.append("useskypeprotocol=");
        b.append(this.useskypeprotocol);
        b.append(", ");
        b.append("rendersecureiframeforemail=");
        b.append(this.rendersecureiframeforemail);
        b.append(", ");
        b.append("inactivitytimeoutinmins=");
        b.append(this.inactivitytimeoutinmins);
        b.append(", ");
        b.append("sessiontimeoutenabled=");
        b.append(this.sessiontimeoutenabled);
        b.append(", ");
        b.append("minaddressbooksyncinterval=");
        b.append(this.minaddressbooksyncinterval);
        b.append(", ");
        b.append("externalbaseurl=");
        b.append(this.externalbaseurl);
        b.append(", ");
        b.append("issalesassistantenabled=");
        b.append(this.issalesassistantenabled);
        b.append(", ");
        b.append("_defaultmobileofflineprofileid_value=");
        b.append(this._defaultmobileofflineprofileid_value);
        b.append(", ");
        b.append("amdesignator=");
        b.append(this.amdesignator);
        b.append(", ");
        b.append("enableimmersiveskypeintegration=");
        b.append(this.enableimmersiveskypeintegration);
        b.append(", ");
        b.append("kbprefix=");
        b.append(this.kbprefix);
        b.append(", ");
        b.append("bounddashboarddefaultcardexpanded=");
        b.append(this.bounddashboarddefaultcardexpanded);
        b.append(", ");
        b.append("hashmaxcount=");
        b.append(this.hashmaxcount);
        b.append(", ");
        b.append("reportinggroupname=");
        b.append(this.reportinggroupname);
        b.append(", ");
        b.append("isdelegateaccessenabled=");
        b.append(this.isdelegateaccessenabled);
        b.append(", ");
        b.append("aciwebendpointurl=");
        b.append(this.aciwebendpointurl);
        b.append(", ");
        b.append("maxuploadfilesize=");
        b.append(this.maxuploadfilesize);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("fiscalyeardisplaycode=");
        b.append(this.fiscalyeardisplaycode);
        b.append(", ");
        b.append("yammeroauthaccesstokenexpired=");
        b.append(this.yammeroauthaccesstokenexpired);
        b.append(", ");
        b.append("externalpartyentitysettings=");
        b.append(this.externalpartyentitysettings);
        b.append(", ");
        b.append("defaultcountrycode=");
        b.append(this.defaultcountrycode);
        b.append(", ");
        b.append("isactivityanalysisenabled=");
        b.append(this.isactivityanalysisenabled);
        b.append(", ");
        b.append("recurrenceexpansionjobbatchsize=");
        b.append(this.recurrenceexpansionjobbatchsize);
        b.append(", ");
        b.append("_basecurrencyid_value=");
        b.append(this._basecurrencyid_value);
        b.append(", ");
        b.append("featureset=");
        b.append(this.featureset);
        b.append(", ");
        b.append("istextwrapenabled=");
        b.append(this.istextwrapenabled);
        b.append(", ");
        b.append("calendartype=");
        b.append(this.calendartype);
        b.append(", ");
        b.append("allowclientmessagebarad=");
        b.append(this.allowclientmessagebarad);
        b.append(", ");
        b.append("usergroupid=");
        b.append(this.usergroupid);
        b.append(", ");
        b.append("isdisabled=");
        b.append(this.isdisabled);
        b.append(", ");
        b.append("isduplicatedetectionenabledforofflinesync=");
        b.append(this.isduplicatedetectionenabledforofflinesync);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("appdesignerexperienceenabled=");
        b.append(this.appdesignerexperienceenabled);
        b.append(", ");
        b.append("categoryprefix=");
        b.append(this.categoryprefix);
        b.append(", ");
        b.append("ispreviewenabledforactioncard=");
        b.append(this.ispreviewenabledforactioncard);
        b.append(", ");
        b.append("ismobileofflineenabled=");
        b.append(this.ismobileofflineenabled);
        b.append(", ");
        b.append("fiscalcalendarstart=");
        b.append(this.fiscalcalendarstart);
        b.append(", ");
        b.append("isexternalsearchindexenabled=");
        b.append(this.isexternalsearchindexenabled);
        b.append(", ");
        b.append("maximumactivebusinessprocessflowsallowedperentity=");
        b.append(this.maximumactivebusinessprocessflowsallowedperentity);
        b.append(", ");
        b.append("enablelivepersonacarduci=");
        b.append(this.enablelivepersonacarduci);
        b.append(", ");
        b.append("timeformatcode=");
        b.append(this.timeformatcode);
        b.append(", ");
        b.append("dayssincerecordlastmodifiedmaxvalue=");
        b.append(this.dayssincerecordlastmodifiedmaxvalue);
        b.append(", ");
        b.append("_acknowledgementtemplateid_value=");
        b.append(this._acknowledgementtemplateid_value);
        b.append(", ");
        b.append("maxdepthforhierarchicalsecuritymodel=");
        b.append(this.maxdepthforhierarchicalsecuritymodel);
        b.append(", ");
        b.append("currencysymbol=");
        b.append(this.currencysymbol);
        b.append(", ");
        b.append("isfolderbasedtrackingenabled=");
        b.append(this.isfolderbasedtrackingenabled);
        b.append(", ");
        b.append("isdefaultcountrycodecheckenabled=");
        b.append(this.isdefaultcountrycodecheckenabled);
        b.append(", ");
        b.append("entityimage=");
        b.append(this.entityimage);
        b.append(", ");
        b.append("fiscalyearformatyear=");
        b.append(this.fiscalyearformatyear);
        b.append(", ");
        b.append("entityimage_timestamp=");
        b.append(this.entityimage_timestamp);
        b.append(", ");
        b.append("privreportinggroupname=");
        b.append(this.privreportinggroupname);
        b.append(", ");
        b.append("yearstartweekcode=");
        b.append(this.yearstartweekcode);
        b.append(", ");
        b.append("uselegacyrendering=");
        b.append(this.uselegacyrendering);
        b.append(", ");
        b.append("maximumtrackingnumber=");
        b.append(this.maximumtrackingnumber);
        b.append(", ");
        b.append("fiscalyearformatsuffix=");
        b.append(this.fiscalyearformatsuffix);
        b.append(", ");
        b.append("allowautoresponsecreation=");
        b.append(this.allowautoresponsecreation);
        b.append(", ");
        b.append("allowlegacyclientexperience=");
        b.append(this.allowlegacyclientexperience);
        b.append(", ");
        b.append("ismsteamsenabled=");
        b.append(this.ismsteamsenabled);
        b.append(", ");
        b.append("enablemicrosoftflowintegration=");
        b.append(this.enablemicrosoftflowintegration);
        b.append(", ");
        b.append("currentparsedtablenumber=");
        b.append(this.currentparsedtablenumber);
        b.append(", ");
        b.append("socialinsightsenabled=");
        b.append(this.socialinsightsenabled);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("initialversion=");
        b.append(this.initialversion);
        b.append(", ");
        b.append("delegatedadminuserid=");
        b.append(this.delegatedadminuserid);
        b.append(", ");
        b.append("isfiscalperiodmonthbased=");
        b.append(this.isfiscalperiodmonthbased);
        b.append(", ");
        b.append("fiscalperiodtype=");
        b.append(this.fiscalperiodtype);
        b.append(", ");
        b.append("inactivitytimeoutreminderinmins=");
        b.append(this.inactivitytimeoutreminderinmins);
        b.append(", ");
        b.append("disabledreason=");
        b.append(this.disabledreason);
        b.append(", ");
        b.append("uniquespecifierlength=");
        b.append(this.uniquespecifierlength);
        b.append(", ");
        b.append("ispdfgenerationenabled=");
        b.append(this.ispdfgenerationenabled);
        b.append(", ");
        b.append("enablelivepersoncardintegrationinoffice=");
        b.append(this.enablelivepersoncardintegrationinoffice);
        b.append(", ");
        b.append("maxrecordsforexporttoexcel=");
        b.append(this.maxrecordsforexporttoexcel);
        b.append(", ");
        b.append("useraccessauditinginterval=");
        b.append(this.useraccessauditinginterval);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("kaprefix=");
        b.append(this.kaprefix);
        b.append(", ");
        b.append("allowmarketingemailexecution=");
        b.append(this.allowmarketingemailexecution);
        b.append(", ");
        b.append("sqmenabled=");
        b.append(this.sqmenabled);
        b.append(", ");
        b.append("timeformatstring=");
        b.append(this.timeformatstring);
        b.append(", ");
        b.append("iscontextualemailenabled=");
        b.append(this.iscontextualemailenabled);
        b.append(", ");
        b.append("dateformatcode=");
        b.append(this.dateformatcode);
        b.append(", ");
        b.append("webresourcehash=");
        b.append(this.webresourcehash);
        b.append(", ");
        b.append("syncoptinselection=");
        b.append(this.syncoptinselection);
        b.append(", ");
        b.append("sortid=");
        b.append(this.sortid);
        b.append(", ");
        b.append("globalhelpurl=");
        b.append(this.globalhelpurl);
        b.append(", ");
        b.append("isallmoneydecimal=");
        b.append(this.isallmoneydecimal);
        b.append(", ");
        b.append("isauditenabled=");
        b.append(this.isauditenabled);
        b.append(", ");
        b.append("fiscalyearformat=");
        b.append(this.fiscalyearformat);
        b.append(", ");
        b.append("sendbulkemailinuci=");
        b.append(this.sendbulkemailinuci);
        b.append(", ");
        b.append("defaultcrmcustomname=");
        b.append(this.defaultcrmcustomname);
        b.append(", ");
        b.append("currencyformatcode=");
        b.append(this.currencyformatcode);
        b.append(", ");
        b.append("isbpfentitycustomizationfeatureenabled=");
        b.append(this.isbpfentitycustomizationfeatureenabled);
        b.append(", ");
        b.append("maxconditionsformobileofflinefilters=");
        b.append(this.maxconditionsformobileofflinefilters);
        b.append(", ");
        b.append("businessclosurecalendarid=");
        b.append(this.businessclosurecalendarid);
        b.append(", ");
        b.append("showweeknumber=");
        b.append(this.showweeknumber);
        b.append(", ");
        b.append("isactioncardenabled=");
        b.append(this.isactioncardenabled);
        b.append(", ");
        b.append("sessiontimeoutinmins=");
        b.append(this.sessiontimeoutinmins);
        b.append(", ");
        b.append("appointmentricheditorexperience=");
        b.append(this.appointmentricheditorexperience);
        b.append(", ");
        b.append("_defaultemailserverprofileid_value=");
        b.append(this._defaultemailserverprofileid_value);
        b.append(", ");
        b.append("integrationuserid=");
        b.append(this.integrationuserid);
        b.append(", ");
        b.append("entityimage_url=");
        b.append(this.entityimage_url);
        b.append(", ");
        b.append("isnewaddproductexperienceenabled=");
        b.append(this.isnewaddproductexperienceenabled);
        b.append(", ");
        b.append("pmdesignator=");
        b.append(this.pmdesignator);
        b.append(", ");
        b.append("sampledataimportid=");
        b.append(this.sampledataimportid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("currencydecimalprecision=");
        b.append(this.currencydecimalprecision);
        b.append(", ");
        b.append("emailconnectionchannel=");
        b.append(this.emailconnectionchannel);
        b.append(", ");
        b.append("ispreviewforemailmonitoringallowed=");
        b.append(this.ispreviewforemailmonitoringallowed);
        b.append(", ");
        b.append("allowunresolvedpartiesonemailsend=");
        b.append(this.allowunresolvedpartiesonemailsend);
        b.append(", ");
        b.append("ispaienabled=");
        b.append(this.ispaienabled);
        b.append(", ");
        b.append("isautodatacapturev2enabled=");
        b.append(this.isautodatacapturev2enabled);
        b.append(", ");
        b.append("allowautounsubscribeacknowledgement=");
        b.append(this.allowautounsubscribeacknowledgement);
        b.append(", ");
        b.append("nexttrackingnumber=");
        b.append(this.nexttrackingnumber);
        b.append(", ");
        b.append("enablepricingoncreate=");
        b.append(this.enablepricingoncreate);
        b.append(", ");
        b.append("parsedtablecolumnprefix=");
        b.append(this.parsedtablecolumnprefix);
        b.append(", ");
        b.append("allowusersseeappdownloadmessage=");
        b.append(this.allowusersseeappdownloadmessage);
        b.append(", ");
        b.append("decimalsymbol=");
        b.append(this.decimalsymbol);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("signupoutlookdownloadfwlink=");
        b.append(this.signupoutlookdownloadfwlink);
        b.append(", ");
        b.append("isresourcebookingexchangesyncenabled=");
        b.append(this.isresourcebookingexchangesyncenabled);
        b.append(", ");
        b.append("disablesocialcare=");
        b.append(this.disablesocialcare);
        b.append(", ");
        b.append("resolvesimilarunresolvedemailaddress=");
        b.append(this.resolvesimilarunresolvedemailaddress);
        b.append(", ");
        b.append("unresolveemailaddressifmultiplematch=");
        b.append(this.unresolveemailaddressifmultiplematch);
        b.append(", ");
        b.append("sharetopreviousowneronassign=");
        b.append(this.sharetopreviousowneronassign);
        b.append(", ");
        b.append("iswriteinproductsallowed=");
        b.append(this.iswriteinproductsallowed);
        b.append(", ");
        b.append("reportinggroupid=");
        b.append(this.reportinggroupid);
        b.append(", ");
        b.append("qualifyleadadditionaloptions=");
        b.append(this.qualifyleadadditionaloptions);
        b.append(", ");
        b.append("isfolderautocreatedonsp=");
        b.append(this.isfolderautocreatedonsp);
        b.append(", ");
        b.append("maxfolderbasedtrackingmappings=");
        b.append(this.maxfolderbasedtrackingmappings);
        b.append(", ");
        b.append("sqlaccessgroupid=");
        b.append(this.sqlaccessgroupid);
        b.append(", ");
        b.append("trackingprefix=");
        b.append(this.trackingprefix);
        b.append(", ");
        b.append("yammergroupid=");
        b.append(this.yammergroupid);
        b.append(", ");
        b.append("dateformatstring=");
        b.append(this.dateformatstring);
        b.append(", ");
        b.append("yammerpostmethod=");
        b.append(this.yammerpostmethod);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
