package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.AppconfigRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "parentnavigationsettingid", 
    "overwritetime", 
    "solutionid", 
    "name", 
    "componentstate", 
    "settingtype", 
    "appconfigidunique", 
    "resourceid", 
    "_createdonbehalfby_value", 
    "privileges", 
    "importsequencenumber", 
    "ismanaged", 
    "advancedsettingorder", 
    "_appconfigid_value", 
    "createdon", 
    "iconresourceid", 
    "_modifiedonbehalfby_value", 
    "_organizationid_value", 
    "overriddencreatedon", 
    "quicksettingorder", 
    "_modifiedby_value", 
    "_createdby_value", 
    "modifiedon", 
    "pageurl", 
    "groupname", 
    "objecttypecode", 
    "introducedversion", 
    "description", 
    "navigationsettingid", 
    "navigationsettingidunique", 
    "progressstate"})
@JsonInclude(Include.NON_NULL)
public class Navigationsetting extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.navigationsetting";
    }

    @JsonProperty("parentnavigationsettingid")
    protected String parentnavigationsettingid;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("settingtype")
    protected Integer settingtype;

    @JsonProperty("appconfigidunique")
    protected String appconfigidunique;

    @JsonProperty("resourceid")
    protected String resourceid;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("privileges")
    protected Integer privileges;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("advancedsettingorder")
    protected Integer advancedsettingorder;

    @JsonProperty("_appconfigid_value")
    protected String _appconfigid_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("iconresourceid")
    protected String iconresourceid;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("quicksettingorder")
    protected Integer quicksettingorder;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("pageurl")
    protected String pageurl;

    @JsonProperty("groupname")
    protected String groupname;

    @JsonProperty("objecttypecode")
    protected Integer objecttypecode;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("navigationsettingid")
    protected String navigationsettingid;

    @JsonProperty("navigationsettingidunique")
    protected String navigationsettingidunique;

    @JsonProperty("progressstate")
    protected Boolean progressstate;

    protected Navigationsetting() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderNavigationsetting() {
        return new Builder();
    }

    public static final class Builder {
        private String parentnavigationsettingid;
        private OffsetDateTime overwritetime;
        private String solutionid;
        private String name;
        private Integer componentstate;
        private Integer settingtype;
        private String appconfigidunique;
        private String resourceid;
        private String _createdonbehalfby_value;
        private Integer privileges;
        private Integer importsequencenumber;
        private Boolean ismanaged;
        private Integer advancedsettingorder;
        private String _appconfigid_value;
        private OffsetDateTime createdon;
        private String iconresourceid;
        private String _modifiedonbehalfby_value;
        private String _organizationid_value;
        private OffsetDateTime overriddencreatedon;
        private Integer quicksettingorder;
        private String _modifiedby_value;
        private String _createdby_value;
        private OffsetDateTime modifiedon;
        private String pageurl;
        private String groupname;
        private Integer objecttypecode;
        private String introducedversion;
        private String description;
        private String navigationsettingid;
        private String navigationsettingidunique;
        private Boolean progressstate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder parentnavigationsettingid(String parentnavigationsettingid) {
            this.parentnavigationsettingid = parentnavigationsettingid;
            this.changedFields = changedFields.add("parentnavigationsettingid");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder settingtype(Integer settingtype) {
            this.settingtype = settingtype;
            this.changedFields = changedFields.add("settingtype");
            return this;
        }

        public Builder appconfigidunique(String appconfigidunique) {
            this.appconfigidunique = appconfigidunique;
            this.changedFields = changedFields.add("appconfigidunique");
            return this;
        }

        public Builder resourceid(String resourceid) {
            this.resourceid = resourceid;
            this.changedFields = changedFields.add("resourceid");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder privileges(Integer privileges) {
            this.privileges = privileges;
            this.changedFields = changedFields.add("privileges");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder advancedsettingorder(Integer advancedsettingorder) {
            this.advancedsettingorder = advancedsettingorder;
            this.changedFields = changedFields.add("advancedsettingorder");
            return this;
        }

        public Builder _appconfigid_value(String _appconfigid_value) {
            this._appconfigid_value = _appconfigid_value;
            this.changedFields = changedFields.add("_appconfigid_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder iconresourceid(String iconresourceid) {
            this.iconresourceid = iconresourceid;
            this.changedFields = changedFields.add("iconresourceid");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder quicksettingorder(Integer quicksettingorder) {
            this.quicksettingorder = quicksettingorder;
            this.changedFields = changedFields.add("quicksettingorder");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder pageurl(String pageurl) {
            this.pageurl = pageurl;
            this.changedFields = changedFields.add("pageurl");
            return this;
        }

        public Builder groupname(String groupname) {
            this.groupname = groupname;
            this.changedFields = changedFields.add("groupname");
            return this;
        }

        public Builder objecttypecode(Integer objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder navigationsettingid(String navigationsettingid) {
            this.navigationsettingid = navigationsettingid;
            this.changedFields = changedFields.add("navigationsettingid");
            return this;
        }

        public Builder navigationsettingidunique(String navigationsettingidunique) {
            this.navigationsettingidunique = navigationsettingidunique;
            this.changedFields = changedFields.add("navigationsettingidunique");
            return this;
        }

        public Builder progressstate(Boolean progressstate) {
            this.progressstate = progressstate;
            this.changedFields = changedFields.add("progressstate");
            return this;
        }

        public Navigationsetting build() {
            Navigationsetting _x = new Navigationsetting();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.navigationsetting";
            _x.parentnavigationsettingid = parentnavigationsettingid;
            _x.overwritetime = overwritetime;
            _x.solutionid = solutionid;
            _x.name = name;
            _x.componentstate = componentstate;
            _x.settingtype = settingtype;
            _x.appconfigidunique = appconfigidunique;
            _x.resourceid = resourceid;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.privileges = privileges;
            _x.importsequencenumber = importsequencenumber;
            _x.ismanaged = ismanaged;
            _x.advancedsettingorder = advancedsettingorder;
            _x._appconfigid_value = _appconfigid_value;
            _x.createdon = createdon;
            _x.iconresourceid = iconresourceid;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._organizationid_value = _organizationid_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.quicksettingorder = quicksettingorder;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdby_value = _createdby_value;
            _x.modifiedon = modifiedon;
            _x.pageurl = pageurl;
            _x.groupname = groupname;
            _x.objecttypecode = objecttypecode;
            _x.introducedversion = introducedversion;
            _x.description = description;
            _x.navigationsettingid = navigationsettingid;
            _x.navigationsettingidunique = navigationsettingidunique;
            _x.progressstate = progressstate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && navigationsettingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(navigationsettingid.toString()));
        }
    }

    @Property(name="parentnavigationsettingid")
    @JsonIgnore
    public Optional<String> getParentnavigationsettingid() {
        return Optional.ofNullable(parentnavigationsettingid);
    }

    public Navigationsetting withParentnavigationsettingid(String parentnavigationsettingid) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("parentnavigationsettingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.parentnavigationsettingid = parentnavigationsettingid;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Navigationsetting withOverwritetime(OffsetDateTime overwritetime) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Navigationsetting withSolutionid(String solutionid) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Navigationsetting withName(String name) {
        Checks.checkIsAscii(name);
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.name = name;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Navigationsetting withComponentstate(Integer componentstate) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="settingtype")
    @JsonIgnore
    public Optional<Integer> getSettingtype() {
        return Optional.ofNullable(settingtype);
    }

    public Navigationsetting withSettingtype(Integer settingtype) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("settingtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.settingtype = settingtype;
        return _x;
    }

    @Property(name="appconfigidunique")
    @JsonIgnore
    public Optional<String> getAppconfigidunique() {
        return Optional.ofNullable(appconfigidunique);
    }

    public Navigationsetting withAppconfigidunique(String appconfigidunique) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("appconfigidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.appconfigidunique = appconfigidunique;
        return _x;
    }

    @Property(name="resourceid")
    @JsonIgnore
    public Optional<String> getResourceid() {
        return Optional.ofNullable(resourceid);
    }

    public Navigationsetting withResourceid(String resourceid) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("resourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.resourceid = resourceid;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Navigationsetting with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="privileges")
    @JsonIgnore
    public Optional<Integer> getPrivileges() {
        return Optional.ofNullable(privileges);
    }

    public Navigationsetting withPrivileges(Integer privileges) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("privileges");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.privileges = privileges;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Navigationsetting withImportsequencenumber(Integer importsequencenumber) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Navigationsetting withIsmanaged(Boolean ismanaged) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="advancedsettingorder")
    @JsonIgnore
    public Optional<Integer> getAdvancedsettingorder() {
        return Optional.ofNullable(advancedsettingorder);
    }

    public Navigationsetting withAdvancedsettingorder(Integer advancedsettingorder) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("advancedsettingorder");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.advancedsettingorder = advancedsettingorder;
        return _x;
    }

    @Property(name="_appconfigid_value")
    @JsonIgnore
    public Optional<String> get_appconfigid_value() {
        return Optional.ofNullable(_appconfigid_value);
    }

    public Navigationsetting with_appconfigid_value(String _appconfigid_value) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("_appconfigid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x._appconfigid_value = _appconfigid_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Navigationsetting withCreatedon(OffsetDateTime createdon) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="iconresourceid")
    @JsonIgnore
    public Optional<String> getIconresourceid() {
        return Optional.ofNullable(iconresourceid);
    }

    public Navigationsetting withIconresourceid(String iconresourceid) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("iconresourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.iconresourceid = iconresourceid;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Navigationsetting with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Navigationsetting with_organizationid_value(String _organizationid_value) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Navigationsetting withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="quicksettingorder")
    @JsonIgnore
    public Optional<Integer> getQuicksettingorder() {
        return Optional.ofNullable(quicksettingorder);
    }

    public Navigationsetting withQuicksettingorder(Integer quicksettingorder) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("quicksettingorder");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.quicksettingorder = quicksettingorder;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Navigationsetting with_modifiedby_value(String _modifiedby_value) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Navigationsetting with_createdby_value(String _createdby_value) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Navigationsetting withModifiedon(OffsetDateTime modifiedon) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="pageurl")
    @JsonIgnore
    public Optional<String> getPageurl() {
        return Optional.ofNullable(pageurl);
    }

    public Navigationsetting withPageurl(String pageurl) {
        Checks.checkIsAscii(pageurl);
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("pageurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.pageurl = pageurl;
        return _x;
    }

    @Property(name="groupname")
    @JsonIgnore
    public Optional<String> getGroupname() {
        return Optional.ofNullable(groupname);
    }

    public Navigationsetting withGroupname(String groupname) {
        Checks.checkIsAscii(groupname);
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("groupname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.groupname = groupname;
        return _x;
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<Integer> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Navigationsetting withObjecttypecode(Integer objecttypecode) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Navigationsetting withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Navigationsetting withDescription(String description) {
        Checks.checkIsAscii(description);
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.description = description;
        return _x;
    }

    @Property(name="navigationsettingid")
    @JsonIgnore
    public Optional<String> getNavigationsettingid() {
        return Optional.ofNullable(navigationsettingid);
    }

    public Navigationsetting withNavigationsettingid(String navigationsettingid) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("navigationsettingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.navigationsettingid = navigationsettingid;
        return _x;
    }

    @Property(name="navigationsettingidunique")
    @JsonIgnore
    public Optional<String> getNavigationsettingidunique() {
        return Optional.ofNullable(navigationsettingidunique);
    }

    public Navigationsetting withNavigationsettingidunique(String navigationsettingidunique) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("navigationsettingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.navigationsettingidunique = navigationsettingidunique;
        return _x;
    }

    @Property(name="progressstate")
    @JsonIgnore
    public Optional<Boolean> getProgressstate() {
        return Optional.ofNullable(progressstate);
    }

    public Navigationsetting withProgressstate(Boolean progressstate) {
        Navigationsetting _x = _copy();
        _x.changedFields = changedFields.add("progressstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.navigationsetting");
        _x.progressstate = progressstate;
        return _x;
    }

    public Navigationsetting withUnmappedField(String name, String value) {
        Navigationsetting _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="navigationsetting_modifiedby")
    @JsonIgnore
    public SystemuserRequest getNavigationsetting_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_modifiedby"), RequestHelper.getValue(unmappedFields, "navigationsetting_modifiedby"));
    }

    @NavigationProperty(name="navigationsetting_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getNavigationsetting_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "navigationsetting_createdonbehalfby"));
    }

    @NavigationProperty(name="navigationsetting_appconfig")
    @JsonIgnore
    public AppconfigRequest getNavigationsetting_appconfig() {
        return new AppconfigRequest(contextPath.addSegment("navigationsetting_appconfig"), RequestHelper.getValue(unmappedFields, "navigationsetting_appconfig"));
    }

    @NavigationProperty(name="navigationsetting_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getNavigationsetting_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "navigationsetting_modifiedonbehalfby"));
    }

    @NavigationProperty(name="navigationsetting_createdby")
    @JsonIgnore
    public SystemuserRequest getNavigationsetting_createdby() {
        return new SystemuserRequest(contextPath.addSegment("navigationsetting_createdby"), RequestHelper.getValue(unmappedFields, "navigationsetting_createdby"));
    }

    @NavigationProperty(name="organization_navigationsetting_navigationsetting")
    @JsonIgnore
    public OrganizationRequest getOrganization_navigationsetting_navigationsetting() {
        return new OrganizationRequest(contextPath.addSegment("organization_navigationsetting_navigationsetting"), RequestHelper.getValue(unmappedFields, "organization_navigationsetting_navigationsetting"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Navigationsetting patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Navigationsetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Navigationsetting put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Navigationsetting _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Navigationsetting _copy() {
        Navigationsetting _x = new Navigationsetting();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.parentnavigationsettingid = parentnavigationsettingid;
        _x.overwritetime = overwritetime;
        _x.solutionid = solutionid;
        _x.name = name;
        _x.componentstate = componentstate;
        _x.settingtype = settingtype;
        _x.appconfigidunique = appconfigidunique;
        _x.resourceid = resourceid;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.privileges = privileges;
        _x.importsequencenumber = importsequencenumber;
        _x.ismanaged = ismanaged;
        _x.advancedsettingorder = advancedsettingorder;
        _x._appconfigid_value = _appconfigid_value;
        _x.createdon = createdon;
        _x.iconresourceid = iconresourceid;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._organizationid_value = _organizationid_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.quicksettingorder = quicksettingorder;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdby_value = _createdby_value;
        _x.modifiedon = modifiedon;
        _x.pageurl = pageurl;
        _x.groupname = groupname;
        _x.objecttypecode = objecttypecode;
        _x.introducedversion = introducedversion;
        _x.description = description;
        _x.navigationsettingid = navigationsettingid;
        _x.navigationsettingidunique = navigationsettingidunique;
        _x.progressstate = progressstate;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Navigationsetting> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Navigationsetting>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Navigationsetting.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Navigationsetting[");
        b.append("parentnavigationsettingid=");
        b.append(this.parentnavigationsettingid);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("settingtype=");
        b.append(this.settingtype);
        b.append(", ");
        b.append("appconfigidunique=");
        b.append(this.appconfigidunique);
        b.append(", ");
        b.append("resourceid=");
        b.append(this.resourceid);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("privileges=");
        b.append(this.privileges);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("advancedsettingorder=");
        b.append(this.advancedsettingorder);
        b.append(", ");
        b.append("_appconfigid_value=");
        b.append(this._appconfigid_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("iconresourceid=");
        b.append(this.iconresourceid);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("quicksettingorder=");
        b.append(this.quicksettingorder);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("pageurl=");
        b.append(this.pageurl);
        b.append(", ");
        b.append("groupname=");
        b.append(this.groupname);
        b.append(", ");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("navigationsettingid=");
        b.append(this.navigationsettingid);
        b.append(", ");
        b.append("navigationsettingidunique=");
        b.append(this.navigationsettingidunique);
        b.append(", ");
        b.append("progressstate=");
        b.append(this.progressstate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
