package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.MobileofflineprofileitemRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "_modifiedonbehalfby_value", 
    "_modifiedby_value", 
    "processid", 
    "_createdby_value", 
    "solutionid", 
    "createdon", 
    "introducedversion", 
    "mobileofflineprofileitemassociationidunique", 
    "name", 
    "stageid", 
    "relationshipdisplayname", 
    "profileitemassociationentityfilter", 
    "relationshipname", 
    "overwritetime", 
    "traversedpath", 
    "isvalidated", 
    "_mobileofflineprofileitemid_value", 
    "modifiedon", 
    "versionnumber", 
    "relationshipid", 
    "_organizationid_value", 
    "mobileofflineprofileitemassociationid", 
    "ismanaged", 
    "publishedon", 
    "_createdonbehalfby_value", 
    "relationshipdata", 
    "selectedrelationshipsschema"})
@JsonInclude(Include.NON_NULL)
public class Mobileofflineprofileitemassociation extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("processid")
    protected String processid;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("mobileofflineprofileitemassociationidunique")
    protected String mobileofflineprofileitemassociationidunique;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("stageid")
    protected String stageid;

    @JsonProperty("relationshipdisplayname")
    protected String relationshipdisplayname;

    @JsonProperty("profileitemassociationentityfilter")
    protected String profileitemassociationentityfilter;

    @JsonProperty("relationshipname")
    protected String relationshipname;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("traversedpath")
    protected String traversedpath;

    @JsonProperty("isvalidated")
    protected Boolean isvalidated;

    @JsonProperty("_mobileofflineprofileitemid_value")
    protected String _mobileofflineprofileitemid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("relationshipid")
    protected String relationshipid;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("mobileofflineprofileitemassociationid")
    protected String mobileofflineprofileitemassociationid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("publishedon")
    protected OffsetDateTime publishedon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("relationshipdata")
    protected String relationshipdata;

    @JsonProperty("selectedrelationshipsschema")
    protected Integer selectedrelationshipsschema;

    protected Mobileofflineprofileitemassociation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileofflineprofileitemassociation() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private String _modifiedonbehalfby_value;
        private String _modifiedby_value;
        private String processid;
        private String _createdby_value;
        private String solutionid;
        private OffsetDateTime createdon;
        private String introducedversion;
        private String mobileofflineprofileitemassociationidunique;
        private String name;
        private String stageid;
        private String relationshipdisplayname;
        private String profileitemassociationentityfilter;
        private String relationshipname;
        private OffsetDateTime overwritetime;
        private String traversedpath;
        private Boolean isvalidated;
        private String _mobileofflineprofileitemid_value;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private String relationshipid;
        private String _organizationid_value;
        private String mobileofflineprofileitemassociationid;
        private Boolean ismanaged;
        private OffsetDateTime publishedon;
        private String _createdonbehalfby_value;
        private String relationshipdata;
        private Integer selectedrelationshipsschema;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder processid(String processid) {
            this.processid = processid;
            this.changedFields = changedFields.add("processid");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder mobileofflineprofileitemassociationidunique(String mobileofflineprofileitemassociationidunique) {
            this.mobileofflineprofileitemassociationidunique = mobileofflineprofileitemassociationidunique;
            this.changedFields = changedFields.add("mobileofflineprofileitemassociationidunique");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder stageid(String stageid) {
            this.stageid = stageid;
            this.changedFields = changedFields.add("stageid");
            return this;
        }

        public Builder relationshipdisplayname(String relationshipdisplayname) {
            this.relationshipdisplayname = relationshipdisplayname;
            this.changedFields = changedFields.add("relationshipdisplayname");
            return this;
        }

        public Builder profileitemassociationentityfilter(String profileitemassociationentityfilter) {
            this.profileitemassociationentityfilter = profileitemassociationentityfilter;
            this.changedFields = changedFields.add("profileitemassociationentityfilter");
            return this;
        }

        public Builder relationshipname(String relationshipname) {
            this.relationshipname = relationshipname;
            this.changedFields = changedFields.add("relationshipname");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder isvalidated(Boolean isvalidated) {
            this.isvalidated = isvalidated;
            this.changedFields = changedFields.add("isvalidated");
            return this;
        }

        public Builder _mobileofflineprofileitemid_value(String _mobileofflineprofileitemid_value) {
            this._mobileofflineprofileitemid_value = _mobileofflineprofileitemid_value;
            this.changedFields = changedFields.add("_mobileofflineprofileitemid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder relationshipid(String relationshipid) {
            this.relationshipid = relationshipid;
            this.changedFields = changedFields.add("relationshipid");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder mobileofflineprofileitemassociationid(String mobileofflineprofileitemassociationid) {
            this.mobileofflineprofileitemassociationid = mobileofflineprofileitemassociationid;
            this.changedFields = changedFields.add("mobileofflineprofileitemassociationid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder publishedon(OffsetDateTime publishedon) {
            this.publishedon = publishedon;
            this.changedFields = changedFields.add("publishedon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder relationshipdata(String relationshipdata) {
            this.relationshipdata = relationshipdata;
            this.changedFields = changedFields.add("relationshipdata");
            return this;
        }

        public Builder selectedrelationshipsschema(Integer selectedrelationshipsschema) {
            this.selectedrelationshipsschema = selectedrelationshipsschema;
            this.changedFields = changedFields.add("selectedrelationshipsschema");
            return this;
        }

        public Mobileofflineprofileitemassociation build() {
            Mobileofflineprofileitemassociation _x = new Mobileofflineprofileitemassociation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation";
            _x.componentstate = componentstate;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x.processid = processid;
            _x._createdby_value = _createdby_value;
            _x.solutionid = solutionid;
            _x.createdon = createdon;
            _x.introducedversion = introducedversion;
            _x.mobileofflineprofileitemassociationidunique = mobileofflineprofileitemassociationidunique;
            _x.name = name;
            _x.stageid = stageid;
            _x.relationshipdisplayname = relationshipdisplayname;
            _x.profileitemassociationentityfilter = profileitemassociationentityfilter;
            _x.relationshipname = relationshipname;
            _x.overwritetime = overwritetime;
            _x.traversedpath = traversedpath;
            _x.isvalidated = isvalidated;
            _x._mobileofflineprofileitemid_value = _mobileofflineprofileitemid_value;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x.relationshipid = relationshipid;
            _x._organizationid_value = _organizationid_value;
            _x.mobileofflineprofileitemassociationid = mobileofflineprofileitemassociationid;
            _x.ismanaged = ismanaged;
            _x.publishedon = publishedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.relationshipdata = relationshipdata;
            _x.selectedrelationshipsschema = selectedrelationshipsschema;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && mobileofflineprofileitemassociationid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(mobileofflineprofileitemassociationid.toString()));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Mobileofflineprofileitemassociation withComponentstate(Integer componentstate) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Mobileofflineprofileitemassociation with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Mobileofflineprofileitemassociation with_modifiedby_value(String _modifiedby_value) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="processid")
    @JsonIgnore
    public Optional<String> getProcessid() {
        return Optional.ofNullable(processid);
    }

    public Mobileofflineprofileitemassociation withProcessid(String processid) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("processid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.processid = processid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Mobileofflineprofileitemassociation with_createdby_value(String _createdby_value) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Mobileofflineprofileitemassociation withSolutionid(String solutionid) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Mobileofflineprofileitemassociation withCreatedon(OffsetDateTime createdon) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Mobileofflineprofileitemassociation withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="mobileofflineprofileitemassociationidunique")
    @JsonIgnore
    public Optional<String> getMobileofflineprofileitemassociationidunique() {
        return Optional.ofNullable(mobileofflineprofileitemassociationidunique);
    }

    public Mobileofflineprofileitemassociation withMobileofflineprofileitemassociationidunique(String mobileofflineprofileitemassociationidunique) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineprofileitemassociationidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.mobileofflineprofileitemassociationidunique = mobileofflineprofileitemassociationidunique;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Mobileofflineprofileitemassociation withName(String name) {
        Checks.checkIsAscii(name);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.name = name;
        return _x;
    }

    @Property(name="stageid")
    @JsonIgnore
    public Optional<String> getStageid() {
        return Optional.ofNullable(stageid);
    }

    public Mobileofflineprofileitemassociation withStageid(String stageid) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("stageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.stageid = stageid;
        return _x;
    }

    @Property(name="relationshipdisplayname")
    @JsonIgnore
    public Optional<String> getRelationshipdisplayname() {
        return Optional.ofNullable(relationshipdisplayname);
    }

    public Mobileofflineprofileitemassociation withRelationshipdisplayname(String relationshipdisplayname) {
        Checks.checkIsAscii(relationshipdisplayname);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("relationshipdisplayname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.relationshipdisplayname = relationshipdisplayname;
        return _x;
    }

    @Property(name="profileitemassociationentityfilter")
    @JsonIgnore
    public Optional<String> getProfileitemassociationentityfilter() {
        return Optional.ofNullable(profileitemassociationentityfilter);
    }

    public Mobileofflineprofileitemassociation withProfileitemassociationentityfilter(String profileitemassociationentityfilter) {
        Checks.checkIsAscii(profileitemassociationentityfilter);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("profileitemassociationentityfilter");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.profileitemassociationentityfilter = profileitemassociationentityfilter;
        return _x;
    }

    @Property(name="relationshipname")
    @JsonIgnore
    public Optional<String> getRelationshipname() {
        return Optional.ofNullable(relationshipname);
    }

    public Mobileofflineprofileitemassociation withRelationshipname(String relationshipname) {
        Checks.checkIsAscii(relationshipname);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("relationshipname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.relationshipname = relationshipname;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Mobileofflineprofileitemassociation withOverwritetime(OffsetDateTime overwritetime) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="traversedpath")
    @JsonIgnore
    public Optional<String> getTraversedpath() {
        return Optional.ofNullable(traversedpath);
    }

    public Mobileofflineprofileitemassociation withTraversedpath(String traversedpath) {
        Checks.checkIsAscii(traversedpath);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("traversedpath");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.traversedpath = traversedpath;
        return _x;
    }

    @Property(name="isvalidated")
    @JsonIgnore
    public Optional<Boolean> getIsvalidated() {
        return Optional.ofNullable(isvalidated);
    }

    public Mobileofflineprofileitemassociation withIsvalidated(Boolean isvalidated) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("isvalidated");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.isvalidated = isvalidated;
        return _x;
    }

    @Property(name="_mobileofflineprofileitemid_value")
    @JsonIgnore
    public Optional<String> get_mobileofflineprofileitemid_value() {
        return Optional.ofNullable(_mobileofflineprofileitemid_value);
    }

    public Mobileofflineprofileitemassociation with_mobileofflineprofileitemid_value(String _mobileofflineprofileitemid_value) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("_mobileofflineprofileitemid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x._mobileofflineprofileitemid_value = _mobileofflineprofileitemid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Mobileofflineprofileitemassociation withModifiedon(OffsetDateTime modifiedon) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Mobileofflineprofileitemassociation withVersionnumber(Long versionnumber) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="relationshipid")
    @JsonIgnore
    public Optional<String> getRelationshipid() {
        return Optional.ofNullable(relationshipid);
    }

    public Mobileofflineprofileitemassociation withRelationshipid(String relationshipid) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("relationshipid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.relationshipid = relationshipid;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Mobileofflineprofileitemassociation with_organizationid_value(String _organizationid_value) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="mobileofflineprofileitemassociationid")
    @JsonIgnore
    public Optional<String> getMobileofflineprofileitemassociationid() {
        return Optional.ofNullable(mobileofflineprofileitemassociationid);
    }

    public Mobileofflineprofileitemassociation withMobileofflineprofileitemassociationid(String mobileofflineprofileitemassociationid) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineprofileitemassociationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.mobileofflineprofileitemassociationid = mobileofflineprofileitemassociationid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Mobileofflineprofileitemassociation withIsmanaged(Boolean ismanaged) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="publishedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getPublishedon() {
        return Optional.ofNullable(publishedon);
    }

    public Mobileofflineprofileitemassociation withPublishedon(OffsetDateTime publishedon) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("publishedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.publishedon = publishedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Mobileofflineprofileitemassociation with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="relationshipdata")
    @JsonIgnore
    public Optional<String> getRelationshipdata() {
        return Optional.ofNullable(relationshipdata);
    }

    public Mobileofflineprofileitemassociation withRelationshipdata(String relationshipdata) {
        Checks.checkIsAscii(relationshipdata);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("relationshipdata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.relationshipdata = relationshipdata;
        return _x;
    }

    @Property(name="selectedrelationshipsschema")
    @JsonIgnore
    public Optional<Integer> getSelectedrelationshipsschema() {
        return Optional.ofNullable(selectedrelationshipsschema);
    }

    public Mobileofflineprofileitemassociation withSelectedrelationshipsschema(Integer selectedrelationshipsschema) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = changedFields.add("selectedrelationshipsschema");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitemassociation");
        _x.selectedrelationshipsschema = selectedrelationshipsschema;
        return _x;
    }

    public Mobileofflineprofileitemassociation withUnmappedField(String name, String value) {
        Mobileofflineprofileitemassociation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="regardingobjectid")
    @JsonIgnore
    public MobileofflineprofileitemRequest getRegardingobjectid() {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("regardingobjectid"), RequestHelper.getValue(unmappedFields, "regardingobjectid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mobileofflineprofileitemassociation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mobileofflineprofileitemassociation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Mobileofflineprofileitemassociation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Mobileofflineprofileitemassociation _copy() {
        Mobileofflineprofileitemassociation _x = new Mobileofflineprofileitemassociation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x.processid = processid;
        _x._createdby_value = _createdby_value;
        _x.solutionid = solutionid;
        _x.createdon = createdon;
        _x.introducedversion = introducedversion;
        _x.mobileofflineprofileitemassociationidunique = mobileofflineprofileitemassociationidunique;
        _x.name = name;
        _x.stageid = stageid;
        _x.relationshipdisplayname = relationshipdisplayname;
        _x.profileitemassociationentityfilter = profileitemassociationentityfilter;
        _x.relationshipname = relationshipname;
        _x.overwritetime = overwritetime;
        _x.traversedpath = traversedpath;
        _x.isvalidated = isvalidated;
        _x._mobileofflineprofileitemid_value = _mobileofflineprofileitemid_value;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x.relationshipid = relationshipid;
        _x._organizationid_value = _organizationid_value;
        _x.mobileofflineprofileitemassociationid = mobileofflineprofileitemassociationid;
        _x.ismanaged = ismanaged;
        _x.publishedon = publishedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.relationshipdata = relationshipdata;
        _x.selectedrelationshipsschema = selectedrelationshipsschema;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Mobileofflineprofileitemassociation[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("processid=");
        b.append(this.processid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("mobileofflineprofileitemassociationidunique=");
        b.append(this.mobileofflineprofileitemassociationidunique);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("stageid=");
        b.append(this.stageid);
        b.append(", ");
        b.append("relationshipdisplayname=");
        b.append(this.relationshipdisplayname);
        b.append(", ");
        b.append("profileitemassociationentityfilter=");
        b.append(this.profileitemassociationentityfilter);
        b.append(", ");
        b.append("relationshipname=");
        b.append(this.relationshipname);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("isvalidated=");
        b.append(this.isvalidated);
        b.append(", ");
        b.append("_mobileofflineprofileitemid_value=");
        b.append(this._mobileofflineprofileitemid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("relationshipid=");
        b.append(this.relationshipid);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("mobileofflineprofileitemassociationid=");
        b.append(this.mobileofflineprofileitemassociationid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("publishedon=");
        b.append(this.publishedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("relationshipdata=");
        b.append(this.relationshipdata);
        b.append(", ");
        b.append("selectedrelationshipsschema=");
        b.append(this.selectedrelationshipsschema);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
