package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemassociationCollectionRequest;
import microsoft.dynamics.crm.entity.request.MobileofflineprofileRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SavedqueryRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "recorddistributioncriteria", 
    "mobileofflineprofileitemidunique", 
    "selectedentitytypecode", 
    "versionnumber", 
    "entityobjecttypecode", 
    "mobileofflineprofileitemid", 
    "_organizationid_value", 
    "introducedversion", 
    "_regardingobjectid_value", 
    "profileitementityfilter", 
    "componentstate", 
    "isvisibleingrid", 
    "recordsownedbymybusinessunit", 
    "ismanaged", 
    "overwritetime", 
    "recordsownedbymyteam", 
    "_modifiedby_value", 
    "traversedpath", 
    "_modifiedonbehalfby_value", 
    "_createdby_value", 
    "stageid", 
    "publishedon", 
    "_createdonbehalfby_value", 
    "selectedentitymetadata", 
    "createdon", 
    "modifiedon", 
    "name", 
    "relationshipdata", 
    "processid", 
    "solutionid", 
    "isvalidated", 
    "recordsownedbyme"})
@JsonInclude(Include.NON_NULL)
public class Mobileofflineprofileitem extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.mobileofflineprofileitem";
    }

    @JsonProperty("recorddistributioncriteria")
    protected Integer recorddistributioncriteria;

    @JsonProperty("mobileofflineprofileitemidunique")
    protected String mobileofflineprofileitemidunique;

    @JsonProperty("selectedentitytypecode")
    protected String selectedentitytypecode;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("entityobjecttypecode")
    protected Integer entityobjecttypecode;

    @JsonProperty("mobileofflineprofileitemid")
    protected String mobileofflineprofileitemid;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_regardingobjectid_value")
    protected String _regardingobjectid_value;

    @JsonProperty("profileitementityfilter")
    protected String profileitementityfilter;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("isvisibleingrid")
    protected Boolean isvisibleingrid;

    @JsonProperty("recordsownedbymybusinessunit")
    protected Boolean recordsownedbymybusinessunit;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("recordsownedbymyteam")
    protected Boolean recordsownedbymyteam;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("traversedpath")
    protected String traversedpath;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("stageid")
    protected String stageid;

    @JsonProperty("publishedon")
    protected OffsetDateTime publishedon;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("selectedentitymetadata")
    protected String selectedentitymetadata;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("relationshipdata")
    protected String relationshipdata;

    @JsonProperty("processid")
    protected String processid;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("isvalidated")
    protected Boolean isvalidated;

    @JsonProperty("recordsownedbyme")
    protected Boolean recordsownedbyme;

    protected Mobileofflineprofileitem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMobileofflineprofileitem() {
        return new Builder();
    }

    public static final class Builder {
        private Integer recorddistributioncriteria;
        private String mobileofflineprofileitemidunique;
        private String selectedentitytypecode;
        private Long versionnumber;
        private Integer entityobjecttypecode;
        private String mobileofflineprofileitemid;
        private String _organizationid_value;
        private String introducedversion;
        private String _regardingobjectid_value;
        private String profileitementityfilter;
        private Integer componentstate;
        private Boolean isvisibleingrid;
        private Boolean recordsownedbymybusinessunit;
        private Boolean ismanaged;
        private OffsetDateTime overwritetime;
        private Boolean recordsownedbymyteam;
        private String _modifiedby_value;
        private String traversedpath;
        private String _modifiedonbehalfby_value;
        private String _createdby_value;
        private String stageid;
        private OffsetDateTime publishedon;
        private String _createdonbehalfby_value;
        private String selectedentitymetadata;
        private OffsetDateTime createdon;
        private OffsetDateTime modifiedon;
        private String name;
        private String relationshipdata;
        private String processid;
        private String solutionid;
        private Boolean isvalidated;
        private Boolean recordsownedbyme;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder recorddistributioncriteria(Integer recorddistributioncriteria) {
            this.recorddistributioncriteria = recorddistributioncriteria;
            this.changedFields = changedFields.add("recorddistributioncriteria");
            return this;
        }

        public Builder mobileofflineprofileitemidunique(String mobileofflineprofileitemidunique) {
            this.mobileofflineprofileitemidunique = mobileofflineprofileitemidunique;
            this.changedFields = changedFields.add("mobileofflineprofileitemidunique");
            return this;
        }

        public Builder selectedentitytypecode(String selectedentitytypecode) {
            this.selectedentitytypecode = selectedentitytypecode;
            this.changedFields = changedFields.add("selectedentitytypecode");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder entityobjecttypecode(Integer entityobjecttypecode) {
            this.entityobjecttypecode = entityobjecttypecode;
            this.changedFields = changedFields.add("entityobjecttypecode");
            return this;
        }

        public Builder mobileofflineprofileitemid(String mobileofflineprofileitemid) {
            this.mobileofflineprofileitemid = mobileofflineprofileitemid;
            this.changedFields = changedFields.add("mobileofflineprofileitemid");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder profileitementityfilter(String profileitementityfilter) {
            this.profileitementityfilter = profileitementityfilter;
            this.changedFields = changedFields.add("profileitementityfilter");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder isvisibleingrid(Boolean isvisibleingrid) {
            this.isvisibleingrid = isvisibleingrid;
            this.changedFields = changedFields.add("isvisibleingrid");
            return this;
        }

        public Builder recordsownedbymybusinessunit(Boolean recordsownedbymybusinessunit) {
            this.recordsownedbymybusinessunit = recordsownedbymybusinessunit;
            this.changedFields = changedFields.add("recordsownedbymybusinessunit");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder recordsownedbymyteam(Boolean recordsownedbymyteam) {
            this.recordsownedbymyteam = recordsownedbymyteam;
            this.changedFields = changedFields.add("recordsownedbymyteam");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder traversedpath(String traversedpath) {
            this.traversedpath = traversedpath;
            this.changedFields = changedFields.add("traversedpath");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder stageid(String stageid) {
            this.stageid = stageid;
            this.changedFields = changedFields.add("stageid");
            return this;
        }

        public Builder publishedon(OffsetDateTime publishedon) {
            this.publishedon = publishedon;
            this.changedFields = changedFields.add("publishedon");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder selectedentitymetadata(String selectedentitymetadata) {
            this.selectedentitymetadata = selectedentitymetadata;
            this.changedFields = changedFields.add("selectedentitymetadata");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder relationshipdata(String relationshipdata) {
            this.relationshipdata = relationshipdata;
            this.changedFields = changedFields.add("relationshipdata");
            return this;
        }

        public Builder processid(String processid) {
            this.processid = processid;
            this.changedFields = changedFields.add("processid");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder isvalidated(Boolean isvalidated) {
            this.isvalidated = isvalidated;
            this.changedFields = changedFields.add("isvalidated");
            return this;
        }

        public Builder recordsownedbyme(Boolean recordsownedbyme) {
            this.recordsownedbyme = recordsownedbyme;
            this.changedFields = changedFields.add("recordsownedbyme");
            return this;
        }

        public Mobileofflineprofileitem build() {
            Mobileofflineprofileitem _x = new Mobileofflineprofileitem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.mobileofflineprofileitem";
            _x.recorddistributioncriteria = recorddistributioncriteria;
            _x.mobileofflineprofileitemidunique = mobileofflineprofileitemidunique;
            _x.selectedentitytypecode = selectedentitytypecode;
            _x.versionnumber = versionnumber;
            _x.entityobjecttypecode = entityobjecttypecode;
            _x.mobileofflineprofileitemid = mobileofflineprofileitemid;
            _x._organizationid_value = _organizationid_value;
            _x.introducedversion = introducedversion;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.profileitementityfilter = profileitementityfilter;
            _x.componentstate = componentstate;
            _x.isvisibleingrid = isvisibleingrid;
            _x.recordsownedbymybusinessunit = recordsownedbymybusinessunit;
            _x.ismanaged = ismanaged;
            _x.overwritetime = overwritetime;
            _x.recordsownedbymyteam = recordsownedbymyteam;
            _x._modifiedby_value = _modifiedby_value;
            _x.traversedpath = traversedpath;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.stageid = stageid;
            _x.publishedon = publishedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.selectedentitymetadata = selectedentitymetadata;
            _x.createdon = createdon;
            _x.modifiedon = modifiedon;
            _x.name = name;
            _x.relationshipdata = relationshipdata;
            _x.processid = processid;
            _x.solutionid = solutionid;
            _x.isvalidated = isvalidated;
            _x.recordsownedbyme = recordsownedbyme;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && mobileofflineprofileitemid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(mobileofflineprofileitemid.toString()));
        }
    }

    @Property(name="recorddistributioncriteria")
    @JsonIgnore
    public Optional<Integer> getRecorddistributioncriteria() {
        return Optional.ofNullable(recorddistributioncriteria);
    }

    public Mobileofflineprofileitem withRecorddistributioncriteria(Integer recorddistributioncriteria) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("recorddistributioncriteria");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.recorddistributioncriteria = recorddistributioncriteria;
        return _x;
    }

    @Property(name="mobileofflineprofileitemidunique")
    @JsonIgnore
    public Optional<String> getMobileofflineprofileitemidunique() {
        return Optional.ofNullable(mobileofflineprofileitemidunique);
    }

    public Mobileofflineprofileitem withMobileofflineprofileitemidunique(String mobileofflineprofileitemidunique) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineprofileitemidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.mobileofflineprofileitemidunique = mobileofflineprofileitemidunique;
        return _x;
    }

    @Property(name="selectedentitytypecode")
    @JsonIgnore
    public Optional<String> getSelectedentitytypecode() {
        return Optional.ofNullable(selectedentitytypecode);
    }

    public Mobileofflineprofileitem withSelectedentitytypecode(String selectedentitytypecode) {
        Checks.checkIsAscii(selectedentitytypecode);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("selectedentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.selectedentitytypecode = selectedentitytypecode;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Mobileofflineprofileitem withVersionnumber(Long versionnumber) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="entityobjecttypecode")
    @JsonIgnore
    public Optional<Integer> getEntityobjecttypecode() {
        return Optional.ofNullable(entityobjecttypecode);
    }

    public Mobileofflineprofileitem withEntityobjecttypecode(Integer entityobjecttypecode) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("entityobjecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.entityobjecttypecode = entityobjecttypecode;
        return _x;
    }

    @Property(name="mobileofflineprofileitemid")
    @JsonIgnore
    public Optional<String> getMobileofflineprofileitemid() {
        return Optional.ofNullable(mobileofflineprofileitemid);
    }

    public Mobileofflineprofileitem withMobileofflineprofileitemid(String mobileofflineprofileitemid) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("mobileofflineprofileitemid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.mobileofflineprofileitemid = mobileofflineprofileitemid;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Mobileofflineprofileitem with_organizationid_value(String _organizationid_value) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Mobileofflineprofileitem withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Mobileofflineprofileitem with_regardingobjectid_value(String _regardingobjectid_value) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="profileitementityfilter")
    @JsonIgnore
    public Optional<String> getProfileitementityfilter() {
        return Optional.ofNullable(profileitementityfilter);
    }

    public Mobileofflineprofileitem withProfileitementityfilter(String profileitementityfilter) {
        Checks.checkIsAscii(profileitementityfilter);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("profileitementityfilter");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.profileitementityfilter = profileitementityfilter;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Mobileofflineprofileitem withComponentstate(Integer componentstate) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="isvisibleingrid")
    @JsonIgnore
    public Optional<Boolean> getIsvisibleingrid() {
        return Optional.ofNullable(isvisibleingrid);
    }

    public Mobileofflineprofileitem withIsvisibleingrid(Boolean isvisibleingrid) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("isvisibleingrid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.isvisibleingrid = isvisibleingrid;
        return _x;
    }

    @Property(name="recordsownedbymybusinessunit")
    @JsonIgnore
    public Optional<Boolean> getRecordsownedbymybusinessunit() {
        return Optional.ofNullable(recordsownedbymybusinessunit);
    }

    public Mobileofflineprofileitem withRecordsownedbymybusinessunit(Boolean recordsownedbymybusinessunit) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("recordsownedbymybusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.recordsownedbymybusinessunit = recordsownedbymybusinessunit;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Mobileofflineprofileitem withIsmanaged(Boolean ismanaged) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Mobileofflineprofileitem withOverwritetime(OffsetDateTime overwritetime) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="recordsownedbymyteam")
    @JsonIgnore
    public Optional<Boolean> getRecordsownedbymyteam() {
        return Optional.ofNullable(recordsownedbymyteam);
    }

    public Mobileofflineprofileitem withRecordsownedbymyteam(Boolean recordsownedbymyteam) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("recordsownedbymyteam");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.recordsownedbymyteam = recordsownedbymyteam;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Mobileofflineprofileitem with_modifiedby_value(String _modifiedby_value) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="traversedpath")
    @JsonIgnore
    public Optional<String> getTraversedpath() {
        return Optional.ofNullable(traversedpath);
    }

    public Mobileofflineprofileitem withTraversedpath(String traversedpath) {
        Checks.checkIsAscii(traversedpath);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("traversedpath");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.traversedpath = traversedpath;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Mobileofflineprofileitem with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Mobileofflineprofileitem with_createdby_value(String _createdby_value) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="stageid")
    @JsonIgnore
    public Optional<String> getStageid() {
        return Optional.ofNullable(stageid);
    }

    public Mobileofflineprofileitem withStageid(String stageid) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("stageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.stageid = stageid;
        return _x;
    }

    @Property(name="publishedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getPublishedon() {
        return Optional.ofNullable(publishedon);
    }

    public Mobileofflineprofileitem withPublishedon(OffsetDateTime publishedon) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("publishedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.publishedon = publishedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Mobileofflineprofileitem with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="selectedentitymetadata")
    @JsonIgnore
    public Optional<String> getSelectedentitymetadata() {
        return Optional.ofNullable(selectedentitymetadata);
    }

    public Mobileofflineprofileitem withSelectedentitymetadata(String selectedentitymetadata) {
        Checks.checkIsAscii(selectedentitymetadata);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("selectedentitymetadata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.selectedentitymetadata = selectedentitymetadata;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Mobileofflineprofileitem withCreatedon(OffsetDateTime createdon) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Mobileofflineprofileitem withModifiedon(OffsetDateTime modifiedon) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Mobileofflineprofileitem withName(String name) {
        Checks.checkIsAscii(name);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.name = name;
        return _x;
    }

    @Property(name="relationshipdata")
    @JsonIgnore
    public Optional<String> getRelationshipdata() {
        return Optional.ofNullable(relationshipdata);
    }

    public Mobileofflineprofileitem withRelationshipdata(String relationshipdata) {
        Checks.checkIsAscii(relationshipdata);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("relationshipdata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.relationshipdata = relationshipdata;
        return _x;
    }

    @Property(name="processid")
    @JsonIgnore
    public Optional<String> getProcessid() {
        return Optional.ofNullable(processid);
    }

    public Mobileofflineprofileitem withProcessid(String processid) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("processid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.processid = processid;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Mobileofflineprofileitem withSolutionid(String solutionid) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="isvalidated")
    @JsonIgnore
    public Optional<Boolean> getIsvalidated() {
        return Optional.ofNullable(isvalidated);
    }

    public Mobileofflineprofileitem withIsvalidated(Boolean isvalidated) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("isvalidated");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.isvalidated = isvalidated;
        return _x;
    }

    @Property(name="recordsownedbyme")
    @JsonIgnore
    public Optional<Boolean> getRecordsownedbyme() {
        return Optional.ofNullable(recordsownedbyme);
    }

    public Mobileofflineprofileitem withRecordsownedbyme(Boolean recordsownedbyme) {
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = changedFields.add("recordsownedbyme");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.mobileofflineprofileitem");
        _x.recordsownedbyme = recordsownedbyme;
        return _x;
    }

    public Mobileofflineprofileitem withUnmappedField(String name, String value) {
        Mobileofflineprofileitem _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="regardingobjectid")
    @JsonIgnore
    public MobileofflineprofileRequest getRegardingobjectid() {
        return new MobileofflineprofileRequest(contextPath.addSegment("regardingobjectid"), RequestHelper.getValue(unmappedFields, "regardingobjectid"));
    }

    @NavigationProperty(name="MobileOfflineProfileItem_MobileOfflineProfileItemAssociation")
    @JsonIgnore
    public MobileofflineprofileitemassociationCollectionRequest getMobileOfflineProfileItem_MobileOfflineProfileItemAssociation() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("MobileOfflineProfileItem_MobileOfflineProfileItemAssociation"), RequestHelper.getValue(unmappedFields, "MobileOfflineProfileItem_MobileOfflineProfileItemAssociation"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="profileitemrule")
    @JsonIgnore
    public SavedqueryRequest getProfileitemrule() {
        return new SavedqueryRequest(contextPath.addSegment("profileitemrule"), RequestHelper.getValue(unmappedFields, "profileitemrule"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mobileofflineprofileitem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Mobileofflineprofileitem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Mobileofflineprofileitem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Mobileofflineprofileitem _copy() {
        Mobileofflineprofileitem _x = new Mobileofflineprofileitem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.recorddistributioncriteria = recorddistributioncriteria;
        _x.mobileofflineprofileitemidunique = mobileofflineprofileitemidunique;
        _x.selectedentitytypecode = selectedentitytypecode;
        _x.versionnumber = versionnumber;
        _x.entityobjecttypecode = entityobjecttypecode;
        _x.mobileofflineprofileitemid = mobileofflineprofileitemid;
        _x._organizationid_value = _organizationid_value;
        _x.introducedversion = introducedversion;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.profileitementityfilter = profileitementityfilter;
        _x.componentstate = componentstate;
        _x.isvisibleingrid = isvisibleingrid;
        _x.recordsownedbymybusinessunit = recordsownedbymybusinessunit;
        _x.ismanaged = ismanaged;
        _x.overwritetime = overwritetime;
        _x.recordsownedbymyteam = recordsownedbymyteam;
        _x._modifiedby_value = _modifiedby_value;
        _x.traversedpath = traversedpath;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.stageid = stageid;
        _x.publishedon = publishedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.selectedentitymetadata = selectedentitymetadata;
        _x.createdon = createdon;
        _x.modifiedon = modifiedon;
        _x.name = name;
        _x.relationshipdata = relationshipdata;
        _x.processid = processid;
        _x.solutionid = solutionid;
        _x.isvalidated = isvalidated;
        _x.recordsownedbyme = recordsownedbyme;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofileitem> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Mobileofflineprofileitem>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Mobileofflineprofileitem.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Mobileofflineprofileitem[");
        b.append("recorddistributioncriteria=");
        b.append(this.recorddistributioncriteria);
        b.append(", ");
        b.append("mobileofflineprofileitemidunique=");
        b.append(this.mobileofflineprofileitemidunique);
        b.append(", ");
        b.append("selectedentitytypecode=");
        b.append(this.selectedentitytypecode);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("entityobjecttypecode=");
        b.append(this.entityobjecttypecode);
        b.append(", ");
        b.append("mobileofflineprofileitemid=");
        b.append(this.mobileofflineprofileitemid);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("profileitementityfilter=");
        b.append(this.profileitementityfilter);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("isvisibleingrid=");
        b.append(this.isvisibleingrid);
        b.append(", ");
        b.append("recordsownedbymybusinessunit=");
        b.append(this.recordsownedbymybusinessunit);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("recordsownedbymyteam=");
        b.append(this.recordsownedbymyteam);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("traversedpath=");
        b.append(this.traversedpath);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("stageid=");
        b.append(this.stageid);
        b.append(", ");
        b.append("publishedon=");
        b.append(this.publishedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("selectedentitymetadata=");
        b.append(this.selectedentitymetadata);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("relationshipdata=");
        b.append(this.relationshipdata);
        b.append(", ");
        b.append("processid=");
        b.append(this.processid);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("isvalidated=");
        b.append(this.isvalidated);
        b.append(", ");
        b.append("recordsownedbyme=");
        b.append(this.recordsownedbyme);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
