package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.ImportmapRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statuscode", 
    "solutionid", 
    "introducedversion", 
    "processcode", 
    "importentitymappingid", 
    "ismanaged", 
    "modifiedon", 
    "createdon", 
    "componentstate", 
    "dedupe", 
    "importentitymappingidunique", 
    "_createdby_value", 
    "_modifiedonbehalfby_value", 
    "targetentityname", 
    "_createdonbehalfby_value", 
    "sourceentityname", 
    "_modifiedby_value", 
    "overwritetime", 
    "_importmapid_value", 
    "statecode"})
@JsonInclude(Include.NON_NULL)
public class Importentitymapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.importentitymapping";
    }

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("processcode")
    protected Integer processcode;

    @JsonProperty("importentitymappingid")
    protected String importentitymappingid;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("dedupe")
    protected Integer dedupe;

    @JsonProperty("importentitymappingidunique")
    protected String importentitymappingidunique;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("targetentityname")
    protected String targetentityname;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("sourceentityname")
    protected String sourceentityname;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_importmapid_value")
    protected String _importmapid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    protected Importentitymapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderImportentitymapping() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statuscode;
        private String solutionid;
        private String introducedversion;
        private Integer processcode;
        private String importentitymappingid;
        private Boolean ismanaged;
        private OffsetDateTime modifiedon;
        private OffsetDateTime createdon;
        private Integer componentstate;
        private Integer dedupe;
        private String importentitymappingidunique;
        private String _createdby_value;
        private String _modifiedonbehalfby_value;
        private String targetentityname;
        private String _createdonbehalfby_value;
        private String sourceentityname;
        private String _modifiedby_value;
        private OffsetDateTime overwritetime;
        private String _importmapid_value;
        private Integer statecode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder processcode(Integer processcode) {
            this.processcode = processcode;
            this.changedFields = changedFields.add("processcode");
            return this;
        }

        public Builder importentitymappingid(String importentitymappingid) {
            this.importentitymappingid = importentitymappingid;
            this.changedFields = changedFields.add("importentitymappingid");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder dedupe(Integer dedupe) {
            this.dedupe = dedupe;
            this.changedFields = changedFields.add("dedupe");
            return this;
        }

        public Builder importentitymappingidunique(String importentitymappingidunique) {
            this.importentitymappingidunique = importentitymappingidunique;
            this.changedFields = changedFields.add("importentitymappingidunique");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder targetentityname(String targetentityname) {
            this.targetentityname = targetentityname;
            this.changedFields = changedFields.add("targetentityname");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder sourceentityname(String sourceentityname) {
            this.sourceentityname = sourceentityname;
            this.changedFields = changedFields.add("sourceentityname");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _importmapid_value(String _importmapid_value) {
            this._importmapid_value = _importmapid_value;
            this.changedFields = changedFields.add("_importmapid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Importentitymapping build() {
            Importentitymapping _x = new Importentitymapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.importentitymapping";
            _x.statuscode = statuscode;
            _x.solutionid = solutionid;
            _x.introducedversion = introducedversion;
            _x.processcode = processcode;
            _x.importentitymappingid = importentitymappingid;
            _x.ismanaged = ismanaged;
            _x.modifiedon = modifiedon;
            _x.createdon = createdon;
            _x.componentstate = componentstate;
            _x.dedupe = dedupe;
            _x.importentitymappingidunique = importentitymappingidunique;
            _x._createdby_value = _createdby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.targetentityname = targetentityname;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.sourceentityname = sourceentityname;
            _x._modifiedby_value = _modifiedby_value;
            _x.overwritetime = overwritetime;
            _x._importmapid_value = _importmapid_value;
            _x.statecode = statecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && importentitymappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(importentitymappingid.toString()));
        }
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Importentitymapping withStatuscode(Integer statuscode) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Importentitymapping withSolutionid(String solutionid) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Importentitymapping withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="processcode")
    @JsonIgnore
    public Optional<Integer> getProcesscode() {
        return Optional.ofNullable(processcode);
    }

    public Importentitymapping withProcesscode(Integer processcode) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("processcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.processcode = processcode;
        return _x;
    }

    @Property(name="importentitymappingid")
    @JsonIgnore
    public Optional<String> getImportentitymappingid() {
        return Optional.ofNullable(importentitymappingid);
    }

    public Importentitymapping withImportentitymappingid(String importentitymappingid) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("importentitymappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.importentitymappingid = importentitymappingid;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Importentitymapping withIsmanaged(Boolean ismanaged) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Importentitymapping withModifiedon(OffsetDateTime modifiedon) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Importentitymapping withCreatedon(OffsetDateTime createdon) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Importentitymapping withComponentstate(Integer componentstate) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="dedupe")
    @JsonIgnore
    public Optional<Integer> getDedupe() {
        return Optional.ofNullable(dedupe);
    }

    public Importentitymapping withDedupe(Integer dedupe) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("dedupe");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.dedupe = dedupe;
        return _x;
    }

    @Property(name="importentitymappingidunique")
    @JsonIgnore
    public Optional<String> getImportentitymappingidunique() {
        return Optional.ofNullable(importentitymappingidunique);
    }

    public Importentitymapping withImportentitymappingidunique(String importentitymappingidunique) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("importentitymappingidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.importentitymappingidunique = importentitymappingidunique;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Importentitymapping with_createdby_value(String _createdby_value) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Importentitymapping with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="targetentityname")
    @JsonIgnore
    public Optional<String> getTargetentityname() {
        return Optional.ofNullable(targetentityname);
    }

    public Importentitymapping withTargetentityname(String targetentityname) {
        Checks.checkIsAscii(targetentityname);
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("targetentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.targetentityname = targetentityname;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Importentitymapping with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="sourceentityname")
    @JsonIgnore
    public Optional<String> getSourceentityname() {
        return Optional.ofNullable(sourceentityname);
    }

    public Importentitymapping withSourceentityname(String sourceentityname) {
        Checks.checkIsAscii(sourceentityname);
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("sourceentityname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.sourceentityname = sourceentityname;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Importentitymapping with_modifiedby_value(String _modifiedby_value) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Importentitymapping withOverwritetime(OffsetDateTime overwritetime) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_importmapid_value")
    @JsonIgnore
    public Optional<String> get_importmapid_value() {
        return Optional.ofNullable(_importmapid_value);
    }

    public Importentitymapping with_importmapid_value(String _importmapid_value) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("_importmapid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x._importmapid_value = _importmapid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Importentitymapping withStatecode(Integer statecode) {
        Importentitymapping _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.importentitymapping");
        _x.statecode = statecode;
        return _x;
    }

    public Importentitymapping withUnmappedField(String name, String value) {
        Importentitymapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="importmapid")
    @JsonIgnore
    public ImportmapRequest getImportmapid() {
        return new ImportmapRequest(contextPath.addSegment("importmapid"), RequestHelper.getValue(unmappedFields, "importmapid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importentitymapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Importentitymapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Importentitymapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Importentitymapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Importentitymapping _copy() {
        Importentitymapping _x = new Importentitymapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statuscode = statuscode;
        _x.solutionid = solutionid;
        _x.introducedversion = introducedversion;
        _x.processcode = processcode;
        _x.importentitymappingid = importentitymappingid;
        _x.ismanaged = ismanaged;
        _x.modifiedon = modifiedon;
        _x.createdon = createdon;
        _x.componentstate = componentstate;
        _x.dedupe = dedupe;
        _x.importentitymappingidunique = importentitymappingidunique;
        _x._createdby_value = _createdby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.targetentityname = targetentityname;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.sourceentityname = sourceentityname;
        _x._modifiedby_value = _modifiedby_value;
        _x.overwritetime = overwritetime;
        _x._importmapid_value = _importmapid_value;
        _x.statecode = statecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Importentitymapping[");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("processcode=");
        b.append(this.processcode);
        b.append(", ");
        b.append("importentitymappingid=");
        b.append(this.importentitymappingid);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("dedupe=");
        b.append(this.dedupe);
        b.append(", ");
        b.append("importentitymappingidunique=");
        b.append(this.importentitymappingidunique);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("targetentityname=");
        b.append(this.targetentityname);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("sourceentityname=");
        b.append(this.sourceentityname);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_importmapid_value=");
        b.append(this._importmapid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
