package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FeedbackCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdonbehalfby_value", 
    "statuscode", 
    "_modifiedby_value", 
    "closedon", 
    "overriddencreatedon", 
    "statecode", 
    "_regardingobjectid_value", 
    "title", 
    "createdon", 
    "rating", 
    "_createdbycontact_value", 
    "comments", 
    "feedbackid", 
    "maxrating", 
    "_closedby_value", 
    "_createdby_value", 
    "importsequencenumber", 
    "source", 
    "_owningbusinessunit_value", 
    "_createdonbehalfbycontact_value", 
    "modifiedon", 
    "exchangerate", 
    "_owningteam_value", 
    "versionnumber", 
    "_owninguser_value", 
    "_modifiedonbehalfby_value", 
    "_transactioncurrencyid_value", 
    "normalizedrating", 
    "minrating", 
    "_ownerid_value"})
@JsonInclude(Include.NON_NULL)
public class Feedback extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.feedback";
    }

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("closedon")
    protected OffsetDateTime closedon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_regardingobjectid_value")
    protected String _regardingobjectid_value;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("rating")
    protected Integer rating;

    @JsonProperty("_createdbycontact_value")
    protected String _createdbycontact_value;

    @JsonProperty("comments")
    protected String comments;

    @JsonProperty("feedbackid")
    protected String feedbackid;

    @JsonProperty("maxrating")
    protected Integer maxrating;

    @JsonProperty("_closedby_value")
    protected String _closedby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("source")
    protected Integer source;

    @JsonProperty("_owningbusinessunit_value")
    protected String _owningbusinessunit_value;

    @JsonProperty("_createdonbehalfbycontact_value")
    protected String _createdonbehalfbycontact_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("_owningteam_value")
    protected String _owningteam_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_owninguser_value")
    protected String _owninguser_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_transactioncurrencyid_value")
    protected String _transactioncurrencyid_value;

    @JsonProperty("normalizedrating")
    protected BigDecimal normalizedrating;

    @JsonProperty("minrating")
    protected Integer minrating;

    @JsonProperty("_ownerid_value")
    protected String _ownerid_value;

    protected Feedback() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderFeedback() {
        return new Builder();
    }

    public static final class Builder {
        private String _createdonbehalfby_value;
        private Integer statuscode;
        private String _modifiedby_value;
        private OffsetDateTime closedon;
        private OffsetDateTime overriddencreatedon;
        private Integer statecode;
        private String _regardingobjectid_value;
        private String title;
        private OffsetDateTime createdon;
        private Integer rating;
        private String _createdbycontact_value;
        private String comments;
        private String feedbackid;
        private Integer maxrating;
        private String _closedby_value;
        private String _createdby_value;
        private Integer importsequencenumber;
        private Integer source;
        private String _owningbusinessunit_value;
        private String _createdonbehalfbycontact_value;
        private OffsetDateTime modifiedon;
        private BigDecimal exchangerate;
        private String _owningteam_value;
        private Long versionnumber;
        private String _owninguser_value;
        private String _modifiedonbehalfby_value;
        private String _transactioncurrencyid_value;
        private BigDecimal normalizedrating;
        private Integer minrating;
        private String _ownerid_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder closedon(OffsetDateTime closedon) {
            this.closedon = closedon;
            this.changedFields = changedFields.add("closedon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _regardingobjectid_value(String _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder rating(Integer rating) {
            this.rating = rating;
            this.changedFields = changedFields.add("rating");
            return this;
        }

        public Builder _createdbycontact_value(String _createdbycontact_value) {
            this._createdbycontact_value = _createdbycontact_value;
            this.changedFields = changedFields.add("_createdbycontact_value");
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            this.changedFields = changedFields.add("comments");
            return this;
        }

        public Builder feedbackid(String feedbackid) {
            this.feedbackid = feedbackid;
            this.changedFields = changedFields.add("feedbackid");
            return this;
        }

        public Builder maxrating(Integer maxrating) {
            this.maxrating = maxrating;
            this.changedFields = changedFields.add("maxrating");
            return this;
        }

        public Builder _closedby_value(String _closedby_value) {
            this._closedby_value = _closedby_value;
            this.changedFields = changedFields.add("_closedby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder source(Integer source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder _owningbusinessunit_value(String _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _createdonbehalfbycontact_value(String _createdonbehalfbycontact_value) {
            this._createdonbehalfbycontact_value = _createdonbehalfbycontact_value;
            this.changedFields = changedFields.add("_createdonbehalfbycontact_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder _owningteam_value(String _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _owninguser_value(String _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _transactioncurrencyid_value(String _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder normalizedrating(BigDecimal normalizedrating) {
            this.normalizedrating = normalizedrating;
            this.changedFields = changedFields.add("normalizedrating");
            return this;
        }

        public Builder minrating(Integer minrating) {
            this.minrating = minrating;
            this.changedFields = changedFields.add("minrating");
            return this;
        }

        public Builder _ownerid_value(String _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Feedback build() {
            Feedback _x = new Feedback();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.feedback";
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.statuscode = statuscode;
            _x._modifiedby_value = _modifiedby_value;
            _x.closedon = closedon;
            _x.overriddencreatedon = overriddencreatedon;
            _x.statecode = statecode;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.title = title;
            _x.createdon = createdon;
            _x.rating = rating;
            _x._createdbycontact_value = _createdbycontact_value;
            _x.comments = comments;
            _x.feedbackid = feedbackid;
            _x.maxrating = maxrating;
            _x._closedby_value = _closedby_value;
            _x._createdby_value = _createdby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.source = source;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._createdonbehalfbycontact_value = _createdonbehalfbycontact_value;
            _x.modifiedon = modifiedon;
            _x.exchangerate = exchangerate;
            _x._owningteam_value = _owningteam_value;
            _x.versionnumber = versionnumber;
            _x._owninguser_value = _owninguser_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.normalizedrating = normalizedrating;
            _x.minrating = minrating;
            _x._ownerid_value = _ownerid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && feedbackid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(feedbackid.toString()));
        }
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Feedback with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Feedback withStatuscode(Integer statuscode) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Feedback with_modifiedby_value(String _modifiedby_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="closedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getClosedon() {
        return Optional.ofNullable(closedon);
    }

    public Feedback withClosedon(OffsetDateTime closedon) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("closedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.closedon = closedon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Feedback withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Feedback withStatecode(Integer statecode) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<String> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Feedback with_regardingobjectid_value(String _regardingobjectid_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Feedback withTitle(String title) {
        Checks.checkIsAscii(title);
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.title = title;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Feedback withCreatedon(OffsetDateTime createdon) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="rating")
    @JsonIgnore
    public Optional<Integer> getRating() {
        return Optional.ofNullable(rating);
    }

    public Feedback withRating(Integer rating) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("rating");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.rating = rating;
        return _x;
    }

    @Property(name="_createdbycontact_value")
    @JsonIgnore
    public Optional<String> get_createdbycontact_value() {
        return Optional.ofNullable(_createdbycontact_value);
    }

    public Feedback with_createdbycontact_value(String _createdbycontact_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_createdbycontact_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._createdbycontact_value = _createdbycontact_value;
        return _x;
    }

    @Property(name="comments")
    @JsonIgnore
    public Optional<String> getComments() {
        return Optional.ofNullable(comments);
    }

    public Feedback withComments(String comments) {
        Checks.checkIsAscii(comments);
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("comments");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.comments = comments;
        return _x;
    }

    @Property(name="feedbackid")
    @JsonIgnore
    public Optional<String> getFeedbackid() {
        return Optional.ofNullable(feedbackid);
    }

    public Feedback withFeedbackid(String feedbackid) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("feedbackid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.feedbackid = feedbackid;
        return _x;
    }

    @Property(name="maxrating")
    @JsonIgnore
    public Optional<Integer> getMaxrating() {
        return Optional.ofNullable(maxrating);
    }

    public Feedback withMaxrating(Integer maxrating) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("maxrating");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.maxrating = maxrating;
        return _x;
    }

    @Property(name="_closedby_value")
    @JsonIgnore
    public Optional<String> get_closedby_value() {
        return Optional.ofNullable(_closedby_value);
    }

    public Feedback with_closedby_value(String _closedby_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_closedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._closedby_value = _closedby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Feedback with_createdby_value(String _createdby_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Feedback withImportsequencenumber(Integer importsequencenumber) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<Integer> getSource() {
        return Optional.ofNullable(source);
    }

    public Feedback withSource(Integer source) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.source = source;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<String> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Feedback with_owningbusinessunit_value(String _owningbusinessunit_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_createdonbehalfbycontact_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfbycontact_value() {
        return Optional.ofNullable(_createdonbehalfbycontact_value);
    }

    public Feedback with_createdonbehalfbycontact_value(String _createdonbehalfbycontact_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfbycontact_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._createdonbehalfbycontact_value = _createdonbehalfbycontact_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Feedback withModifiedon(OffsetDateTime modifiedon) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Feedback withExchangerate(BigDecimal exchangerate) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<String> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Feedback with_owningteam_value(String _owningteam_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Feedback withVersionnumber(Long versionnumber) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<String> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Feedback with_owninguser_value(String _owninguser_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Feedback with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<String> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Feedback with_transactioncurrencyid_value(String _transactioncurrencyid_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="normalizedrating")
    @JsonIgnore
    public Optional<BigDecimal> getNormalizedrating() {
        return Optional.ofNullable(normalizedrating);
    }

    public Feedback withNormalizedrating(BigDecimal normalizedrating) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("normalizedrating");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.normalizedrating = normalizedrating;
        return _x;
    }

    @Property(name="minrating")
    @JsonIgnore
    public Optional<Integer> getMinrating() {
        return Optional.ofNullable(minrating);
    }

    public Feedback withMinrating(Integer minrating) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("minrating");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x.minrating = minrating;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<String> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Feedback with_ownerid_value(String _ownerid_value) {
        Feedback _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.feedback");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    public Feedback withUnmappedField(String name, String value) {
        Feedback _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="ContactId")
    @JsonIgnore
    public ContactRequest getContactId() {
        return new ContactRequest(contextPath.addSegment("ContactId"), RequestHelper.getValue(unmappedFields, "ContactId"));
    }

    @NavigationProperty(name="CreatedOnBehalfByContact")
    @JsonIgnore
    public ContactRequest getCreatedOnBehalfByContact() {
        return new ContactRequest(contextPath.addSegment("CreatedOnBehalfByContact"), RequestHelper.getValue(unmappedFields, "CreatedOnBehalfByContact"));
    }

    @NavigationProperty(name="feedback_principalobjectattributeaccess")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getFeedback_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("feedback_principalobjectattributeaccess"), RequestHelper.getValue(unmappedFields, "feedback_principalobjectattributeaccess"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="ModifiedOnBehalfBy")
    @JsonIgnore
    public SystemuserRequest getModifiedOnBehalfBy() {
        return new SystemuserRequest(contextPath.addSegment("ModifiedOnBehalfBy"), RequestHelper.getValue(unmappedFields, "ModifiedOnBehalfBy"));
    }

    @NavigationProperty(name="closedby")
    @JsonIgnore
    public SystemuserRequest getClosedby() {
        return new SystemuserRequest(contextPath.addSegment("closedby"), RequestHelper.getValue(unmappedFields, "closedby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="CreatedByContact")
    @JsonIgnore
    public ContactRequest getCreatedByContact() {
        return new ContactRequest(contextPath.addSegment("CreatedByContact"), RequestHelper.getValue(unmappedFields, "CreatedByContact"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="FeedbackId")
    @JsonIgnore
    public FeedbackRequest getFeedbackId() {
        return new FeedbackRequest(contextPath.addSegment("FeedbackId"), RequestHelper.getValue(unmappedFields, "FeedbackId"));
    }

    @NavigationProperty(name="feedback_feedback")
    @JsonIgnore
    public FeedbackCollectionRequest getFeedback_feedback() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("feedback_feedback"), RequestHelper.getValue(unmappedFields, "feedback_feedback"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="Feedback_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getFeedback_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Feedback_SyncErrors"), RequestHelper.getValue(unmappedFields, "Feedback_SyncErrors"));
    }

    @NavigationProperty(name="KnowledgeArticleId")
    @JsonIgnore
    public KnowledgearticleRequest getKnowledgeArticleId() {
        return new KnowledgearticleRequest(contextPath.addSegment("KnowledgeArticleId"), RequestHelper.getValue(unmappedFields, "KnowledgeArticleId"));
    }

    @NavigationProperty(name="feedback_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getFeedback_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("feedback_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "feedback_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="feedback_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getFeedback_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("feedback_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "feedback_DuplicateMatchingRecord"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Feedback patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Feedback _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Feedback put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Feedback _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Feedback _copy() {
        Feedback _x = new Feedback();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.statuscode = statuscode;
        _x._modifiedby_value = _modifiedby_value;
        _x.closedon = closedon;
        _x.overriddencreatedon = overriddencreatedon;
        _x.statecode = statecode;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.title = title;
        _x.createdon = createdon;
        _x.rating = rating;
        _x._createdbycontact_value = _createdbycontact_value;
        _x.comments = comments;
        _x.feedbackid = feedbackid;
        _x.maxrating = maxrating;
        _x._closedby_value = _closedby_value;
        _x._createdby_value = _createdby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.source = source;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._createdonbehalfbycontact_value = _createdonbehalfbycontact_value;
        _x.modifiedon = modifiedon;
        _x.exchangerate = exchangerate;
        _x._owningteam_value = _owningteam_value;
        _x.versionnumber = versionnumber;
        _x._owninguser_value = _owninguser_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.normalizedrating = normalizedrating;
        _x.minrating = minrating;
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Feedback[");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("closedon=");
        b.append(this.closedon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("rating=");
        b.append(this.rating);
        b.append(", ");
        b.append("_createdbycontact_value=");
        b.append(this._createdbycontact_value);
        b.append(", ");
        b.append("comments=");
        b.append(this.comments);
        b.append(", ");
        b.append("feedbackid=");
        b.append(this.feedbackid);
        b.append(", ");
        b.append("maxrating=");
        b.append(this.maxrating);
        b.append(", ");
        b.append("_closedby_value=");
        b.append(this._closedby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_createdonbehalfbycontact_value=");
        b.append(this._createdonbehalfbycontact_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("normalizedrating=");
        b.append(this.normalizedrating);
        b.append(", ");
        b.append("minrating=");
        b.append(this.minrating);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
