package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "documenttype", 
    "_modifiedby_value", 
    "name", 
    "_modifiedonbehalfby_value", 
    "_createdby_value", 
    "associatedentitytypecode", 
    "documenttemplateid", 
    "clientdata", 
    "modifiedon", 
    "versionnumber", 
    "description", 
    "createdon", 
    "_organizationid_value", 
    "status", 
    "content", 
    "languagecode", 
    "_createdonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Documenttemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.documenttemplate";
    }

    @JsonProperty("documenttype")
    protected Integer documenttype;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("associatedentitytypecode")
    protected String associatedentitytypecode;

    @JsonProperty("documenttemplateid")
    protected String documenttemplateid;

    @JsonProperty("clientdata")
    protected String clientdata;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("status")
    protected Boolean status;

    @JsonProperty("content")
    protected String content;

    @JsonProperty("languagecode")
    protected Integer languagecode;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    protected Documenttemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDocumenttemplate() {
        return new Builder();
    }

    public static final class Builder {
        private Integer documenttype;
        private String _modifiedby_value;
        private String name;
        private String _modifiedonbehalfby_value;
        private String _createdby_value;
        private String associatedentitytypecode;
        private String documenttemplateid;
        private String clientdata;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private String description;
        private OffsetDateTime createdon;
        private String _organizationid_value;
        private Boolean status;
        private String content;
        private Integer languagecode;
        private String _createdonbehalfby_value;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder documenttype(Integer documenttype) {
            this.documenttype = documenttype;
            this.changedFields = changedFields.add("documenttype");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder associatedentitytypecode(String associatedentitytypecode) {
            this.associatedentitytypecode = associatedentitytypecode;
            this.changedFields = changedFields.add("associatedentitytypecode");
            return this;
        }

        public Builder documenttemplateid(String documenttemplateid) {
            this.documenttemplateid = documenttemplateid;
            this.changedFields = changedFields.add("documenttemplateid");
            return this;
        }

        public Builder clientdata(String clientdata) {
            this.clientdata = clientdata;
            this.changedFields = changedFields.add("clientdata");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder status(Boolean status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder content(String content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder languagecode(Integer languagecode) {
            this.languagecode = languagecode;
            this.changedFields = changedFields.add("languagecode");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Documenttemplate build() {
            Documenttemplate _x = new Documenttemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.documenttemplate";
            _x.documenttype = documenttype;
            _x._modifiedby_value = _modifiedby_value;
            _x.name = name;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.associatedentitytypecode = associatedentitytypecode;
            _x.documenttemplateid = documenttemplateid;
            _x.clientdata = clientdata;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x.description = description;
            _x.createdon = createdon;
            _x._organizationid_value = _organizationid_value;
            _x.status = status;
            _x.content = content;
            _x.languagecode = languagecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && documenttemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(documenttemplateid.toString()));
        }
    }

    @Property(name="documenttype")
    @JsonIgnore
    public Optional<Integer> getDocumenttype() {
        return Optional.ofNullable(documenttype);
    }

    public Documenttemplate withDocumenttype(Integer documenttype) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("documenttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.documenttype = documenttype;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Documenttemplate with_modifiedby_value(String _modifiedby_value) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Documenttemplate withName(String name) {
        Checks.checkIsAscii(name);
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.name = name;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Documenttemplate with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Documenttemplate with_createdby_value(String _createdby_value) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="associatedentitytypecode")
    @JsonIgnore
    public Optional<String> getAssociatedentitytypecode() {
        return Optional.ofNullable(associatedentitytypecode);
    }

    public Documenttemplate withAssociatedentitytypecode(String associatedentitytypecode) {
        Checks.checkIsAscii(associatedentitytypecode);
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("associatedentitytypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.associatedentitytypecode = associatedentitytypecode;
        return _x;
    }

    @Property(name="documenttemplateid")
    @JsonIgnore
    public Optional<String> getDocumenttemplateid() {
        return Optional.ofNullable(documenttemplateid);
    }

    public Documenttemplate withDocumenttemplateid(String documenttemplateid) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("documenttemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.documenttemplateid = documenttemplateid;
        return _x;
    }

    @Property(name="clientdata")
    @JsonIgnore
    public Optional<String> getClientdata() {
        return Optional.ofNullable(clientdata);
    }

    public Documenttemplate withClientdata(String clientdata) {
        Checks.checkIsAscii(clientdata);
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("clientdata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.clientdata = clientdata;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Documenttemplate withModifiedon(OffsetDateTime modifiedon) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Documenttemplate withVersionnumber(Long versionnumber) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Documenttemplate withDescription(String description) {
        Checks.checkIsAscii(description);
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.description = description;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Documenttemplate withCreatedon(OffsetDateTime createdon) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Documenttemplate with_organizationid_value(String _organizationid_value) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<Boolean> getStatus() {
        return Optional.ofNullable(status);
    }

    public Documenttemplate withStatus(Boolean status) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.status = status;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<String> getContent() {
        return Optional.ofNullable(content);
    }

    public Documenttemplate withContent(String content) {
        Checks.checkIsAscii(content);
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.content = content;
        return _x;
    }

    @Property(name="languagecode")
    @JsonIgnore
    public Optional<Integer> getLanguagecode() {
        return Optional.ofNullable(languagecode);
    }

    public Documenttemplate withLanguagecode(Integer languagecode) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("languagecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x.languagecode = languagecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Documenttemplate with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Documenttemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.documenttemplate");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    public Documenttemplate withUnmappedField(String name, String value) {
        Documenttemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Documenttemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Documenttemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Documenttemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Documenttemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Documenttemplate _copy() {
        Documenttemplate _x = new Documenttemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.documenttype = documenttype;
        _x._modifiedby_value = _modifiedby_value;
        _x.name = name;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.associatedentitytypecode = associatedentitytypecode;
        _x.documenttemplateid = documenttemplateid;
        _x.clientdata = clientdata;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x.description = description;
        _x.createdon = createdon;
        _x._organizationid_value = _organizationid_value;
        _x.status = status;
        _x.content = content;
        _x.languagecode = languagecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Documenttemplate[");
        b.append("documenttype=");
        b.append(this.documenttype);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("associatedentitytypecode=");
        b.append(this.associatedentitytypecode);
        b.append(", ");
        b.append("documenttemplateid=");
        b.append(this.documenttemplateid);
        b.append(", ");
        b.append("clientdata=");
        b.append(this.clientdata);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("languagecode=");
        b.append(this.languagecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
