package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "newsarticle", 
    "articleurl", 
    "_organizationid_value", 
    "businessunitnewsarticleid", 
    "_modifiedby_value", 
    "timezoneruleversionnumber", 
    "activeon", 
    "createdon", 
    "versionnumber", 
    "_createdonbehalfby_value", 
    "activeuntil", 
    "importsequencenumber", 
    "articletypecode", 
    "overriddencreatedon", 
    "articletitle", 
    "_createdby_value", 
    "showonhomepage", 
    "modifiedon", 
    "_modifiedonbehalfby_value", 
    "utcconversiontimezonecode"})
@JsonInclude(Include.NON_NULL)
public class Businessunitnewsarticle extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.businessunitnewsarticle";
    }

    @JsonProperty("newsarticle")
    protected String newsarticle;

    @JsonProperty("articleurl")
    protected String articleurl;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("businessunitnewsarticleid")
    protected String businessunitnewsarticleid;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("activeon")
    protected OffsetDateTime activeon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("activeuntil")
    protected OffsetDateTime activeuntil;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("articletypecode")
    protected Integer articletypecode;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("articletitle")
    protected String articletitle;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("showonhomepage")
    protected Boolean showonhomepage;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    protected Businessunitnewsarticle() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBusinessunitnewsarticle() {
        return new Builder();
    }

    public static final class Builder {
        private String newsarticle;
        private String articleurl;
        private String _organizationid_value;
        private String businessunitnewsarticleid;
        private String _modifiedby_value;
        private Integer timezoneruleversionnumber;
        private OffsetDateTime activeon;
        private OffsetDateTime createdon;
        private Long versionnumber;
        private String _createdonbehalfby_value;
        private OffsetDateTime activeuntil;
        private Integer importsequencenumber;
        private Integer articletypecode;
        private OffsetDateTime overriddencreatedon;
        private String articletitle;
        private String _createdby_value;
        private Boolean showonhomepage;
        private OffsetDateTime modifiedon;
        private String _modifiedonbehalfby_value;
        private Integer utcconversiontimezonecode;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder newsarticle(String newsarticle) {
            this.newsarticle = newsarticle;
            this.changedFields = changedFields.add("newsarticle");
            return this;
        }

        public Builder articleurl(String articleurl) {
            this.articleurl = articleurl;
            this.changedFields = changedFields.add("articleurl");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder businessunitnewsarticleid(String businessunitnewsarticleid) {
            this.businessunitnewsarticleid = businessunitnewsarticleid;
            this.changedFields = changedFields.add("businessunitnewsarticleid");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder activeon(OffsetDateTime activeon) {
            this.activeon = activeon;
            this.changedFields = changedFields.add("activeon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder activeuntil(OffsetDateTime activeuntil) {
            this.activeuntil = activeuntil;
            this.changedFields = changedFields.add("activeuntil");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder articletypecode(Integer articletypecode) {
            this.articletypecode = articletypecode;
            this.changedFields = changedFields.add("articletypecode");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder articletitle(String articletitle) {
            this.articletitle = articletitle;
            this.changedFields = changedFields.add("articletitle");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder showonhomepage(Boolean showonhomepage) {
            this.showonhomepage = showonhomepage;
            this.changedFields = changedFields.add("showonhomepage");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Businessunitnewsarticle build() {
            Businessunitnewsarticle _x = new Businessunitnewsarticle();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.businessunitnewsarticle";
            _x.newsarticle = newsarticle;
            _x.articleurl = articleurl;
            _x._organizationid_value = _organizationid_value;
            _x.businessunitnewsarticleid = businessunitnewsarticleid;
            _x._modifiedby_value = _modifiedby_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.activeon = activeon;
            _x.createdon = createdon;
            _x.versionnumber = versionnumber;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.activeuntil = activeuntil;
            _x.importsequencenumber = importsequencenumber;
            _x.articletypecode = articletypecode;
            _x.overriddencreatedon = overriddencreatedon;
            _x.articletitle = articletitle;
            _x._createdby_value = _createdby_value;
            _x.showonhomepage = showonhomepage;
            _x.modifiedon = modifiedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && businessunitnewsarticleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(businessunitnewsarticleid.toString()));
        }
    }

    @Property(name="newsarticle")
    @JsonIgnore
    public Optional<String> getNewsarticle() {
        return Optional.ofNullable(newsarticle);
    }

    public Businessunitnewsarticle withNewsarticle(String newsarticle) {
        Checks.checkIsAscii(newsarticle);
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("newsarticle");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.newsarticle = newsarticle;
        return _x;
    }

    @Property(name="articleurl")
    @JsonIgnore
    public Optional<String> getArticleurl() {
        return Optional.ofNullable(articleurl);
    }

    public Businessunitnewsarticle withArticleurl(String articleurl) {
        Checks.checkIsAscii(articleurl);
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("articleurl");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.articleurl = articleurl;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Businessunitnewsarticle with_organizationid_value(String _organizationid_value) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="businessunitnewsarticleid")
    @JsonIgnore
    public Optional<String> getBusinessunitnewsarticleid() {
        return Optional.ofNullable(businessunitnewsarticleid);
    }

    public Businessunitnewsarticle withBusinessunitnewsarticleid(String businessunitnewsarticleid) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("businessunitnewsarticleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.businessunitnewsarticleid = businessunitnewsarticleid;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Businessunitnewsarticle with_modifiedby_value(String _modifiedby_value) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Businessunitnewsarticle withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="activeon")
    @JsonIgnore
    public Optional<OffsetDateTime> getActiveon() {
        return Optional.ofNullable(activeon);
    }

    public Businessunitnewsarticle withActiveon(OffsetDateTime activeon) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("activeon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.activeon = activeon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Businessunitnewsarticle withCreatedon(OffsetDateTime createdon) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Businessunitnewsarticle withVersionnumber(Long versionnumber) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Businessunitnewsarticle with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="activeuntil")
    @JsonIgnore
    public Optional<OffsetDateTime> getActiveuntil() {
        return Optional.ofNullable(activeuntil);
    }

    public Businessunitnewsarticle withActiveuntil(OffsetDateTime activeuntil) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("activeuntil");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.activeuntil = activeuntil;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Businessunitnewsarticle withImportsequencenumber(Integer importsequencenumber) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="articletypecode")
    @JsonIgnore
    public Optional<Integer> getArticletypecode() {
        return Optional.ofNullable(articletypecode);
    }

    public Businessunitnewsarticle withArticletypecode(Integer articletypecode) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("articletypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.articletypecode = articletypecode;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Businessunitnewsarticle withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="articletitle")
    @JsonIgnore
    public Optional<String> getArticletitle() {
        return Optional.ofNullable(articletitle);
    }

    public Businessunitnewsarticle withArticletitle(String articletitle) {
        Checks.checkIsAscii(articletitle);
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("articletitle");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.articletitle = articletitle;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Businessunitnewsarticle with_createdby_value(String _createdby_value) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="showonhomepage")
    @JsonIgnore
    public Optional<Boolean> getShowonhomepage() {
        return Optional.ofNullable(showonhomepage);
    }

    public Businessunitnewsarticle withShowonhomepage(Boolean showonhomepage) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("showonhomepage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.showonhomepage = showonhomepage;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Businessunitnewsarticle withModifiedon(OffsetDateTime modifiedon) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Businessunitnewsarticle with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Businessunitnewsarticle withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.businessunitnewsarticle");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    public Businessunitnewsarticle withUnmappedField(String name, String value) {
        Businessunitnewsarticle _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="BusinessUnitNewsArticle_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getBusinessUnitNewsArticle_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("BusinessUnitNewsArticle_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "BusinessUnitNewsArticle_BulkDeleteFailures"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="BusinessUnitNewsArticle_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getBusinessUnitNewsArticle_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("BusinessUnitNewsArticle_AsyncOperations"), RequestHelper.getValue(unmappedFields, "BusinessUnitNewsArticle_AsyncOperations"));
    }

    @NavigationProperty(name="BusinessUnitNewsArticle_ProcessSessions")
    @JsonIgnore
    public ProcesssessionCollectionRequest getBusinessUnitNewsArticle_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("BusinessUnitNewsArticle_ProcessSessions"), RequestHelper.getValue(unmappedFields, "BusinessUnitNewsArticle_ProcessSessions"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Businessunitnewsarticle patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Businessunitnewsarticle put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Businessunitnewsarticle _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Businessunitnewsarticle _copy() {
        Businessunitnewsarticle _x = new Businessunitnewsarticle();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.newsarticle = newsarticle;
        _x.articleurl = articleurl;
        _x._organizationid_value = _organizationid_value;
        _x.businessunitnewsarticleid = businessunitnewsarticleid;
        _x._modifiedby_value = _modifiedby_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.activeon = activeon;
        _x.createdon = createdon;
        _x.versionnumber = versionnumber;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.activeuntil = activeuntil;
        _x.importsequencenumber = importsequencenumber;
        _x.articletypecode = articletypecode;
        _x.overriddencreatedon = overriddencreatedon;
        _x.articletitle = articletitle;
        _x._createdby_value = _createdby_value;
        _x.showonhomepage = showonhomepage;
        _x.modifiedon = modifiedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Businessunitnewsarticle[");
        b.append("newsarticle=");
        b.append(this.newsarticle);
        b.append(", ");
        b.append("articleurl=");
        b.append(this.articleurl);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("businessunitnewsarticleid=");
        b.append(this.businessunitnewsarticleid);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("activeon=");
        b.append(this.activeon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("activeuntil=");
        b.append(this.activeuntil);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("articletypecode=");
        b.append(this.articletypecode);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("articletitle=");
        b.append(this.articletitle);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("showonhomepage=");
        b.append(this.showonhomepage);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
