package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import microsoft.dynamics.crm.entity.collection.request.AppconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppmodulecomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ServiceplanCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PublisherRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "appmodulexmlmanaged", 
    "webresourceid", 
    "uniquename", 
    "componentstate", 
    "createdon", 
    "publishedon", 
    "overwritetime", 
    "url", 
    "appmoduleversion", 
    "appmoduleidunique", 
    "clienttype", 
    "_modifiedonbehalfby_value", 
    "isdefault", 
    "navigationtype", 
    "versionnumber", 
    "ismanaged", 
    "formfactor", 
    "_modifiedby_value", 
    "introducedversion", 
    "modifiedon", 
    "welcomepageid", 
    "name", 
    "_createdonbehalfby_value", 
    "appmoduleid", 
    "overriddencreatedon", 
    "solutionid", 
    "isfeatured", 
    "description", 
    "configxml", 
    "eventhandlers", 
    "_publisherid_value", 
    "optimizedfor", 
    "_createdby_value", 
    "_organizationid_value", 
    "importsequencenumber", 
    "descriptor"})
@JsonInclude(Include.NON_NULL)
public class Appmodule extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.appmodule";
    }

    @JsonProperty("appmodulexmlmanaged")
    protected String appmodulexmlmanaged;

    @JsonProperty("webresourceid")
    protected String webresourceid;

    @JsonProperty("uniquename")
    protected String uniquename;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("publishedon")
    protected OffsetDateTime publishedon;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("appmoduleversion")
    protected String appmoduleversion;

    @JsonProperty("appmoduleidunique")
    protected String appmoduleidunique;

    @JsonProperty("clienttype")
    protected Integer clienttype;

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("isdefault")
    protected Boolean isdefault;

    @JsonProperty("navigationtype")
    protected Integer navigationtype;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("formfactor")
    protected Integer formfactor;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("welcomepageid")
    protected String welcomepageid;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("appmoduleid")
    protected String appmoduleid;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("solutionid")
    protected String solutionid;

    @JsonProperty("isfeatured")
    protected Boolean isfeatured;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("configxml")
    protected String configxml;

    @JsonProperty("eventhandlers")
    protected String eventhandlers;

    @JsonProperty("_publisherid_value")
    protected String _publisherid_value;

    @JsonProperty("optimizedfor")
    protected String optimizedfor;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("descriptor")
    protected String descriptor;

    protected Appmodule() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppmodule() {
        return new Builder();
    }

    public static final class Builder {
        private String appmodulexmlmanaged;
        private String webresourceid;
        private String uniquename;
        private Integer componentstate;
        private OffsetDateTime createdon;
        private OffsetDateTime publishedon;
        private OffsetDateTime overwritetime;
        private String url;
        private String appmoduleversion;
        private String appmoduleidunique;
        private Integer clienttype;
        private String _modifiedonbehalfby_value;
        private Boolean isdefault;
        private Integer navigationtype;
        private Long versionnumber;
        private Boolean ismanaged;
        private Integer formfactor;
        private String _modifiedby_value;
        private String introducedversion;
        private OffsetDateTime modifiedon;
        private String welcomepageid;
        private String name;
        private String _createdonbehalfby_value;
        private String appmoduleid;
        private OffsetDateTime overriddencreatedon;
        private String solutionid;
        private Boolean isfeatured;
        private String description;
        private String configxml;
        private String eventhandlers;
        private String _publisherid_value;
        private String optimizedfor;
        private String _createdby_value;
        private String _organizationid_value;
        private Integer importsequencenumber;
        private String descriptor;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder appmodulexmlmanaged(String appmodulexmlmanaged) {
            this.appmodulexmlmanaged = appmodulexmlmanaged;
            this.changedFields = changedFields.add("appmodulexmlmanaged");
            return this;
        }

        public Builder webresourceid(String webresourceid) {
            this.webresourceid = webresourceid;
            this.changedFields = changedFields.add("webresourceid");
            return this;
        }

        public Builder uniquename(String uniquename) {
            this.uniquename = uniquename;
            this.changedFields = changedFields.add("uniquename");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder publishedon(OffsetDateTime publishedon) {
            this.publishedon = publishedon;
            this.changedFields = changedFields.add("publishedon");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder appmoduleversion(String appmoduleversion) {
            this.appmoduleversion = appmoduleversion;
            this.changedFields = changedFields.add("appmoduleversion");
            return this;
        }

        public Builder appmoduleidunique(String appmoduleidunique) {
            this.appmoduleidunique = appmoduleidunique;
            this.changedFields = changedFields.add("appmoduleidunique");
            return this;
        }

        public Builder clienttype(Integer clienttype) {
            this.clienttype = clienttype;
            this.changedFields = changedFields.add("clienttype");
            return this;
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder isdefault(Boolean isdefault) {
            this.isdefault = isdefault;
            this.changedFields = changedFields.add("isdefault");
            return this;
        }

        public Builder navigationtype(Integer navigationtype) {
            this.navigationtype = navigationtype;
            this.changedFields = changedFields.add("navigationtype");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder formfactor(Integer formfactor) {
            this.formfactor = formfactor;
            this.changedFields = changedFields.add("formfactor");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder welcomepageid(String welcomepageid) {
            this.welcomepageid = welcomepageid;
            this.changedFields = changedFields.add("welcomepageid");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder appmoduleid(String appmoduleid) {
            this.appmoduleid = appmoduleid;
            this.changedFields = changedFields.add("appmoduleid");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder solutionid(String solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder isfeatured(Boolean isfeatured) {
            this.isfeatured = isfeatured;
            this.changedFields = changedFields.add("isfeatured");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder configxml(String configxml) {
            this.configxml = configxml;
            this.changedFields = changedFields.add("configxml");
            return this;
        }

        public Builder eventhandlers(String eventhandlers) {
            this.eventhandlers = eventhandlers;
            this.changedFields = changedFields.add("eventhandlers");
            return this;
        }

        public Builder _publisherid_value(String _publisherid_value) {
            this._publisherid_value = _publisherid_value;
            this.changedFields = changedFields.add("_publisherid_value");
            return this;
        }

        public Builder optimizedfor(String optimizedfor) {
            this.optimizedfor = optimizedfor;
            this.changedFields = changedFields.add("optimizedfor");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder descriptor(String descriptor) {
            this.descriptor = descriptor;
            this.changedFields = changedFields.add("descriptor");
            return this;
        }

        public Appmodule build() {
            Appmodule _x = new Appmodule();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.appmodule";
            _x.appmodulexmlmanaged = appmodulexmlmanaged;
            _x.webresourceid = webresourceid;
            _x.uniquename = uniquename;
            _x.componentstate = componentstate;
            _x.createdon = createdon;
            _x.publishedon = publishedon;
            _x.overwritetime = overwritetime;
            _x.url = url;
            _x.appmoduleversion = appmoduleversion;
            _x.appmoduleidunique = appmoduleidunique;
            _x.clienttype = clienttype;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.isdefault = isdefault;
            _x.navigationtype = navigationtype;
            _x.versionnumber = versionnumber;
            _x.ismanaged = ismanaged;
            _x.formfactor = formfactor;
            _x._modifiedby_value = _modifiedby_value;
            _x.introducedversion = introducedversion;
            _x.modifiedon = modifiedon;
            _x.welcomepageid = welcomepageid;
            _x.name = name;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.appmoduleid = appmoduleid;
            _x.overriddencreatedon = overriddencreatedon;
            _x.solutionid = solutionid;
            _x.isfeatured = isfeatured;
            _x.description = description;
            _x.configxml = configxml;
            _x.eventhandlers = eventhandlers;
            _x._publisherid_value = _publisherid_value;
            _x.optimizedfor = optimizedfor;
            _x._createdby_value = _createdby_value;
            _x._organizationid_value = _organizationid_value;
            _x.importsequencenumber = importsequencenumber;
            _x.descriptor = descriptor;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && appmoduleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(appmoduleid.toString()));
        }
    }

    @Property(name="appmodulexmlmanaged")
    @JsonIgnore
    public Optional<String> getAppmodulexmlmanaged() {
        return Optional.ofNullable(appmodulexmlmanaged);
    }

    public Appmodule withAppmodulexmlmanaged(String appmodulexmlmanaged) {
        Checks.checkIsAscii(appmodulexmlmanaged);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("appmodulexmlmanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.appmodulexmlmanaged = appmodulexmlmanaged;
        return _x;
    }

    @Property(name="webresourceid")
    @JsonIgnore
    public Optional<String> getWebresourceid() {
        return Optional.ofNullable(webresourceid);
    }

    public Appmodule withWebresourceid(String webresourceid) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("webresourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.webresourceid = webresourceid;
        return _x;
    }

    @Property(name="uniquename")
    @JsonIgnore
    public Optional<String> getUniquename() {
        return Optional.ofNullable(uniquename);
    }

    public Appmodule withUniquename(String uniquename) {
        Checks.checkIsAscii(uniquename);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("uniquename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.uniquename = uniquename;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Appmodule withComponentstate(Integer componentstate) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Appmodule withCreatedon(OffsetDateTime createdon) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="publishedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getPublishedon() {
        return Optional.ofNullable(publishedon);
    }

    public Appmodule withPublishedon(OffsetDateTime publishedon) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("publishedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.publishedon = publishedon;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Appmodule withOverwritetime(OffsetDateTime overwritetime) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public Appmodule withUrl(String url) {
        Checks.checkIsAscii(url);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.url = url;
        return _x;
    }

    @Property(name="appmoduleversion")
    @JsonIgnore
    public Optional<String> getAppmoduleversion() {
        return Optional.ofNullable(appmoduleversion);
    }

    public Appmodule withAppmoduleversion(String appmoduleversion) {
        Checks.checkIsAscii(appmoduleversion);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("appmoduleversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.appmoduleversion = appmoduleversion;
        return _x;
    }

    @Property(name="appmoduleidunique")
    @JsonIgnore
    public Optional<String> getAppmoduleidunique() {
        return Optional.ofNullable(appmoduleidunique);
    }

    public Appmodule withAppmoduleidunique(String appmoduleidunique) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("appmoduleidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.appmoduleidunique = appmoduleidunique;
        return _x;
    }

    @Property(name="clienttype")
    @JsonIgnore
    public Optional<Integer> getClienttype() {
        return Optional.ofNullable(clienttype);
    }

    public Appmodule withClienttype(Integer clienttype) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("clienttype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.clienttype = clienttype;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Appmodule with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="isdefault")
    @JsonIgnore
    public Optional<Boolean> getIsdefault() {
        return Optional.ofNullable(isdefault);
    }

    public Appmodule withIsdefault(Boolean isdefault) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("isdefault");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.isdefault = isdefault;
        return _x;
    }

    @Property(name="navigationtype")
    @JsonIgnore
    public Optional<Integer> getNavigationtype() {
        return Optional.ofNullable(navigationtype);
    }

    public Appmodule withNavigationtype(Integer navigationtype) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("navigationtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.navigationtype = navigationtype;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Appmodule withVersionnumber(Long versionnumber) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Appmodule withIsmanaged(Boolean ismanaged) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="formfactor")
    @JsonIgnore
    public Optional<Integer> getFormfactor() {
        return Optional.ofNullable(formfactor);
    }

    public Appmodule withFormfactor(Integer formfactor) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("formfactor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.formfactor = formfactor;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Appmodule with_modifiedby_value(String _modifiedby_value) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Appmodule withIntroducedversion(String introducedversion) {
        Checks.checkIsAscii(introducedversion);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Appmodule withModifiedon(OffsetDateTime modifiedon) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="welcomepageid")
    @JsonIgnore
    public Optional<String> getWelcomepageid() {
        return Optional.ofNullable(welcomepageid);
    }

    public Appmodule withWelcomepageid(String welcomepageid) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("welcomepageid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.welcomepageid = welcomepageid;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Appmodule withName(String name) {
        Checks.checkIsAscii(name);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.name = name;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Appmodule with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="appmoduleid")
    @JsonIgnore
    public Optional<String> getAppmoduleid() {
        return Optional.ofNullable(appmoduleid);
    }

    public Appmodule withAppmoduleid(String appmoduleid) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("appmoduleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.appmoduleid = appmoduleid;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Appmodule withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<String> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Appmodule withSolutionid(String solutionid) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="isfeatured")
    @JsonIgnore
    public Optional<Boolean> getIsfeatured() {
        return Optional.ofNullable(isfeatured);
    }

    public Appmodule withIsfeatured(Boolean isfeatured) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("isfeatured");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.isfeatured = isfeatured;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Appmodule withDescription(String description) {
        Checks.checkIsAscii(description);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.description = description;
        return _x;
    }

    @Property(name="configxml")
    @JsonIgnore
    public Optional<String> getConfigxml() {
        return Optional.ofNullable(configxml);
    }

    public Appmodule withConfigxml(String configxml) {
        Checks.checkIsAscii(configxml);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("configxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.configxml = configxml;
        return _x;
    }

    @Property(name="eventhandlers")
    @JsonIgnore
    public Optional<String> getEventhandlers() {
        return Optional.ofNullable(eventhandlers);
    }

    public Appmodule withEventhandlers(String eventhandlers) {
        Checks.checkIsAscii(eventhandlers);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("eventhandlers");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.eventhandlers = eventhandlers;
        return _x;
    }

    @Property(name="_publisherid_value")
    @JsonIgnore
    public Optional<String> get_publisherid_value() {
        return Optional.ofNullable(_publisherid_value);
    }

    public Appmodule with_publisherid_value(String _publisherid_value) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("_publisherid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x._publisherid_value = _publisherid_value;
        return _x;
    }

    @Property(name="optimizedfor")
    @JsonIgnore
    public Optional<String> getOptimizedfor() {
        return Optional.ofNullable(optimizedfor);
    }

    public Appmodule withOptimizedfor(String optimizedfor) {
        Checks.checkIsAscii(optimizedfor);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("optimizedfor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.optimizedfor = optimizedfor;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Appmodule with_createdby_value(String _createdby_value) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Appmodule with_organizationid_value(String _organizationid_value) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Appmodule withImportsequencenumber(Integer importsequencenumber) {
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="descriptor")
    @JsonIgnore
    public Optional<String> getDescriptor() {
        return Optional.ofNullable(descriptor);
    }

    public Appmodule withDescriptor(String descriptor) {
        Checks.checkIsAscii(descriptor);
        Appmodule _x = _copy();
        _x.changedFields = changedFields.add("descriptor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmodule");
        _x.descriptor = descriptor;
        return _x;
    }

    public Appmodule withUnmappedField(String name, String value) {
        Appmodule _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appmoduleroles_association")
    @JsonIgnore
    public RoleCollectionRequest getAppmoduleroles_association() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("appmoduleroles_association"), RequestHelper.getValue(unmappedFields, "appmoduleroles_association"));
    }

    @NavigationProperty(name="appmodule_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppmodule_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "appmodule_modifiedonbehalfby"));
    }

    @NavigationProperty(name="appmodule_appconfig")
    @JsonIgnore
    public AppconfigCollectionRequest getAppmodule_appconfig() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("appmodule_appconfig"), RequestHelper.getValue(unmappedFields, "appmodule_appconfig"));
    }

    @NavigationProperty(name="appmodule_createdby")
    @JsonIgnore
    public SystemuserRequest getAppmodule_createdby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_createdby"), RequestHelper.getValue(unmappedFields, "appmodule_createdby"));
    }

    @NavigationProperty(name="publisher_appmodule_appmodule")
    @JsonIgnore
    public PublisherRequest getPublisher_appmodule_appmodule() {
        return new PublisherRequest(contextPath.addSegment("publisher_appmodule_appmodule"), RequestHelper.getValue(unmappedFields, "publisher_appmodule_appmodule"));
    }

    @NavigationProperty(name="appmodule_appmodulecomponent")
    @JsonIgnore
    public AppmodulecomponentCollectionRequest getAppmodule_appmodulecomponent() {
        return new AppmodulecomponentCollectionRequest(
                        contextPath.addSegment("appmodule_appmodulecomponent"), RequestHelper.getValue(unmappedFields, "appmodule_appmodulecomponent"));
    }

    @NavigationProperty(name="appmodule_modifiedby")
    @JsonIgnore
    public SystemuserRequest getAppmodule_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_modifiedby"), RequestHelper.getValue(unmappedFields, "appmodule_modifiedby"));
    }

    @NavigationProperty(name="appmodule_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppmodule_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appmodule_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "appmodule_createdonbehalfby"));
    }

    @NavigationProperty(name="organization_appmodule_appmodule")
    @JsonIgnore
    public OrganizationRequest getOrganization_appmodule_appmodule() {
        return new OrganizationRequest(contextPath.addSegment("organization_appmodule_appmodule"), RequestHelper.getValue(unmappedFields, "organization_appmodule_appmodule"));
    }

    @NavigationProperty(name="serviceplan_appmodule_association")
    @JsonIgnore
    public ServiceplanCollectionRequest getServiceplan_appmodule_association() {
        return new ServiceplanCollectionRequest(
                        contextPath.addSegment("serviceplan_appmodule_association"), RequestHelper.getValue(unmappedFields, "serviceplan_appmodule_association"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appmodule patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Appmodule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appmodule put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Appmodule _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Appmodule _copy() {
        Appmodule _x = new Appmodule();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.appmodulexmlmanaged = appmodulexmlmanaged;
        _x.webresourceid = webresourceid;
        _x.uniquename = uniquename;
        _x.componentstate = componentstate;
        _x.createdon = createdon;
        _x.publishedon = publishedon;
        _x.overwritetime = overwritetime;
        _x.url = url;
        _x.appmoduleversion = appmoduleversion;
        _x.appmoduleidunique = appmoduleidunique;
        _x.clienttype = clienttype;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.isdefault = isdefault;
        _x.navigationtype = navigationtype;
        _x.versionnumber = versionnumber;
        _x.ismanaged = ismanaged;
        _x.formfactor = formfactor;
        _x._modifiedby_value = _modifiedby_value;
        _x.introducedversion = introducedversion;
        _x.modifiedon = modifiedon;
        _x.welcomepageid = welcomepageid;
        _x.name = name;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.appmoduleid = appmoduleid;
        _x.overriddencreatedon = overriddencreatedon;
        _x.solutionid = solutionid;
        _x.isfeatured = isfeatured;
        _x.description = description;
        _x.configxml = configxml;
        _x.eventhandlers = eventhandlers;
        _x._publisherid_value = _publisherid_value;
        _x.optimizedfor = optimizedfor;
        _x._createdby_value = _createdby_value;
        _x._organizationid_value = _organizationid_value;
        _x.importsequencenumber = importsequencenumber;
        _x.descriptor = descriptor;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Appmodule> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Appmodule>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Appmodule.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Appmodule[");
        b.append("appmodulexmlmanaged=");
        b.append(this.appmodulexmlmanaged);
        b.append(", ");
        b.append("webresourceid=");
        b.append(this.webresourceid);
        b.append(", ");
        b.append("uniquename=");
        b.append(this.uniquename);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("publishedon=");
        b.append(this.publishedon);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("appmoduleversion=");
        b.append(this.appmoduleversion);
        b.append(", ");
        b.append("appmoduleidunique=");
        b.append(this.appmoduleidunique);
        b.append(", ");
        b.append("clienttype=");
        b.append(this.clienttype);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("isdefault=");
        b.append(this.isdefault);
        b.append(", ");
        b.append("navigationtype=");
        b.append(this.navigationtype);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("formfactor=");
        b.append(this.formfactor);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("welcomepageid=");
        b.append(this.welcomepageid);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("appmoduleid=");
        b.append(this.appmoduleid);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("isfeatured=");
        b.append(this.isfeatured);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("configxml=");
        b.append(this.configxml);
        b.append(", ");
        b.append("eventhandlers=");
        b.append(this.eventhandlers);
        b.append(", ");
        b.append("_publisherid_value=");
        b.append(this._publisherid_value);
        b.append(", ");
        b.append("optimizedfor=");
        b.append(this.optimizedfor);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("descriptor=");
        b.append(this.descriptor);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
