package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_modifiedonbehalfby_value", 
    "_modifiedby_value", 
    "_createdby_value", 
    "modifiedon", 
    "versionnumber", 
    "utcconversiontimezonecode", 
    "createdon", 
    "statecode", 
    "_organizationid_value", 
    "_createdonbehalfby_value", 
    "viewname", 
    "webapplicationendpoint", 
    "statuscode", 
    "aciviewmapperid"})
@JsonInclude(Include.NON_NULL)
public class Aciviewmapper extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.aciviewmapper";
    }

    @JsonProperty("_modifiedonbehalfby_value")
    protected String _modifiedonbehalfby_value;

    @JsonProperty("_modifiedby_value")
    protected String _modifiedby_value;

    @JsonProperty("_createdby_value")
    protected String _createdby_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_organizationid_value")
    protected String _organizationid_value;

    @JsonProperty("_createdonbehalfby_value")
    protected String _createdonbehalfby_value;

    @JsonProperty("viewname")
    protected String viewname;

    @JsonProperty("webapplicationendpoint")
    protected String webapplicationendpoint;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("aciviewmapperid")
    protected String aciviewmapperid;

    protected Aciviewmapper() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAciviewmapper() {
        return new Builder();
    }

    public static final class Builder {
        private String _modifiedonbehalfby_value;
        private String _modifiedby_value;
        private String _createdby_value;
        private OffsetDateTime modifiedon;
        private Long versionnumber;
        private Integer utcconversiontimezonecode;
        private OffsetDateTime createdon;
        private Integer statecode;
        private String _organizationid_value;
        private String _createdonbehalfby_value;
        private String viewname;
        private String webapplicationendpoint;
        private Integer statuscode;
        private String aciviewmapperid;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder _modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder _modifiedby_value(String _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdby_value(String _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _organizationid_value(String _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder _createdonbehalfby_value(String _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder viewname(String viewname) {
            this.viewname = viewname;
            this.changedFields = changedFields.add("viewname");
            return this;
        }

        public Builder webapplicationendpoint(String webapplicationendpoint) {
            this.webapplicationendpoint = webapplicationendpoint;
            this.changedFields = changedFields.add("webapplicationendpoint");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder aciviewmapperid(String aciviewmapperid) {
            this.aciviewmapperid = aciviewmapperid;
            this.changedFields = changedFields.add("aciviewmapperid");
            return this;
        }

        public Aciviewmapper build() {
            Aciviewmapper _x = new Aciviewmapper();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.aciviewmapper";
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdby_value = _createdby_value;
            _x.modifiedon = modifiedon;
            _x.versionnumber = versionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.createdon = createdon;
            _x.statecode = statecode;
            _x._organizationid_value = _organizationid_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.viewname = viewname;
            _x.webapplicationendpoint = webapplicationendpoint;
            _x.statuscode = statuscode;
            _x.aciviewmapperid = aciviewmapperid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && aciviewmapperid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(aciviewmapperid.toString()));
        }
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Aciviewmapper with_modifiedonbehalfby_value(String _modifiedonbehalfby_value) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<String> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Aciviewmapper with_modifiedby_value(String _modifiedby_value) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<String> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Aciviewmapper with_createdby_value(String _createdby_value) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Aciviewmapper withModifiedon(OffsetDateTime modifiedon) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Aciviewmapper withVersionnumber(Long versionnumber) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Aciviewmapper withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Aciviewmapper withCreatedon(OffsetDateTime createdon) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Aciviewmapper withStatecode(Integer statecode) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<String> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Aciviewmapper with_organizationid_value(String _organizationid_value) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<String> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Aciviewmapper with_createdonbehalfby_value(String _createdonbehalfby_value) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="viewname")
    @JsonIgnore
    public Optional<String> getViewname() {
        return Optional.ofNullable(viewname);
    }

    public Aciviewmapper withViewname(String viewname) {
        Checks.checkIsAscii(viewname);
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("viewname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.viewname = viewname;
        return _x;
    }

    @Property(name="webapplicationendpoint")
    @JsonIgnore
    public Optional<String> getWebapplicationendpoint() {
        return Optional.ofNullable(webapplicationendpoint);
    }

    public Aciviewmapper withWebapplicationendpoint(String webapplicationendpoint) {
        Checks.checkIsAscii(webapplicationendpoint);
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("webapplicationendpoint");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.webapplicationendpoint = webapplicationendpoint;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Aciviewmapper withStatuscode(Integer statuscode) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="aciviewmapperid")
    @JsonIgnore
    public Optional<String> getAciviewmapperid() {
        return Optional.ofNullable(aciviewmapperid);
    }

    public Aciviewmapper withAciviewmapperid(String aciviewmapperid) {
        Aciviewmapper _x = _copy();
        _x.changedFields = changedFields.add("aciviewmapperid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.aciviewmapper");
        _x.aciviewmapperid = aciviewmapperid;
        return _x;
    }

    public Aciviewmapper withUnmappedField(String name, String value) {
        Aciviewmapper _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Aciviewmapper patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Aciviewmapper _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Aciviewmapper put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Aciviewmapper _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Aciviewmapper _copy() {
        Aciviewmapper _x = new Aciviewmapper();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdby_value = _createdby_value;
        _x.modifiedon = modifiedon;
        _x.versionnumber = versionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.createdon = createdon;
        _x.statecode = statecode;
        _x._organizationid_value = _organizationid_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.viewname = viewname;
        _x.webapplicationendpoint = webapplicationendpoint;
        _x.statuscode = statuscode;
        _x.aciviewmapperid = aciviewmapperid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Aciviewmapper[");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("viewname=");
        b.append(this.viewname);
        b.append(", ");
        b.append("webapplicationendpoint=");
        b.append(this.webapplicationendpoint);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("aciviewmapperid=");
        b.append(this.aciviewmapperid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
