package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Data", 
    "SyncToken", 
    "IsFinalPage"})
@JsonInclude(Include.NON_NULL)
public class SyncSubscriptionDataResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Data")
    protected SubscriptionData data;

    @JsonProperty("SyncToken")
    protected String syncToken;

    @JsonProperty("IsFinalPage")
    protected Boolean isFinalPage;

    protected SyncSubscriptionDataResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse";
    }

    @Property(name="Data")
    @JsonIgnore
    public Optional<SubscriptionData> getData() {
        return Optional.ofNullable(data);
    }

    public SyncSubscriptionDataResponse withData(SubscriptionData data) {
        SyncSubscriptionDataResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse");
        _x.data = data;
        return _x;
    }

    @Property(name="SyncToken")
    @JsonIgnore
    public Optional<String> getSyncToken() {
        return Optional.ofNullable(syncToken);
    }

    public SyncSubscriptionDataResponse withSyncToken(String syncToken) {
        Checks.checkIsAscii(syncToken);
        SyncSubscriptionDataResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse");
        _x.syncToken = syncToken;
        return _x;
    }

    @Property(name="IsFinalPage")
    @JsonIgnore
    public Optional<Boolean> getIsFinalPage() {
        return Optional.ofNullable(isFinalPage);
    }

    public SyncSubscriptionDataResponse withIsFinalPage(Boolean isFinalPage) {
        SyncSubscriptionDataResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse");
        _x.isFinalPage = isFinalPage;
        return _x;
    }

    public SyncSubscriptionDataResponse withUnmappedField(String name, String value) {
        SyncSubscriptionDataResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private SubscriptionData data;
        private String syncToken;
        private Boolean isFinalPage;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder data(SubscriptionData data) {
            this.data = data;
            this.changedFields = changedFields.add("Data");
            return this;
        }

        public Builder syncToken(String syncToken) {
            this.syncToken = syncToken;
            this.changedFields = changedFields.add("SyncToken");
            return this;
        }

        public Builder isFinalPage(Boolean isFinalPage) {
            this.isFinalPage = isFinalPage;
            this.changedFields = changedFields.add("IsFinalPage");
            return this;
        }

        public SyncSubscriptionDataResponse build() {
            SyncSubscriptionDataResponse _x = new SyncSubscriptionDataResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse";
            _x.data = data;
            _x.syncToken = syncToken;
            _x.isFinalPage = isFinalPage;
            return _x;
        }
    }

    private SyncSubscriptionDataResponse _copy() {
        SyncSubscriptionDataResponse _x = new SyncSubscriptionDataResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.data = data;
        _x.syncToken = syncToken;
        _x.isFinalPage = isFinalPage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SyncSubscriptionDataResponse[");
        b.append("Data=");
        b.append(this.data);
        b.append(", ");
        b.append("SyncToken=");
        b.append(this.syncToken);
        b.append(", ");
        b.append("IsFinalPage=");
        b.append(this.isFinalPage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
