package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AvailableCount", 
    "GrantedLicenseCount"})
@JsonInclude(Include.NON_NULL)
public class RetrieveLicenseInfoResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AvailableCount")
    protected Integer availableCount;

    @JsonProperty("GrantedLicenseCount")
    protected Integer grantedLicenseCount;

    protected RetrieveLicenseInfoResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveLicenseInfoResponse";
    }

    @Property(name="AvailableCount")
    @JsonIgnore
    public Optional<Integer> getAvailableCount() {
        return Optional.ofNullable(availableCount);
    }

    public RetrieveLicenseInfoResponse withAvailableCount(Integer availableCount) {
        RetrieveLicenseInfoResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveLicenseInfoResponse");
        _x.availableCount = availableCount;
        return _x;
    }

    @Property(name="GrantedLicenseCount")
    @JsonIgnore
    public Optional<Integer> getGrantedLicenseCount() {
        return Optional.ofNullable(grantedLicenseCount);
    }

    public RetrieveLicenseInfoResponse withGrantedLicenseCount(Integer grantedLicenseCount) {
        RetrieveLicenseInfoResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveLicenseInfoResponse");
        _x.grantedLicenseCount = grantedLicenseCount;
        return _x;
    }

    public RetrieveLicenseInfoResponse withUnmappedField(String name, String value) {
        RetrieveLicenseInfoResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer availableCount;
        private Integer grantedLicenseCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder availableCount(Integer availableCount) {
            this.availableCount = availableCount;
            this.changedFields = changedFields.add("AvailableCount");
            return this;
        }

        public Builder grantedLicenseCount(Integer grantedLicenseCount) {
            this.grantedLicenseCount = grantedLicenseCount;
            this.changedFields = changedFields.add("GrantedLicenseCount");
            return this;
        }

        public RetrieveLicenseInfoResponse build() {
            RetrieveLicenseInfoResponse _x = new RetrieveLicenseInfoResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveLicenseInfoResponse";
            _x.availableCount = availableCount;
            _x.grantedLicenseCount = grantedLicenseCount;
            return _x;
        }
    }

    private RetrieveLicenseInfoResponse _copy() {
        RetrieveLicenseInfoResponse _x = new RetrieveLicenseInfoResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.availableCount = availableCount;
        _x.grantedLicenseCount = grantedLicenseCount;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveLicenseInfoResponse[");
        b.append("AvailableCount=");
        b.append(this.availableCount);
        b.append(", ");
        b.append("GrantedLicenseCount=");
        b.append(this.grantedLicenseCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
