package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "CompressedEntityXml"})
@JsonInclude(Include.NON_NULL)
public class RetrieveEntityRibbonResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("CompressedEntityXml")
    protected byte[] compressedEntityXml;

    protected RetrieveEntityRibbonResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveEntityRibbonResponse";
    }

    @Property(name="CompressedEntityXml")
    @JsonIgnore
    public Optional<byte[]> getCompressedEntityXml() {
        return Optional.ofNullable(compressedEntityXml);
    }

    public RetrieveEntityRibbonResponse withCompressedEntityXml(byte[] compressedEntityXml) {
        RetrieveEntityRibbonResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveEntityRibbonResponse");
        _x.compressedEntityXml = compressedEntityXml;
        return _x;
    }

    public RetrieveEntityRibbonResponse withUnmappedField(String name, String value) {
        RetrieveEntityRibbonResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private byte[] compressedEntityXml;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder compressedEntityXml(byte[] compressedEntityXml) {
            this.compressedEntityXml = compressedEntityXml;
            this.changedFields = changedFields.add("CompressedEntityXml");
            return this;
        }

        public RetrieveEntityRibbonResponse build() {
            RetrieveEntityRibbonResponse _x = new RetrieveEntityRibbonResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveEntityRibbonResponse";
            _x.compressedEntityXml = compressedEntityXml;
            return _x;
        }
    }

    private RetrieveEntityRibbonResponse _copy() {
        RetrieveEntityRibbonResponse _x = new RetrieveEntityRibbonResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.compressedEntityXml = compressedEntityXml;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveEntityRibbonResponse[");
        b.append("CompressedEntityXml=");
        b.append(this.compressedEntityXml);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
