package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "AbsoluteUrl", 
    "SiteCollectionUrl"})
@JsonInclude(Include.NON_NULL)
public class RetrieveAbsoluteAndSiteCollectionUrlResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("AbsoluteUrl")
    protected String absoluteUrl;

    @JsonProperty("SiteCollectionUrl")
    protected String siteCollectionUrl;

    protected RetrieveAbsoluteAndSiteCollectionUrlResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrlResponse";
    }

    @Property(name="AbsoluteUrl")
    @JsonIgnore
    public Optional<String> getAbsoluteUrl() {
        return Optional.ofNullable(absoluteUrl);
    }

    public RetrieveAbsoluteAndSiteCollectionUrlResponse withAbsoluteUrl(String absoluteUrl) {
        Checks.checkIsAscii(absoluteUrl);
        RetrieveAbsoluteAndSiteCollectionUrlResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrlResponse");
        _x.absoluteUrl = absoluteUrl;
        return _x;
    }

    @Property(name="SiteCollectionUrl")
    @JsonIgnore
    public Optional<String> getSiteCollectionUrl() {
        return Optional.ofNullable(siteCollectionUrl);
    }

    public RetrieveAbsoluteAndSiteCollectionUrlResponse withSiteCollectionUrl(String siteCollectionUrl) {
        Checks.checkIsAscii(siteCollectionUrl);
        RetrieveAbsoluteAndSiteCollectionUrlResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrlResponse");
        _x.siteCollectionUrl = siteCollectionUrl;
        return _x;
    }

    public RetrieveAbsoluteAndSiteCollectionUrlResponse withUnmappedField(String name, String value) {
        RetrieveAbsoluteAndSiteCollectionUrlResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String absoluteUrl;
        private String siteCollectionUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder absoluteUrl(String absoluteUrl) {
            this.absoluteUrl = absoluteUrl;
            this.changedFields = changedFields.add("AbsoluteUrl");
            return this;
        }

        public Builder siteCollectionUrl(String siteCollectionUrl) {
            this.siteCollectionUrl = siteCollectionUrl;
            this.changedFields = changedFields.add("SiteCollectionUrl");
            return this;
        }

        public RetrieveAbsoluteAndSiteCollectionUrlResponse build() {
            RetrieveAbsoluteAndSiteCollectionUrlResponse _x = new RetrieveAbsoluteAndSiteCollectionUrlResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveAbsoluteAndSiteCollectionUrlResponse";
            _x.absoluteUrl = absoluteUrl;
            _x.siteCollectionUrl = siteCollectionUrl;
            return _x;
        }
    }

    private RetrieveAbsoluteAndSiteCollectionUrlResponse _copy() {
        RetrieveAbsoluteAndSiteCollectionUrlResponse _x = new RetrieveAbsoluteAndSiteCollectionUrlResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.absoluteUrl = absoluteUrl;
        _x.siteCollectionUrl = siteCollectionUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveAbsoluteAndSiteCollectionUrlResponse[");
        b.append("AbsoluteUrl=");
        b.append(this.absoluteUrl);
        b.append(", ");
        b.append("SiteCollectionUrl=");
        b.append(this.siteCollectionUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
